/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ntask.core;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.wso2.carbon.ntask.common.TaskConstants;
import org.wso2.carbon.ntask.core.internal.TasksDSComponent;

@XmlRootElement(name="taskInfo")
public class TaskInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TENANT_ID_PROP = "__TENANT_ID_PROP__";
    private String name;
    private String taskClass;
    private Map<String, String> properties;
    private Map<String, String> locationResolverProperties;
    private String locationResolverClass;
    private TriggerInfo triggerInfo;

    @Deprecated
    public TaskInfo() {
        this.setProperties(null);
        this.setLocationResolverClass(TasksDSComponent.getTaskService().getServerConfiguration().getLocationResolverClass());
        this.setLocationResolverProperties(TasksDSComponent.getTaskService().getServerConfiguration().getLocationResolverProperties());
    }

    public TaskInfo(String name, String taskClass, Map<String, String> properties, TriggerInfo triggerInfo) {
        this.name = name;
        this.taskClass = taskClass;
        this.setProperties(properties);
        this.triggerInfo = triggerInfo;
        if (this.getTriggerInfo() == null) {
            throw new IllegalArgumentException("Trigger information cannot be null");
        }
        this.setLocationResolverClass(TasksDSComponent.getTaskService().getServerConfiguration().getLocationResolverClass());
        this.setLocationResolverProperties(TasksDSComponent.getTaskService().getServerConfiguration().getLocationResolverProperties());
    }

    @Deprecated
    public TaskInfo(String name, String taskClass, Map<String, String> properties, String locationResolverClass, TriggerInfo triggerInfo) {
        this.name = name;
        this.taskClass = taskClass;
        this.setProperties(properties);
        this.setLocationResolverClass(TasksDSComponent.getTaskService().getServerConfiguration().getLocationResolverClass());
        this.triggerInfo = triggerInfo;
        if (this.getTriggerInfo() == null) {
            throw new IllegalArgumentException("Trigger information cannot be null");
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTaskClass(String taskClass) {
        this.taskClass = taskClass;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public void setTriggerInfo(TriggerInfo triggerInfo) {
        this.triggerInfo = triggerInfo;
    }

    @XmlElement(name="triggerInfo")
    public TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    @XmlElement(name="name")
    public String getName() {
        return this.name;
    }

    @XmlElement(name="taskClass")
    public String getTaskClass() {
        return this.taskClass;
    }

    @XmlElement(name="locationResolverClass")
    public String getLocationResolverClass() {
        return this.locationResolverClass;
    }

    public void setLocationResolverClass(String locationResolverClass) {
        this.locationResolverClass = locationResolverClass;
    }

    @XmlElementWrapper(name="locationResolverProperties", required=false, nillable=true)
    public Map<String, String> getLocationResolverProperties() {
        return this.locationResolverProperties;
    }

    public void setLocationResolverProperties(Map<String, String> locationResolverProperties) {
        this.locationResolverProperties = new HashMap<String, String>();
        if (locationResolverProperties != null) {
            this.locationResolverProperties.putAll(locationResolverProperties);
        }
    }

    @XmlElementWrapper(name="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object rhs) {
        if (!(rhs instanceof TaskInfo)) {
            return false;
        }
        return ((TaskInfo)rhs).getName().equals(this.getName());
    }

    @XmlRootElement(name="triggerInfo")
    public static class TriggerInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Date startTime;
        private Date endTime;
        private long intervalMillis;
        private int repeatCount;
        private String cronExpression;
        private TaskConstants.TaskMisfirePolicy misfirePolicy = TaskConstants.TaskMisfirePolicy.DEFAULT;
        private boolean disallowConcurrentExecution;

        public TriggerInfo() {
        }

        public TriggerInfo(Date startTime, Date endTime, long intervalMillis, int repeatCount) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.intervalMillis = intervalMillis;
            this.repeatCount = repeatCount;
        }

        public TriggerInfo(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        public void setDisallowConcurrentExecution(boolean disallowConcurrentExecution) {
            this.disallowConcurrentExecution = disallowConcurrentExecution;
        }

        public void setMisfirePolicy(TaskConstants.TaskMisfirePolicy misfirePolicy) {
            this.misfirePolicy = misfirePolicy;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public void setIntervalMillis(long intervalMillis) {
            this.intervalMillis = intervalMillis;
        }

        public void setRepeatCount(int repeatCount) {
            this.repeatCount = repeatCount;
        }

        public void setCronExpression(String cronExpression) {
            this.cronExpression = cronExpression;
        }

        @XmlElement(name="disallowConcurrentExecution")
        public boolean isDisallowConcurrentExecution() {
            return this.disallowConcurrentExecution;
        }

        @XmlElement(name="misfirePolicy")
        public TaskConstants.TaskMisfirePolicy getMisfirePolicy() {
            return this.misfirePolicy;
        }

        @XmlElement(name="cronExpression")
        public String getCronExpression() {
            return this.cronExpression;
        }

        @XmlElement(name="startTime")
        public Date getStartTime() {
            return this.startTime;
        }

        @XmlElement(name="endTime")
        public Date getEndTime() {
            return this.endTime;
        }

        @XmlElement(name="intervalMillis")
        public long getIntervalMillis() {
            return this.intervalMillis;
        }

        @XmlElement(name="repeatCount")
        public int getRepeatCount() {
            return this.repeatCount;
        }
    }
}

