/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.common;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;
import org.apache.oltu.oauth2.common.utils.OAuthUtils;
import org.wso2.carbon.identity.oauth.common.OAuthConstants;

public class OAuthCommonUtil {
    public static boolean isAllowedContentType(String contentTypeHeader, List<String> allowedContentTypes) {
        String[] requestContentTypes;
        if (contentTypeHeader == null || allowedContentTypes == null) {
            return false;
        }
        for (String requestContentType : requestContentTypes = contentTypeHeader.split(";")) {
            if (!allowedContentTypes.contains(requestContentType)) continue;
            return true;
        }
        return false;
    }

    public static void validateContentTypes(HttpServletRequest request) throws OAuthProblemException {
        String contentType = request.getContentType();
        if (!OAuthCommonUtil.isAllowedContentType(contentType, OAuthConstants.ALLOWED_CONTENT_TYPES)) {
            throw OAuthUtils.handleBadContentTypeException((String)String.join((CharSequence)" or ", OAuthConstants.ALLOWED_CONTENT_TYPES));
        }
    }
}

