/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.common;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.as.validator.TokenValidator;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;

public class IDTokenResponseValidator
extends TokenValidator {
    private static boolean containOIDCScope(String scope) {
        String[] scopeArray;
        for (String openidscope : scopeArray = scope.split("\\s+")) {
            if (!openidscope.equals("openid")) continue;
            return true;
        }
        return false;
    }

    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        super.validateRequiredParameters(request);
        String openIdScope = request.getParameter("scope");
        if (StringUtils.isBlank((String)openIdScope) || !IDTokenResponseValidator.containOIDCScope(openIdScope)) {
            throw OAuthProblemException.error((String)"invalid_request").description("'response_type' contains 'id_token'; but 'openid' scope not found.");
        }
    }

    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
        String method = request.getMethod();
        if (!"GET".equals(method) && !"POST".equals(method)) {
            throw OAuthProblemException.error((String)"invalid_request").description("Method not correct.");
        }
    }

    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
    }
}

