/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth.common;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.oltu.oauth2.as.validator.TokenValidator;
import org.apache.oltu.oauth2.common.exception.OAuthProblemException;

public class CodeTokenResponseValidator
extends TokenValidator {
    private static boolean isContainOIDCScope(String scope) {
        String[] scopeArray;
        for (String anyScope : scopeArray = scope.split("\\s+")) {
            if (!anyScope.equals("openid")) continue;
            return true;
        }
        return false;
    }

    public void validateRequiredParameters(HttpServletRequest request) throws OAuthProblemException {
        super.validateRequiredParameters(request);
        String openIdScope = request.getParameter("scope");
        if (StringUtils.isBlank((String)openIdScope) || !CodeTokenResponseValidator.isContainOIDCScope(openIdScope)) {
            String clientID = request.getParameter("client_id");
            throw OAuthProblemException.error((String)"invalid_request").description("Request with 'client_id' = '" + clientID + "' has 'response_type' for 'hybrid flow'; but 'openid' scope not found.");
        }
    }

    public void validateMethod(HttpServletRequest request) throws OAuthProblemException {
        String method = request.getMethod();
        if (!"GET".equals(method) && !"POST".equals(method)) {
            throw OAuthProblemException.error((String)"invalid_request").description("Method not correct.");
        }
    }

    public void validateContentType(HttpServletRequest request) throws OAuthProblemException {
    }
}

