/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.websocket.internal;

import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;

public class WebsocketClient
extends Endpoint {
    private static final Log log = LogFactory.getLog(WebsocketClient.class);
    private InputEventAdapterListener inputEventAdapterListener;
    private int tenantId;

    public WebsocketClient(InputEventAdapterListener inputEventAdapterListener, int tenantId) {
        this.inputEventAdapterListener = inputEventAdapterListener;
        this.tenantId = tenantId;
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<String>(){

            public void onMessage(String message) {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(WebsocketClient.this.tenantId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Received message: '" + message));
                }
                WebsocketClient.this.inputEventAdapterListener.onEvent((Object)message);
                PrivilegedCarbonContext.endTenantFlow();
            }
        });
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Input ws-adaptor: WebsocketClient Endpoint closed: " + closeReason.toString() + "for request URI - " + session.getRequestURI()));
        }
        try {
            session.close();
        }
        catch (IOException e) {
            log.error((Object)("Error occurred during closing session. Session ID:" + session.getId() + ", for request URI - " + session.getRequestURI() + ", Reason: " + e.getMessage()), (Throwable)e);
        }
    }

    public void onError(Session session, Throwable thr) {
        log.error((Object)("Error occurred during session ID:" + session.getId() + ", for request URI - " + session.getRequestURI() + ", Reason: " + thr), thr);
        try {
            session.close();
        }
        catch (IOException e) {
            log.error((Object)("Error occurred during closing session. Session ID:" + session.getId() + ", for request URI - " + session.getRequestURI() + ", Reason: " + e.getMessage()), (Throwable)e);
        }
    }
}

