/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.websocket;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterFactory;
import org.wso2.carbon.event.input.adapter.core.Property;
import org.wso2.carbon.event.input.adapter.websocket.WebsocketEventAdapter;

public class WebsocketEventAdapterFactory
extends InputEventAdapterFactory {
    private ResourceBundle resourceBundle = ResourceBundle.getBundle("org.wso2.carbon.event.input.adapter.websocket.i18n.Resources", Locale.getDefault());

    public String getType() {
        return "websocket";
    }

    public List<String> getSupportedMessageFormats() {
        ArrayList<String> supportInputMessageTypes = new ArrayList<String>();
        supportInputMessageTypes.add("xml");
        supportInputMessageTypes.add("json");
        supportInputMessageTypes.add("text");
        return supportInputMessageTypes;
    }

    public List<Property> getPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Property urlProperty = new Property("websocket.server.url");
        urlProperty.setDisplayName(this.resourceBundle.getString("websocket.server.url"));
        urlProperty.setHint(this.resourceBundle.getString("websocket.server.url.hint"));
        urlProperty.setRequired(true);
        propertyList.add(urlProperty);
        Property isDuplicatedInCluster = new Property("events.duplicated.in.cluster");
        isDuplicatedInCluster.setDisplayName(this.resourceBundle.getString("events.duplicated.in.cluster"));
        isDuplicatedInCluster.setRequired(false);
        isDuplicatedInCluster.setOptions(new String[]{"true", "false"});
        isDuplicatedInCluster.setDefaultValue("false");
        propertyList.add(isDuplicatedInCluster);
        return propertyList;
    }

    public String getUsageTips() {
        return null;
    }

    public InputEventAdapter createEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        return new WebsocketEventAdapter(eventAdapterConfiguration, globalProperties);
    }
}

