/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.input.adapter.websocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import org.glassfish.tyrus.client.ClientManager;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapter;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterConfiguration;
import org.wso2.carbon.event.input.adapter.core.InputEventAdapterListener;
import org.wso2.carbon.event.input.adapter.core.exception.ConnectionUnavailableException;
import org.wso2.carbon.event.input.adapter.core.exception.InputEventAdapterException;
import org.wso2.carbon.event.input.adapter.core.exception.TestConnectionNotSupportedException;
import org.wso2.carbon.event.input.adapter.websocket.internal.WebsocketClient;

public class WebsocketEventAdapter
implements InputEventAdapter {
    private InputEventAdapterListener eventAdapterListener;
    private final InputEventAdapterConfiguration eventAdapterConfiguration;
    private final Map<String, String> globalProperties;
    private final String socketServerUrl;
    private ClientManager client;
    private int tenantId;

    public WebsocketEventAdapter(InputEventAdapterConfiguration eventAdapterConfiguration, Map<String, String> globalProperties) {
        this.eventAdapterConfiguration = eventAdapterConfiguration;
        this.globalProperties = globalProperties;
        this.socketServerUrl = (String)eventAdapterConfiguration.getProperties().get("websocket.server.url");
    }

    public void init(InputEventAdapterListener eventAdaptorListener) throws InputEventAdapterException {
        this.validateInputEventAdapterConfigurations(this.eventAdapterConfiguration);
        this.eventAdapterListener = eventAdaptorListener;
        this.tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public void testConnect() throws TestConnectionNotSupportedException {
        this.connect();
    }

    public void connect() {
        ClientEndpointConfig clientEndpointConfig = ClientEndpointConfig.Builder.create().build();
        this.client = ClientManager.createClient();
        try {
            this.client.connectToServer((Endpoint)new WebsocketClient(this.eventAdapterListener, this.tenantId), clientEndpointConfig, new URI(this.socketServerUrl));
        }
        catch (DeploymentException e) {
            throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " failed to connect to the websocket server " + this.socketServerUrl, (Throwable)e);
        }
        catch (IOException e) {
            throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " failed to connect to the websocket server " + this.socketServerUrl, (Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ConnectionUnavailableException("The adapter " + this.eventAdapterConfiguration.getName() + " failed to connect to the websocket server " + this.socketServerUrl, (Throwable)e);
        }
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }

    public void destroy() {
    }

    public boolean isEventDuplicatedInCluster() {
        return Boolean.parseBoolean((String)this.eventAdapterConfiguration.getProperties().get("events.duplicated.in.cluster"));
    }

    public boolean isPolling() {
        return true;
    }

    private void validateInputEventAdapterConfigurations(InputEventAdapterConfiguration eventAdapterConfiguration) throws InputEventAdapterException {
        String socketServerUrl = (String)eventAdapterConfiguration.getProperties().get("websocket.server.url");
        if (!socketServerUrl.startsWith("ws://")) {
            throw new InputEventAdapterException("Provided websocket URL - " + socketServerUrl + " is invalid for websocket input adaptor with name" + eventAdapterConfiguration.getName() + ". The websocket URL should start with 'ws://' prefix.");
        }
    }
}

