/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.util;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.processors.RandomPasswordProcessor;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementClientException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementServerException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.idp.mgt.internal.IdPManagementServiceComponent;
import org.wso2.carbon.idp.mgt.util.IdPManagementConstants;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.tenant.TenantManager;

public class IdPManagementUtil {
    private static final Log log = LogFactory.getLog(IdPManagementUtil.class);
    private static String tenantContext;
    private static String tenantParameter;

    public static int getTenantIdOfDomain(String tenantDomain) throws UserStoreException {
        if (tenantDomain != null) {
            TenantManager tenantManager = IdPManagementServiceComponent.getRealmService().getTenantManager();
            int tenantId = tenantManager.getTenantId(tenantDomain);
            return tenantId;
        }
        log.debug((Object)"Invalid tenant domain: 'NULL'");
        throw new IllegalArgumentException("Invalid tenant domain: 'NULL'");
    }

    public static String getResidentIdPEntityId() {
        String localEntityId = IdentityUtil.getProperty((String)"SSOService.EntityId");
        if (localEntityId == null || localEntityId.trim().isEmpty()) {
            localEntityId = "localhost";
        }
        return localEntityId;
    }

    public static int getIdleSessionTimeOut(String tenantDomain) {
        IdentityProviderManager identityProviderManager = IdentityProviderManager.getInstance();
        int timeout = Integer.parseInt("15");
        try {
            IdentityProvider identityProvider = identityProviderManager.getResidentIdP(tenantDomain);
            IdentityProviderProperty idpProperty = IdentityApplicationManagementUtil.getProperty((IdentityProviderProperty[])identityProvider.getIdpProperties(), (String)"SessionIdleTimeout");
            if (idpProperty != null) {
                timeout = Integer.parseInt(idpProperty.getValue());
            }
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)("Error when accessing the IdentityProviderManager for tenant : " + tenantDomain), (Throwable)((Object)e));
        }
        return timeout * 60;
    }

    public static int getRememberMeTimeout(String tenantDomain) {
        IdentityProviderManager identityProviderManager = IdentityProviderManager.getInstance();
        int rememberMeTimeout = Integer.parseInt("20160");
        try {
            IdentityProvider identityProvider = identityProviderManager.getResidentIdP(tenantDomain);
            IdentityProviderProperty idpProperty = IdentityApplicationManagementUtil.getProperty((IdentityProviderProperty[])identityProvider.getIdpProperties(), (String)"RememberMeTimeout");
            if (idpProperty != null) {
                rememberMeTimeout = Integer.parseInt(idpProperty.getValue());
            }
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)("Error when accessing the IdentityProviderManager for tenant : " + tenantDomain), (Throwable)((Object)e));
        }
        return rememberMeTimeout * 60;
    }

    public static void removeOriginalPasswords(IdentityProvider identityProvider) {
        if (identityProvider == null || identityProvider.getProvisioningConnectorConfigs() == null) {
            return;
        }
        for (ProvisioningConnectorConfig provisioningConnectorConfig : identityProvider.getProvisioningConnectorConfigs()) {
            Object[] properties = provisioningConnectorConfig.getProvisioningProperties();
            if (ArrayUtils.isEmpty((Object[])properties)) continue;
            properties = RandomPasswordProcessor.getInstance().removeOriginalPasswords((Property[])properties);
            provisioningConnectorConfig.setProvisioningProperties((Property[])properties);
        }
    }

    public static void removeRandomPasswords(IdentityProvider identityProvider, boolean withCacheClear) {
        if (identityProvider == null || identityProvider.getProvisioningConnectorConfigs() == null) {
            return;
        }
        for (ProvisioningConnectorConfig provisioningConnectorConfig : identityProvider.getProvisioningConnectorConfigs()) {
            Object[] properties = provisioningConnectorConfig.getProvisioningProperties();
            if (ArrayUtils.isEmpty((Object[])properties)) continue;
            properties = RandomPasswordProcessor.getInstance().removeRandomPasswords((Property[])properties, withCacheClear);
            provisioningConnectorConfig.setProvisioningProperties((Property[])properties);
        }
    }

    public static void setTenantSpecifiers(String tenantDomain) {
        if (!"carbon.super".equalsIgnoreCase(tenantDomain)) {
            tenantContext = "t/" + tenantDomain + "/";
            tenantParameter = "?tenantDomain=" + tenantDomain;
        } else {
            tenantContext = "";
            tenantParameter = "";
        }
    }

    public static String getTenantContext() {
        return tenantContext;
    }

    public static String getTenantParameter() {
        return tenantParameter;
    }

    public static IdentityProviderManagementClientException handleClientException(IdPManagementConstants.ErrorMessage error, String data) {
        String message = IdPManagementUtil.includeData(error, data);
        return new IdentityProviderManagementClientException(error.getCode(), message);
    }

    public static IdentityProviderManagementClientException handleClientException(IdPManagementConstants.ErrorMessage error, String data, Throwable e) {
        String message = IdPManagementUtil.includeData(error, data);
        return new IdentityProviderManagementClientException(error.getCode(), message, e);
    }

    public static IdentityProviderManagementServerException handleServerException(IdPManagementConstants.ErrorMessage error, String data) {
        String message = IdPManagementUtil.includeData(error, data);
        return new IdentityProviderManagementServerException(error.getCode(), message);
    }

    public static IdentityProviderManagementServerException handleServerException(IdPManagementConstants.ErrorMessage error, String data, Throwable e) {
        String message = IdPManagementUtil.includeData(error, data);
        return new IdentityProviderManagementServerException(error.getCode(), message, e);
    }

    private static String includeData(IdPManagementConstants.ErrorMessage error, String data) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return message;
    }
}

