/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.listener;

import java.util.Collection;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.dao.CacheBackedIdPMgtDAO;
import org.wso2.carbon.idp.mgt.dao.IdPManagementDAO;
import org.wso2.carbon.idp.mgt.internal.IdPManagementServiceComponent;
import org.wso2.carbon.idp.mgt.listener.AbstractIdentityProviderMgtListener;
import org.wso2.carbon.idp.mgt.listener.IdentityProviderMgtListener;

public class IdentityProviderNameResolverListener
extends AbstractIdentityProviderMgtListener {
    private static CacheBackedIdPMgtDAO dao = new CacheBackedIdPMgtDAO(new IdPManagementDAO());

    @Override
    public int getDefaultOrderId() {
        return 202;
    }

    @Override
    public boolean doPreDeleteIdPByResourceId(String resourceId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider idp = dao.getIdPByResourceId(resourceId, IdentityTenantUtil.getTenantId((String)tenantDomain), tenantDomain);
        if (idp != null) {
            String idpName = idp.getIdentityProviderName();
            Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
            for (IdentityProviderMgtListener listener : listeners) {
                if (!listener.isEnable() || listener.doPreDeleteIdP(idpName, tenantDomain)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean doPostDeleteIdPByResourceId(String resourceId, IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        if (identityProvider != null) {
            String idpName = identityProvider.getIdentityProviderName();
            Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
            for (IdentityProviderMgtListener listener : listeners) {
                if (!listener.isEnable() || listener.doPostDeleteIdP(idpName, tenantDomain)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean doPreUpdateIdPByResourceId(String resourceId, IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        IdentityProvider idp = dao.getIdPByResourceId(resourceId, tenantId, tenantDomain);
        if (idp != null) {
            String oldIdPName = idp.getIdentityProviderName();
            Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
            for (IdentityProviderMgtListener listener : listeners) {
                if (!listener.isEnable() || listener.doPreUpdateIdP(oldIdPName, identityProvider, tenantDomain)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean doPostUpdateIdPByResourceId(String resourceId, IdentityProvider oldIdentityProvider, IdentityProvider newIdentityProvider, String tenantDomain) throws IdentityProviderManagementException {
        if (oldIdentityProvider != null) {
            String oldIdPName = oldIdentityProvider.getIdentityProviderName();
            Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
            for (IdentityProviderMgtListener listener : listeners) {
                if (!listener.isEnable() || listener.doPostUpdateIdP(oldIdPName, newIdentityProvider, tenantDomain)) continue;
                return false;
            }
        }
        return true;
    }
}

