/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.listener;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.listener.AbstractIdentityProviderMgtListener;

public class IdPMgtValidationListener
extends AbstractIdentityProviderMgtListener {
    private static final Log log = LogFactory.getLog(IdPMgtValidationListener.class);

    @Override
    public int getDefaultOrderId() {
        return 30;
    }

    @Override
    public boolean doPreDeleteIdP(String idPName, String tenantDomain) throws IdentityProviderManagementException {
        if (StringUtils.isEmpty((String)idPName)) {
            throw new IllegalArgumentException("Invalid argument: Identity Provider Name value is empty");
        }
        String loggedInTenant = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        if ("LOCAL".equals(idPName)) {
            if (StringUtils.equals((String)"carbon.super", (String)tenantDomain)) {
                throw new IdentityProviderManagementException("Cannot delete Resident Identity Provider of Super Tenant");
            }
            if ("carbon.super" != loggedInTenant) {
                throw new IdentityProviderManagementException("Tenant user of " + loggedInTenant + " cannot delete Resident Identity Provider of tenant " + tenantDomain);
            }
            log.warn((Object)("Deleting Resident Identity Provider for tenant " + tenantDomain));
        }
        return true;
    }

    @Override
    public boolean doPreDeleteIdPs(String tenantDomain) throws IdentityProviderManagementException {
        return super.doPreDeleteIdPs(tenantDomain);
    }

    @Override
    public boolean doPreAddIdP(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        if (identityProvider == null) {
            throw new IllegalArgumentException("Identity provider cannot be null when adding an IdP");
        }
        if (StringUtils.isEmpty((String)identityProvider.getIdentityProviderName())) {
            throw new IllegalArgumentException("Invalid argument: Identity Provider Name value is empty");
        }
        return true;
    }

    @Override
    public boolean doPreUpdateResidentIdP(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        if (identityProvider == null) {
            throw new IllegalArgumentException("Identity provider is null");
        }
        if (StringUtils.isEmpty((String)identityProvider.getHomeRealmId())) {
            String msg = "Invalid argument: Resident Identity Provider Home Realm Identifier value is empty";
            throw new IllegalArgumentException(msg);
        }
        return true;
    }

    @Override
    public boolean doPreUpdateIdP(String oldIdPName, IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        if (identityProvider == null) {
            throw new IllegalArgumentException("Invalid argument: 'newIdentityProvider' is NULL'");
        }
        if (StringUtils.isEmpty((String)oldIdPName)) {
            throw new IllegalArgumentException("The IdP name which need to be updated is empty");
        }
        if (StringUtils.isEmpty((String)identityProvider.getIdentityProviderName())) {
            String msg = "Invalid argument: The new value of the identity provider name is empty.";
            throw new IdentityProviderManagementException(msg);
        }
        if (!oldIdPName.startsWith("SHARED_") && identityProvider.getIdentityProviderName() != null && identityProvider.getIdentityProviderName().startsWith("SHARED_")) {
            throw new IdentityProviderManagementException("Cannot update Idp name to have 'SHARED_' as a prefix (previous name:" + oldIdPName + ", New name: " + identityProvider.getIdentityProviderName() + ")");
        }
        return true;
    }

    @Override
    public boolean doPreAddResidentIdP(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        if (StringUtils.isEmpty((String)identityProvider.getHomeRealmId())) {
            String msg = "Invalid argument: Resident Identity Provider Home Realm Identifier value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        return true;
    }
}

