/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.listener;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.listener.AbstractIdentityProviderMgtListener;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class IDPMgtAuditLogger
extends AbstractIdentityProviderMgtListener {
    Log audit = CarbonConstants.AUDIT_LOG;
    private static String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ";
    private final String SUCCESS = "Success";

    @Override
    public int getDefaultOrderId() {
        return 220;
    }

    @Override
    public boolean doPostAddIdP(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        String displayName = "Undefined";
        String idpName = "Undefined";
        if (identityProvider != null) {
            if (StringUtils.isNotEmpty((String)identityProvider.getDisplayName())) {
                displayName = identityProvider.getDisplayName();
            }
            idpName = identityProvider.getIdentityProviderName();
        }
        this.audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "add", UserCoreUtil.addTenantDomainToEntry((String)displayName, (String)tenantDomain), idpName, "Success"));
        return true;
    }

    @Override
    public boolean doPostUpdateIdP(String oldIdPName, IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        String displayName = "Undefined";
        if (identityProvider != null && StringUtils.isNotEmpty((String)identityProvider.getDisplayName())) {
            displayName = identityProvider.getDisplayName();
        }
        this.audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "update", oldIdPName, UserCoreUtil.addTenantDomainToEntry((String)displayName, (String)tenantDomain), "Success"));
        return true;
    }

    @Override
    public boolean doPostDeleteIdP(String idPName, String tenantDomain) throws IdentityProviderManagementException {
        if (StringUtils.isEmpty((String)idPName)) {
            idPName = "Undefined";
        }
        this.audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "delete", UserCoreUtil.addTenantDomainToEntry((String)idPName, (String)tenantDomain), null, "Success"));
        return true;
    }

    @Override
    public boolean doPostDeleteIdPs(String tenantDomain) throws IdentityProviderManagementException {
        this.audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "delete all IdPs", tenantDomain, null, "Success"));
        return true;
    }

    private String getUser() {
        String user = CarbonContext.getThreadLocalCarbonContext().getUsername();
        user = user != null ? user + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain() : "wso2.system.user";
        return user;
    }
}

