/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.internal;

import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.AbstractIdentityUserOperationEventListener;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.dao.CacheBackedIdPMgtDAO;
import org.wso2.carbon.idp.mgt.dao.IdPManagementDAO;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class UserStoreListener
extends AbstractIdentityUserOperationEventListener {
    private CacheBackedIdPMgtDAO dao = new CacheBackedIdPMgtDAO(new IdPManagementDAO());

    public int getExecutionOrderId() {
        int orderId = this.getOrderId();
        if (orderId != -1) {
            return orderId;
        }
        return 20;
    }

    public boolean doPostUpdateRoleName(String newRoleName, String oldRoleName, UserStoreManager um) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.dao.renameTenantRole(newRoleName, oldRoleName, tenantId, tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
        return true;
    }

    public boolean doPostDeleteRole(String roleName, UserStoreManager userStoreManager) throws UserStoreException {
        if (!this.isEnable()) {
            return true;
        }
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            this.dao.deleteTenantRole(tenantId, roleName, tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
        return true;
    }
}

