/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.core.AbstractIdentityTenantMgtListener;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.stratos.common.beans.TenantInfoBean;
import org.wso2.carbon.stratos.common.exception.StratosException;

public class TenantManagementListener
extends AbstractIdentityTenantMgtListener {
    private static final int EXEC_ORDER = 21;
    private static final Log log = LogFactory.getLog(TenantManagementListener.class);

    public void onTenantCreate(TenantInfoBean tenantInfo) throws StratosException {
        try {
            String tenantDomain = tenantInfo.getTenantDomain();
            IdentityProvider identityProvider = new IdentityProvider();
            identityProvider.setIdentityProviderName("LOCAL");
            identityProvider.setHomeRealmId("localhost");
            identityProvider.setPrimary(true);
            IdentityProviderManager.getInstance().addResidentIdP(identityProvider, tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String message = "Error when adding Resident Identity Provider entry for tenant " + tenantInfo.getTenantDomain();
            throw new StratosException(message, (Throwable)((Object)e));
        }
    }

    public void onTenantDelete(int i) {
    }

    public int getListenerOrder() {
        return 21;
    }

    public void onPreDelete(int tenantId) throws StratosException {
        String tenantDomain = IdentityTenantUtil.getTenantDomain((int)tenantId);
        try {
            IdentityProviderManager.getInstance().deleteIdPs(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String message = "Error when deleting Identity Providers for tenant " + tenantDomain;
            throw new StratosException(message, (Throwable)((Object)e));
        }
    }
}

