/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.core.ConnectorConfig;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.role.mgt.core.RoleManagementService;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.idp.mgt.dao.CacheBackedIdPMgtDAO;
import org.wso2.carbon.idp.mgt.dao.IdPManagementDAO;
import org.wso2.carbon.idp.mgt.internal.IdpMgtServiceComponentHolder;
import org.wso2.carbon.idp.mgt.internal.TenantManagementListener;
import org.wso2.carbon.idp.mgt.internal.UserStoreListener;
import org.wso2.carbon.idp.mgt.listener.IDPMgtAuditLogger;
import org.wso2.carbon.idp.mgt.listener.IdPMgtValidationListener;
import org.wso2.carbon.idp.mgt.listener.IdentityProviderMgtListener;
import org.wso2.carbon.idp.mgt.listener.IdentityProviderNameResolverListener;
import org.wso2.carbon.idp.mgt.util.MetadataConverter;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="idp.mgt.dscomponent", immediate=true)
public class IdPManagementServiceComponent {
    private static Log log = LogFactory.getLog(IdPManagementServiceComponent.class);
    private static Map<String, IdentityProvider> fileBasedIdPs = new HashMap<String, IdentityProvider>();
    private static Set<String> sharedIdps = new HashSet<String>();
    private static Comparator<IdentityProviderMgtListener> idpMgtListenerComparator = new Comparator<IdentityProviderMgtListener>(){

        @Override
        public int compare(IdentityProviderMgtListener identityProviderMgtListener1, IdentityProviderMgtListener identityProviderMgtListener2) {
            if (identityProviderMgtListener1.getExecutionOrderId() > identityProviderMgtListener2.getExecutionOrderId()) {
                return 1;
            }
            if (identityProviderMgtListener1.getExecutionOrderId() < identityProviderMgtListener2.getExecutionOrderId()) {
                return -1;
            }
            return 0;
        }
    };

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Registry service in Identity idp-mgt bundle");
        }
        try {
            IdpMgtServiceComponentHolder.getInstance().setRegistryService(registryService);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Registry in idp-mgt bundle", e);
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in idp.mgt bundle");
        }
        IdpMgtServiceComponentHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="identity.provider.saml.service.component", service=MetadataConverter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetadataConverterService")
    protected void setMetadataConverterService(MetadataConverter converter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Metadata converter set in Identity idp-mgt bundle");
        }
        try {
            IdpMgtServiceComponentHolder.getInstance().addMetadataConverter(converter);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get a reference to the Metadata Converter in idp-mgt bundle", e);
        }
    }

    protected void unsetMetadataConverterService(MetadataConverter metadataConverter) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"org.wso2.carbon.idp.mgt.util.MetadataConverter unset in idp-mgt");
        }
        IdpMgtServiceComponentHolder.getInstance().removeMetadataConverter(metadataConverter);
    }

    public static Map<String, IdentityProvider> getFileBasedIdPs() {
        return fileBasedIdPs;
    }

    public static RealmService getRealmService() {
        return IdpMgtServiceComponentHolder.getInstance().getRealmService();
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService rlmService) {
        IdpMgtServiceComponentHolder.getInstance().setRealmService(rlmService);
    }

    public static ConfigurationContextService getConfigurationContextService() {
        return IdpMgtServiceComponentHolder.getInstance().getConfigurationContextService();
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService service) {
        IdpMgtServiceComponentHolder.getInstance().setConfigurationContextService(service);
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bundleCtx = ctxt.getBundleContext();
            TenantManagementListener idPMgtTenantMgtListener = new TenantManagementListener();
            ServiceRegistration tenantMgtListenerSR = bundleCtx.registerService(TenantMgtListener.class.getName(), (Object)idPMgtTenantMgtListener, null);
            if (tenantMgtListenerSR != null) {
                log.debug((Object)"Identity Provider Management - TenantMgtListener registered");
            } else {
                log.error((Object)"Identity Provider Management - TenantMgtListener could not be registered");
            }
            ServiceRegistration userOperationListenerSR = bundleCtx.registerService(UserOperationEventListener.class.getName(), (Object)new UserStoreListener(), null);
            if (userOperationListenerSR != null) {
                log.debug((Object)"Identity Provider Management - UserOperationEventListener registered");
            } else {
                log.error((Object)"Identity Provider Management - UserOperationEventListener could not be registered");
            }
            ServiceRegistration auditLoggerSR = bundleCtx.registerService(IdentityProviderMgtListener.class.getName(), (Object)new IDPMgtAuditLogger(), null);
            if (auditLoggerSR != null) {
                log.debug((Object)"Identity Provider Management - Audit Logger registered");
            } else {
                log.error((Object)"Identity Provider Management - Error while registering Audit Logger");
            }
            ServiceRegistration idPNameResolverListener = bundleCtx.registerService(IdentityProviderMgtListener.class.getName(), (Object)new IdentityProviderNameResolverListener(), null);
            if (idPNameResolverListener != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Identity Provider Name Resolver Listener registered.");
                }
            } else {
                log.error((Object)"Identity Provider Management - Error while registering Identity Provider Name Resolver Listener.");
            }
            this.setIdentityProviderMgtListenerService(new IdPMgtValidationListener());
            CacheBackedIdPMgtDAO dao = new CacheBackedIdPMgtDAO(new IdPManagementDAO());
            if (dao.getIdPByName(null, "LOCAL", IdentityTenantUtil.getTenantId((String)"carbon.super"), "carbon.super") == null) {
                IdPManagementServiceComponent.addSuperTenantIdp();
            }
            bundleCtx.registerService(IdpManager.class, (Object)IdentityProviderManager.getInstance(), null);
            this.buildFileBasedIdPList();
            this.cleanUpRemovedIdps();
            log.debug((Object)"Identity Provider Management bundle is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating Identity Provider Management bundle", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFileBasedIdPList() {
        String spConfigDirPath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "identity" + File.separator + "identity-providers";
        FileInputStream fileInputStream = null;
        File spConfigDir = new File(spConfigDirPath);
        OMElement documentElement = null;
        Object[] fileList = spConfigDir.listFiles();
        if (spConfigDir.exists() && ArrayUtils.isNotEmpty((Object[])fileList)) {
            for (Object fileEntry : fileList) {
                try {
                    IdentityProvider idp;
                    if (((File)fileEntry).isDirectory() || (idp = IdentityProvider.build((OMElement)(documentElement = new StAXOMBuilder((InputStream)(fileInputStream = new FileInputStream(new File(((File)fileEntry).getAbsolutePath())))).getDocumentElement()))) == null) continue;
                    IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
                    String superTenantDN = "carbon.super";
                    if (this.isSharedIdP(idp)) {
                        IdentityProvider currentIdp = idpManager.getIdPByName(idp.getIdentityProviderName(), superTenantDN);
                        if (currentIdp != null && !"default".equals(currentIdp.getIdentityProviderName())) {
                            idpManager.updateIdP(idp.getIdentityProviderName(), idp, superTenantDN);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Shared IdP " + idp.getIdentityProviderName() + " updated"));
                            }
                        } else {
                            idpManager.addIdP(idp, superTenantDN);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Shared IdP " + idp.getIdentityProviderName() + " added"));
                            }
                        }
                        sharedIdps.add(idp.getIdentityProviderName());
                        continue;
                    }
                    fileBasedIdPs.put(idp.getIdentityProviderName(), idp);
                }
                catch (Exception e) {
                    log.error((Object)"Error while loading idp from file system.", (Throwable)e);
                }
                finally {
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void cleanUpRemovedIdps() {
        List<IdentityProvider> idPs;
        IdentityProviderManager idpManager = IdentityProviderManager.getInstance();
        String superTenantDN = "carbon.super";
        try {
            idPs = idpManager.getIdPs(superTenantDN);
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)"Error loading IDPs", (Throwable)((Object)e));
            return;
        }
        for (IdentityProvider idp : idPs) {
            if (!this.isSharedIdP(idp) || sharedIdps.contains(idp.getIdentityProviderName())) continue;
            try {
                idpManager.deleteIdP(idp.getIdentityProviderName(), superTenantDN);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Deleted shared IdP with the name : " + idp.getIdentityProviderName()));
            }
            catch (IdentityProviderManagementException e) {
                log.error((Object)("Error when deleting IdP " + idp.getIdentityProviderName()), (Throwable)((Object)e));
            }
        }
    }

    private boolean isSharedIdP(IdentityProvider idp) {
        return idp != null && idp.getIdentityProviderName() != null && idp.getIdentityProviderName().startsWith("SHARED_");
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Identity Provider Management bundle is deactivated");
    }

    protected void unsetRealmService(RealmService realmService) {
        IdpMgtServiceComponentHolder.getInstance().setRealmService(null);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService service) {
        IdpMgtServiceComponentHolder.getInstance().setConfigurationContextService(null);
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="org.wso2.carbon.identity.role.mgt.core.internal.RoleManagementServiceComponent", service=RoleManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRoleManagementService")
    private void setRoleManagementService(RoleManagementService roleManagementService) {
        IdpMgtServiceComponentHolder.getInstance().setRoleManagementService(roleManagementService);
    }

    private void unsetRoleManagementService(RoleManagementService roleManagementService) {
        IdpMgtServiceComponentHolder.getInstance().setRoleManagementService(null);
    }

    @Reference(name="idp.mgt.event.listener.service", service=IdentityProviderMgtListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityProviderMgtListenerService")
    protected void setIdentityProviderMgtListenerService(IdentityProviderMgtListener identityProviderMgtListenerService) {
        IdpMgtServiceComponentHolder.getInstance().getIdpMgtListeners().add(identityProviderMgtListenerService);
        Collections.sort(IdpMgtServiceComponentHolder.getInstance().getIdpMgtListeners(), idpMgtListenerComparator);
    }

    protected void unsetIdentityProviderMgtListenerService(IdentityProviderMgtListener identityProviderMgtListenerService) {
        IdpMgtServiceComponentHolder.getInstance().getIdpMgtListeners().remove(identityProviderMgtListenerService);
    }

    public static Collection<IdentityProviderMgtListener> getIdpMgtListeners() {
        return IdpMgtServiceComponentHolder.getInstance().getIdpMgtListeners();
    }

    private static void addSuperTenantIdp() throws Exception {
        try {
            IdentityProvider identityProvider = new IdentityProvider();
            identityProvider.setIdentityProviderName("LOCAL");
            identityProvider.setHomeRealmId(IdentityUtil.getHostName());
            identityProvider.setPrimary(true);
            IdentityProviderManager.getInstance().addResidentIdP(identityProvider, "carbon.super");
        }
        catch (Throwable e) {
            throw new Exception("Error when adding Resident Identity Provider entry for super tenant ", e);
        }
    }

    @Reference(name="identity.core.ConnectorConfig", service=ConnectorConfig.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetGovernanceConnector")
    protected void setIdentityGovernanceConnector(ConnectorConfig identityConnectorConfig) {
        try {
            IdpMgtServiceComponentHolder.getInstance().addConnectorConfig(identityConnectorConfig);
        }
        catch (IdentityProviderManagementException e) {
            log.error((Object)"Error while clearing the cache with the registered connector config.");
        }
    }

    protected void unsetGovernanceConnector(ConnectorConfig identityConnectorConfig) {
        IdpMgtServiceComponentHolder.getInstance().unsetGovernanceConnector(identityConnectorConfig);
    }
}

