/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.dao;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.wso2.carbon.identity.application.common.model.CertificateInfo;
import org.wso2.carbon.identity.application.common.model.Claim;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.JustInTimeProvisioningConfig;
import org.wso2.carbon.identity.application.common.model.LocalRole;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.core.ConnectorConfig;
import org.wso2.carbon.identity.core.ConnectorException;
import org.wso2.carbon.identity.core.model.ExpressionNode;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementClientException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementServerException;
import org.wso2.carbon.idp.mgt.internal.IdpMgtServiceComponentHolder;
import org.wso2.carbon.idp.mgt.model.ConnectedAppsResult;
import org.wso2.carbon.idp.mgt.model.FilterQueryBuilder;
import org.wso2.carbon.idp.mgt.util.IdPManagementConstants;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.utils.DBUtils;

public class IdPManagementDAO {
    private static final Log log = LogFactory.getLog(IdPManagementDAO.class);

    public List<IdentityProvider> getIdPs(Connection dbConnection, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        ArrayList<IdentityProvider> arrayList;
        block17: {
            ResultSet rs;
            PreparedStatement prepStmt;
            block16: {
                boolean dbConnInitialized = true;
                prepStmt = null;
                rs = null;
                ArrayList<IdentityProvider> idps = new ArrayList<IdentityProvider>();
                if (dbConnection == null) {
                    dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
                } else {
                    dbConnInitialized = false;
                }
                try {
                    String sqlStmt = "SELECT NAME, IS_PRIMARY, HOME_REALM_ID, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, IS_ENABLED, DISPLAY_NAME, ID, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%'))";
                    prepStmt = dbConnection.prepareStatement(sqlStmt);
                    prepStmt.setInt(1, tenantId);
                    prepStmt.setInt(2, -1234);
                    rs = prepStmt.executeQuery();
                    while (rs.next()) {
                        String identityProviderName = rs.getString(1);
                        if ("LOCAL".equals(identityProviderName)) continue;
                        IdentityProvider identityProvider = new IdentityProvider();
                        identityProvider.setIdentityProviderName(identityProviderName);
                        if ("1".equals(rs.getString("IS_PRIMARY"))) {
                            identityProvider.setPrimary(true);
                        } else {
                            identityProvider.setPrimary(false);
                        }
                        identityProvider.setHomeRealmId(rs.getString("HOME_REALM_ID"));
                        identityProvider.setIdentityProviderDescription(rs.getString("DESCRIPTION"));
                        if ("1".equals(rs.getString("IS_FEDERATION_HUB"))) {
                            identityProvider.setFederationHub(false);
                        }
                        if ("1".equals(rs.getString("IS_LOCAL_CLAIM_DIALECT"))) {
                            if (identityProvider.getClaimConfig() == null) {
                                identityProvider.setClaimConfig(new ClaimConfig());
                            }
                            identityProvider.getClaimConfig().setLocalClaimDialect(true);
                        }
                        if ("1".equals(rs.getString("IS_ENABLED"))) {
                            identityProvider.setEnable(true);
                        } else {
                            identityProvider.setEnable(false);
                        }
                        identityProvider.setDisplayName(rs.getString("DISPLAY_NAME"));
                        identityProvider.setId(rs.getString("ID"));
                        List<IdentityProviderProperty> propertyList = this.getIdentityPropertiesByIdpId(dbConnection, Integer.parseInt(identityProvider.getId()));
                        identityProvider.setIdpProperties(propertyList.toArray(new IdentityProviderProperty[0]));
                        identityProvider.setImageUrl(rs.getString("IMAGE_URL"));
                        identityProvider.setResourceId(rs.getString("UUID"));
                        idps.add(identityProvider);
                    }
                    arrayList = idps;
                    if (!dbConnInitialized) break block16;
                }
                catch (SQLException e) {
                    try {
                        throw new IdentityProviderManagementException("Error occurred while retrieving registered Identity Provider Entity IDs for tenant " + tenantDomain, e);
                    }
                    catch (Throwable throwable) {
                        if (dbConnInitialized) {
                            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                        } else {
                            IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                        }
                        throw throwable;
                    }
                }
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
                break block17;
            }
            IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        }
        return arrayList;
    }

    public List<IdentityProvider> getIdPsSearch(Connection dbConnection, int tenantId, String tenantDomain, String filter) throws IdentityProviderManagementException {
        ArrayList<IdentityProvider> arrayList;
        block19: {
            ResultSet rs;
            PreparedStatement prepStmt;
            block18: {
                boolean dbConnInitialized = true;
                prepStmt = null;
                rs = null;
                ArrayList<IdentityProvider> idps = new ArrayList<IdentityProvider>();
                if (dbConnection == null) {
                    dbConnection = IdentityDatabaseUtil.getDBConnection();
                } else {
                    dbConnInitialized = false;
                }
                try {
                    String sqlStmt = "SELECT NAME, IS_PRIMARY, HOME_REALM_ID, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, IS_ENABLED, DISPLAY_NAME, ID, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND NAME LIKE ?";
                    prepStmt = dbConnection.prepareStatement(sqlStmt);
                    if (StringUtils.isNotBlank((String)filter)) {
                        filter = filter.trim();
                        filter = filter.replace("*", "%");
                        filter = filter.replace("?", "_");
                    } else {
                        filter = "%";
                    }
                    prepStmt.setInt(1, tenantId);
                    prepStmt.setInt(2, -1234);
                    prepStmt.setString(3, filter);
                    rs = prepStmt.executeQuery();
                    while (rs.next()) {
                        String identityProviderName = rs.getString(1);
                        if ("LOCAL".equals(identityProviderName)) continue;
                        IdentityProvider identityProvider = new IdentityProvider();
                        identityProvider.setIdentityProviderName(identityProviderName);
                        if ("1".equals(rs.getString("IS_PRIMARY"))) {
                            identityProvider.setPrimary(true);
                        } else {
                            identityProvider.setPrimary(false);
                        }
                        identityProvider.setHomeRealmId(rs.getString("HOME_REALM_ID"));
                        identityProvider.setIdentityProviderDescription(rs.getString("DESCRIPTION"));
                        if ("1".equals(rs.getString("IS_FEDERATION_HUB"))) {
                            identityProvider.setFederationHub(false);
                        }
                        if ("1".equals(rs.getString("IS_LOCAL_CLAIM_DIALECT"))) {
                            if (identityProvider.getClaimConfig() == null) {
                                identityProvider.setClaimConfig(new ClaimConfig());
                            }
                            identityProvider.getClaimConfig().setLocalClaimDialect(true);
                        }
                        if ("1".equals(rs.getString("IS_ENABLED"))) {
                            identityProvider.setEnable(true);
                        } else {
                            identityProvider.setEnable(false);
                        }
                        identityProvider.setDisplayName(rs.getString("DISPLAY_NAME"));
                        identityProvider.setId(rs.getString("ID"));
                        List<IdentityProviderProperty> propertyList = this.getIdentityPropertiesByIdpId(dbConnection, Integer.parseInt(identityProvider.getId()));
                        identityProvider.setIdpProperties(propertyList.toArray(new IdentityProviderProperty[0]));
                        identityProvider.setImageUrl(rs.getString("IMAGE_URL"));
                        identityProvider.setResourceId(rs.getString("UUID"));
                        if ("LOCAL".equals(identityProvider.getIdentityProviderName())) continue;
                        idps.add(identityProvider);
                    }
                    IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
                    arrayList = idps;
                    if (!dbConnInitialized) break block18;
                }
                catch (SQLException e) {
                    try {
                        IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
                        throw new IdentityProviderManagementException("Error occurred while retrieving registered Identity Provider Entity IDs for tenant " + tenantDomain, e);
                    }
                    catch (Throwable throwable) {
                        if (dbConnInitialized) {
                            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                        } else {
                            IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                        }
                        throw throwable;
                    }
                }
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
                break block19;
            }
            IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        }
        return arrayList;
    }

    List<IdentityProvider> getIdPsSearch(int tenantId, List<ExpressionNode> expressionNode, int limit, int offset, String sortOrder, String sortBy) throws IdentityProviderManagementServerException, IdentityProviderManagementClientException {
        return this.getIdPsSearch(tenantId, expressionNode, limit, offset, sortOrder, sortBy, null);
    }

    /*
     * Exception decompiling
     */
    List<IdentityProvider> getIdPsSearch(int tenantId, List<ExpressionNode> expressionNode, int limit, int offset, String sortOrder, String sortBy, List<String> requiredAttributes) throws IdentityProviderManagementServerException, IdentityProviderManagementClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResultSet getIdpQueryResultSet(Connection dbConnection, String sortedOrder, int tenantId, int offset, int limit, FilterQueryBuilder filterQueryBuilder, List<String> requiredAttributes) throws SQLException, IdentityProviderManagementServerException, IdentityProviderManagementClientException {
        PreparedStatement prepStmt;
        Map<Integer, String> filterAttributeValue = filterQueryBuilder.getFilterAttributeValue();
        int filterAttributeValueSize = filterAttributeValue.entrySet().size();
        String databaseProductName = dbConnection.getMetaData().getDatabaseProductName();
        if (databaseProductName.contains("MySQL") || databaseProductName.contains("MariaDB") || databaseProductName.contains("H2")) {
            String sqlQuery = "SELECT ID, NAME, DESCRIPTION, IS_ENABLED, IMAGE_URL, UUID ";
            sqlQuery = this.appendRequiredAttributes(sqlQuery, requiredAttributes);
            String sqlTail = String.format("TENANT_ID = ? AND NAME != 'LOCAL' ORDER BY %s LIMIT ?, ?", sortedOrder);
            sqlQuery = sqlQuery + "FROM IDP WHERE " + filterQueryBuilder.getFilterQuery() + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            for (Map.Entry<Integer, String> prepareStatement : filterAttributeValue.entrySet()) {
                prepStmt.setString(prepareStatement.getKey(), prepareStatement.getValue());
            }
            prepStmt.setInt(filterAttributeValueSize + 1, tenantId);
            prepStmt.setInt(filterAttributeValueSize + 2, offset);
            prepStmt.setInt(filterAttributeValueSize + 3, limit);
        } else if (databaseProductName.contains("Oracle")) {
            String tempSqlQuery = "SELECT ID, NAME, DESCRIPTION, IS_ENABLED, IMAGE_URL, UUID, TENANT_ID ";
            tempSqlQuery = this.appendRequiredAttributes(tempSqlQuery, requiredAttributes);
            String sortBy = String.format("FROM IDP ORDER BY %s ) WHERE ", sortedOrder);
            String sqlTail = "TENANT_ID = ? AND NAME != 'LOCAL' AND ROWNUM <= ?) WHERE rnum > ?";
            String sqlQuery = tempSqlQuery + " FROM ( " + tempSqlQuery + ", ROWNUM AS rnum FROM (" + tempSqlQuery + sortBy;
            sqlQuery = sqlQuery + filterQueryBuilder.getFilterQuery() + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            for (Map.Entry<Integer, String> prepareStatement : filterAttributeValue.entrySet()) {
                prepStmt.setString(prepareStatement.getKey(), prepareStatement.getValue());
            }
            prepStmt.setInt(filterAttributeValueSize + 1, tenantId);
            prepStmt.setInt(filterAttributeValueSize + 2, offset + limit);
            prepStmt.setInt(filterAttributeValueSize + 3, offset);
        } else if (databaseProductName.contains("Microsoft")) {
            String sqlQuery = "SELECT ID, NAME, DESCRIPTION, IS_ENABLED, IMAGE_URL, UUID ";
            sqlQuery = this.appendRequiredAttributes(sqlQuery, requiredAttributes);
            String sqlTail = String.format("TENANT_ID =? AND NAME != 'LOCAL' ORDER BY %s OFFSET ? ROWS FETCH NEXT ? ROWS ONLY", sortedOrder);
            sqlQuery = sqlQuery + "FROM IDP WHERE " + filterQueryBuilder.getFilterQuery() + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            for (Map.Entry<Integer, String> prepareStatement : filterAttributeValue.entrySet()) {
                prepStmt.setString(prepareStatement.getKey(), prepareStatement.getValue());
            }
            prepStmt.setInt(filterAttributeValueSize + 1, tenantId);
            prepStmt.setInt(filterAttributeValueSize + 2, offset);
            prepStmt.setInt(filterAttributeValueSize + 3, limit);
        } else if (databaseProductName.contains("PostgreSQL")) {
            String sqlQuery = "SELECT ID, NAME, DESCRIPTION, IS_ENABLED, IMAGE_URL, UUID ";
            sqlQuery = this.appendRequiredAttributes(sqlQuery, requiredAttributes);
            String sqlTail = String.format("TENANT_ID = ? AND NAME != 'LOCAL' ORDER BY %s LIMIT ? OFFSET ?", sortedOrder);
            sqlQuery = sqlQuery + "FROM IDP WHERE " + filterQueryBuilder.getFilterQuery() + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            for (Map.Entry<Integer, String> prepareStatement : filterAttributeValue.entrySet()) {
                prepStmt.setString(prepareStatement.getKey(), prepareStatement.getValue());
            }
            prepStmt.setInt(filterAttributeValueSize + 1, tenantId);
            prepStmt.setInt(filterAttributeValueSize + 2, limit);
            prepStmt.setInt(filterAttributeValueSize + 3, offset);
        } else if (databaseProductName.contains("DB2")) {
            String sqlQuery = "SELECT ID, NAME, DESCRIPTION, IS_ENABLED, IMAGE_URL, UUID ";
            sqlQuery = this.appendRequiredAttributes(sqlQuery, requiredAttributes);
            String sqlTail = String.format("TENANT_ID = ? AND NAME != 'LOCAL' ORDER BY %s LIMIT ? OFFSET ?", sortedOrder);
            sqlQuery = sqlQuery + "FROM IDP WHERE " + filterQueryBuilder.getFilterQuery() + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            for (Map.Entry<Integer, String> prepareStatement : filterAttributeValue.entrySet()) {
                prepStmt.setString(prepareStatement.getKey(), prepareStatement.getValue());
            }
            prepStmt.setInt(filterAttributeValueSize + 1, tenantId);
            prepStmt.setInt(filterAttributeValueSize + 2, limit);
            prepStmt.setInt(filterAttributeValueSize + 3, offset);
        } else if (databaseProductName.contains("INFORMIX")) {
            String sqlQuery = "SELECT SKIP ? FIRST ? ID, NAME, DESCRIPTION, IS_ENABLED, IMAGE_URL, UUID ";
            sqlQuery = this.appendRequiredAttributes(sqlQuery, requiredAttributes);
            String sqlTail = String.format("TENANT_ID = ? AND NAME != 'LOCAL' ORDER BY %s", sortedOrder);
            sqlQuery = sqlQuery + "FROM IDP WHERE " + filterQueryBuilder.getFilterQuery() + sqlTail;
            prepStmt = dbConnection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, offset);
            prepStmt.setInt(2, limit);
            for (Map.Entry<Integer, String> prepareStatement : filterAttributeValue.entrySet()) {
                prepStmt.setString(prepareStatement.getKey() + 2, prepareStatement.getValue());
            }
            prepStmt.setInt(filterAttributeValue.entrySet().size() + 3, tenantId);
        } else {
            log.error((Object)"Error while loading Identity Provider from DB: Database driver could not be identified or not supported.");
            String message = "Error while loading Identity Provider from DB: Database driver could not be identified or not supported.";
            throw IdPManagementUtil.handleServerException(IdPManagementConstants.ErrorMessage.ERROR_CODE_CONNECTING_DATABASE, message);
        }
        return prepStmt.executeQuery();
    }

    private String appendRequiredAttributes(String sqlQuery, List<String> requiredAttributes) throws IdentityProviderManagementClientException {
        if (CollectionUtils.isNotEmpty(requiredAttributes)) {
            Iterator<String> iterator = requiredAttributes.iterator();
            block32: while (iterator.hasNext()) {
                String attribute;
                switch (attribute = iterator.next()) {
                    case "id": {
                        continue block32;
                    }
                    case "name": {
                        continue block32;
                    }
                    case "description": {
                        continue block32;
                    }
                    case "isEnabled": {
                        continue block32;
                    }
                    case "image": {
                        continue block32;
                    }
                    case "isPrimary": {
                        sqlQuery = sqlQuery + ", IS_PRIMARY ";
                        continue block32;
                    }
                    case "homeRealmIdentifier": {
                        sqlQuery = sqlQuery + ", HOME_REALM_ID ";
                        continue block32;
                    }
                    case "isFederationHub": {
                        sqlQuery = sqlQuery + ", IS_FEDERATION_HUB ";
                        continue block32;
                    }
                    case "certificate": {
                        sqlQuery = sqlQuery + ", CERTIFICATE ";
                        continue block32;
                    }
                    case "alias": {
                        sqlQuery = sqlQuery + ", ALIAS ";
                        continue block32;
                    }
                    case "claims": {
                        sqlQuery = sqlQuery + ", USER_CLAIM_URI, ROLE_CLAIM_URI, IS_LOCAL_CLAIM_DIALECT ";
                        continue block32;
                    }
                    case "roles": {
                        sqlQuery = sqlQuery + ", PROVISIONING_ROLE ";
                        continue block32;
                    }
                    case "federatedAuthenticators": {
                        sqlQuery = sqlQuery + ", DEFAULT_AUTHENTICATOR_NAME ";
                        continue block32;
                    }
                    case "provisioning": {
                        sqlQuery = sqlQuery + ", INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, DEFAULT_PRO_CONNECTOR_NAME ";
                        continue block32;
                    }
                }
                throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_ATTRIBUTE_INVALID, attribute);
            }
        }
        return sqlQuery;
    }

    private List<IdentityProvider> populateIdentityProviderList(ResultSet resultSet, Connection dbConnection, List<String> requiredAttributes, int tenantId) throws SQLException, IdentityProviderManagementServerException {
        ArrayList<IdentityProvider> identityProviderList = new ArrayList<IdentityProvider>();
        while (resultSet.next()) {
            IdentityProvider identityProvider = new IdentityProvider();
            identityProvider.setId(resultSet.getString("ID"));
            identityProvider.setIdentityProviderName(resultSet.getString("NAME"));
            identityProvider.setIdentityProviderDescription(resultSet.getString("DESCRIPTION"));
            if ("1".equals(resultSet.getString("IS_ENABLED"))) {
                identityProvider.setEnable(true);
            } else {
                identityProvider.setEnable(false);
            }
            identityProvider.setImageUrl(resultSet.getString("IMAGE_URL"));
            identityProvider.setResourceId(resultSet.getString("UUID"));
            this.populateRequiredAttributesForIdentityProviderList(resultSet, dbConnection, requiredAttributes, tenantId, identityProvider);
            if (!"LOCAL".equals(identityProvider.getIdentityProviderName())) {
                identityProviderList.add(identityProvider);
            }
            List<IdentityProviderProperty> propertyList = this.getIdentityPropertiesByIdpId(dbConnection, Integer.parseInt(resultSet.getString("ID")));
            identityProvider.setIdpProperties(propertyList.toArray(new IdentityProviderProperty[0]));
        }
        return identityProviderList;
    }

    private void populateRequiredAttributesForIdentityProviderList(ResultSet resultSet, Connection dbConnection, List<String> requiredAttributes, int tenantId, IdentityProvider identityProvider) throws SQLException, IdentityProviderManagementServerException {
        int idpId = Integer.parseInt(identityProvider.getId());
        String idPName = identityProvider.getIdentityProviderName();
        try {
            if (CollectionUtils.isNotEmpty(requiredAttributes)) {
                Iterator<String> iterator = requiredAttributes.iterator();
                while (iterator.hasNext()) {
                    String attribute;
                    switch (attribute = iterator.next()) {
                        case "isPrimary": {
                            if ("1".equals(resultSet.getString("IS_PRIMARY"))) {
                                identityProvider.setPrimary(true);
                                break;
                            }
                            identityProvider.setPrimary(false);
                            break;
                        }
                        case "homeRealmIdentifier": {
                            identityProvider.setHomeRealmId(resultSet.getString("HOME_REALM_ID"));
                            break;
                        }
                        case "isFederationHub": {
                            if (!"1".equals(resultSet.getString("IS_FEDERATION_HUB"))) break;
                            identityProvider.setFederationHub(false);
                            break;
                        }
                        case "certificate": {
                            identityProvider.setCertificate(this.getBlobValue(resultSet.getBinaryStream("CERTIFICATE")));
                            break;
                        }
                        case "alias": {
                            identityProvider.setAlias(resultSet.getString("ALIAS"));
                            break;
                        }
                        case "claims": {
                            if (identityProvider.getClaimConfig() == null) {
                                identityProvider.setClaimConfig(new ClaimConfig());
                            }
                            if ("1".equals(resultSet.getString("IS_LOCAL_CLAIM_DIALECT"))) {
                                identityProvider.getClaimConfig().setLocalClaimDialect(true);
                            } else {
                                identityProvider.getClaimConfig().setLocalClaimDialect(false);
                            }
                            String userClaimUri = resultSet.getString("USER_CLAIM_URI");
                            String roleClaimUri = resultSet.getString("ROLE_CLAIM_URI");
                            if (identityProvider.getClaimConfig().isLocalClaimDialect()) {
                                identityProvider.setClaimConfig(this.getLocalIdPDefaultClaimValues(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                                break;
                            }
                            identityProvider.setClaimConfig(this.getIdPClaimConfiguration(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                            break;
                        }
                        case "roles": {
                            identityProvider.setProvisioningRole(resultSet.getString("PROVISIONING_ROLE"));
                            identityProvider.setPermissionAndRoleConfig(this.getPermissionsAndRoleConfiguration(dbConnection, idPName, idpId, tenantId));
                            break;
                        }
                        case "federatedAuthenticators": {
                            String defaultAuthenticatorName = resultSet.getString("DEFAULT_AUTHENTICATOR_NAME");
                            identityProvider.setFederatedAuthenticatorConfigs(this.getFederatedAuthenticatorConfigs(dbConnection, idPName, identityProvider, tenantId));
                            if (defaultAuthenticatorName == null || identityProvider.getFederatedAuthenticatorConfigs() == null) break;
                            identityProvider.setDefaultAuthenticatorConfig(IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)defaultAuthenticatorName));
                            break;
                        }
                        case "provisioning": {
                            JustInTimeProvisioningConfig jitProConfig = new JustInTimeProvisioningConfig();
                            if ("1".equals(resultSet.getString("INBOUND_PROV_ENABLED"))) {
                                jitProConfig.setProvisioningEnabled(true);
                            } else {
                                jitProConfig.setProvisioningEnabled(false);
                            }
                            jitProConfig.setProvisioningUserStore(resultSet.getString("INBOUND_PROV_USER_STORE_ID"));
                            identityProvider.setJustInTimeProvisioningConfig(jitProConfig);
                            String defaultProvisioningConnectorConfigName = resultSet.getString("DEFAULT_PRO_CONNECTOR_NAME");
                            if (defaultProvisioningConnectorConfigName != null) {
                                ProvisioningConnectorConfig defaultProConnector = new ProvisioningConnectorConfig();
                                defaultProConnector.setName(defaultProvisioningConnectorConfigName);
                                identityProvider.setDefaultProvisioningConnectorConfig(defaultProConnector);
                            }
                            identityProvider.setProvisioningConnectorConfigs(this.getProvisioningConnectorConfigs(dbConnection, idPName, idpId, tenantId));
                        }
                    }
                }
            }
        }
        catch (IdentityProviderManagementException e) {
            throw new IdentityProviderManagementServerException("Error occurred while performing required attribute filter", (Throwable)((Object)e));
        }
    }

    int getCountOfFilteredIdPs(int tenantId, List<ExpressionNode> expressionNode) throws IdentityProviderManagementServerException, IdentityProviderManagementClientException {
        String sqlStmt = "SELECT COUNT(*) FROM IDP WHERE ";
        int countOfFilteredIdp = 0;
        FilterQueryBuilder filterQueryBuilder = new FilterQueryBuilder();
        this.appendFilterQuery(expressionNode, filterQueryBuilder);
        Map<Integer, String> filterAttributeValue = filterQueryBuilder.getFilterAttributeValue();
        sqlStmt = sqlStmt + filterQueryBuilder.getFilterQuery() + "TENANT_ID = ? AND NAME != 'LOCAL'";
        try (Connection dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
             PreparedStatement prepStmt = dbConnection.prepareStatement(sqlStmt);){
            for (Map.Entry<Integer, String> prepareStatement : filterAttributeValue.entrySet()) {
                prepStmt.setString(prepareStatement.getKey(), prepareStatement.getValue());
            }
            prepStmt.setInt(filterAttributeValue.entrySet().size() + 1, tenantId);
            try (ResultSet rs = prepStmt.executeQuery();){
                if (rs.next()) {
                    countOfFilteredIdp = Integer.parseInt(rs.getString(1));
                }
            }
        }
        catch (SQLException e) {
            String message = "Error occurred while retrieving Identity Provider count for a tenant : " + IdentityTenantUtil.getTenantDomain((int)tenantId);
            throw IdPManagementUtil.handleServerException(IdPManagementConstants.ErrorMessage.ERROR_CODE_CONNECTING_DATABASE, message, e);
        }
        return countOfFilteredIdp;
    }

    private void appendFilterQuery(List<ExpressionNode> expressionNodes, FilterQueryBuilder filterQueryBuilder) throws IdentityProviderManagementClientException {
        StringBuilder filter = new StringBuilder();
        if (CollectionUtils.isEmpty(expressionNodes)) {
            filterQueryBuilder.setFilterQuery("");
        } else {
            for (ExpressionNode expressionNode : expressionNodes) {
                String operation = expressionNode.getOperation();
                String value = expressionNode.getValue();
                String attributeName = expressionNode.getAttributeValue();
                if (!StringUtils.isNotBlank((String)attributeName) || !StringUtils.isNotBlank((String)value) || !StringUtils.isNotBlank((String)operation)) continue;
                switch (attributeName) {
                    case "name": {
                        attributeName = "NAME";
                        break;
                    }
                    case "description": {
                        attributeName = "DESCRIPTION";
                        break;
                    }
                    case "homeRealmIdentifier": {
                        attributeName = "HOME_REALM_ID";
                        break;
                    }
                    case "isEnabled": {
                        attributeName = "IS_ENABLED";
                        break;
                    }
                    case "id": {
                        attributeName = "UUID";
                        break;
                    }
                    default: {
                        String message = "Invalid filter attribute name. Filter attribute : " + attributeName;
                        throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP, message);
                    }
                }
                if ("eq".equals(operation)) {
                    filter.append(attributeName).append(" = ? AND ");
                    filterQueryBuilder.setFilterAttributeValue(value);
                    continue;
                }
                if ("sw".equals(operation)) {
                    filter.append(attributeName).append(" like ? AND ");
                    filterQueryBuilder.setFilterAttributeValue(value + "%");
                    continue;
                }
                if ("ew".equals(operation)) {
                    filter.append(attributeName).append(" like ? AND ");
                    filterQueryBuilder.setFilterAttributeValue("%" + value);
                    continue;
                }
                if ("co".equals(operation)) {
                    filter.append(attributeName).append(" like ? AND ");
                    filterQueryBuilder.setFilterAttributeValue("%" + value + "%");
                    continue;
                }
                String message = "Invalid filter value. filter: " + operation;
                throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP, message);
            }
            if (StringUtils.isBlank((String)filter.toString())) {
                filterQueryBuilder.setFilterQuery("");
            } else {
                filterQueryBuilder.setFilterQuery(filter.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IdentityProviderProperty> getIdentityPropertiesByIdpId(Connection dbConnection, int idpId) throws SQLException {
        String sqlStmt = "SELECT ID, NAME, VALUE, DISPLAY_NAME FROM IDP_METADATA WHERE IDP_ID = ?";
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ArrayList<IdentityProviderProperty> idpProperties = new ArrayList<IdentityProviderProperty>();
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idpId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                IdentityProviderProperty property = new IdentityProviderProperty();
                property.setName(rs.getString("NAME"));
                property.setValue(rs.getString("VALUE"));
                property.setDisplayName(rs.getString("DISPLAY_NAME"));
                idpProperties.add(property);
            }
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        return idpProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdentityProviderProperties(Connection dbConnection, int idpId, List<IdentityProviderProperty> properties, int tenantId) throws SQLException {
        String sqlStmt = "INSERT INTO IDP_METADATA (IDP_ID, NAME, VALUE, DISPLAY_NAME, TENANT_ID) VALUES (?, ?, ?, ?, ?)";
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            for (IdentityProviderProperty property : properties) {
                if (property.getValue() != null) {
                    prepStmt.setInt(1, idpId);
                    prepStmt.setString(2, property.getName());
                    prepStmt.setString(3, property.getValue());
                    prepStmt.setString(4, property.getDisplayName());
                    prepStmt.setInt(5, tenantId);
                    prepStmt.addBatch();
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                String msg = "IDP property '%s' of IDP with id:%d of tenantId:%d is null. Not adding the property to 'IDP_METADATA' table.";
                log.debug((Object)String.format(msg, property.getName(), idpId, tenantId));
            }
            prepStmt.executeBatch();
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIdentityProviderProperties(Connection dbConnection, int idpId, List<IdentityProviderProperty> properties, int tenantId) throws SQLException {
        PreparedStatement prepStmt = null;
        try {
            prepStmt = dbConnection.prepareStatement("DELETE FROM IDP_METADATA WHERE IDP_ID = ?");
            prepStmt.setInt(1, idpId);
            prepStmt.executeUpdate();
            this.addIdentityProviderProperties(dbConnection, idpId, properties, tenantId);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FederatedAuthenticatorConfig[] getFederatedAuthenticatorConfigs(Connection dbConnection, String idPName, IdentityProvider federatedIdp, int tenantId) throws IdentityProviderManagementException, SQLException {
        FederatedAuthenticatorConfig[] federatedAuthenticatorConfigArray;
        int idPId = this.getIdentityProviderIdentifier(dbConnection, idPName, tenantId);
        PreparedStatement prepStmt1 = null;
        PreparedStatement prepStmt2 = null;
        ResultSet rs = null;
        ResultSet proprs = null;
        String defaultAuthName = null;
        if (federatedIdp != null && federatedIdp.getDefaultAuthenticatorConfig() != null) {
            defaultAuthName = federatedIdp.getDefaultAuthenticatorConfig().getName();
        }
        String sqlStmt = "SELECT ID, NAME, IS_ENABLED, DISPLAY_NAME FROM IDP_AUTHENTICATOR WHERE IDP_ID = ?";
        HashSet<FederatedAuthenticatorConfig> federatedAuthenticatorConfigs = new HashSet<FederatedAuthenticatorConfig>();
        try {
            prepStmt1 = dbConnection.prepareStatement(sqlStmt);
            prepStmt1.setInt(1, idPId);
            rs = prepStmt1.executeQuery();
            while (rs.next()) {
                FederatedAuthenticatorConfig authnConfig = new FederatedAuthenticatorConfig();
                int authnId = rs.getInt("ID");
                authnConfig.setName(rs.getString("NAME"));
                if ("1".equals(rs.getString("IS_ENABLED"))) {
                    authnConfig.setEnabled(true);
                } else {
                    authnConfig.setEnabled(false);
                }
                authnConfig.setDisplayName(rs.getString("DISPLAY_NAME"));
                if (defaultAuthName != null && authnConfig.getName().equals(defaultAuthName)) {
                    federatedIdp.getDefaultAuthenticatorConfig().setDisplayName(authnConfig.getDisplayName());
                }
                sqlStmt = "SELECT PROPERTY_KEY, PROPERTY_VALUE, IS_SECRET FROM IDP_AUTHENTICATOR_PROPERTY WHERE AUTHENTICATOR_ID = ?";
                prepStmt2 = dbConnection.prepareStatement(sqlStmt);
                prepStmt2.setInt(1, authnId);
                proprs = prepStmt2.executeQuery();
                HashSet<Property> properties = new HashSet<Property>();
                while (proprs.next()) {
                    Property property = new Property();
                    property.setName(proprs.getString("PROPERTY_KEY"));
                    property.setValue(proprs.getString("PROPERTY_VALUE"));
                    if ("1".equals(proprs.getString("IS_SECRET"))) {
                        property.setConfidential(true);
                    }
                    properties.add(property);
                }
                authnConfig.setProperties(properties.toArray(new Property[properties.size()]));
                federatedAuthenticatorConfigs.add(authnConfig);
            }
            federatedAuthenticatorConfigArray = federatedAuthenticatorConfigs.toArray(new FederatedAuthenticatorConfig[federatedAuthenticatorConfigs.size()]);
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, proprs, prepStmt2);
            IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt1);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, proprs, prepStmt2);
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt1);
        return federatedAuthenticatorConfigArray;
    }

    private void updateFederatedAuthenticatorConfigs(FederatedAuthenticatorConfig[] newFederatedAuthenticatorConfigs, FederatedAuthenticatorConfig[] oldFederatedAuthenticatorConfigs, Connection dbConnection, int idpId, int tenantId, boolean isResidentIdP) throws IdentityProviderManagementException, SQLException {
        HashMap<String, FederatedAuthenticatorConfig> oldFedAuthnConfigMap = new HashMap<String, FederatedAuthenticatorConfig>();
        if (oldFederatedAuthenticatorConfigs != null && oldFederatedAuthenticatorConfigs.length > 0) {
            for (FederatedAuthenticatorConfig fedAuthnConfig : oldFederatedAuthenticatorConfigs) {
                oldFedAuthnConfigMap.put(fedAuthnConfig.getName(), fedAuthnConfig);
            }
        }
        HashMap<String, FederatedAuthenticatorConfig> newFedAuthnConfigMap = new HashMap<String, FederatedAuthenticatorConfig>();
        if (newFederatedAuthenticatorConfigs != null && newFederatedAuthenticatorConfigs.length > 0) {
            for (FederatedAuthenticatorConfig fedAuthenticator : newFederatedAuthenticatorConfigs) {
                newFedAuthnConfigMap.put(fedAuthenticator.getName(), fedAuthenticator);
                if (!fedAuthenticator.isValid()) continue;
                if (oldFedAuthnConfigMap.containsKey(fedAuthenticator.getName())) {
                    this.updateFederatedAuthenticatorConfig(fedAuthenticator, (FederatedAuthenticatorConfig)oldFedAuthnConfigMap.get(fedAuthenticator.getName()), dbConnection, idpId, tenantId);
                    continue;
                }
                this.addFederatedAuthenticatorConfig(fedAuthenticator, dbConnection, idpId, tenantId);
            }
        }
        if (!isResidentIdP) {
            for (String oldFedAuthenticator : oldFedAuthnConfigMap.keySet()) {
                if (newFedAuthnConfigMap.containsKey(oldFedAuthenticator)) continue;
                this.deleteFederatedAuthenticatorConfig((FederatedAuthenticatorConfig)oldFedAuthnConfigMap.get(oldFedAuthenticator), dbConnection, idpId, tenantId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFederatedAuthenticatorConfig(FederatedAuthenticatorConfig newFederatedAuthenticatorConfig, FederatedAuthenticatorConfig oldFederatedAuthenticatorConfig, Connection dbConnection, int idpId, int tenantId) throws IdentityProviderManagementException, SQLException {
        PreparedStatement prepStmt1 = null;
        try {
            String sqlStmt = "UPDATE IDP_AUTHENTICATOR SET IS_ENABLED=? WHERE IDP_ID=? AND NAME=?";
            prepStmt1 = dbConnection.prepareStatement(sqlStmt);
            if (newFederatedAuthenticatorConfig.isEnabled()) {
                prepStmt1.setString(1, "1");
            } else {
                prepStmt1.setString(1, "0");
            }
            prepStmt1.setInt(2, idpId);
            prepStmt1.setString(3, newFederatedAuthenticatorConfig.getName());
            prepStmt1.executeUpdate();
            int authnId = this.getAuthenticatorIdentifier(dbConnection, idpId, newFederatedAuthenticatorConfig.getName());
            ArrayList<Property> unUpdatedProperties = new ArrayList();
            ArrayList<Property> singleValuedProperties = new ArrayList<Property>();
            ArrayList<Property> multiValuedProperties = new ArrayList<Property>();
            if (ArrayUtils.isNotEmpty((Object[])oldFederatedAuthenticatorConfig.getProperties())) {
                if (ArrayUtils.isNotEmpty((Object[])newFederatedAuthenticatorConfig.getProperties())) {
                    for (Property propertyOld : oldFederatedAuthenticatorConfig.getProperties()) {
                        boolean hasProp = false;
                        for (Property propertyNew : newFederatedAuthenticatorConfig.getProperties()) {
                            if (!StringUtils.equals((String)propertyOld.getName(), (String)propertyNew.getName())) continue;
                            hasProp = true;
                            break;
                        }
                        if (hasProp) continue;
                        unUpdatedProperties.add(propertyOld);
                    }
                } else {
                    unUpdatedProperties = new ArrayList<Property>(Arrays.asList(oldFederatedAuthenticatorConfig.getProperties()));
                }
            }
            for (Property property : newFederatedAuthenticatorConfig.getProperties()) {
                if (Pattern.matches(".*\\.[0-9]+", property.getName())) {
                    multiValuedProperties.add(property);
                    continue;
                }
                singleValuedProperties.add(property);
            }
            if (CollectionUtils.isNotEmpty(unUpdatedProperties)) {
                this.deleteFederatedConfigProperties(dbConnection, authnId, tenantId, unUpdatedProperties);
            }
            if (CollectionUtils.isNotEmpty(singleValuedProperties)) {
                this.updateSingleValuedFederatedConfigProperties(dbConnection, authnId, tenantId, singleValuedProperties);
            }
            if (CollectionUtils.isNotEmpty(multiValuedProperties)) {
                this.updateMultiValuedFederatedConfigProperties(dbConnection, oldFederatedAuthenticatorConfig.getProperties(), authnId, tenantId, multiValuedProperties);
            }
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(prepStmt1);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt1);
    }

    public void addFederatedAuthenticatorConfigs(FederatedAuthenticatorConfig[] authnConfigs, Connection dbConnection, int idpId, int tenantId) throws IdentityProviderManagementException, SQLException {
        for (FederatedAuthenticatorConfig authnConfig : authnConfigs) {
            this.addFederatedAuthenticatorConfig(authnConfig, dbConnection, idpId, tenantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFederatedAuthenticatorConfig(FederatedAuthenticatorConfig authnConfig, Connection dbConnection, int idpId, int tenantId) throws IdentityProviderManagementException, SQLException {
        PreparedStatement prepStmt1 = null;
        PreparedStatement prepStmt2 = null;
        String sqlStmt = "INSERT INTO IDP_AUTHENTICATOR (IDP_ID, TENANT_ID, IS_ENABLED, NAME, DISPLAY_NAME) VALUES (?,?,?,?,?)";
        try {
            prepStmt1 = dbConnection.prepareStatement(sqlStmt);
            prepStmt1.setInt(1, idpId);
            prepStmt1.setInt(2, tenantId);
            if (authnConfig.isEnabled()) {
                prepStmt1.setString(3, "1");
            } else {
                prepStmt1.setString(3, "0");
            }
            prepStmt1.setString(4, authnConfig.getName());
            prepStmt1.setString(5, authnConfig.getDisplayName());
            prepStmt1.execute();
            int authnId = this.getAuthenticatorIdentifier(dbConnection, idpId, authnConfig.getName());
            sqlStmt = "INSERT INTO IDP_AUTHENTICATOR_PROPERTY (AUTHENTICATOR_ID, TENANT_ID, PROPERTY_KEY, PROPERTY_VALUE, IS_SECRET) VALUES (?, ?, ?, ?, ?)";
            if (authnConfig.getProperties() == null) {
                authnConfig.setProperties(new Property[0]);
            }
            for (Property property : authnConfig.getProperties()) {
                prepStmt2 = dbConnection.prepareStatement(sqlStmt);
                prepStmt2.setInt(1, authnId);
                prepStmt2.setInt(2, tenantId);
                prepStmt2.setString(3, property.getName());
                prepStmt2.setString(4, property.getValue());
                if (property.isConfidential()) {
                    prepStmt2.setString(5, "1");
                } else {
                    prepStmt2.setString(5, "0");
                }
                prepStmt2.executeUpdate();
            }
        }
        finally {
            IdentityDatabaseUtil.closeStatement(prepStmt2);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt1);
        }
    }

    private void deleteFederatedAuthenticatorConfig(FederatedAuthenticatorConfig authnConfig, Connection dbConnection, int idpId, int tenantId) throws IdentityProviderManagementException, SQLException {
        try (PreparedStatement prepStmt = dbConnection.prepareStatement("DELETE FROM IDP_AUTHENTICATOR WHERE IDP_ID=? AND NAME=?");){
            prepStmt.setInt(1, idpId);
            prepStmt.setString(2, authnConfig.getName());
            prepStmt.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSingleValuedFederatedConfigProperties(Connection dbConnection, int authnId, int tenantId, List<Property> singleValuedProperties) throws SQLException {
        PreparedStatement prepStmt2 = null;
        PreparedStatement prepStmt3 = null;
        try {
            for (Property property : singleValuedProperties) {
                String sqlStmt = "UPDATE IDP_AUTHENTICATOR_PROPERTY SET PROPERTY_VALUE = ?, IS_SECRET = ? WHERE AUTHENTICATOR_ID = ? AND PROPERTY_KEY = ?";
                prepStmt2 = dbConnection.prepareStatement(sqlStmt);
                prepStmt2.setString(1, property.getValue());
                if (property.isConfidential()) {
                    prepStmt2.setString(2, "1");
                } else {
                    prepStmt2.setString(2, "0");
                }
                prepStmt2.setInt(3, authnId);
                prepStmt2.setString(4, property.getName());
                int rows = prepStmt2.executeUpdate();
                if (rows != 0) continue;
                sqlStmt = "INSERT INTO IDP_AUTHENTICATOR_PROPERTY (AUTHENTICATOR_ID, TENANT_ID, PROPERTY_KEY, PROPERTY_VALUE, IS_SECRET) VALUES (?, ?, ?, ?, ?)";
                prepStmt3 = dbConnection.prepareStatement(sqlStmt);
                prepStmt3.setInt(1, authnId);
                prepStmt3.setInt(2, tenantId);
                prepStmt3.setString(3, property.getName());
                prepStmt3.setString(4, property.getValue());
                if (property.isConfidential()) {
                    prepStmt3.setString(5, "1");
                } else {
                    prepStmt3.setString(5, "0");
                }
                prepStmt3.executeUpdate();
            }
        }
        finally {
            IdentityDatabaseUtil.closeStatement(prepStmt3);
            IdentityDatabaseUtil.closeStatement(prepStmt2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMultiValuedFederatedConfigProperties(Connection dbConnection, Property[] oldFederatedAuthenticatorConfigProperties, int authnId, int tenantId, List<Property> multiValuedProperties) throws SQLException {
        PreparedStatement deleteOldValuePrepStmt = null;
        PreparedStatement addNewPropsPrepStmt = null;
        try {
            String sqlStmt;
            for (Property property : oldFederatedAuthenticatorConfigProperties) {
                if (!Pattern.matches(".*\\.[0-9]+", property.getName())) continue;
                sqlStmt = "DELETE FROM IDP_AUTHENTICATOR_PROPERTY WHERE PROPERTY_KEY = ? AND TENANT_ID = ? AND AUTHENTICATOR_ID = ?";
                deleteOldValuePrepStmt = dbConnection.prepareStatement(sqlStmt);
                deleteOldValuePrepStmt.setString(1, property.getName());
                deleteOldValuePrepStmt.setInt(2, tenantId);
                deleteOldValuePrepStmt.setInt(3, authnId);
                deleteOldValuePrepStmt.executeUpdate();
            }
            for (Property property : multiValuedProperties) {
                sqlStmt = "INSERT INTO IDP_AUTHENTICATOR_PROPERTY (AUTHENTICATOR_ID, TENANT_ID, PROPERTY_KEY, PROPERTY_VALUE, IS_SECRET) VALUES (?, ?, ?, ?, ?)";
                addNewPropsPrepStmt = dbConnection.prepareStatement(sqlStmt);
                addNewPropsPrepStmt.setInt(1, authnId);
                addNewPropsPrepStmt.setInt(2, tenantId);
                addNewPropsPrepStmt.setString(3, property.getName());
                addNewPropsPrepStmt.setString(4, property.getValue());
                if (property.isConfidential()) {
                    addNewPropsPrepStmt.setString(5, "1");
                } else {
                    addNewPropsPrepStmt.setString(5, "0");
                }
                addNewPropsPrepStmt.executeUpdate();
            }
        }
        finally {
            IdentityDatabaseUtil.closeStatement(deleteOldValuePrepStmt);
            IdentityDatabaseUtil.closeStatement(addNewPropsPrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFederatedConfigProperties(Connection dbConnection, int authnId, int tenantId, List<Property> properties) throws SQLException {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        PreparedStatement deletePrepStmt = null;
        String sqlStmt = "DELETE FROM IDP_AUTHENTICATOR_PROPERTY WHERE PROPERTY_KEY = ? AND TENANT_ID = ? AND AUTHENTICATOR_ID = ?";
        try {
            deletePrepStmt = dbConnection.prepareStatement(sqlStmt);
            for (Property property : properties) {
                deletePrepStmt.setString(1, property.getName());
                deletePrepStmt.setInt(2, tenantId);
                deletePrepStmt.setInt(3, authnId);
                deletePrepStmt.addBatch();
            }
            deletePrepStmt.executeBatch();
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)deletePrepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClaimConfig getLocalIdPDefaultClaimValues(Connection dbConnection, String idPName, String userClaimUri, String roleClaimUri, int idpId, int tenantId) throws SQLException {
        ClaimConfig claimConfig;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        ClaimConfig claimConfig2 = new ClaimConfig();
        try {
            claimConfig2.setLocalClaimDialect(true);
            claimConfig2.setRoleClaimURI(roleClaimUri);
            claimConfig2.setUserClaimURI(userClaimUri);
            String sqlStmt = "SELECT CLAIM_URI,DEFAULT_VALUE,IS_REQUESTED FROM IDP_LOCAL_CLAIM  WHERE IDP_ID = ? AND TENANT_ID =?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idpId);
            prepStmt.setInt(2, tenantId);
            ArrayList<ClaimMapping> claimMappings = new ArrayList<ClaimMapping>();
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                ClaimMapping claimMapping = new ClaimMapping();
                Claim remoteClaim = new Claim();
                Claim localClaim = new Claim();
                localClaim.setClaimUri(rs.getString("CLAIM_URI"));
                claimMapping.setLocalClaim(localClaim);
                claimMapping.setRemoteClaim(remoteClaim);
                claimMapping.setDefaultValue(rs.getString("DEFAULT_VALUE"));
                if ("1".equals(rs.getString("IS_REQUESTED"))) {
                    claimMapping.setRequested(true);
                } else if (rs.getString("IS_REQUESTED").equals("1")) {
                    claimMapping.setRequested(false);
                }
                claimMappings.add(claimMapping);
            }
            claimConfig2.setClaimMappings(claimMappings.toArray(new ClaimMapping[claimMappings.size()]));
            claimConfig = claimConfig2;
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs, prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        return claimConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClaimConfig getIdPClaimConfiguration(Connection dbConnection, String idPName, String userClaimUri, String roleClaimUri, int idPId, int tenantId) throws SQLException {
        ClaimConfig claimConfig;
        PreparedStatement prepStmt1 = null;
        PreparedStatement prepStmt2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            ArrayList<Claim> claimList = new ArrayList<Claim>();
            String sqlStmt = "SELECT ID, CLAIM FROM IDP_CLAIM WHERE IDP_ID=?";
            prepStmt1 = dbConnection.prepareStatement(sqlStmt);
            prepStmt1.setInt(1, idPId);
            rs1 = prepStmt1.executeQuery();
            ClaimConfig claimConfig2 = new ClaimConfig();
            while (rs1.next()) {
                Claim identityProviderClaim = new Claim();
                identityProviderClaim.setClaimId(rs1.getInt(1));
                identityProviderClaim.setClaimUri(rs1.getString(2));
                claimList.add(identityProviderClaim);
            }
            claimConfig2.setIdpClaims(claimList.toArray(new Claim[claimList.size()]));
            claimConfig2.setUserClaimURI(userClaimUri);
            claimConfig2.setRoleClaimURI(roleClaimUri);
            ArrayList<ClaimMapping> claimMappings = new ArrayList<ClaimMapping>();
            sqlStmt = "SELECT IDP_CLAIM.CLAIM, IDP_CLAIM_MAPPING.LOCAL_CLAIM, IDP_CLAIM_MAPPING.DEFAULT_VALUE, IDP_CLAIM_MAPPING.IS_REQUESTED FROM IDP_CLAIM_MAPPING INNER JOIN IDP_CLAIM ON IDP_CLAIM_MAPPING.IDP_CLAIM_ID= IDP_CLAIM.ID WHERE IDP_CLAIM.IDP_ID=?";
            prepStmt2 = dbConnection.prepareStatement(sqlStmt);
            prepStmt2.setInt(1, idPId);
            rs2 = prepStmt2.executeQuery();
            while (rs2.next()) {
                ClaimMapping claimMapping = new ClaimMapping();
                Claim idpClaim = new Claim();
                idpClaim.setClaimUri(rs2.getString("CLAIM"));
                Claim localClaim = new Claim();
                localClaim.setClaimUri(rs2.getString("LOCAL_CLAIM"));
                claimMapping.setLocalClaim(localClaim);
                claimMapping.setRemoteClaim(idpClaim);
                claimMapping.setDefaultValue(rs2.getString("DEFAULT_VALUE"));
                if ("1".equals(rs2.getString("IS_REQUESTED"))) {
                    claimMapping.setRequested(true);
                } else if ("0".equals(rs2.getString("IS_REQUESTED"))) {
                    claimMapping.setRequested(false);
                }
                claimMappings.add(claimMapping);
            }
            claimConfig2.setClaimMappings(claimMappings.toArray(new ClaimMapping[claimMappings.size()]));
            claimConfig = claimConfig2;
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs2, prepStmt2);
            IdentityDatabaseUtil.closeAllConnections(null, rs1, (PreparedStatement)prepStmt1);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs2, (PreparedStatement)prepStmt2);
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs1, (PreparedStatement)prepStmt1);
        return claimConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionsAndRoleConfig getPermissionsAndRoleConfiguration(Connection dbConnection, String idPName, int idPId, int tenantId) throws SQLException {
        PermissionsAndRoleConfig permissionsAndRoleConfig;
        PreparedStatement prepStmt1 = null;
        PreparedStatement prepStmt2 = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        PermissionsAndRoleConfig permissionRoleConfiguration = new PermissionsAndRoleConfig();
        try {
            ArrayList<String> idpRoleList = new ArrayList<String>();
            String sqlStmt = "SELECT ID, ROLE  FROM IDP_ROLE WHERE IDP_ID=?";
            prepStmt1 = dbConnection.prepareStatement(sqlStmt);
            prepStmt1.setInt(1, idPId);
            rs1 = prepStmt1.executeQuery();
            while (rs1.next()) {
                idpRoleList.add(rs1.getString("ROLE"));
            }
            permissionRoleConfiguration.setIdpRoles(idpRoleList.toArray(new String[idpRoleList.size()]));
            ArrayList<RoleMapping> roleMappings = new ArrayList<RoleMapping>();
            sqlStmt = "SELECT IDP_ROLE_MAPPING.USER_STORE_ID, IDP_ROLE_MAPPING.LOCAL_ROLE, IDP_ROLE.ROLE FROM IDP_ROLE_MAPPING  INNER JOIN IDP_ROLE ON IDP_ROLE_MAPPING.IDP_ROLE_ID=IDP_ROLE.ID WHERE IDP_ROLE.IDP_ID=?";
            prepStmt2 = dbConnection.prepareStatement(sqlStmt);
            prepStmt2.setInt(1, idPId);
            rs2 = prepStmt2.executeQuery();
            while (rs2.next()) {
                LocalRole localRole = new LocalRole(rs2.getString("USER_STORE_ID"), rs2.getString("LOCAL_ROLE"));
                RoleMapping roleMapping = new RoleMapping(localRole, rs2.getString("ROLE"));
                roleMappings.add(roleMapping);
            }
            permissionRoleConfiguration.setRoleMappings(roleMappings.toArray(new RoleMapping[roleMappings.size()]));
            permissionsAndRoleConfig = permissionRoleConfiguration;
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs2, prepStmt2);
            IdentityDatabaseUtil.closeAllConnections(null, rs1, (PreparedStatement)prepStmt1);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs2, (PreparedStatement)prepStmt2);
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs1, (PreparedStatement)prepStmt1);
        return permissionsAndRoleConfig;
    }

    private void addProvisioningConnectorConfigs(ProvisioningConnectorConfig[] provisioningConnectors, Connection dbConnection, int idpId, int tenantId) throws IdentityProviderManagementException, SQLException {
        PreparedStatement prepStmt = null;
        PreparedStatement prepBaseStmt = null;
        ResultSet rs = null;
        try {
            String sqlStmt = "INSERT INTO IDP_PROV_CONFIG_PROPERTY (TENANT_ID, PROVISIONING_CONFIG_ID, PROPERTY_KEY, PROPERTY_VALUE, PROPERTY_BLOB_VALUE, PROPERTY_TYPE, IS_SECRET) VALUES (?, ?, ?, ?, ?, ?, ?)";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            String sqlBaseStmt = "INSERT INTO IDP_PROVISIONING_CONFIG (TENANT_ID, IDP_ID, PROVISIONING_CONNECTOR_TYPE, IS_ENABLED, IS_BLOCKING) VALUES (?, ?, ? ,?, ?)";
            String dbProductName = dbConnection.getMetaData().getDatabaseProductName();
            prepBaseStmt = dbConnection.prepareStatement(sqlBaseStmt, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            if (provisioningConnectors != null) {
                for (ProvisioningConnectorConfig connector : provisioningConnectors) {
                    Property[] connctorProperties = connector.getProvisioningProperties();
                    if (connctorProperties == null) continue;
                    prepBaseStmt.setInt(1, tenantId);
                    prepBaseStmt.setInt(2, idpId);
                    prepBaseStmt.setString(3, connector.getName());
                    if (connector.isEnabled()) {
                        prepBaseStmt.setString(4, "1");
                    } else {
                        prepBaseStmt.setString(4, "0");
                    }
                    if (connector.isBlocking()) {
                        prepBaseStmt.setString(5, "1");
                    } else {
                        prepBaseStmt.setString(5, "0");
                    }
                    prepBaseStmt.executeUpdate();
                    rs = prepBaseStmt.getGeneratedKeys();
                    if (rs.next()) {
                        int provisioningConfigID = rs.getInt(1);
                        if (connctorProperties.length > 0) {
                            for (Property config : connctorProperties) {
                                if (config == null) continue;
                                prepStmt.setInt(1, tenantId);
                                prepStmt.setInt(2, provisioningConfigID);
                                prepStmt.setString(3, config.getName());
                                if ("BLOB".equals(config.getType())) {
                                    prepStmt.setString(4, null);
                                    this.setBlobValue(config.getValue(), prepStmt, 5);
                                    prepStmt.setString(6, config.getType());
                                } else {
                                    prepStmt.setString(4, config.getValue());
                                    this.setBlobValue(null, prepStmt, 5);
                                    prepStmt.setString(6, "STRING");
                                }
                                if (config.isConfidential()) {
                                    prepStmt.setString(7, "1");
                                } else {
                                    prepStmt.setString(7, "0");
                                }
                                prepStmt.addBatch();
                            }
                        }
                    }
                    prepStmt.executeBatch();
                }
            }
        }
        catch (IOException e) {
            try {
                throw new IdentityProviderManagementException("An error occurred while processing content stream.", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                IdentityDatabaseUtil.closeStatement(prepBaseStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepBaseStmt);
    }

    private void setBlobValue(String value, PreparedStatement prepStmt, int index) throws SQLException, IOException {
        if (value != null) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes());
            prepStmt.setBinaryStream(index, (InputStream)inputStream, ((InputStream)inputStream).available());
        } else {
            prepStmt.setBinaryStream(index, (InputStream)new ByteArrayInputStream(new byte[0]), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProvisioningConnectorConfigs(ProvisioningConnectorConfig[] newProvisioningConnectorConfigs, Connection dbConnection, int idpId, int tenantId) throws IdentityProviderManagementException, SQLException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            this.deleteProvisioningConnectorConfigs(dbConnection, idpId);
            if (newProvisioningConnectorConfigs != null && newProvisioningConnectorConfigs.length > 0) {
                this.addProvisioningConnectorConfigs(newProvisioningConnectorConfigs, dbConnection, idpId, tenantId);
            }
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections(null, rs, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningConnectorConfig[] getProvisioningConnectorConfigs(Connection dbConnection, String idPName, int idPId, int tenantId) throws IdentityProviderManagementException, SQLException {
        ProvisioningConnectorConfig[] provisioningConnectorConfigArray;
        PreparedStatement prepStmt = null;
        PreparedStatement prepBaseStmt = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            String sqlBaseStmt = "SELECT ID, TENANT_ID, IDP_ID, PROVISIONING_CONNECTOR_TYPE, IS_ENABLED, IS_BLOCKING  FROM IDP_PROVISIONING_CONFIG WHERE IDP_ID=?";
            prepBaseStmt = dbConnection.prepareStatement(sqlBaseStmt);
            prepBaseStmt.setInt(1, idPId);
            rs1 = prepBaseStmt.executeQuery();
            HashMap<String, ProvisioningConnectorConfig> provisioningConnectorMap = new HashMap<String, ProvisioningConnectorConfig>();
            while (rs1.next()) {
                String type = rs1.getString("PROVISIONING_CONNECTOR_TYPE");
                if (provisioningConnectorMap.containsKey(type)) continue;
                ProvisioningConnectorConfig provisioningConnector = new ProvisioningConnectorConfig();
                provisioningConnector.setName(type);
                if ("1".equals(rs1.getString("IS_ENABLED"))) {
                    provisioningConnector.setEnabled(true);
                } else {
                    provisioningConnector.setEnabled(false);
                }
                if ("1".equals(rs1.getString("IS_BLOCKING"))) {
                    provisioningConnector.setBlocking(true);
                } else {
                    provisioningConnector.setBlocking(false);
                }
                if (provisioningConnector.getProvisioningProperties() == null || provisioningConnector.getProvisioningProperties().length == 0) {
                    String sqlStmt = "SELECT TENANT_ID, PROVISIONING_CONFIG_ID, PROPERTY_KEY, PROPERTY_VALUE, PROPERTY_BLOB_VALUE, PROPERTY_TYPE, IS_SECRET FROM IDP_PROV_CONFIG_PROPERTY WHERE TENANT_ID=? AND PROVISIONING_CONFIG_ID=?";
                    prepStmt = dbConnection.prepareStatement(sqlStmt);
                    int configId = rs1.getInt("ID");
                    prepStmt.setInt(1, tenantId);
                    prepStmt.setInt(2, configId);
                    rs2 = prepStmt.executeQuery();
                    ArrayList<Property> provisioningProperties = new ArrayList<Property>();
                    while (rs2.next()) {
                        Property property = new Property();
                        String name = rs2.getString("PROPERTY_KEY");
                        String value = rs2.getString("PROPERTY_VALUE");
                        String blobValue = this.getBlobValue(rs2.getBinaryStream("PROPERTY_BLOB_VALUE"));
                        String propertyType = rs2.getString("PROPERTY_TYPE");
                        String isSecret = rs2.getString("IS_SECRET");
                        property.setName(name);
                        if (propertyType != null && "BLOB".equals(propertyType.trim())) {
                            property.setValue(blobValue);
                        } else {
                            property.setValue(value);
                        }
                        property.setType(propertyType);
                        if ("1".equals(isSecret)) {
                            property.setConfidential(true);
                        } else {
                            property.setConfidential(false);
                        }
                        provisioningProperties.add(property);
                    }
                    provisioningConnector.setProvisioningProperties(provisioningProperties.toArray(new Property[provisioningProperties.size()]));
                }
                provisioningConnectorMap.put(type, provisioningConnector);
            }
            provisioningConnectorConfigArray = provisioningConnectorMap.values().toArray(new ProvisioningConnectorConfig[provisioningConnectorMap.size()]);
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs2, (PreparedStatement)prepBaseStmt);
            IdentityDatabaseUtil.closeAllConnections(null, rs1, prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, rs2, (PreparedStatement)prepBaseStmt);
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs1, prepStmt);
        return provisioningConnectorConfigArray;
    }

    private String getBlobValue(InputStream is) throws IdentityProviderManagementException {
        if (is != null) {
            BufferedReader br = null;
            StringBuilder sb = new StringBuilder();
            try {
                String line;
                br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (IOException e) {
                throw new IdentityProviderManagementException("Error occurred while reading blob value from input stream", e);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error in retrieving the Blob value", (Throwable)e);
                    }
                }
            }
            return sb.toString();
        }
        return null;
    }

    public IdentityProvider getIdPByName(Connection dbConnection, String idPName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        return this.getIDP(dbConnection, idPName, -1, null, tenantId, tenantDomain);
    }

    public IdentityProvider getIDPbyId(Connection dbConnection, int idpId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        return this.getIDP(dbConnection, null, idpId, null, tenantId, tenantDomain);
    }

    public IdentityProvider getIDPbyResourceId(Connection dbConnection, String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        return this.getIDP(dbConnection, null, -1, resourceId, tenantId, tenantDomain);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IdentityProvider getIDP(Connection dbConnection, String idPName, int idpId, String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider;
        ResultSet rs;
        PreparedStatement prepStmt;
        block31: {
            prepStmt = null;
            rs = null;
            IdentityProvider federatedIdp = null;
            boolean dbConnectionInitialized = true;
            if (dbConnection == null) {
                dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            } else {
                dbConnectionInitialized = false;
            }
            try {
                String sqlStmt = "SELECT ID, NAME, IS_PRIMARY, HOME_REALM_ID, CERTIFICATE, ALIAS, INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, USER_CLAIM_URI, ROLE_CLAIM_URI, DEFAULT_AUTHENTICATOR_NAME,DEFAULT_PRO_CONNECTOR_NAME, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, PROVISIONING_ROLE, IS_ENABLED, DISPLAY_NAME, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND UUID = ?";
                if (StringUtils.isBlank((String)resourceId)) {
                    sqlStmt = "SELECT ID, NAME, IS_PRIMARY, HOME_REALM_ID, CERTIFICATE, ALIAS, INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, USER_CLAIM_URI, ROLE_CLAIM_URI,DEFAULT_AUTHENTICATOR_NAME,DEFAULT_PRO_CONNECTOR_NAME, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, PROVISIONING_ROLE, IS_ENABLED, DISPLAY_NAME, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND NAME = ?";
                    if (StringUtils.isEmpty((String)idPName)) {
                        sqlStmt = "SELECT ID, NAME, IS_PRIMARY, HOME_REALM_ID, CERTIFICATE, ALIAS, INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, USER_CLAIM_URI, ROLE_CLAIM_URI,DEFAULT_AUTHENTICATOR_NAME,DEFAULT_PRO_CONNECTOR_NAME, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, PROVISIONING_ROLE, IS_ENABLED, DISPLAY_NAME, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND ID = ?";
                    }
                }
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setInt(1, tenantId);
                prepStmt.setInt(2, -1234);
                if (StringUtils.isNotEmpty((String)resourceId)) {
                    prepStmt.setString(3, resourceId);
                } else if (StringUtils.isNotEmpty((String)idPName)) {
                    prepStmt.setString(3, idPName);
                } else {
                    prepStmt.setInt(3, idpId);
                }
                rs = prepStmt.executeQuery();
                if (rs.next()) {
                    federatedIdp = new IdentityProvider();
                    idpId = rs.getInt("ID");
                    federatedIdp.setId(Integer.toString(idpId));
                    idPName = rs.getString("NAME");
                    federatedIdp.setIdentityProviderName(idPName);
                    resourceId = rs.getString("UUID");
                    federatedIdp.setResourceId(resourceId);
                    federatedIdp.setImageUrl(rs.getString("IMAGE_URL"));
                    if ("1".equals(rs.getString("IS_PRIMARY"))) {
                        federatedIdp.setPrimary(true);
                    } else {
                        federatedIdp.setPrimary(false);
                    }
                    federatedIdp.setHomeRealmId(rs.getString("HOME_REALM_ID"));
                    federatedIdp.setCertificate(this.getBlobValue(rs.getBinaryStream("CERTIFICATE")));
                    federatedIdp.setAlias(rs.getString("ALIAS"));
                    JustInTimeProvisioningConfig jitProConfig = new JustInTimeProvisioningConfig();
                    if ("1".equals(rs.getString("INBOUND_PROV_ENABLED"))) {
                        jitProConfig.setProvisioningEnabled(true);
                    } else {
                        jitProConfig.setProvisioningEnabled(false);
                    }
                    jitProConfig.setProvisioningUserStore(rs.getString("INBOUND_PROV_USER_STORE_ID"));
                    federatedIdp.setJustInTimeProvisioningConfig(jitProConfig);
                    String userClaimUri = rs.getString("USER_CLAIM_URI");
                    String roleClaimUri = rs.getString("ROLE_CLAIM_URI");
                    String defaultAuthenticatorName = rs.getString("DEFAULT_AUTHENTICATOR_NAME");
                    String defaultProvisioningConnectorConfigName = rs.getString("DEFAULT_PRO_CONNECTOR_NAME");
                    federatedIdp.setIdentityProviderDescription(rs.getString("DESCRIPTION"));
                    if ("1".equals(rs.getString("IS_FEDERATION_HUB"))) {
                        federatedIdp.setFederationHub(true);
                    } else {
                        federatedIdp.setFederationHub(false);
                    }
                    if (federatedIdp.getClaimConfig() == null) {
                        federatedIdp.setClaimConfig(new ClaimConfig());
                    }
                    if ("1".equals(rs.getString("IS_LOCAL_CLAIM_DIALECT"))) {
                        federatedIdp.getClaimConfig().setLocalClaimDialect(true);
                    } else {
                        federatedIdp.getClaimConfig().setLocalClaimDialect(false);
                    }
                    federatedIdp.setProvisioningRole(rs.getString("PROVISIONING_ROLE"));
                    if ("1".equals(rs.getString("IS_ENABLED"))) {
                        federatedIdp.setEnable(true);
                    } else {
                        federatedIdp.setEnable(false);
                    }
                    federatedIdp.setDisplayName(rs.getString("DISPLAY_NAME"));
                    if (defaultProvisioningConnectorConfigName != null) {
                        ProvisioningConnectorConfig defaultProConnector = new ProvisioningConnectorConfig();
                        defaultProConnector.setName(defaultProvisioningConnectorConfigName);
                        federatedIdp.setDefaultProvisioningConnectorConfig(defaultProConnector);
                    }
                    federatedIdp.setFederatedAuthenticatorConfigs(this.getFederatedAuthenticatorConfigs(dbConnection, idPName, federatedIdp, tenantId));
                    if (defaultAuthenticatorName != null && federatedIdp.getFederatedAuthenticatorConfigs() != null) {
                        federatedIdp.setDefaultAuthenticatorConfig(IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])federatedIdp.getFederatedAuthenticatorConfigs(), (String)defaultAuthenticatorName));
                    }
                    if (federatedIdp.getClaimConfig().isLocalClaimDialect()) {
                        federatedIdp.setClaimConfig(this.getLocalIdPDefaultClaimValues(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                    } else {
                        federatedIdp.setClaimConfig(this.getIdPClaimConfiguration(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                    }
                    federatedIdp.setProvisioningConnectorConfigs(this.getProvisioningConnectorConfigs(dbConnection, idPName, idpId, tenantId));
                    federatedIdp.setPermissionAndRoleConfig(this.getPermissionsAndRoleConfiguration(dbConnection, idPName, idpId, tenantId));
                    List<IdentityProviderProperty> propertyList = this.filterIdenityProperties(federatedIdp, this.getIdentityPropertiesByIdpId(dbConnection, idpId));
                    if ("LOCAL".equals(idPName)) {
                        propertyList = this.resolveConnectorProperties(propertyList, tenantDomain);
                    }
                    federatedIdp.setIdpProperties(propertyList.toArray(new IdentityProviderProperty[0]));
                }
                identityProvider = federatedIdp;
                if (!dbConnectionInitialized) break block31;
            }
            catch (SQLException e) {
                try {
                    throw new IdentityProviderManagementException("Error occurred while retrieving Identity Provider information for tenant : " + tenantDomain + " and Identity Provider name : " + idPName, e);
                    catch (ConnectorException e2) {
                        throw new IdentityProviderManagementException("Error occurred while retrieving the identity connector configurations.", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (dbConnectionInitialized) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, prepStmt);
                        throw throwable;
                    }
                    IdentityDatabaseUtil.closeAllConnections(null, rs, prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
            return identityProvider;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        return identityProvider;
    }

    private List<IdentityProviderProperty> filterIdenityProperties(IdentityProvider federatedIdp, List<IdentityProviderProperty> identityProviderProperties) {
        JustInTimeProvisioningConfig justInTimeProvisioningConfig = federatedIdp.getJustInTimeProvisioningConfig();
        if (justInTimeProvisioningConfig != null) {
            identityProviderProperties.forEach(identityProviderProperty -> {
                if (identityProviderProperty.getName().equals("PASSWORD_PROVISIONING_ENABLED")) {
                    justInTimeProvisioningConfig.setPasswordProvisioningEnabled(Boolean.parseBoolean(identityProviderProperty.getValue()));
                } else if (identityProviderProperty.getName().equals("MODIFY_USERNAME_ENABLED")) {
                    justInTimeProvisioningConfig.setModifyUserNameAllowed(Boolean.parseBoolean(identityProviderProperty.getValue()));
                } else if (identityProviderProperty.getName().equals("PROMPT_CONSENT_ENABLED")) {
                    justInTimeProvisioningConfig.setPromptConsent(Boolean.parseBoolean(identityProviderProperty.getValue()));
                }
            });
        }
        identityProviderProperties.removeIf(identityProviderProperty -> identityProviderProperty.getName().equals("MODIFY_USERNAME_ENABLED") || identityProviderProperty.getName().equals("PASSWORD_PROVISIONING_ENABLED") || identityProviderProperty.getName().equals("PROMPT_CONSENT_ENABLED"));
        return identityProviderProperties;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdentityProvider getIdPByAuthenticatorPropertyValue(Connection dbConnection, String property, String value, String authenticator, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider;
        ResultSet rs;
        PreparedStatement prepStmt;
        block25: {
            prepStmt = null;
            rs = null;
            IdentityProvider federatedIdp = null;
            boolean dbConnectionInitialized = true;
            if (dbConnection == null) {
                dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            } else {
                dbConnectionInitialized = false;
            }
            try {
                String sqlStmt = "SELECT idp.ID, idp.NAME, idp.IS_PRIMARY, idp.HOME_REALM_ID, idp.CERTIFICATE, idp.ALIAS, idp.INBOUND_PROV_ENABLED, idp.INBOUND_PROV_USER_STORE_ID, idp.USER_CLAIM_URI, idp.ROLE_CLAIM_URI, idp.DEFAULT_AUTHENTICATOR_NAME, idp.DEFAULT_PRO_CONNECTOR_NAME, idp.DESCRIPTION, idp.IS_FEDERATION_HUB, idp.IS_LOCAL_CLAIM_DIALECT, idp.PROVISIONING_ROLE, idp.IS_ENABLED, idp.DISPLAY_NAME FROM IDP idp INNER JOIN  IDP_AUTHENTICATOR idp_auth ON idp.ID = idp_auth.IDP_ID INNER JOIN IDP_AUTHENTICATOR_PROPERTY idp_auth_pro ON idp_auth.ID = idp_auth_pro.AUTHENTICATOR_ID WHERE  idp_auth_pro.PROPERTY_KEY =?  AND idp_auth_pro.PROPERTY_VALUE = ? AND idp_auth_pro.TENANT_ID =? AND idp_auth.name =?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setString(1, property);
                prepStmt.setString(2, value);
                prepStmt.setInt(3, tenantId);
                prepStmt.setString(4, authenticator);
                rs = prepStmt.executeQuery();
                int idpId = -1;
                String idPName = "";
                if (rs.next()) {
                    federatedIdp = new IdentityProvider();
                    idpId = rs.getInt("ID");
                    idPName = rs.getString("NAME");
                    federatedIdp.setIdentityProviderName(idPName);
                    if ("1".equals(rs.getString("IS_PRIMARY"))) {
                        federatedIdp.setPrimary(true);
                    } else {
                        federatedIdp.setPrimary(false);
                    }
                    federatedIdp.setHomeRealmId(rs.getString("HOME_REALM_ID"));
                    federatedIdp.setCertificate(this.getBlobValue(rs.getBinaryStream("CERTIFICATE")));
                    federatedIdp.setAlias(rs.getString("ALIAS"));
                    JustInTimeProvisioningConfig jitProConfig = new JustInTimeProvisioningConfig();
                    if ("1".equals(rs.getString("INBOUND_PROV_ENABLED"))) {
                        jitProConfig.setProvisioningEnabled(true);
                    } else {
                        jitProConfig.setProvisioningEnabled(false);
                    }
                    jitProConfig.setProvisioningUserStore(rs.getString("INBOUND_PROV_USER_STORE_ID"));
                    federatedIdp.setJustInTimeProvisioningConfig(jitProConfig);
                    String userClaimUri = rs.getString("USER_CLAIM_URI");
                    String roleClaimUri = rs.getString("ROLE_CLAIM_URI");
                    String defaultAuthenticatorName = rs.getString("DEFAULT_AUTHENTICATOR_NAME");
                    String defaultProvisioningConnectorConfigName = rs.getString("DEFAULT_PRO_CONNECTOR_NAME");
                    federatedIdp.setIdentityProviderDescription(rs.getString("DESCRIPTION"));
                    if ("1".equals(rs.getString("IS_FEDERATION_HUB"))) {
                        federatedIdp.setFederationHub(true);
                    } else {
                        federatedIdp.setFederationHub(false);
                    }
                    if (federatedIdp.getClaimConfig() == null) {
                        federatedIdp.setClaimConfig(new ClaimConfig());
                    }
                    if ("1".equals(rs.getString("IS_LOCAL_CLAIM_DIALECT"))) {
                        federatedIdp.getClaimConfig().setLocalClaimDialect(true);
                    } else {
                        federatedIdp.getClaimConfig().setLocalClaimDialect(false);
                    }
                    federatedIdp.setProvisioningRole(rs.getString("PROVISIONING_ROLE"));
                    if ("1".equals(rs.getString("IS_ENABLED"))) {
                        federatedIdp.setEnable(true);
                    } else {
                        federatedIdp.setEnable(false);
                    }
                    federatedIdp.setDisplayName(rs.getString("DISPLAY_NAME"));
                    if (defaultAuthenticatorName != null) {
                        FederatedAuthenticatorConfig defaultAuthenticator = new FederatedAuthenticatorConfig();
                        defaultAuthenticator.setName(defaultAuthenticatorName);
                        federatedIdp.setDefaultAuthenticatorConfig(defaultAuthenticator);
                    }
                    if (defaultProvisioningConnectorConfigName != null) {
                        ProvisioningConnectorConfig defaultProConnector = new ProvisioningConnectorConfig();
                        defaultProConnector.setName(defaultProvisioningConnectorConfigName);
                        federatedIdp.setDefaultProvisioningConnectorConfig(defaultProConnector);
                    }
                    federatedIdp.setFederatedAuthenticatorConfigs(this.getFederatedAuthenticatorConfigs(dbConnection, idPName, federatedIdp, tenantId));
                    if (federatedIdp.getClaimConfig().isLocalClaimDialect()) {
                        federatedIdp.setClaimConfig(this.getLocalIdPDefaultClaimValues(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                    } else {
                        federatedIdp.setClaimConfig(this.getIdPClaimConfiguration(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                    }
                    federatedIdp.setProvisioningConnectorConfigs(this.getProvisioningConnectorConfigs(dbConnection, idPName, idpId, tenantId));
                    federatedIdp.setPermissionAndRoleConfig(this.getPermissionsAndRoleConfiguration(dbConnection, idPName, idpId, tenantId));
                    List<IdentityProviderProperty> propertyList = this.filterIdenityProperties(federatedIdp, this.getIdentityPropertiesByIdpId(dbConnection, Integer.parseInt(rs.getString("ID"))));
                    if ("LOCAL".equals(idPName)) {
                        propertyList = this.resolveConnectorProperties(propertyList, tenantDomain);
                    }
                    federatedIdp.setIdpProperties(propertyList.toArray(new IdentityProviderProperty[0]));
                }
                identityProvider = federatedIdp;
                if (!dbConnectionInitialized) break block25;
            }
            catch (SQLException e) {
                try {
                    throw new IdentityProviderManagementException("Error occurred while retrieving Identity Provider information for Authenticator Property : " + property + " and value : " + value, e);
                    catch (ConnectorException e2) {
                        throw new IdentityProviderManagementException("Error occurred while retrieving the identity connector configurations.", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (dbConnectionInitialized) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                        throw throwable;
                    }
                    IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
            return identityProvider;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        return identityProvider;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IdentityProvider getIdPByAuthenticatorPropertyValue(Connection dbConnection, String property, String value, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider;
        ResultSet rs;
        PreparedStatement prepStmt;
        block25: {
            prepStmt = null;
            rs = null;
            IdentityProvider federatedIdp = null;
            boolean dbConnectionInitialized = true;
            if (dbConnection == null) {
                dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            } else {
                dbConnectionInitialized = false;
            }
            try {
                String sqlStmt = "SELECT idp.ID, idp.NAME, idp.IS_PRIMARY, idp.HOME_REALM_ID, idp.CERTIFICATE, idp.ALIAS, idp.INBOUND_PROV_ENABLED, idp.INBOUND_PROV_USER_STORE_ID, idp.USER_CLAIM_URI, idp.ROLE_CLAIM_URI, idp.DEFAULT_AUTHENTICATOR_NAME, idp.DEFAULT_PRO_CONNECTOR_NAME, idp.DESCRIPTION, idp.IS_FEDERATION_HUB, idp.IS_LOCAL_CLAIM_DIALECT, idp.PROVISIONING_ROLE, idp.IS_ENABLED, idp.DISPLAY_NAME FROM IDP idp INNER JOIN  IDP_AUTHENTICATOR idp_auth ON idp.ID = idp_auth.IDP_ID INNER JOIN IDP_AUTHENTICATOR_PROPERTY idp_auth_pro ON idp_auth.ID = idp_auth_pro.AUTHENTICATOR_ID WHERE  idp_auth_pro.PROPERTY_KEY =?  AND idp_auth_pro.PROPERTY_VALUE = ? AND idp_auth_pro.TENANT_ID =?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setString(1, property);
                prepStmt.setString(2, value);
                prepStmt.setInt(3, tenantId);
                rs = prepStmt.executeQuery();
                int idpId = -1;
                String idPName = "";
                if (rs.next()) {
                    federatedIdp = new IdentityProvider();
                    idpId = rs.getInt("ID");
                    idPName = rs.getString("NAME");
                    federatedIdp.setIdentityProviderName(idPName);
                    if ("1".equals(rs.getString("IS_PRIMARY"))) {
                        federatedIdp.setPrimary(true);
                    } else {
                        federatedIdp.setPrimary(false);
                    }
                    federatedIdp.setHomeRealmId(rs.getString("HOME_REALM_ID"));
                    federatedIdp.setCertificate(this.getBlobValue(rs.getBinaryStream("CERTIFICATE")));
                    federatedIdp.setAlias(rs.getString("ALIAS"));
                    JustInTimeProvisioningConfig jitProConfig = new JustInTimeProvisioningConfig();
                    if ("1".equals(rs.getString("INBOUND_PROV_ENABLED"))) {
                        jitProConfig.setProvisioningEnabled(true);
                    } else {
                        jitProConfig.setProvisioningEnabled(false);
                    }
                    jitProConfig.setProvisioningUserStore(rs.getString("INBOUND_PROV_USER_STORE_ID"));
                    federatedIdp.setJustInTimeProvisioningConfig(jitProConfig);
                    String userClaimUri = rs.getString("USER_CLAIM_URI");
                    String roleClaimUri = rs.getString("ROLE_CLAIM_URI");
                    String defaultAuthenticatorName = rs.getString("DEFAULT_AUTHENTICATOR_NAME");
                    String defaultProvisioningConnectorConfigName = rs.getString("DEFAULT_PRO_CONNECTOR_NAME");
                    federatedIdp.setIdentityProviderDescription(rs.getString("DESCRIPTION"));
                    if ("1".equals(rs.getString("IS_FEDERATION_HUB"))) {
                        federatedIdp.setFederationHub(true);
                    } else {
                        federatedIdp.setFederationHub(false);
                    }
                    if (federatedIdp.getClaimConfig() == null) {
                        federatedIdp.setClaimConfig(new ClaimConfig());
                    }
                    if ("1".equals(rs.getString("IS_LOCAL_CLAIM_DIALECT"))) {
                        federatedIdp.getClaimConfig().setLocalClaimDialect(true);
                    } else {
                        federatedIdp.getClaimConfig().setLocalClaimDialect(false);
                    }
                    federatedIdp.setProvisioningRole(rs.getString("PROVISIONING_ROLE"));
                    if ("1".equals(rs.getString("IS_ENABLED"))) {
                        federatedIdp.setEnable(true);
                    } else {
                        federatedIdp.setEnable(false);
                    }
                    federatedIdp.setDisplayName(rs.getString("DISPLAY_NAME"));
                    if (defaultAuthenticatorName != null) {
                        FederatedAuthenticatorConfig defaultAuthenticator = new FederatedAuthenticatorConfig();
                        defaultAuthenticator.setName(defaultAuthenticatorName);
                        federatedIdp.setDefaultAuthenticatorConfig(defaultAuthenticator);
                    }
                    if (defaultProvisioningConnectorConfigName != null) {
                        ProvisioningConnectorConfig defaultProConnector = new ProvisioningConnectorConfig();
                        defaultProConnector.setName(defaultProvisioningConnectorConfigName);
                        federatedIdp.setDefaultProvisioningConnectorConfig(defaultProConnector);
                    }
                    federatedIdp.setFederatedAuthenticatorConfigs(this.getFederatedAuthenticatorConfigs(dbConnection, idPName, federatedIdp, tenantId));
                    if (federatedIdp.getClaimConfig().isLocalClaimDialect()) {
                        federatedIdp.setClaimConfig(this.getLocalIdPDefaultClaimValues(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                    } else {
                        federatedIdp.setClaimConfig(this.getIdPClaimConfiguration(dbConnection, idPName, userClaimUri, roleClaimUri, idpId, tenantId));
                    }
                    federatedIdp.setProvisioningConnectorConfigs(this.getProvisioningConnectorConfigs(dbConnection, idPName, idpId, tenantId));
                    federatedIdp.setPermissionAndRoleConfig(this.getPermissionsAndRoleConfiguration(dbConnection, idPName, idpId, tenantId));
                    List<IdentityProviderProperty> propertyList = this.filterIdenityProperties(federatedIdp, this.getIdentityPropertiesByIdpId(dbConnection, Integer.parseInt(rs.getString("ID"))));
                    if ("LOCAL".equals(idPName)) {
                        propertyList = this.resolveConnectorProperties(propertyList, tenantDomain);
                    }
                    federatedIdp.setIdpProperties(propertyList.toArray(new IdentityProviderProperty[0]));
                }
                identityProvider = federatedIdp;
                if (!dbConnectionInitialized) break block25;
            }
            catch (SQLException e) {
                try {
                    throw new IdentityProviderManagementException("Error occurred while retrieving Identity Provider information for Authenticator Property : " + property + " and value : " + value, e);
                    catch (ConnectorException e2) {
                        throw new IdentityProviderManagementException("Error occurred while retrieving the identity connector configurations.", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (dbConnectionInitialized) {
                        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                        throw throwable;
                    }
                    IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
            return identityProvider;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        return identityProvider;
    }

    public IdentityProvider getIdPByRealmId(String realmId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider;
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String idPName = null;
        try {
            String sqlStmt = "SELECT NAME FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND HOME_REALM_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.setInt(2, -1234);
            prepStmt.setString(3, realmId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                idPName = rs.getString("NAME");
            }
            identityProvider = this.getIdPByName(dbConnection, idPName, tenantId, tenantDomain);
        }
        catch (SQLException e) {
            try {
                throw new IdentityProviderManagementException("Error while retreiving Identity Provider by realm " + realmId, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return identityProvider;
    }

    public void addIdP(IdentityProvider identityProvider, int tenantId) throws IdentityProviderManagementException {
        this.addIdPWithResourceId(identityProvider, tenantId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String addIdPWithResourceId(IdentityProvider identityProvider, int tenantId) throws IdentityProviderManagementException {
        String string;
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)true);
        PreparedStatement prepStmt = null;
        try {
            if (identityProvider.isPrimary()) {
                this.switchOffPrimary(dbConnection, tenantId);
            }
            String sqlStmt = "INSERT INTO IDP (TENANT_ID, NAME, IS_PRIMARY, HOME_REALM_ID, CERTIFICATE, ALIAS, INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, USER_CLAIM_URI, ROLE_CLAIM_URI,DEFAULT_AUTHENTICATOR_NAME,DEFAULT_PRO_CONNECTOR_NAME, DESCRIPTION,IS_FEDERATION_HUB,IS_LOCAL_CLAIM_DIALECT,PROVISIONING_ROLE, IS_ENABLED, DISPLAY_NAME, IMAGE_URL, UUID) VALUES (?, ?, ?,?,?, ?, ?, ?, ?, ?,?,?, ?,?,? ,?, ?, ?, ?, ?)";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, identityProvider.getIdentityProviderName());
            if (identityProvider.isPrimary()) {
                prepStmt.setString(3, "1");
            } else {
                prepStmt.setString(3, "0");
            }
            prepStmt.setString(4, identityProvider.getHomeRealmId());
            if (ArrayUtils.isNotEmpty((Object[])identityProvider.getCertificateInfoArray())) {
                try {
                    IdentityApplicationManagementUtil.getCertDataArray((CertificateInfo[])identityProvider.getCertificateInfoArray());
                }
                catch (CertificateException ex) {
                    throw new IdentityProviderManagementException("Malformed Public Certificate file has been provided.", ex);
                }
            }
            JSONArray certificateInfoJsonArray = new JSONArray((Object)identityProvider.getCertificateInfoArray());
            this.setBlobValue(certificateInfoJsonArray.toString(), prepStmt, 5);
            prepStmt.setString(6, identityProvider.getAlias());
            if (identityProvider.getJustInTimeProvisioningConfig() != null && identityProvider.getJustInTimeProvisioningConfig().isProvisioningEnabled()) {
                prepStmt.setString(7, "1");
                prepStmt.setString(8, identityProvider.getJustInTimeProvisioningConfig().getProvisioningUserStore());
            } else {
                prepStmt.setString(7, "0");
                prepStmt.setString(8, null);
            }
            if (identityProvider.getClaimConfig() != null) {
                prepStmt.setString(9, identityProvider.getClaimConfig().getUserClaimURI());
                prepStmt.setString(10, identityProvider.getClaimConfig().getRoleClaimURI());
            } else {
                prepStmt.setString(9, null);
                prepStmt.setString(10, null);
            }
            if (identityProvider.getDefaultAuthenticatorConfig() != null) {
                prepStmt.setString(11, identityProvider.getDefaultAuthenticatorConfig().getName());
            } else {
                prepStmt.setString(11, null);
            }
            if (identityProvider.getDefaultProvisioningConnectorConfig() != null) {
                prepStmt.setString(12, identityProvider.getDefaultProvisioningConnectorConfig().getName());
            } else {
                prepStmt.setString(12, null);
            }
            prepStmt.setString(13, identityProvider.getIdentityProviderDescription());
            if (identityProvider.isFederationHub()) {
                prepStmt.setString(14, "1");
            } else {
                prepStmt.setString(14, "0");
            }
            if (identityProvider.getClaimConfig() != null && identityProvider.getClaimConfig().isLocalClaimDialect()) {
                prepStmt.setString(15, "1");
            } else {
                prepStmt.setString(15, "0");
            }
            prepStmt.setString(16, identityProvider.getProvisioningRole());
            prepStmt.setString(17, "1");
            prepStmt.setString(18, identityProvider.getDisplayName());
            prepStmt.setString(19, identityProvider.getImageUrl());
            String resourceId = UUID.randomUUID().toString();
            prepStmt.setString(20, resourceId);
            prepStmt.executeUpdate();
            prepStmt.clearParameters();
            IdentityProvider createdIDP = this.getIDPbyResourceId(dbConnection, resourceId, tenantId, IdentityTenantUtil.getTenantDomain((int)tenantId));
            int idPId = Integer.parseInt(createdIDP.getId());
            if (idPId <= 0) {
                String msg = "Error adding Identity Provider for tenant " + tenantId;
                throw new IdentityProviderManagementException(msg);
            }
            if (identityProvider.getProvisioningConnectorConfigs() != null && identityProvider.getProvisioningConnectorConfigs().length > 0) {
                this.addProvisioningConnectorConfigs(identityProvider.getProvisioningConnectorConfigs(), dbConnection, idPId, tenantId);
            }
            this.addFederatedAuthenticatorConfigs(identityProvider.getFederatedAuthenticatorConfigs(), dbConnection, idPId, tenantId);
            if (identityProvider.getPermissionAndRoleConfig() != null && identityProvider.getPermissionAndRoleConfig().getIdpRoles() != null && identityProvider.getPermissionAndRoleConfig().getIdpRoles().length > 0) {
                this.addIdPRoles(dbConnection, idPId, tenantId, identityProvider.getPermissionAndRoleConfig().getIdpRoles());
                if (identityProvider.getPermissionAndRoleConfig().getRoleMappings() != null && identityProvider.getPermissionAndRoleConfig().getRoleMappings().length > 0) {
                    this.addIdPRoleMappings(dbConnection, idPId, tenantId, identityProvider.getPermissionAndRoleConfig().getRoleMappings());
                }
            }
            if (identityProvider.getClaimConfig() != null && identityProvider.getClaimConfig().getClaimMappings() != null && identityProvider.getClaimConfig().getClaimMappings().length > 0) {
                if (identityProvider.getClaimConfig().isLocalClaimDialect()) {
                    this.addDefaultClaimValuesForLocalIdP(dbConnection, idPId, tenantId, identityProvider.getClaimConfig().getClaimMappings());
                } else {
                    this.addIdPClaims(dbConnection, idPId, tenantId, identityProvider.getClaimConfig().getIdpClaims());
                    this.addIdPClaimMappings(dbConnection, idPId, tenantId, identityProvider.getClaimConfig().getClaimMappings());
                }
            }
            IdentityProviderProperty[] idpProperties = identityProvider.getIdpProperties();
            if ("LOCAL".equals(identityProvider.getIdentityProviderName())) {
                idpProperties = this.filterConnectorProperties(idpProperties, IdentityTenantUtil.getTenantDomain((int)tenantId)).toArray(new IdentityProviderProperty[0]);
            }
            List<IdentityProviderProperty> identityProviderProperties = this.getCombinedProperties(identityProvider.getJustInTimeProvisioningConfig(), idpProperties);
            this.addIdentityProviderProperties(dbConnection, idPId, identityProviderProperties, tenantId);
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
            string = resourceId;
        }
        catch (IOException e) {
            try {
                throw new IdentityProviderManagementException("An error occurred while processing content stream.", e);
                catch (SQLException e2) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
                    throw new IdentityProviderManagementException("Error occurred while adding Identity Provider for tenant " + tenantId, e2);
                }
                catch (ConnectorException e3) {
                    throw new IdentityProviderManagementException("An error occurred while filtering IDP properties.", e3);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, (PreparedStatement)prepStmt);
        return string;
    }

    private List<IdentityProviderProperty> getCombinedProperties(JustInTimeProvisioningConfig justInTimeProvisioningConfig, IdentityProviderProperty[] idpProperties) {
        ArrayList<Object> identityProviderProperties = new ArrayList();
        if (ArrayUtils.isNotEmpty((Object[])idpProperties)) {
            identityProviderProperties = new ArrayList<IdentityProviderProperty>(Arrays.asList(idpProperties));
        }
        IdentityProviderProperty passwordProvisioningProperty = new IdentityProviderProperty();
        passwordProvisioningProperty.setName("PASSWORD_PROVISIONING_ENABLED");
        passwordProvisioningProperty.setValue("false");
        IdentityProviderProperty modifyUserNameProperty = new IdentityProviderProperty();
        modifyUserNameProperty.setName("MODIFY_USERNAME_ENABLED");
        modifyUserNameProperty.setValue("false");
        IdentityProviderProperty promptConsentProperty = new IdentityProviderProperty();
        promptConsentProperty.setName("PROMPT_CONSENT_ENABLED");
        promptConsentProperty.setValue("false");
        if (justInTimeProvisioningConfig != null && justInTimeProvisioningConfig.isProvisioningEnabled()) {
            passwordProvisioningProperty.setValue(String.valueOf(justInTimeProvisioningConfig.isPasswordProvisioningEnabled()));
            modifyUserNameProperty.setValue(String.valueOf(justInTimeProvisioningConfig.isModifyUserNameAllowed()));
            promptConsentProperty.setValue(String.valueOf(justInTimeProvisioningConfig.isPromptConsent()));
        }
        identityProviderProperties.add(passwordProvisioningProperty);
        identityProviderProperties.add(modifyUserNameProperty);
        identityProviderProperties.add(promptConsentProperty);
        return identityProviderProperties;
    }

    public void updateIdP(IdentityProvider newIdentityProvider, IdentityProvider currentIdentityProvider, int tenantId) throws IdentityProviderManagementException {
        this.updateIdPWithResourceId(null, newIdentityProvider, currentIdentityProvider, tenantId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateIdPWithResourceId(String resourceId, IdentityProvider newIdentityProvider, IdentityProvider currentIdentityProvider, int tenantId) throws IdentityProviderManagementException {
        if (StringUtils.isBlank((String)resourceId)) {
            resourceId = currentIdentityProvider.getResourceId();
        }
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt1 = null;
        PreparedStatement prepStmt2 = null;
        ResultSet rs = null;
        try {
            int idPId = this.getIdentityProviderIdByName(dbConnection, currentIdentityProvider.getIdentityProviderName(), tenantId);
            if (idPId <= 0) {
                String msg = "Trying to update non-existent Identity Provider for tenant " + tenantId;
                throw new IdentityProviderManagementException(msg);
            }
            String sqlStmt = "UPDATE IDP SET NAME=?, IS_PRIMARY=?, HOME_REALM_ID=?, CERTIFICATE=?, ALIAS=?, INBOUND_PROV_ENABLED=?, INBOUND_PROV_USER_STORE_ID=?,USER_CLAIM_URI=?, ROLE_CLAIM_URI=?, DEFAULT_AUTHENTICATOR_NAME=?, DEFAULT_PRO_CONNECTOR_NAME=?, DESCRIPTION=?, IS_FEDERATION_HUB=?, IS_LOCAL_CLAIM_DIALECT=?, PROVISIONING_ROLE=?, IS_ENABLED=?, DISPLAY_NAME=?, IMAGE_URL=? WHERE UUID=?";
            if (StringUtils.isBlank((String)resourceId)) {
                sqlStmt = "UPDATE IDP SET NAME=?, IS_PRIMARY=?, HOME_REALM_ID=?, CERTIFICATE=?, ALIAS=?, INBOUND_PROV_ENABLED=?, INBOUND_PROV_USER_STORE_ID=?,USER_CLAIM_URI=?, ROLE_CLAIM_URI=?, DEFAULT_AUTHENTICATOR_NAME=?, DEFAULT_PRO_CONNECTOR_NAME=?, DESCRIPTION=?, IS_FEDERATION_HUB=?, IS_LOCAL_CLAIM_DIALECT=?, PROVISIONING_ROLE=?, IS_ENABLED=?, DISPLAY_NAME=?  WHERE TENANT_ID=? AND NAME=?";
            }
            prepStmt1 = dbConnection.prepareStatement(sqlStmt);
            prepStmt1.setString(1, newIdentityProvider.getIdentityProviderName());
            if (newIdentityProvider.isPrimary()) {
                prepStmt1.setString(2, "1");
            } else {
                prepStmt1.setString(2, "0");
            }
            prepStmt1.setString(3, newIdentityProvider.getHomeRealmId());
            if (ArrayUtils.isNotEmpty((Object[])newIdentityProvider.getCertificateInfoArray())) {
                try {
                    IdentityApplicationManagementUtil.getCertDataArray((CertificateInfo[])newIdentityProvider.getCertificateInfoArray());
                }
                catch (CertificateException ex) {
                    throw new IdentityProviderManagementException("Malformed Public Certificate file has been provided.", ex);
                }
            }
            JSONArray certificateInfoJsonArray = new JSONArray((Object)newIdentityProvider.getCertificateInfoArray());
            this.setBlobValue(certificateInfoJsonArray.toString(), prepStmt1, 4);
            prepStmt1.setString(5, newIdentityProvider.getAlias());
            if (newIdentityProvider.getJustInTimeProvisioningConfig() != null && newIdentityProvider.getJustInTimeProvisioningConfig().isProvisioningEnabled()) {
                prepStmt1.setString(6, "1");
                prepStmt1.setString(7, newIdentityProvider.getJustInTimeProvisioningConfig().getProvisioningUserStore());
            } else {
                prepStmt1.setString(6, "0");
                prepStmt1.setString(7, null);
            }
            if (newIdentityProvider.getClaimConfig() != null) {
                prepStmt1.setString(8, newIdentityProvider.getClaimConfig().getUserClaimURI());
                prepStmt1.setString(9, newIdentityProvider.getClaimConfig().getRoleClaimURI());
            } else {
                prepStmt1.setString(8, null);
                prepStmt1.setString(9, null);
            }
            if (newIdentityProvider.getDefaultAuthenticatorConfig() != null && newIdentityProvider.getDefaultAuthenticatorConfig().getName() != null) {
                prepStmt1.setString(10, newIdentityProvider.getDefaultAuthenticatorConfig().getName());
            } else {
                prepStmt1.setString(10, null);
            }
            if (newIdentityProvider.getDefaultProvisioningConnectorConfig() != null && newIdentityProvider.getDefaultProvisioningConnectorConfig().getName() != null) {
                prepStmt1.setString(11, newIdentityProvider.getDefaultProvisioningConnectorConfig().getName());
            } else {
                prepStmt1.setString(11, null);
            }
            prepStmt1.setString(12, newIdentityProvider.getIdentityProviderDescription());
            if (newIdentityProvider.isFederationHub()) {
                prepStmt1.setString(13, "1");
            } else {
                prepStmt1.setString(13, "0");
            }
            if (newIdentityProvider.getClaimConfig() != null && newIdentityProvider.getClaimConfig().isLocalClaimDialect()) {
                prepStmt1.setString(14, "1");
            } else {
                prepStmt1.setString(14, "0");
            }
            prepStmt1.setString(15, newIdentityProvider.getProvisioningRole());
            if (newIdentityProvider.isEnable()) {
                prepStmt1.setString(16, "1");
            } else {
                prepStmt1.setString(16, "0");
            }
            prepStmt1.setString(17, newIdentityProvider.getDisplayName());
            if (StringUtils.isBlank((String)resourceId)) {
                prepStmt1.setInt(18, tenantId);
                prepStmt1.setString(19, currentIdentityProvider.getIdentityProviderName());
            } else {
                prepStmt1.setString(18, newIdentityProvider.getImageUrl());
                prepStmt1.setString(19, resourceId);
            }
            prepStmt1.executeUpdate();
            sqlStmt = "SELECT ID, NAME, IS_PRIMARY, HOME_REALM_ID, CERTIFICATE, ALIAS, INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, USER_CLAIM_URI, ROLE_CLAIM_URI, DEFAULT_AUTHENTICATOR_NAME,DEFAULT_PRO_CONNECTOR_NAME, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, PROVISIONING_ROLE, IS_ENABLED, DISPLAY_NAME, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND UUID = ?";
            if (StringUtils.isBlank((String)resourceId)) {
                sqlStmt = "SELECT ID, NAME, IS_PRIMARY, HOME_REALM_ID, CERTIFICATE, ALIAS, INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, USER_CLAIM_URI, ROLE_CLAIM_URI,DEFAULT_AUTHENTICATOR_NAME,DEFAULT_PRO_CONNECTOR_NAME, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, PROVISIONING_ROLE, IS_ENABLED, DISPLAY_NAME, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND NAME = ?";
            }
            prepStmt2 = dbConnection.prepareStatement(sqlStmt);
            prepStmt2.setInt(1, tenantId);
            prepStmt2.setInt(2, -1234);
            if (StringUtils.isBlank((String)resourceId)) {
                prepStmt2.setString(3, newIdentityProvider.getIdentityProviderName());
            } else {
                prepStmt2.setString(3, resourceId);
            }
            rs = prepStmt2.executeQuery();
            if (rs.next()) {
                int idpId = rs.getInt("ID");
                boolean isResidentIdP = "LOCAL".equals(newIdentityProvider.getIdentityProviderName());
                this.updateFederatedAuthenticatorConfigs(newIdentityProvider.getFederatedAuthenticatorConfigs(), currentIdentityProvider.getFederatedAuthenticatorConfigs(), dbConnection, idpId, tenantId, isResidentIdP);
                this.updateClaimConfiguration(dbConnection, idpId, tenantId, newIdentityProvider.getClaimConfig());
                this.updateRoleConfiguration(dbConnection, idpId, tenantId, newIdentityProvider.getPermissionAndRoleConfig());
                this.updateProvisioningConnectorConfigs(newIdentityProvider.getProvisioningConnectorConfigs(), dbConnection, idpId, tenantId);
                IdentityProviderProperty[] idpProperties = newIdentityProvider.getIdpProperties();
                if (isResidentIdP) {
                    idpProperties = this.filterConnectorProperties(idpProperties, IdentityTenantUtil.getTenantDomain((int)tenantId)).toArray(new IdentityProviderProperty[0]);
                }
                List<IdentityProviderProperty> identityProviderProperties = this.getCombinedProperties(newIdentityProvider.getJustInTimeProvisioningConfig(), idpProperties);
                this.updateIdentityProviderProperties(dbConnection, idpId, identityProviderProperties, tenantId);
            }
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (IOException e) {
            try {
                throw new IdentityProviderManagementException("An error occurred while processing content stream.", e);
                catch (SQLException e2) {
                    IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
                    throw new IdentityProviderManagementException("Error occurred while updating Identity Provider information  for tenant " + tenantId, e2);
                }
                catch (ConnectorException e3) {
                    throw new IdentityProviderManagementException("An error occurred while filtering IDP properties.", e3);
                }
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, prepStmt1);
                IdentityDatabaseUtil.closeStatement(prepStmt2);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt1);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt2);
    }

    public boolean isIdpReferredBySP(String idPName, int tenantId) throws IdentityProviderManagementException {
        ResultSet rsProvIdp;
        PreparedStatement prepStmtProvIdp;
        ResultSet rsFedIdp;
        PreparedStatement prepStmtFedIdp;
        Connection dbConnection;
        boolean isReffered;
        block6: {
            isReffered = false;
            dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
            prepStmtFedIdp = null;
            rsFedIdp = null;
            prepStmtProvIdp = null;
            rsProvIdp = null;
            try {
                String sqlStmt = "SELECT COUNT(*) FROM SP_FEDERATED_IDP A JOIN IDP_AUTHENTICATOR B ON A.AUTHENTICATOR_ID = B.ID WHERE B.IDP_ID = (SELECT ID FROM IDP C WHERE (C.TENANT_ID = ? OR (C.TENANT_ID = ? AND C.NAME LIKE 'SHARED_%')) AND C.NAME = ?)";
                prepStmtFedIdp = dbConnection.prepareStatement(sqlStmt);
                prepStmtFedIdp.setInt(1, tenantId);
                prepStmtFedIdp.setInt(2, -1234);
                prepStmtFedIdp.setString(3, idPName);
                rsFedIdp = prepStmtFedIdp.executeQuery();
                if (rsFedIdp.next()) {
                    boolean bl = isReffered = rsFedIdp.getInt(1) > 0;
                }
                if (isReffered) break block6;
                sqlStmt = "SELECT COUNT(*) FROM SP_PROVISIONING_CONNECTOR WHERE (TENANT_ID=? AND IDP_NAME=?)";
                prepStmtProvIdp = dbConnection.prepareStatement(sqlStmt);
                prepStmtProvIdp.setInt(1, tenantId);
                prepStmtProvIdp.setString(2, idPName);
                rsProvIdp = prepStmtProvIdp.executeQuery();
                if (rsProvIdp.next()) {
                    isReffered = rsProvIdp.getInt(1) > 0;
                }
            }
            catch (SQLException e) {
                try {
                    throw new IdentityProviderManagementException("Error occurred while searching for IDP references in SP ", e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeAllConnections(null, rsProvIdp, prepStmtProvIdp);
                    IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rsFedIdp, (PreparedStatement)prepStmtFedIdp);
                    throw throwable;
                }
            }
        }
        IdentityDatabaseUtil.closeAllConnections(null, rsProvIdp, prepStmtProvIdp);
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rsFedIdp, (PreparedStatement)prepStmtFedIdp);
        return isReffered;
    }

    public void deleteIdP(String idPName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        try {
            IdentityProvider identityProvider = this.getIdPByName(dbConnection, idPName, tenantId, tenantDomain);
            if (identityProvider == null) {
                String msg = "Trying to delete non-existent Identity Provider: %s in tenantDomain: %s";
                throw new IdentityProviderManagementException(String.format(msg, idPName, tenantDomain));
            }
            this.deleteIdP(dbConnection, tenantId, idPName, null);
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new IdentityProviderManagementException("Error occurred while deleting Identity Provider of tenant " + tenantDomain, e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)dbConnection);
        }
    }

    public void deleteIdPs(int tenantId) throws IdentityProviderManagementException {
        try (Connection conn = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            PreparedStatement prepStmt = conn.prepareStatement("DELETE FROM IDP WHERE TENANT_ID = ?");
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new IdentityProviderManagementException("Error occurred while deleting Identity Providers of tenant " + tenantId, e);
        }
    }

    public void deleteIdPByResourceId(String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        try {
            IdentityProvider identityProvider = this.getIDPbyResourceId(dbConnection, resourceId, tenantId, tenantDomain);
            if (identityProvider == null) {
                String msg = "Trying to delete non-existent Identity Provider with resource ID: %s in tenantDomain: %s";
                throw new IdentityProviderManagementException(String.format(msg, resourceId, tenantDomain));
            }
            this.deleteIdP(dbConnection, tenantId, null, resourceId);
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new IdentityProviderManagementException("Error occurred while deleting Identity Provider of tenant " + tenantDomain, e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)dbConnection);
        }
    }

    public void forceDeleteIdP(String idPName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        try {
            IdentityProvider identityProvider = this.getIdPByName(dbConnection, idPName, tenantId, tenantDomain);
            if (identityProvider == null) {
                String msg = "Trying to force delete non-existent Identity Provider: %s in tenantDomain: %s";
                throw new IdentityProviderManagementException(String.format(msg, idPName, tenantDomain));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Deleting SP Authentication Associations for IDP:%s of tenantDomain:%s", idPName, tenantDomain));
            }
            this.deleteIdpSpAuthAssociations(dbConnection, tenantId, idPName);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Deleting SP Provisioning Associations for IDP:%s of tenantDomain:%s", idPName, tenantDomain));
            }
            this.deleteIdpSpProvisioningAssociations(dbConnection, tenantId, idPName);
            this.deleteIdP(dbConnection, tenantId, idPName, null);
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new IdentityProviderManagementException(String.format("Error occurred while deleting Identity Provider:%s of tenant:%s ", idPName, tenantDomain), e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)dbConnection);
        }
    }

    public void forceDeleteIdPByResourceId(String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        try {
            IdentityProvider identityProvider = this.getIDPbyResourceId(dbConnection, resourceId, tenantId, tenantDomain);
            if (identityProvider == null) {
                String msg = "Trying to force delete non-existent Identity Provider with resource ID: %s in tenantDomain: %s";
                throw new IdentityProviderManagementException(String.format(msg, resourceId, tenantDomain));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Deleting SP Authentication Associations for IDP:%s of tenantDomain:%s", identityProvider.getIdentityProviderName(), tenantDomain));
            }
            this.deleteIdpSpAuthAssociations(dbConnection, tenantId, identityProvider.getIdentityProviderName());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Deleting SP Provisioning Associations for IDP:%s of tenantDomain:%s", identityProvider.getIdentityProviderName(), tenantDomain));
            }
            this.deleteIdpSpProvisioningAssociations(dbConnection, tenantId, identityProvider.getIdentityProviderName());
            this.deleteIdP(dbConnection, tenantId, null, resourceId);
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new IdentityProviderManagementException(String.format("Error occurred while deleting Identity Provider with resource ID:%s of tenant:%s ", resourceId, tenantDomain), e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)dbConnection);
        }
    }

    public void deleteTenantRole(int tenantId, String role, String tenantDomain) throws IdentityProviderManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            String sqlStmt = "DELETE FROM IDP_ROLE WHERE TENANT_ID=? AND ROLE=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, tenantId);
            prepStmt.setString(2, role);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new IdentityProviderManagementException("Error occurred while deleting tenant role " + role + " of tenant " + tenantDomain, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, (PreparedStatement)prepStmt);
        }
    }

    public void renameTenantRole(String newRoleName, String oldRoleName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            String sqlStmt = "UPDATE IDP_ROLE_MAPPING SET LOCAL_ROLE=? WHERE (TENANT_ID=? AND LOCAL_ROLE=?)";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, newRoleName);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, oldRoleName);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new IdentityProviderManagementException("Error occurred while renaming tenant role " + oldRoleName + " to " + newRoleName + " of tenant " + tenantDomain, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, (PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllIdPClaims(Connection dbConnection, int idpId) throws IdentityProviderManagementException, SQLException {
        PreparedStatement prepStmt = null;
        try {
            String sqlStmt = "DELETE FROM IDP_CLAIM WHERE IDP_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idpId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteLocalIdPClaimValues(Connection dbConnection, int idpId, int tenantId) throws IdentityProviderManagementException, SQLException {
        PreparedStatement prepStmt = null;
        try {
            String sqlStmt = "DELETE FROM  IDP_LOCAL_CLAIM WHERE (IDP_ID=? AND TENANT_ID=?)";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idpId);
            prepStmt.setInt(2, tenantId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteAllIdPRoles(Connection dbConnection, int idpId) throws IdentityProviderManagementException, SQLException {
        PreparedStatement prepStmt = null;
        try {
            String sqlStmt = "DELETE FROM IDP_ROLE WHERE IDP_ID=?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idpId);
            prepStmt.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    public void renameClaimURI(String newClaimURI, String oldClaimURI, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            String sqlStmt = "UPDATE IDP_CLAIM_MAPPING SET LOCAL_CLAIM=? WHERE (TENANT_ID=? AND LOCAL_CLAIM=?)";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, newClaimURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, oldClaimURI);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)dbConnection);
            throw new IdentityProviderManagementException("Error occurred while renaming tenant role " + oldClaimURI + " to " + newClaimURI + " of tenant " + tenantDomain, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, null, (PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchOffPrimary(Connection conn, int tenantId) throws SQLException {
        PreparedStatement prepStmt = null;
        String sqlStmt = "UPDATE IDP SET IS_PRIMARY=? WHERE (TENANT_ID=? AND IS_PRIMARY=?)";
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setString(1, "0");
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, "1");
            prepStmt.executeUpdate();
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAppointPrimary(Connection conn, int tenantId, String tenantDomain) throws SQLException, IdentityProviderManagementException {
        block3: {
            block2: {
                List<IdentityProvider> tenantIdPs = this.getIdPs(conn, tenantId, tenantDomain);
                if (tenantIdPs.isEmpty()) break block2;
                PreparedStatement prepStmt = null;
                try {
                    String sqlStmt = "UPDATE IDP SET IS_PRIMARY=? WHERE (TENANT_ID=? AND NAME=? AND IS_PRIMARY=?)";
                    prepStmt = conn.prepareStatement(sqlStmt);
                    prepStmt.setString(1, "1");
                    prepStmt.setInt(2, tenantId);
                    prepStmt.setString(3, tenantIdPs.get(0).getIdentityProviderName());
                    prepStmt.setString(4, "0");
                    prepStmt.executeUpdate();
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                break block3;
            }
            String msg = "No Identity Providers registered for tenant " + tenantDomain;
            log.warn((Object)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdPClaims(Connection conn, int idPId, int tenantId, Claim[] claims) throws SQLException {
        PreparedStatement prepStmt = null;
        if (claims == null || claims.length == 0) {
            return;
        }
        try {
            String sqlStmt = "INSERT INTO IDP_CLAIM (IDP_ID, TENANT_ID, CLAIM) VALUES (?, ?, ?)";
            prepStmt = conn.prepareStatement(sqlStmt);
            for (Claim claim : claims) {
                prepStmt.setInt(1, idPId);
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, claim.getClaimUri());
                prepStmt.addBatch();
                prepStmt.clearParameters();
            }
            prepStmt.executeBatch();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDefaultClaimValuesForLocalIdP(Connection conn, int idPId, int tenantId, ClaimMapping[] claimMappings) throws SQLException, IdentityProviderManagementException {
        ResultSet rs;
        PreparedStatement prepStmt;
        block6: {
            prepStmt = null;
            rs = null;
            if (claimMappings != null && claimMappings.length != 0) break block6;
            IdentityDatabaseUtil.closeAllConnections(null, rs, prepStmt);
            return;
        }
        try {
            String sqlStmt = "INSERT INTO IDP_LOCAL_CLAIM (IDP_ID, CLAIM_URI,DEFAULT_VALUE,TENANT_ID, IS_REQUESTED) VALUES (?, ?, ?, ?, ?)";
            prepStmt = conn.prepareStatement(sqlStmt);
            for (ClaimMapping mapping : claimMappings) {
                if (mapping == null || mapping.getLocalClaim() == null || mapping.getLocalClaim().getClaimUri() == null) continue;
                prepStmt.setInt(1, idPId);
                prepStmt.setString(2, mapping.getLocalClaim().getClaimUri());
                prepStmt.setString(3, mapping.getDefaultValue());
                prepStmt.setInt(4, tenantId);
                if (mapping.isRequested()) {
                    prepStmt.setString(5, "1");
                } else {
                    prepStmt.setString(5, "0");
                }
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs, prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdPClaimMappings(Connection conn, int idPId, int tenantId, ClaimMapping[] claimMappings) throws SQLException, IdentityProviderManagementException {
        ResultSet rs;
        PreparedStatement prepStmt;
        HashMap<String, Integer> claimIdMap;
        block10: {
            claimIdMap = new HashMap<String, Integer>();
            prepStmt = null;
            rs = null;
            if (claimMappings != null && claimMappings.length != 0) break block10;
            IdentityDatabaseUtil.closeAllConnections(null, rs, prepStmt);
            return;
        }
        try {
            String sqlStmt = "SELECT ID, CLAIM FROM IDP_CLAIM WHERE IDP_ID=?";
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idPId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                int id = rs.getInt("ID");
                String claim = rs.getString("CLAIM");
                claimIdMap.put(claim, id);
            }
            prepStmt.clearParameters();
            if (claimIdMap.isEmpty()) {
                String message = "No Identity Provider claim URIs defined for tenant " + tenantId;
                throw new IdentityProviderManagementException(message);
            }
            sqlStmt = "INSERT INTO IDP_CLAIM_MAPPING (IDP_CLAIM_ID, TENANT_ID, LOCAL_CLAIM,DEFAULT_VALUE, IS_REQUESTED) VALUES (?, ?, ?, ?, ?)";
            prepStmt = conn.prepareStatement(sqlStmt);
            for (ClaimMapping mapping : claimMappings) {
                if (mapping != null && mapping.getRemoteClaim() != null && claimIdMap.containsKey(mapping.getRemoteClaim().getClaimUri())) {
                    int idpClaimId = (Integer)claimIdMap.get(mapping.getRemoteClaim().getClaimUri());
                    String localClaimURI = mapping.getLocalClaim().getClaimUri();
                    prepStmt.setInt(1, idpClaimId);
                    prepStmt.setInt(2, tenantId);
                    prepStmt.setString(3, localClaimURI);
                    prepStmt.setString(4, mapping.getDefaultValue());
                    if (mapping.isRequested()) {
                        prepStmt.setString(5, "1");
                    } else {
                        prepStmt.setString(5, "0");
                    }
                } else {
                    throw new IdentityProviderManagementException("Cannot find Identity Provider claim mapping for tenant " + tenantId);
                }
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs, prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdPRoles(Connection conn, int idPId, int tenantId, String[] idpRoleNames) throws SQLException {
        PreparedStatement prepStmt = null;
        String sqlStmt = "INSERT INTO IDP_ROLE (IDP_ID, TENANT_ID, ROLE) VALUES (?, ?, ?)";
        if (idpRoleNames == null || idpRoleNames.length == 0) {
            return;
        }
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            for (String idpRole : idpRoleNames) {
                prepStmt.setInt(1, idPId);
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, idpRole);
                prepStmt.addBatch();
                prepStmt.clearParameters();
            }
            prepStmt.executeBatch();
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIdPRoleMappings(Connection conn, int idPId, int tenantId, RoleMapping[] roleMappings) throws SQLException, IdentityProviderManagementException {
        HashMap<String, Integer> roleIdMap = new HashMap<String, Integer>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String sqlStmt = "SELECT ID, ROLE  FROM IDP_ROLE WHERE IDP_ID=?";
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idPId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                int idpRoleId = rs.getInt("ID");
                String roleName = rs.getString("ROLE");
                roleIdMap.put(roleName, idpRoleId);
            }
            if (roleIdMap.isEmpty()) {
                String message = "No Identity Provider roles defined for tenant " + tenantId;
                throw new IdentityProviderManagementException(message);
            }
            sqlStmt = "INSERT INTO IDP_ROLE_MAPPING (IDP_ROLE_ID, TENANT_ID, USER_STORE_ID, LOCAL_ROLE) VALUES (?, ?, ?, ?)";
            prepStmt = conn.prepareStatement(sqlStmt);
            for (RoleMapping mapping : roleMappings) {
                if (mapping.getRemoteRole() == null || !roleIdMap.containsKey(mapping.getRemoteRole())) {
                    throw new IdentityProviderManagementException("Cannot find Identity Provider role " + mapping.getRemoteRole() + " for tenant " + tenantId);
                }
                int idpRoleId = (Integer)roleIdMap.get(mapping.getRemoteRole());
                String userStoreId = mapping.getLocalRole().getUserStoreId();
                String localRole = mapping.getLocalRole().getLocalRoleName();
                prepStmt.setInt(1, idpRoleId);
                prepStmt.setInt(2, tenantId);
                prepStmt.setString(3, userStoreId);
                prepStmt.setString(4, localRole);
                prepStmt.addBatch();
            }
            prepStmt.executeBatch();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
    }

    private void updateClaimConfiguration(Connection conn, int idPId, int tenantId, ClaimConfig newClaimConfig) throws SQLException, IdentityProviderManagementException {
        this.deleteAllIdPClaims(conn, idPId);
        this.deleteLocalIdPClaimValues(conn, idPId, tenantId);
        if (newClaimConfig == null) {
            return;
        }
        if (newClaimConfig.isLocalClaimDialect()) {
            if (newClaimConfig.getClaimMappings() != null && newClaimConfig.getClaimMappings().length > 0) {
                this.addDefaultClaimValuesForLocalIdP(conn, idPId, tenantId, newClaimConfig.getClaimMappings());
            }
        } else {
            boolean addedClaims = false;
            if (newClaimConfig.getIdpClaims() != null && newClaimConfig.getIdpClaims().length > 0) {
                this.addIdPClaims(conn, idPId, tenantId, newClaimConfig.getIdpClaims());
                addedClaims = true;
            }
            if (addedClaims && newClaimConfig.getClaimMappings() != null && newClaimConfig.getClaimMappings().length > 0) {
                this.addIdPClaimMappings(conn, idPId, tenantId, newClaimConfig.getClaimMappings());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIdPRoles(Connection conn, int idPId, List<String> addedRoles, List<String> deletedRoles, List<String> renamedOldRoles, List<String> renamedNewRoles) throws SQLException {
        Statement prepStmt1 = null;
        Statement prepStmt2 = null;
        Statement prepStmt3 = null;
        String sqlStmt = null;
        try {
            for (String deletedRole : deletedRoles) {
                sqlStmt = "DELETE FROM IDP_ROLE WHERE (IDP_ID=? AND ROLE=?)";
                prepStmt1 = conn.prepareStatement(sqlStmt);
                prepStmt1.setInt(1, idPId);
                prepStmt1.setString(2, deletedRole);
                prepStmt1.addBatch();
            }
            prepStmt1.executeBatch();
            for (String addedRole : addedRoles) {
                sqlStmt = "INSERT INTO IDP_ROLE (IDP_ID, TENANT_ID, ROLE) VALUES (?, ?, ?)";
                prepStmt2 = conn.prepareStatement(sqlStmt);
                prepStmt2.setInt(1, idPId);
                prepStmt2.setString(2, addedRole);
                prepStmt2.addBatch();
            }
            prepStmt2.executeBatch();
            prepStmt2.clearParameters();
            prepStmt2.clearBatch();
            for (int i = 0; i < renamedOldRoles.size(); ++i) {
                sqlStmt = "UPDATE IDP_ROLE SET ROLE=? WHERE (IDP_ID=? AND ROLE=?)";
                prepStmt3 = conn.prepareStatement(sqlStmt);
                prepStmt3.setString(1, renamedNewRoles.get(i));
                prepStmt3.setInt(2, idPId);
                prepStmt3.setString(3, renamedOldRoles.get(i));
                prepStmt3.addBatch();
            }
            prepStmt3.executeBatch();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement(prepStmt3);
            IdentityDatabaseUtil.closeStatement(prepStmt2);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt1);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt3);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt2);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt1);
    }

    private void updateRoleConfiguration(Connection conn, int idPId, int tenantId, PermissionsAndRoleConfig newRoleConfiguration) throws SQLException, IdentityProviderManagementException {
        this.deleteAllIdPRoles(conn, idPId);
        if (newRoleConfiguration == null) {
            return;
        }
        this.addIdPRoles(conn, idPId, tenantId, newRoleConfiguration.getIdpRoles());
        if (newRoleConfiguration.getRoleMappings() == null || newRoleConfiguration.getRoleMappings().length == 0) {
            return;
        }
        this.addIdPRoleMappings(conn, idPId, tenantId, newRoleConfiguration.getRoleMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteProvisioningConnectorConfigs(Connection conn, int idPId) throws SQLException {
        PreparedStatement prepStmt = null;
        String sqlStmt = "DELETE FROM IDP_PROVISIONING_CONFIG WHERE IDP_ID=?";
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setInt(1, idPId);
            prepStmt.executeUpdate();
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIdP(Connection conn, int tenantId, String idPName, String resourceId) throws SQLException {
        PreparedStatement prepStmt = null;
        String sqlStmt = "DELETE FROM IDP WHERE UUID=?";
        if (StringUtils.isBlank((String)resourceId)) {
            sqlStmt = "DELETE FROM IDP WHERE (TENANT_ID=? AND NAME=?)";
        }
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            if (StringUtils.isBlank((String)resourceId)) {
                prepStmt.setInt(1, tenantId);
                prepStmt.setString(2, idPName);
            } else {
                prepStmt.setString(1, resourceId);
            }
            prepStmt.executeUpdate();
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIdpSpAuthAssociations(Connection conn, int tenantId, String idpName) throws SQLException {
        PreparedStatement removeAuthStepPreparedStatement = null;
        PreparedStatement removeEmptyAuthStepPreparedStatement = null;
        String removeAuthStepsSql = "DELETE FROM SP_FEDERATED_IDP WHERE AUTHENTICATOR_ID in (SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID=(SELECT ID FROM IDP WHERE NAME=? AND TENANT_ID=?))";
        String removeEmptyAuthStepsSql = "DELETE FROM SP_AUTH_STEP WHERE ID NOT IN (SELECT ID FROM SP_FEDERATED_IDP)";
        try {
            removeAuthStepPreparedStatement = conn.prepareStatement(removeAuthStepsSql);
            removeAuthStepPreparedStatement.setString(1, idpName);
            removeAuthStepPreparedStatement.setInt(2, tenantId);
            removeAuthStepPreparedStatement.executeUpdate();
            removeEmptyAuthStepPreparedStatement = conn.prepareStatement(removeEmptyAuthStepsSql);
            removeEmptyAuthStepPreparedStatement.executeUpdate();
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)removeAuthStepPreparedStatement);
            IdentityDatabaseUtil.closeStatement(removeEmptyAuthStepPreparedStatement);
            throw throwable;
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)removeAuthStepPreparedStatement);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)removeEmptyAuthStepPreparedStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIdpSpProvisioningAssociations(Connection conn, int tenantId, String idpName) throws SQLException {
        PreparedStatement prepStmt = null;
        String sqlStmt = "DELETE FROM SP_PROVISIONING_CONNECTOR WHERE IDP_NAME=? AND TENANT_ID=?";
        try {
            prepStmt = conn.prepareStatement(sqlStmt);
            prepStmt.setString(1, idpName);
            prepStmt.setInt(2, tenantId);
            prepStmt.executeUpdate();
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdentityProviderIdByName(Connection dbConnection, String idpName, int tenantId) throws SQLException, IdentityProviderManagementException {
        ResultSet rs;
        PreparedStatement prepStmt;
        boolean dbConnInitialized;
        block8: {
            int n;
            block10: {
                block9: {
                    dbConnInitialized = true;
                    prepStmt = null;
                    rs = null;
                    if (dbConnection == null) {
                        dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
                    } else {
                        dbConnInitialized = false;
                    }
                    try {
                        String sqlStmt = "SELECT ID FROM IDP WHERE ((TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND NAME = ?)";
                        prepStmt = dbConnection.prepareStatement(sqlStmt);
                        prepStmt.setInt(1, tenantId);
                        prepStmt.setInt(2, -1234);
                        prepStmt.setString(3, idpName);
                        rs = prepStmt.executeQuery();
                        if (!rs.next()) break block8;
                        n = rs.getInt(1);
                        if (!dbConnInitialized) break block9;
                    }
                    catch (Throwable throwable) {
                        if (dbConnInitialized) {
                            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                        } else {
                            IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                        }
                        throw throwable;
                    }
                    IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
                    break block10;
                }
                IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
            }
            return n;
        }
        if (dbConnInitialized) {
            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
        } else {
            IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        }
        return 0;
    }

    private Property[] concatArrays(Property[] o1, Property[] o2) {
        Property[] ret = new Property[o1.length + o2.length];
        System.arraycopy(o1, 0, ret, 0, o1.length);
        System.arraycopy(o2, 0, ret, o1.length, o2.length);
        return ret;
    }

    private int getIdentityProviderIdentifier(Connection dbConnection, String idPName, int tenantId) throws SQLException, IdentityProviderManagementException {
        block3: {
            int n;
            String sqlStmt = null;
            PreparedStatement prepStmt = null;
            ResultSet rs = null;
            try {
                sqlStmt = "SELECT ID, NAME, IS_PRIMARY, HOME_REALM_ID, CERTIFICATE, ALIAS, INBOUND_PROV_ENABLED, INBOUND_PROV_USER_STORE_ID, USER_CLAIM_URI, ROLE_CLAIM_URI,DEFAULT_AUTHENTICATOR_NAME,DEFAULT_PRO_CONNECTOR_NAME, DESCRIPTION, IS_FEDERATION_HUB, IS_LOCAL_CLAIM_DIALECT, PROVISIONING_ROLE, IS_ENABLED, DISPLAY_NAME, IMAGE_URL, UUID FROM IDP WHERE (TENANT_ID = ? OR (TENANT_ID = ? AND NAME LIKE 'SHARED_%')) AND NAME = ?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setInt(1, tenantId);
                prepStmt.setInt(2, -1234);
                prepStmt.setString(3, idPName);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt("ID");
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
            IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
            return n;
        }
        throw new IdentityProviderManagementException("Invalid Identity Provider Name " + idPName);
    }

    public boolean isIdPAvailableForAuthenticatorProperty(String authenticatorName, String propertyName, String idPEntityId, int tenantId) throws IdentityProviderManagementException {
        boolean isAvailable = false;
        Connection dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            String sqlStmt = "SELECT COUNT(prop.ID) FROM IDP_AUTHENTICATOR_PROPERTY prop INNER JOIN IDP_AUTHENTICATOR auth ON auth.ID = prop.AUTHENTICATOR_ID WHERE prop.PROPERTY_KEY=? AND prop.PROPERTY_VALUE=? AND prop.TENANT_ID=? AND auth.NAME = ?";
            prepStmt = dbConnection.prepareStatement(sqlStmt);
            prepStmt.setString(1, propertyName);
            prepStmt.setString(2, idPEntityId);
            prepStmt.setInt(3, tenantId);
            prepStmt.setString(4, authenticatorName);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                isAvailable = rs.getInt(1) > 0;
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityProviderManagementException("Error occurred while searching for similar IdP EntityIds", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return isAvailable;
    }

    public ConnectedAppsResult getConnectedApplications(String resourceId, int limit, int offset) throws IdentityProviderManagementException {
        ConnectedAppsResult connectedAppsResult = new ConnectedAppsResult();
        ArrayList<String> connectedApps = new ArrayList<String>();
        try (Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);){
            try (PreparedStatement prepStmt = this.createConnectedAppsSqlStatement(connection, resourceId, limit, offset);
                 ResultSet resultSet = prepStmt.executeQuery();){
                while (resultSet.next()) {
                    connectedApps.add(resultSet.getString("UUID"));
                }
            }
            String sqlQuery = "SELECT COUNT(1) FROM (SELECT UUID FROM (SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID=SP_FEDERATED_IDP.ID) INNER JOIN SP_APP ON SP_AUTH_STEP.APP_ID=SP_APP.ID WHERE AUTHENTICATOR_ID IN (SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = (SELECT ID FROM IDP WHERE UUID = ?)) UNION SELECT SP_APP.UUID FROM SP_PROVISIONING_CONNECTOR INNER JOIN SP_APP ON SP_PROVISIONING_CONNECTOR.APP_ID = SP_APP.ID INNER JOIN IDP ON IDP_NAME = IDP.NAME WHERE IDP.UUID = ?) APP";
            try (PreparedStatement prepStmt = connection.prepareStatement(sqlQuery);){
                prepStmt.setString(1, resourceId);
                prepStmt.setString(2, resourceId);
                try (ResultSet resultSet = prepStmt.executeQuery();){
                    if (resultSet.next()) {
                        connectedAppsResult.setTotalAppCount(resultSet.getInt(1));
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)("Error occurred during retrieving connected applications of IDP: " + resourceId), (Throwable)e);
            throw IdPManagementUtil.handleServerException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP_CONNECTED_APPS, resourceId);
        }
        connectedAppsResult.setApps(connectedApps);
        connectedAppsResult.setLimit(limit);
        connectedAppsResult.setOffSet(offset);
        return connectedAppsResult;
    }

    private PreparedStatement createConnectedAppsSqlStatement(Connection connection, String id, int limit, int offset) throws SQLException, IdentityProviderManagementServerException {
        PreparedStatement prepStmt;
        String databaseProductName = connection.getMetaData().getDatabaseProductName();
        if (databaseProductName.contains("MySQL") || databaseProductName.contains("MariaDB") || databaseProductName.contains("H2")) {
            String sqlQuery = "SELECT UUID FROM (SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID=SP_FEDERATED_IDP.ID) INNER JOIN SP_APP ON SP_AUTH_STEP.APP_ID=SP_APP.ID WHERE AUTHENTICATOR_ID IN (SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = (SELECT ID FROM IDP WHERE UUID = ?)) UNION SELECT SP_APP.UUID FROM SP_PROVISIONING_CONNECTOR INNER JOIN SP_APP ON SP_PROVISIONING_CONNECTOR.APP_ID = SP_APP.ID INNER JOIN IDP ON IDP_NAME = IDP.NAME WHERE IDP.UUID = ? LIMIT ?,?;";
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, id);
            prepStmt.setString(2, id);
            prepStmt.setInt(3, offset);
            prepStmt.setInt(4, limit);
        } else if (databaseProductName.contains("Oracle")) {
            String sqlQuery = "SELECT UUID FROM (SELECT UUID, ROWNUM AS RNUM FROM ( SELECT UUID FROM (SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID = SP_FEDERATED_IDP.ID) INNER JOIN SP_APP ON SP_AUTH_STEP.APP_ID = SP_APP.ID WHERE AUTHENTICATOR_ID IN ( SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = ( SELECT ID FROM IDP WHERE UUID = ?)) UNION SELECT SP_APP.UUID FROM SP_PROVISIONING_CONNECTOR INNER JOIN SP_APP ON SP_PROVISIONING_CONNECTOR.APP_ID = SP_APP.ID INNER JOIN IDP ON IDP_NAME = IDP.NAME WHERE IDP.UUID = ?) WHERE ROWNUM <= ?) WHERE RNUM > ?";
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, id);
            prepStmt.setString(2, id);
            prepStmt.setInt(3, offset + limit);
            prepStmt.setInt(4, offset);
        } else if (databaseProductName.contains("Microsoft")) {
            String sqlQuery = "(SELECT UUID, SP_APP.ID FROM SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID=SP_FEDERATED_IDP.ID INNER JOIN SP_APP ON SP_AUTH_STEP.APP_ID=SP_APP.ID WHERE AUTHENTICATOR_ID IN (SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = (SELECT ID FROM IDP WHERE UUID = ?))) UNION (SELECT SP_APP.UUID, SP_APP.ID FROM SP_PROVISIONING_CONNECTOR INNER JOIN SP_APP ON SP_PROVISIONING_CONNECTOR.APP_ID = SP_APP.ID INNER JOIN IDP ON IDP_NAME = IDP.NAME WHERE IDP.UUID = ?) ORDER BY SP_APP.ID OFFSET ? ROWS FETCH NEXT ? ROWS ONLY";
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, id);
            prepStmt.setString(2, id);
            prepStmt.setInt(3, offset);
            prepStmt.setInt(4, limit);
        } else if (databaseProductName.contains("PostgreSQL")) {
            String sqlQuery = "SELECT UUID FROM (SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID=SP_FEDERATED_IDP.ID) INNER JOIN SP_APP ON SP_AUTH_STEP.APP_ID=SP_APP.ID WHERE AUTHENTICATOR_ID IN (SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = (SELECT ID FROM IDP WHERE UUID = ?)) UNION SELECT SP_APP.UUID FROM SP_PROVISIONING_CONNECTOR INNER JOIN SP_APP ON SP_PROVISIONING_CONNECTOR.APP_ID = SP_APP.ID INNER JOIN IDP ON IDP_NAME = IDP.NAME WHERE IDP.UUID = ? LIMIT ? OFFSET ?";
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, id);
            prepStmt.setString(2, id);
            prepStmt.setInt(3, limit);
            prepStmt.setInt(4, offset);
        } else if (databaseProductName.contains("DB2")) {
            String sqlQuery = "SELECT UUID FROM (SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID=SP_FEDERATED_IDP.ID) INNER JOIN SP_APP ON SP_AUTH_STEP.APP_ID=SP_APP.ID WHERE AUTHENTICATOR_ID IN (SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = (SELECT ID FROM IDP WHERE UUID = ?)) UNION SELECT SP_APP.UUID FROM SP_PROVISIONING_CONNECTOR INNER JOIN SP_APP ON SP_PROVISIONING_CONNECTOR.APP_ID = SP_APP.ID INNER JOIN IDP ON IDP_NAME = IDP.NAME WHERE IDP.UUID = ? LIMIT ? OFFSET ?";
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setString(1, id);
            prepStmt.setString(2, id);
            prepStmt.setInt(3, limit);
            prepStmt.setInt(4, offset);
        } else if (databaseProductName.contains("INFORMIX")) {
            String sqlQuery = "SELECT SKIP ? FIRST ? UUID FROM (SP_AUTH_STEP INNER JOIN SP_FEDERATED_IDP ON SP_AUTH_STEP.ID=SP_FEDERATED_IDP.ID) INNER JOIN SP_APP ON SP_AUTH_STEP.APP_ID=SP_APP.ID WHERE AUTHENTICATOR_ID IN (SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = (SELECT ID FROM IDP WHERE UUID = ?))";
            prepStmt = connection.prepareStatement(sqlQuery);
            prepStmt.setInt(1, offset);
            prepStmt.setInt(2, limit);
            prepStmt.setString(3, id);
        } else {
            String message = "Error while loading Identity Provider Connected Applications from DB: Database driver could not be identified or not supported.";
            log.error((Object)message);
            throw IdPManagementUtil.handleServerException(IdPManagementConstants.ErrorMessage.ERROR_CODE_CONNECTING_DATABASE, message);
        }
        return prepStmt;
    }

    private int getAuthenticatorIdentifier(Connection dbConnection, int idPId, String authnType) throws SQLException, IdentityProviderManagementException {
        block3: {
            int n;
            String sqlStmt = null;
            PreparedStatement prepStmt = null;
            ResultSet rs = null;
            try {
                sqlStmt = "SELECT ID FROM IDP_AUTHENTICATOR WHERE IDP_ID = ? AND NAME = ?";
                prepStmt = dbConnection.prepareStatement(sqlStmt);
                prepStmt.setInt(1, idPId);
                prepStmt.setString(2, authnType);
                rs = prepStmt.executeQuery();
                if (!rs.next()) break block3;
                n = rs.getInt("ID");
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
            IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
            return n;
        }
        throw new IdentityProviderManagementException("Cannot find authenticator : " + authnType);
    }

    private List<IdentityProviderProperty> resolveConnectorProperties(List<IdentityProviderProperty> propertiesFromDb, String tenantDomain) throws ConnectorException {
        Map<String, IdentityProviderProperty> propertyMapFromDb = propertiesFromDb.stream().collect(Collectors.toMap(IdentityProviderProperty::getName, property -> property));
        Map<String, IdentityProviderProperty> propertiesFromConnectors = this.getConnectorProperties(tenantDomain);
        propertiesFromConnectors.putAll(propertyMapFromDb);
        return new ArrayList<IdentityProviderProperty>(propertiesFromConnectors.values());
    }

    private List<IdentityProviderProperty> filterConnectorProperties(IdentityProviderProperty[] propertiesFromRequest, String tenantDomain) throws ConnectorException {
        Map<String, IdentityProviderProperty> propertiesFromConnectors = this.getConnectorProperties(tenantDomain);
        Map<String, IdentityProviderProperty> propertyMapFromRequest = Arrays.stream(propertiesFromRequest).collect(Collectors.toMap(IdentityProviderProperty::getName, property -> property));
        for (Map.Entry<String, IdentityProviderProperty> entry : propertiesFromConnectors.entrySet()) {
            IdentityProviderProperty propertyFromRequest = propertyMapFromRequest.get(entry.getKey());
            if (propertyFromRequest == null || !entry.getValue().getValue().equals(propertyFromRequest.getValue())) continue;
            propertyMapFromRequest.remove(entry.getKey());
        }
        return new ArrayList<IdentityProviderProperty>(propertyMapFromRequest.values());
    }

    private Map<String, IdentityProviderProperty> getConnectorProperties(String tenantDomain) throws ConnectorException {
        List<ConnectorConfig> connectorConfigList = IdpMgtServiceComponentHolder.getInstance().getIdentityConnectorConfigList();
        HashMap<String, IdentityProviderProperty> propertiesFromConnectors = new HashMap<String, IdentityProviderProperty>();
        for (ConnectorConfig connectorConfig : connectorConfigList) {
            String[] propertyNames = connectorConfig.getPropertyNames();
            Properties defaultPropertyValues = connectorConfig.getDefaultPropertyValues(tenantDomain);
            Map displayNames = connectorConfig.getPropertyNameMapping();
            for (String property : propertyNames) {
                IdentityProviderProperty identityProviderProperty = new IdentityProviderProperty();
                identityProviderProperty.setName(property);
                identityProviderProperty.setValue(defaultPropertyValues.getProperty(property));
                identityProviderProperty.setDisplayName((String)displayNames.get(property));
                propertiesFromConnectors.put(property, identityProviderProperty);
            }
        }
        return propertiesFromConnectors;
    }

    public String getIdPNameByMetadataProperty(Connection dbConnection, String property, String value, int tenantId) throws IdentityProviderManagementException {
        String string;
        block10: {
            ResultSet rs;
            PreparedStatement prepStmt;
            block9: {
                prepStmt = null;
                rs = null;
                boolean dbConnectionInitialized = true;
                if (dbConnection == null) {
                    dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)false);
                } else {
                    dbConnectionInitialized = false;
                }
                try {
                    String sqlStmt = "SELECT IDP.NAME FROM IDP INNER JOIN IDP_METADATA ON IDP.ID = IDP_METADATA.IDP_ID WHERE IDP_METADATA.NAME = ? AND IDP_METADATA.VALUE = ? AND IDP_METADATA.TENANT_ID = ?";
                    prepStmt = dbConnection.prepareStatement(sqlStmt);
                    prepStmt.setString(1, property);
                    prepStmt.setString(2, value);
                    prepStmt.setInt(3, tenantId);
                    rs = prepStmt.executeQuery();
                    String idPName = null;
                    if (rs.next()) {
                        idPName = rs.getString(1);
                    }
                    string = idPName;
                    if (!dbConnectionInitialized) break block9;
                }
                catch (SQLException e) {
                    try {
                        throw new IdentityProviderManagementException("Error occurred while retrieving Identity Provider information for IDP metadata property name: " + property + " value: " + value, e);
                    }
                    catch (Throwable throwable) {
                        if (dbConnectionInitialized) {
                            IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, rs, (PreparedStatement)prepStmt);
                        } else {
                            IdentityDatabaseUtil.closeAllConnections(null, rs, (PreparedStatement)prepStmt);
                        }
                        throw throwable;
                    }
                }
                IdentityDatabaseUtil.closeAllConnections((Connection)dbConnection, (ResultSet)rs, (PreparedStatement)prepStmt);
                break block10;
            }
            IdentityDatabaseUtil.closeAllConnections(null, (ResultSet)rs, (PreparedStatement)prepStmt);
        }
        return string;
    }
}

