/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.dao;

import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.idp.mgt.internal.IdPManagementServiceComponent;

public class FileBasedIdPMgtDAO {
    public IdentityProvider getIdPByName(String idPName, String tenantDomain) {
        return IdPManagementServiceComponent.getFileBasedIdPs().get(idPName);
    }

    public IdentityProvider getIdPByAuthenticatorPropertyValue(String property, String value, String tenantDomain) {
        return this.getIdPByAuthenticatorPropertyValue(property, value, tenantDomain, "samlsso");
    }

    public IdentityProvider getIdPByAuthenticatorPropertyValue(String property, String value, String tenantDomain, String authenticatorName) {
        Map<String, IdentityProvider> identityProviders = IdPManagementServiceComponent.getFileBasedIdPs();
        for (Map.Entry<String, IdentityProvider> entry : identityProviders.entrySet()) {
            Property samlProperty;
            FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs = entry.getValue().getFederatedAuthenticatorConfigs();
            FederatedAuthenticatorConfig samlAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])federatedAuthenticatorConfigs, (String)authenticatorName);
            if (samlAuthenticatorConfig == null || (samlProperty = IdentityApplicationManagementUtil.getProperty((Property[])samlAuthenticatorConfig.getProperties(), (String)property)) == null || !value.equalsIgnoreCase(samlProperty.getValue())) continue;
            return entry.getValue();
        }
        return null;
    }

    public IdentityProvider getIdPByRealmId(String realmId, String tenantDomain) {
        Map<String, IdentityProvider> map = IdPManagementServiceComponent.getFileBasedIdPs();
        for (Map.Entry<String, IdentityProvider> entry : map.entrySet()) {
            if (entry.getValue().getHomeRealmId() == null || !entry.getValue().getHomeRealmId().equals(realmId)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getIdPNameByMetadataProperty(String property, String value) {
        Map<String, IdentityProvider> identityProviders = IdPManagementServiceComponent.getFileBasedIdPs();
        for (Map.Entry<String, IdentityProvider> entry : identityProviders.entrySet()) {
            Object[] identityProviderProperties = entry.getValue().getIdpProperties();
            if (ArrayUtils.isEmpty((Object[])identityProviderProperties)) continue;
            for (Object prop : identityProviderProperties) {
                if (prop == null || !property.equals(prop.getName()) || !value.equals(prop.getValue())) continue;
                return entry.getValue().getIdentityProviderName();
            }
        }
        return null;
    }
}

