/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt.dao;

import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.core.model.ExpressionNode;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementClientException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementServerException;
import org.wso2.carbon.idp.mgt.cache.IdPAuthPropertyCacheKey;
import org.wso2.carbon.idp.mgt.cache.IdPCacheByAuthProperty;
import org.wso2.carbon.idp.mgt.cache.IdPCacheByHRI;
import org.wso2.carbon.idp.mgt.cache.IdPCacheByMetadataProperty;
import org.wso2.carbon.idp.mgt.cache.IdPCacheByName;
import org.wso2.carbon.idp.mgt.cache.IdPCacheByResourceId;
import org.wso2.carbon.idp.mgt.cache.IdPCacheEntry;
import org.wso2.carbon.idp.mgt.cache.IdPHomeRealmIdCacheKey;
import org.wso2.carbon.idp.mgt.cache.IdPMetadataPropertyCacheKey;
import org.wso2.carbon.idp.mgt.cache.IdPNameCacheKey;
import org.wso2.carbon.idp.mgt.cache.IdPResourceIdCacheKey;
import org.wso2.carbon.idp.mgt.dao.IdPManagementDAO;
import org.wso2.carbon.idp.mgt.model.ConnectedAppsResult;
import org.wso2.carbon.idp.mgt.util.IdPManagementConstants;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;

public class CacheBackedIdPMgtDAO {
    private static final Log log = LogFactory.getLog(CacheBackedIdPMgtDAO.class);
    private IdPManagementDAO idPMgtDAO = null;
    private IdPCacheByName idPCacheByName = null;
    private IdPCacheByHRI idPCacheByHRI = null;
    private IdPCacheByAuthProperty idPCacheByAuthProperty = null;
    private IdPCacheByResourceId idPCacheByResourceId = null;
    private IdPCacheByMetadataProperty idPCacheByMetadataProperty = null;

    public CacheBackedIdPMgtDAO(IdPManagementDAO idPMgtDAO) {
        this.idPMgtDAO = idPMgtDAO;
        this.idPCacheByName = IdPCacheByName.getInstance();
        this.idPCacheByHRI = IdPCacheByHRI.getInstance();
        this.idPCacheByAuthProperty = IdPCacheByAuthProperty.getInstance();
        this.idPCacheByResourceId = IdPCacheByResourceId.getInstance();
        this.idPCacheByMetadataProperty = IdPCacheByMetadataProperty.getInstance();
    }

    public List<IdentityProvider> getIdPs(Connection dbConnection, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        return this.idPMgtDAO.getIdPs(dbConnection, tenantId, tenantDomain);
    }

    public List<IdentityProvider> getIdPsSearch(Connection dbConnection, int tenantId, String tenantDomain, String filter) throws IdentityProviderManagementException {
        return this.idPMgtDAO.getIdPsSearch(dbConnection, tenantId, tenantDomain, filter);
    }

    public List<IdentityProvider> getPaginatedIdPsSearch(int tenantId, List<ExpressionNode> expressionConditions, int limit, int offset, String sortOrder, String sortBy) throws IdentityProviderManagementServerException, IdentityProviderManagementClientException {
        return this.idPMgtDAO.getIdPsSearch(tenantId, expressionConditions, limit, offset, sortOrder, sortBy);
    }

    public List<IdentityProvider> getPaginatedIdPsSearch(int tenantId, List<ExpressionNode> expressionConditions, int limit, int offset, String sortOrder, String sortBy, List<String> requiredAttributes) throws IdentityProviderManagementServerException, IdentityProviderManagementClientException {
        return this.idPMgtDAO.getIdPsSearch(tenantId, expressionConditions, limit, offset, sortOrder, sortBy, requiredAttributes);
    }

    public int getTotalIdPCount(int tenantId, List<ExpressionNode> expressionConditions) throws IdentityProviderManagementServerException, IdentityProviderManagementClientException {
        return this.idPMgtDAO.getCountOfFilteredIdPs(tenantId, expressionConditions);
    }

    public IdentityProvider getIdPByName(Connection dbConnection, String idPName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdPNameCacheKey cacheKey = new IdPNameCacheKey(idPName, tenantDomain);
        IdPCacheEntry entry = (IdPCacheEntry)((Object)this.idPCacheByName.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            log.debug((Object)("Cache entry found for Identity Provider " + idPName));
            IdentityProvider identityProvider = entry.getIdentityProvider();
            IdPManagementUtil.removeRandomPasswords(identityProvider, false);
            return identityProvider;
        }
        log.debug((Object)("Cache entry not found for Identity Provider " + idPName + ". Fetching entry from DB"));
        IdentityProvider identityProvider = this.idPMgtDAO.getIdPByName(dbConnection, idPName, tenantId, tenantDomain);
        if (identityProvider != null) {
            log.debug((Object)("Entry fetched from DB for Identity Provider " + idPName + ". Updating cache"));
            this.idPCacheByName.addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            if (identityProvider.getHomeRealmId() != null) {
                IdPHomeRealmIdCacheKey homeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
                this.idPCacheByHRI.addToCache((Serializable)((Object)homeRealmIdCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            }
        } else {
            log.debug((Object)("Entry for Identity Provider " + idPName + " not found in cache or DB"));
        }
        return identityProvider;
    }

    public IdentityProvider getIdPById(Connection dbConnection, int id, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider = this.idPMgtDAO.getIDPbyId(dbConnection, id, tenantId, tenantDomain);
        if (identityProvider != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry fetched from DB for Identity Provider " + identityProvider.getIdentityProviderName() + ". Updating cache"));
            }
            IdPNameCacheKey cacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            if (identityProvider.getHomeRealmId() != null) {
                IdPHomeRealmIdCacheKey homeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
                this.idPCacheByHRI.addToCache((Serializable)((Object)homeRealmIdCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("No IDP found with ID: %d either in cache or DB", id));
        }
        return identityProvider;
    }

    public IdentityProvider getIdPByResourceId(String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider;
        IdPResourceIdCacheKey cacheKey = new IdPResourceIdCacheKey(resourceId);
        IdPCacheEntry entry = (IdPCacheEntry)((Object)this.idPCacheByResourceId.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache entry found for Identity Provider with resource ID:" + resourceId));
            }
            IdentityProvider identityProvider2 = entry.getIdentityProvider();
            IdPManagementUtil.removeRandomPasswords(identityProvider2, false);
            return identityProvider2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache entry not found for Identity Provider with resource ID: " + resourceId + ". Fetching entry from DB"));
        }
        if ((identityProvider = this.idPMgtDAO.getIDPbyResourceId(null, resourceId, tenantId, tenantDomain)) != null) {
            this.addIdPCache(identityProvider, tenantDomain);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("No IDP found with resource ID: %s either in cache or DB", resourceId));
        }
        return identityProvider;
    }

    public IdentityProvider getIdPByAuthenticatorPropertyValue(Connection dbConnection, String property, String value, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdPAuthPropertyCacheKey cacheKey = new IdPAuthPropertyCacheKey(property, value, tenantDomain);
        IdPCacheEntry entry = (IdPCacheEntry)((Object)this.idPCacheByAuthProperty.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            log.debug((Object)("Cache entry found for Identity Provider with authenticator property " + property + " and with value " + value));
            IdentityProvider identityProvider = entry.getIdentityProvider();
            return identityProvider;
        }
        log.debug((Object)("Cache entry not found for Identity Provider with authenticator property " + property + " and with value " + value + ". Fetching entry from DB"));
        IdentityProvider identityProvider = this.idPMgtDAO.getIdPByAuthenticatorPropertyValue(dbConnection, property, value, tenantId, tenantDomain);
        if (identityProvider != null) {
            log.debug((Object)("Entry fetched from DB for Identity Provider with authenticator property " + property + " and with value " + value + ". Updating cache"));
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.addToCache((Serializable)((Object)idPNameCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            if (identityProvider.getHomeRealmId() != null) {
                IdPHomeRealmIdCacheKey homeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
                this.idPCacheByHRI.addToCache((Serializable)((Object)homeRealmIdCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            }
        } else {
            log.debug((Object)("Entry for Identity Provider with authenticator property " + property + " and with value " + value + " not found in cache or DB"));
        }
        return identityProvider;
    }

    public IdentityProvider getIdPByAuthenticatorPropertyValue(Connection dbConnection, String property, String value, String authenticator, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdPAuthPropertyCacheKey cacheKey = new IdPAuthPropertyCacheKey(property, value, tenantDomain);
        IdPCacheEntry entry = (IdPCacheEntry)((Object)this.idPCacheByAuthProperty.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            log.debug((Object)("Cache entry found for Identity Provider with authenticator property " + property + " and with value " + value));
            IdentityProvider identityProvider = entry.getIdentityProvider();
            return identityProvider;
        }
        log.debug((Object)("Cache entry not found for Identity Provider with authenticator property " + property + " and with value " + value + ". Fetching entry from DB"));
        IdentityProvider identityProvider = this.idPMgtDAO.getIdPByAuthenticatorPropertyValue(dbConnection, property, value, authenticator, tenantId, tenantDomain);
        if (identityProvider != null) {
            log.debug((Object)("Entry fetched from DB for Identity Provider with authenticator property " + property + " and with value " + value + ". Updating cache"));
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.addToCache((Serializable)((Object)idPNameCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            if (identityProvider.getHomeRealmId() != null) {
                IdPHomeRealmIdCacheKey homeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
                this.idPCacheByHRI.addToCache((Serializable)((Object)homeRealmIdCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            }
        } else {
            log.debug((Object)("Entry for Identity Provider with authenticator property " + property + " and with value " + value + " not found in cache or DB"));
        }
        return identityProvider;
    }

    public IdentityProvider getIdPByRealmId(String realmId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdPHomeRealmIdCacheKey cacheKey = new IdPHomeRealmIdCacheKey(realmId, tenantDomain);
        IdPCacheEntry entry = (IdPCacheEntry)((Object)this.idPCacheByHRI.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            log.debug((Object)("Cache entry found for Identity Provider with Home Realm ID " + realmId));
            return entry.getIdentityProvider();
        }
        log.debug((Object)("Cache entry not found for Identity Provider with Home Realm ID " + realmId + ". Fetching entry from DB"));
        IdentityProvider identityProvider = this.idPMgtDAO.getIdPByRealmId(realmId, tenantId, tenantDomain);
        if (identityProvider != null) {
            log.debug((Object)("Entry fetched from DB for Identity Provider with Home Realm ID " + realmId + ". Updating cache"));
            this.idPCacheByHRI.addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.addToCache((Serializable)((Object)idPNameCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
        } else {
            log.debug((Object)("Entry for Identity Provider with Home Realm ID " + realmId + " not found in cache or DB"));
        }
        return identityProvider;
    }

    public String addIdP(IdentityProvider identityProvider, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        return this.idPMgtDAO.addIdPWithResourceId(identityProvider, tenantId);
    }

    public void updateIdP(IdentityProvider newIdentityProvider, IdentityProvider currentIdentityProvider, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing entry for Identity Provider " + currentIdentityProvider.getIdentityProviderName() + " from cache"));
        }
        this.clearIdpCache(currentIdentityProvider.getIdentityProviderName(), currentIdentityProvider.getResourceId(), tenantId, tenantDomain);
        this.idPMgtDAO.updateIdPWithResourceId(currentIdentityProvider.getResourceId(), newIdentityProvider, currentIdentityProvider, tenantId);
    }

    public void deleteIdP(String idPName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        if (this.idPMgtDAO.isIdpReferredBySP(idPName, tenantId)) {
            throw new IdentityProviderManagementException("Identity Provider '" + idPName + "' cannot be deleted as it is referred by Service Providers.");
        }
        IdentityProvider identityProvider = this.getIdPByName(null, idPName, tenantId, tenantDomain);
        if (identityProvider != null) {
            this.idPMgtDAO.deleteIdP(idPName, tenantId, tenantDomain);
            this.clearIdpCache(idPName, tenantId, tenantDomain);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("IDP:%s of tenantDomain:%s is not found is cache or DB", idPName, tenantDomain));
        }
    }

    public void deleteIdPs(int tenantId) throws IdentityProviderManagementException {
        this.idPMgtDAO.deleteIdPs(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("All Identity Providers of tenant:%d are deleted", tenantId));
        }
    }

    public void deleteIdPByResourceId(String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider = this.getIdPByResourceId(resourceId, tenantId, tenantDomain);
        if (identityProvider != null) {
            String idPName = identityProvider.getIdentityProviderName();
            if (this.idPMgtDAO.isIdpReferredBySP(idPName, tenantId)) {
                String data = "Identity Provider '" + idPName + "' cannot be deleted as it is referred by Service Providers.";
                throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_DELETE_IDP, data);
            }
            this.idPMgtDAO.deleteIdPByResourceId(resourceId, tenantId, tenantDomain);
            this.clearIdpCache(idPName, resourceId, tenantId, tenantDomain);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("IDP with resource ID: %s of tenantDomain:%s is not found is cache or DB", resourceId, tenantDomain));
        }
    }

    public void forceDeleteIdP(String idPName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Force deleting IDP:%s of tenantDomain:%s started.", idPName, tenantDomain));
        }
        if ((identityProvider = this.getIdPByName(null, idPName, tenantId, tenantDomain)) != null) {
            this.idPMgtDAO.forceDeleteIdP(idPName, tenantId, tenantDomain);
            this.clearIdpCache(idPName, tenantId, tenantDomain);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("IDP:%s of tenantDomain:%s is not found is cache or DB", idPName, tenantDomain));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Force deleting IDP:%s of tenantDomain:%s completed.", idPName, tenantDomain));
        }
    }

    public void forceDeleteIdPByResourceId(String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Force deleting IDP with resource ID:%s of tenantDomain:%s started.", resourceId, tenantDomain));
        }
        if ((identityProvider = this.getIdPByResourceId(resourceId, tenantId, tenantDomain)) != null) {
            this.idPMgtDAO.forceDeleteIdPByResourceId(resourceId, tenantId, tenantDomain);
            this.clearIdpCache(identityProvider.getIdentityProviderName(), resourceId, tenantId, tenantDomain);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("IDP with resource ID:%s of tenantDomain:%s is not found is cache or DB", resourceId, tenantDomain));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Force deleting IDP with resource ID:%s of tenantDomain:%s completed.", resourceId, tenantDomain));
        }
    }

    public void addIdPCache(IdentityProvider identityProvider, String tenantDomain) {
        if (identityProvider != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding new entry for Identity Provider: '" + identityProvider.getIdentityProviderName() + "' to cache."));
            }
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.addToCache((Serializable)((Object)idPNameCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            if (identityProvider.getHomeRealmId() != null) {
                IdPHomeRealmIdCacheKey idPHomeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
                this.idPCacheByHRI.addToCache((Serializable)((Object)idPHomeRealmIdCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
            }
            IdPResourceIdCacheKey idPResourceIdCacheKey = new IdPResourceIdCacheKey(identityProvider.getResourceId());
            this.idPCacheByResourceId.addToCache((Serializable)((Object)idPResourceIdCacheKey), (Serializable)((Object)new IdPCacheEntry(identityProvider)));
        }
    }

    public void clearIdpCache(String idPName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        this.clearIdpCache(idPName, null, tenantId, tenantDomain);
    }

    public void clearIdpCache(String idPName, String resourceId, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider identityProvider = StringUtils.isNotBlank((String)resourceId) ? this.getIdPByResourceId(resourceId, tenantId, tenantDomain) : this.getIdPByName(null, idPName, tenantId, tenantDomain);
        if (identityProvider != null) {
            String idPIssuerName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing entry for Identity Provider " + idPName + " of tenantDomain:" + tenantDomain + " from cache."));
            }
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(idPName, tenantDomain);
            this.idPCacheByName.clearCacheEntry((Serializable)((Object)idPNameCacheKey));
            if (identityProvider.getHomeRealmId() != null) {
                IdPHomeRealmIdCacheKey idPHomeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
                this.idPCacheByHRI.clearCacheEntry((Serializable)((Object)idPHomeRealmIdCacheKey));
            }
            if (StringUtils.isNotBlank((String)resourceId)) {
                IdPResourceIdCacheKey idPResourceIdCacheKey = new IdPResourceIdCacheKey(resourceId);
                this.idPCacheByResourceId.clearCacheEntry((Serializable)((Object)idPResourceIdCacheKey));
            }
            if (StringUtils.isNotBlank((String)(idPIssuerName = this.getIDPIssuerName(identityProvider)))) {
                IdPMetadataPropertyCacheKey cacheKey = new IdPMetadataPropertyCacheKey("idpIssuerName", idPIssuerName, tenantDomain);
                this.idPCacheByMetadataProperty.clearCacheEntry((Serializable)((Object)cacheKey));
            }
        } else {
            log.debug((Object)("Entry for Identity Provider " + idPName + " not found in cache or DB"));
        }
    }

    public void deleteTenantRole(int tenantId, String role, String tenantDomain) throws IdentityProviderManagementException {
        log.debug((Object)("Removing all cached Identity Provider entries for tenant Domain " + tenantDomain));
        List<IdentityProvider> identityProviders = this.getIdPs(null, tenantId, tenantDomain);
        for (IdentityProvider identityProvider : identityProviders) {
            identityProvider = this.getIdPByName(null, identityProvider.getIdentityProviderName(), tenantId, tenantDomain);
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.clearCacheEntry((Serializable)((Object)idPNameCacheKey));
            if (identityProvider.getHomeRealmId() == null) continue;
            IdPHomeRealmIdCacheKey idPHomeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
            this.idPCacheByHRI.clearCacheEntry((Serializable)((Object)idPHomeRealmIdCacheKey));
        }
        this.idPMgtDAO.deleteTenantRole(tenantId, role, tenantDomain);
    }

    public void renameTenantRole(String newRoleName, String oldRoleName, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        log.debug((Object)("Removing all cached Identity Provider entries for tenant Domain " + tenantDomain));
        List<IdentityProvider> identityProviders = this.getIdPs(null, tenantId, tenantDomain);
        for (IdentityProvider identityProvider : identityProviders) {
            identityProvider = this.getIdPByName(null, identityProvider.getIdentityProviderName(), tenantId, tenantDomain);
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.clearCacheEntry((Serializable)((Object)idPNameCacheKey));
            if (identityProvider.getHomeRealmId() == null) continue;
            IdPHomeRealmIdCacheKey idPHomeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
            this.idPCacheByHRI.clearCacheEntry((Serializable)((Object)idPHomeRealmIdCacheKey));
        }
        this.idPMgtDAO.renameTenantRole(newRoleName, oldRoleName, tenantId, tenantDomain);
    }

    public void deleteTenantClaimURI(int tenantId, String claimURI, String tenantDomain) throws IdentityProviderManagementException {
        log.debug((Object)("Removing all cached Identity Provider entries for tenant Domain " + tenantDomain));
        List<IdentityProvider> identityProviders = this.getIdPs(null, tenantId, tenantDomain);
        for (IdentityProvider identityProvider : identityProviders) {
            identityProvider = this.getIdPByName(null, identityProvider.getIdentityProviderName(), tenantId, tenantDomain);
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.clearCacheEntry((Serializable)((Object)idPNameCacheKey));
            if (identityProvider.getHomeRealmId() == null) continue;
            IdPHomeRealmIdCacheKey idPHomeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
            this.idPCacheByHRI.clearCacheEntry((Serializable)((Object)idPHomeRealmIdCacheKey));
        }
        this.idPMgtDAO.deleteTenantRole(tenantId, claimURI, tenantDomain);
    }

    public void renameTenantClaimURI(String newClaimURI, String oldClaimURI, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        log.debug((Object)("Removing all cached Identity Provider entries for tenant Domain " + tenantDomain));
        List<IdentityProvider> identityProviders = this.getIdPs(null, tenantId, tenantDomain);
        for (IdentityProvider identityProvider : identityProviders) {
            identityProvider = this.getIdPByName(null, identityProvider.getIdentityProviderName(), tenantId, tenantDomain);
            IdPNameCacheKey idPNameCacheKey = new IdPNameCacheKey(identityProvider.getIdentityProviderName(), tenantDomain);
            this.idPCacheByName.clearCacheEntry((Serializable)((Object)idPNameCacheKey));
            if (identityProvider.getHomeRealmId() == null) continue;
            IdPHomeRealmIdCacheKey idPHomeRealmIdCacheKey = new IdPHomeRealmIdCacheKey(identityProvider.getHomeRealmId(), tenantDomain);
            this.idPCacheByHRI.clearCacheEntry((Serializable)((Object)idPHomeRealmIdCacheKey));
        }
        this.idPMgtDAO.renameTenantRole(newClaimURI, oldClaimURI, tenantId, tenantDomain);
    }

    public boolean isIdPAvailableForAuthenticatorProperty(String authenticatorName, String propertyName, String idPEntityId, int tenantId) throws IdentityProviderManagementException {
        return this.idPMgtDAO.isIdPAvailableForAuthenticatorProperty(authenticatorName, propertyName, idPEntityId, tenantId);
    }

    public ConnectedAppsResult getConnectedApplications(String resourceId, int limit, int offset) throws IdentityProviderManagementException {
        return this.idPMgtDAO.getConnectedApplications(resourceId, limit, offset);
    }

    public String getIdPNameByMetadataProperty(Connection dbConnection, String property, String value, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        IdPMetadataPropertyCacheKey cacheKey = new IdPMetadataPropertyCacheKey(property, value, tenantDomain);
        String idPName = (String)((Object)this.idPCacheByMetadataProperty.getValueFromCache((Serializable)((Object)cacheKey)));
        if (idPName != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache entry IDP name: " + idPName + " found for IDP metadata property name: " + property + " value: " + value));
            }
            return idPName;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache entry not found for IDP metadata property name: " + property + " value: " + value + ". Fetching entry from DB"));
        }
        if ((idPName = this.idPMgtDAO.getIdPNameByMetadataProperty(dbConnection, property, value, tenantId)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("DB entry IDP name: " + idPName + " found for IDP metadata property name: " + property + " value: " + value));
            }
            this.idPCacheByMetadataProperty.addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)idPName));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("DB entry not found for IDP metadata property name: " + property + " value: " + value));
        }
        return idPName;
    }

    private String getIDPIssuerName(IdentityProvider identityProvider) {
        Object[] identityProviderProperties = identityProvider.getIdpProperties();
        if (!ArrayUtils.isEmpty((Object[])identityProviderProperties)) {
            for (Object prop : identityProviderProperties) {
                if (prop == null || !"idpIssuerName".equals(prop.getName())) continue;
                return prop.getValue();
            }
        }
        return null;
    }
}

