/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.common.ApplicationAuthenticatorService;
import org.wso2.carbon.identity.application.common.ProvisioningConnectorService;
import org.wso2.carbon.identity.application.common.model.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.IdentityProviderProperty;
import org.wso2.carbon.identity.application.common.model.LocalRole;
import org.wso2.carbon.identity.application.common.model.PermissionsAndRoleConfig;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.application.common.model.RoleMapping;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.model.ExpressionNode;
import org.wso2.carbon.identity.core.model.FilterTreeBuilder;
import org.wso2.carbon.identity.core.model.Node;
import org.wso2.carbon.identity.core.model.OperationNode;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.role.mgt.core.IdentityRoleManagementException;
import org.wso2.carbon.identity.role.mgt.core.RoleManagementService;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementClientException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementServerException;
import org.wso2.carbon.idp.mgt.IdentityProviderSAMLException;
import org.wso2.carbon.idp.mgt.IdpManager;
import org.wso2.carbon.idp.mgt.dao.CacheBackedIdPMgtDAO;
import org.wso2.carbon.idp.mgt.dao.FileBasedIdPMgtDAO;
import org.wso2.carbon.idp.mgt.dao.IdPManagementDAO;
import org.wso2.carbon.idp.mgt.internal.IdPManagementServiceComponent;
import org.wso2.carbon.idp.mgt.internal.IdpMgtServiceComponentHolder;
import org.wso2.carbon.idp.mgt.listener.IdentityProviderMgtListener;
import org.wso2.carbon.idp.mgt.model.ConnectedAppsResult;
import org.wso2.carbon.idp.mgt.model.IdpSearchResult;
import org.wso2.carbon.idp.mgt.util.IdPManagementConstants;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.idp.mgt.util.MetadataConverter;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;

public class IdentityProviderManager
implements IdpManager {
    private static final Log log = LogFactory.getLog(IdentityProviderManager.class);
    private static final String OPENID_IDP_ENTITY_ID = "IdPEntityId";
    private static CacheBackedIdPMgtDAO dao = new CacheBackedIdPMgtDAO(new IdPManagementDAO());
    private static volatile IdentityProviderManager instance = new IdentityProviderManager();

    private IdentityProviderManager() {
    }

    public static IdentityProviderManager getInstance() {
        return instance;
    }

    @Override
    public IdentityProvider getResidentIdP(String tenantDomain) throws IdentityProviderManagementException {
        IdPManagementUtil.setTenantSpecifiers(tenantDomain);
        String openIdUrl = IdentityUtil.getProperty((String)"OpenID.OpenIDServerUrl");
        String oauth1RequestTokenUrl = IdentityUtil.getProperty((String)"OAuth.OAuth1RequestTokenUrl");
        String oauth1AuthorizeUrl = IdentityUtil.getProperty((String)"OAuth.OAuth1AuthorizeUrl");
        String oauth1AccessTokenUrl = IdentityUtil.getProperty((String)"OAuth.OAuth1AccessTokenUrl");
        String oauth2AuthzEPUrl = IdentityUtil.getProperty((String)"OAuth.OAuth2AuthzEPUrl");
        String oauth2TokenEPUrl = IdentityUtil.getProperty((String)"OAuth.OAuth2TokenEPUrl");
        String oauth2UserInfoEPUrl = IdentityUtil.getProperty((String)"OAuth.OAuth2UserInfoEPUrl");
        String oidcCheckSessionEPUrl = IdentityUtil.getProperty((String)"OAuth.OIDCCheckSessionEPUrl");
        String oidcLogoutEPUrl = IdentityUtil.getProperty((String)"OAuth.OIDCLogoutEPUrl");
        String passiveStsUrl = IdentityUtil.getProperty((String)"PassiveSTS.IdentityProviderURL");
        String stsUrl = IdentityUtil.getProperty((String)"SecurityTokenService.IdentityProviderURL");
        String scimUsersEndpoint = IdentityUtil.getProperty((String)"SCIM.UserEPUrl");
        String scimGroupsEndpoint = IdentityUtil.getProperty((String)"SCIM.GroupEPUrl");
        String scim2UsersEndpoint = IdentityUtil.getProperty((String)"SCIM2.UserEPUrl");
        String scim2GroupsEndpoint = IdentityUtil.getProperty((String)"SCIM2.GroupEPUrl");
        String oauth2RevokeEPUrl = IdentityUtil.getProperty((String)"OAuth.OAuth2RevokeEPUrl");
        String oauth2IntrospectEpUrl = IdentityUtil.getProperty((String)"OAuth.OAuth2IntrospectEPUrl");
        String oIDCWebFingerEPUrl = IdentityUtil.getProperty((String)"OAuth.OIDCWebFingerEPUrl");
        String oAuth2DCREPUrl = IdentityUtil.getProperty((String)"OAuth.OAuth2DCREPUrl");
        String oAuth2JWKSPage = IdentityUtil.getProperty((String)"OAuth.OAuth2JWKSPage");
        String oIDCDiscoveryEPUrl = IdentityUtil.getProperty((String)"OAuth.OIDCDiscoveryEPUrl");
        if (StringUtils.isBlank((String)openIdUrl)) {
            openIdUrl = IdentityUtil.getServerURL((String)"openid", (boolean)true, (boolean)true);
        }
        if (StringUtils.isBlank((String)oauth1RequestTokenUrl)) {
            oauth1RequestTokenUrl = IdentityUtil.getServerURL((String)"oauth/request-token", (boolean)true, (boolean)true);
        }
        if (StringUtils.isBlank((String)oauth1AuthorizeUrl)) {
            oauth1AuthorizeUrl = IdentityUtil.getServerURL((String)"oauth/authorize-url", (boolean)true, (boolean)true);
        }
        if (StringUtils.isBlank((String)oauth1AccessTokenUrl)) {
            oauth1AccessTokenUrl = IdentityUtil.getServerURL((String)"oauth/access-token", (boolean)true, (boolean)true);
        }
        oauth2AuthzEPUrl = this.resolveAbsoluteURL("oauth2/authorize", oauth2AuthzEPUrl);
        oauth2TokenEPUrl = this.resolveAbsoluteURL("oauth2/token", oauth2TokenEPUrl);
        oauth2RevokeEPUrl = this.resolveAbsoluteURL("oauth2/revoke", oauth2RevokeEPUrl);
        oauth2IntrospectEpUrl = this.resolveAbsoluteURL("oauth2/introspect", oauth2IntrospectEpUrl);
        oauth2IntrospectEpUrl = this.addTenantPathParamInLegacyMode(oauth2IntrospectEpUrl, tenantDomain);
        oauth2UserInfoEPUrl = this.resolveAbsoluteURL("oauth2/userinfo", oauth2UserInfoEPUrl);
        oidcCheckSessionEPUrl = this.resolveAbsoluteURL("oidc/checksession", oidcCheckSessionEPUrl);
        oidcLogoutEPUrl = this.resolveAbsoluteURL("oidc/logout", oidcLogoutEPUrl);
        oAuth2DCREPUrl = this.resolveAbsoluteURL("api/identity/oauth2/dcr/v1.1/register", oAuth2DCREPUrl);
        oAuth2DCREPUrl = this.addTenantPathParamInLegacyMode(oAuth2DCREPUrl, tenantDomain);
        oAuth2JWKSPage = this.resolveAbsoluteURL("oauth2/jwks", oAuth2JWKSPage);
        oAuth2JWKSPage = this.addTenantPathParamInLegacyMode(oAuth2JWKSPage, tenantDomain);
        oIDCDiscoveryEPUrl = this.resolveAbsoluteURL("oauth2/oidcdiscovery", oIDCDiscoveryEPUrl);
        oIDCDiscoveryEPUrl = this.addTenantPathParamInLegacyMode(oIDCDiscoveryEPUrl, tenantDomain);
        passiveStsUrl = this.resolveAbsoluteURL("passivests", passiveStsUrl);
        stsUrl = StringUtils.isNotBlank((String)stsUrl) ? stsUrl.replace("wso2carbon-sts", IdPManagementUtil.getTenantContext() + "wso2carbon-sts") : IdentityUtil.getServerURL((String)("services/" + IdPManagementUtil.getTenantContext() + "wso2carbon-sts"), (boolean)true, (boolean)true);
        if (StringUtils.isBlank((String)scimUsersEndpoint)) {
            scimUsersEndpoint = IdentityUtil.getServerURL((String)"wso2/scim/Users", (boolean)true, (boolean)false);
        }
        if (StringUtils.isBlank((String)scimGroupsEndpoint)) {
            scimGroupsEndpoint = IdentityUtil.getServerURL((String)"wso2/scim/Groups", (boolean)true, (boolean)false);
        }
        if (StringUtils.isBlank((String)scim2UsersEndpoint)) {
            scim2UsersEndpoint = IdentityUtil.getServerURL((String)"scim2/Users", (boolean)true, (boolean)false);
        }
        try {
            if (StringUtils.isNotBlank((String)tenantDomain) && !"carbon.super".equals(tenantDomain)) {
                scim2UsersEndpoint = this.getTenantUrl(scim2UsersEndpoint, tenantDomain);
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"SCIM 2.0 Users endpoint is malformed");
        }
        if (StringUtils.isBlank((String)scim2GroupsEndpoint)) {
            scim2GroupsEndpoint = IdentityUtil.getServerURL((String)"scim2/Groups", (boolean)true, (boolean)false);
        }
        try {
            if (StringUtils.isNotBlank((String)tenantDomain) && !"carbon.super".equals(tenantDomain)) {
                scim2GroupsEndpoint = this.getTenantUrl(scim2GroupsEndpoint, tenantDomain);
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)"SCIM 2.0 Groups endpoint is malformed");
        }
        IdentityProvider identityProvider = dao.getIdPByName(null, "LOCAL", IdentityTenantUtil.getTenantId((String)tenantDomain), tenantDomain);
        if (identityProvider == null) {
            String message = "Could not find Resident Identity Provider for tenant " + tenantDomain;
            throw new IdentityProviderManagementException(message);
        }
        int tenantId = -1;
        try {
            tenantId = IdPManagementServiceComponent.getRealmService().getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            throw new IdentityProviderManagementException("Exception occurred while retrieving Tenant ID from Tenant Domain " + tenantDomain, e);
        }
        X509Certificate cert = null;
        try {
            IdentityTenantUtil.initializeRegistry((int)tenantId);
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain(tenantDomain, true);
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            if (!"carbon.super".equals(tenantDomain)) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                KeyStore keyStore = keyStoreManager.getKeyStore(jksName);
                cert = (X509Certificate)keyStore.getCertificate(tenantDomain);
            } else {
                cert = keyStoreManager.getDefaultPrimaryCertificate();
            }
        }
        catch (Exception e) {
            String msg = "Error retrieving primary certificate for tenant : " + tenantDomain;
            throw new IdentityProviderManagementException(msg, e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        if (cert == null) {
            throw new IdentityProviderManagementException("Cannot find the primary certificate for tenant " + tenantDomain);
        }
        try {
            identityProvider.setCertificate(Base64.encode((byte[])cert.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            String msg = "Error occurred while encoding primary certificate for tenant domain " + tenantDomain;
            throw new IdentityProviderManagementException(msg, e);
        }
        ArrayList<FederatedAuthenticatorConfig> fedAuthnCofigs = new ArrayList<FederatedAuthenticatorConfig>();
        ArrayList<Object> propertiesList = null;
        FederatedAuthenticatorConfig openIdFedAuthn = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"openid");
        if (openIdFedAuthn == null) {
            openIdFedAuthn = new FederatedAuthenticatorConfig();
            openIdFedAuthn.setName("openid");
        }
        propertiesList = new ArrayList<Property>(Arrays.asList(openIdFedAuthn.getProperties()));
        if (IdentityApplicationManagementUtil.getProperty((Property[])openIdFedAuthn.getProperties(), (String)"OpenIdUrl") == null) {
            Property openIdUrlProp = new Property();
            openIdUrlProp.setName("OpenIdUrl");
            openIdUrlProp.setValue(openIdUrl);
            propertiesList.add(openIdUrlProp);
        }
        openIdFedAuthn.setProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        fedAuthnCofigs.add(openIdFedAuthn);
        FederatedAuthenticatorConfig saml2SSOFedAuthn = this.buildSAMLProperties(identityProvider, tenantDomain);
        fedAuthnCofigs.add(saml2SSOFedAuthn);
        FederatedAuthenticatorConfig oauth1FedAuthn = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"oauth10a");
        if (oauth1FedAuthn == null) {
            oauth1FedAuthn = new FederatedAuthenticatorConfig();
            oauth1FedAuthn.setName("oauth10a");
        }
        propertiesList = new ArrayList<Property>(Arrays.asList(oauth1FedAuthn.getProperties()));
        if (IdentityApplicationManagementUtil.getProperty((Property[])oauth1FedAuthn.getProperties(), (String)"OAuth1RequestTokenUrl") == null) {
            Property oauth1ReqTokUrlProp = new Property();
            oauth1ReqTokUrlProp.setName("OAuth1RequestTokenUrl");
            oauth1ReqTokUrlProp.setValue(oauth1RequestTokenUrl);
            propertiesList.add(oauth1ReqTokUrlProp);
        }
        if (IdentityApplicationManagementUtil.getProperty((Property[])oauth1FedAuthn.getProperties(), (String)"OAuth1AuthorizeUrl") == null) {
            Property oauth1AuthzUrlProp = new Property();
            oauth1AuthzUrlProp.setName("OAuth1AuthorizeUrl");
            oauth1AuthzUrlProp.setValue(oauth1AuthorizeUrl);
            propertiesList.add(oauth1AuthzUrlProp);
        }
        if (IdentityApplicationManagementUtil.getProperty((Property[])oauth1FedAuthn.getProperties(), (String)"OAuth1AccessTokenUrl") == null) {
            Property oauth1AccessTokUrlProp = new Property();
            oauth1AccessTokUrlProp.setName("OAuth1AccessTokenUrl");
            oauth1AccessTokUrlProp.setValue(oauth1AccessTokenUrl);
            propertiesList.add(oauth1AccessTokUrlProp);
        }
        oauth1FedAuthn.setProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        fedAuthnCofigs.add(oauth1FedAuthn);
        FederatedAuthenticatorConfig oidcFedAuthn = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"openidconnect");
        if (oidcFedAuthn == null) {
            oidcFedAuthn = new FederatedAuthenticatorConfig();
            oidcFedAuthn.setName("openidconnect");
        }
        propertiesList = new ArrayList();
        Property idPEntityIdProp = this.resolveFedAuthnProperty(this.getOIDCResidentIdPEntityId(), oidcFedAuthn, OPENID_IDP_ENTITY_ID);
        propertiesList.add(idPEntityIdProp);
        Property authzUrlProp = this.resolveFedAuthnProperty(oauth2AuthzEPUrl, oidcFedAuthn, "OAuth2AuthzEPUrl");
        propertiesList.add(authzUrlProp);
        Property tokenUrlProp = this.resolveFedAuthnProperty(oauth2TokenEPUrl, oidcFedAuthn, "OAuth2TokenEPUrl");
        propertiesList.add(tokenUrlProp);
        Property revokeUrlProp = this.resolveFedAuthnProperty(oauth2RevokeEPUrl, oidcFedAuthn, "OAuth2RevokeEPUrl");
        propertiesList.add(revokeUrlProp);
        Property instropsectUrlProp = this.resolveFedAuthnProperty(oauth2IntrospectEpUrl, oidcFedAuthn, "OAuth2IntrospectEPUrl");
        propertiesList.add(instropsectUrlProp);
        Property userInfoUrlProp = this.resolveFedAuthnProperty(oauth2UserInfoEPUrl, oidcFedAuthn, "OAuth2UserInfoEPUrl");
        propertiesList.add(userInfoUrlProp);
        Property checkSessionUrlProp = this.resolveFedAuthnProperty(oidcCheckSessionEPUrl, oidcFedAuthn, "OIDCCheckSessionEPUrl");
        propertiesList.add(checkSessionUrlProp);
        Property logoutUrlProp = this.resolveFedAuthnProperty(oidcLogoutEPUrl, oidcFedAuthn, "OIDCLogoutEPUrl");
        propertiesList.add(logoutUrlProp);
        Property dcrUrlProp = this.resolveFedAuthnProperty(oAuth2DCREPUrl, oidcFedAuthn, "OAuth2DCREPUrl");
        propertiesList.add(dcrUrlProp);
        Property webFingerUrlProp = this.resolveFedAuthnProperty(oIDCWebFingerEPUrl, oidcFedAuthn, "OIDCWebFingerEPUrl");
        propertiesList.add(webFingerUrlProp);
        Property jwksUrlProp = this.resolveFedAuthnProperty(oAuth2JWKSPage, oidcFedAuthn, "OAuth2JWKSPage");
        propertiesList.add(jwksUrlProp);
        Property discoveryUrlProp = this.resolveFedAuthnProperty(oIDCDiscoveryEPUrl, oidcFedAuthn, "OIDCDiscoveryEPUrl");
        propertiesList.add(discoveryUrlProp);
        oidcFedAuthn.setProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        fedAuthnCofigs.add(oidcFedAuthn);
        FederatedAuthenticatorConfig passiveSTSFedAuthn = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"passivests");
        if (passiveSTSFedAuthn == null) {
            passiveSTSFedAuthn = new FederatedAuthenticatorConfig();
            passiveSTSFedAuthn.setName("passivests");
        }
        propertiesList = new ArrayList();
        Property passiveSTSUrlProperty = IdentityApplicationManagementUtil.getProperty((Property[])passiveSTSFedAuthn.getProperties(), (String)"IdentityProviderUrl");
        if (passiveSTSUrlProperty == null) {
            passiveSTSUrlProperty = new Property();
            passiveSTSUrlProperty.setName("IdentityProviderUrl");
        }
        passiveSTSUrlProperty.setValue(passiveStsUrl);
        propertiesList.add(passiveSTSUrlProperty);
        Property stsIdPEntityIdProperty = IdentityApplicationManagementUtil.getProperty((Property[])passiveSTSFedAuthn.getProperties(), (String)OPENID_IDP_ENTITY_ID);
        if (stsIdPEntityIdProperty == null) {
            stsIdPEntityIdProperty = new Property();
            stsIdPEntityIdProperty.setName(OPENID_IDP_ENTITY_ID);
            stsIdPEntityIdProperty.setValue(IdPManagementUtil.getResidentIdPEntityId());
        }
        propertiesList.add(stsIdPEntityIdProperty);
        for (Property property : passiveSTSFedAuthn.getProperties()) {
            if (property == null || "IdentityProviderUrl".equals(property.getName()) || OPENID_IDP_ENTITY_ID.equals(property.getName())) continue;
            propertiesList.add(property);
        }
        passiveSTSFedAuthn.setProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        fedAuthnCofigs.add(passiveSTSFedAuthn);
        FederatedAuthenticatorConfig stsFedAuthn = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"wstrust");
        if (stsFedAuthn == null) {
            stsFedAuthn = new FederatedAuthenticatorConfig();
            stsFedAuthn.setName("wstrust");
        }
        propertiesList = new ArrayList<Property>(Arrays.asList(stsFedAuthn.getProperties()));
        if (IdentityApplicationManagementUtil.getProperty((Property[])stsFedAuthn.getProperties(), (String)"IDENTITY_PROVIDER_URL") == null) {
            Property stsUrlProp = new Property();
            stsUrlProp.setName("IDENTITY_PROVIDER_URL");
            stsUrlProp.setValue(stsUrl);
            propertiesList.add(stsUrlProp);
        }
        stsFedAuthn.setProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        fedAuthnCofigs.add(stsFedAuthn);
        ArrayList identityProviderProperties = new ArrayList();
        FederatedAuthenticatorConfig sessionTimeoutConfig = new FederatedAuthenticatorConfig();
        sessionTimeoutConfig.setName("IDPProperties");
        propertiesList = new ArrayList<Property>(Arrays.asList(sessionTimeoutConfig.getProperties()));
        Property cleanUpPeriodProp = new Property();
        cleanUpPeriodProp.setName("CleanUpPeriod");
        String cleanUpPeriod = IdentityUtil.getProperty((String)"JDBCPersistenceManager.SessionDataPersist.SessionDataCleanUp.CleanUpPeriod");
        if (StringUtils.isBlank((String)cleanUpPeriod)) {
            cleanUpPeriod = "1140";
        } else if (!StringUtils.isNumeric((String)cleanUpPeriod)) {
            log.warn((Object)"PersistanceCleanUpPeriod in identity.xml should be a numeric value");
            cleanUpPeriod = "1140";
        }
        cleanUpPeriodProp.setValue(cleanUpPeriod);
        propertiesList.add(cleanUpPeriodProp);
        sessionTimeoutConfig.setProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        fedAuthnCofigs.add(sessionTimeoutConfig);
        identityProvider.setFederatedAuthenticatorConfigs(fedAuthnCofigs.toArray(new FederatedAuthenticatorConfig[fedAuthnCofigs.size()]));
        ProvisioningConnectorConfig scimProvConn = IdentityApplicationManagementUtil.getProvisioningConnector((ProvisioningConnectorConfig[])identityProvider.getProvisioningConnectorConfigs(), (String)"scim");
        if (scimProvConn == null) {
            scimProvConn = new ProvisioningConnectorConfig();
            scimProvConn.setName("scim");
        }
        propertiesList = new ArrayList<Property>(Arrays.asList(scimProvConn.getProvisioningProperties()));
        Property scimUserEndpointProperty = IdentityApplicationManagementUtil.getProperty((Property[])scimProvConn.getProvisioningProperties(), (String)"scimUserEndpoint");
        if (scimUserEndpointProperty == null) {
            Property property = new Property();
            property.setName("scimUserEndpoint");
            property.setValue(scimUsersEndpoint);
            propertiesList.add(property);
        } else if (!scimUsersEndpoint.equalsIgnoreCase(scimUserEndpointProperty.getValue())) {
            scimUserEndpointProperty.setValue(scimUsersEndpoint);
        }
        Property scimGroupEndpointProperty = IdentityApplicationManagementUtil.getProperty((Property[])scimProvConn.getProvisioningProperties(), (String)"scimGroupEndpoint");
        if (scimGroupEndpointProperty == null) {
            Property property = new Property();
            property.setName("scimGroupEndpoint");
            property.setValue(scimGroupsEndpoint);
            propertiesList.add(property);
        } else if (!scimGroupsEndpoint.equalsIgnoreCase(scimGroupEndpointProperty.getValue())) {
            scimGroupEndpointProperty.setValue(scimGroupsEndpoint);
        }
        Property scim2UserEndpointProperty = IdentityApplicationManagementUtil.getProperty((Property[])scimProvConn.getProvisioningProperties(), (String)"scim2UserEndpoint");
        if (scim2UserEndpointProperty == null) {
            Property property = new Property();
            property.setName("scim2UserEndpoint");
            property.setValue(scim2UsersEndpoint);
            propertiesList.add(property);
        } else if (!scim2UsersEndpoint.equalsIgnoreCase(scim2UserEndpointProperty.getValue())) {
            scim2UserEndpointProperty.setValue(scim2UsersEndpoint);
        }
        Property scim2GroupEndpointProperty = IdentityApplicationManagementUtil.getProperty((Property[])scimProvConn.getProvisioningProperties(), (String)"scim2GroupEndpoint");
        if (scim2GroupEndpointProperty == null) {
            Property property = new Property();
            property.setName("scim2GroupEndpoint");
            property.setValue(scim2GroupsEndpoint);
            propertiesList.add(property);
        } else if (!scim2GroupsEndpoint.equalsIgnoreCase(scim2GroupEndpointProperty.getValue())) {
            scim2GroupEndpointProperty.setValue(scim2GroupsEndpoint);
        }
        scimProvConn.setProvisioningProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        identityProvider.setProvisioningConnectorConfigs(new ProvisioningConnectorConfig[]{scimProvConn});
        return identityProvider;
    }

    private String buildSAMLUrl(String urlFromConfigFile, String tenantDomain, String defaultContext, boolean appendTenantDomainInLegacyMode) throws IdentityProviderManagementException {
        String url = urlFromConfigFile;
        if (StringUtils.isBlank((String)url)) {
            try {
                url = ServiceURLBuilder.create().addPath(new String[]{defaultContext}).build().getAbsolutePublicURL();
            }
            catch (URLBuilderException ex) {
                throw new IdentityProviderManagementException("Error while building URL for context: " + defaultContext + " for tenantDomain: " + tenantDomain, ex);
            }
        }
        if (appendTenantDomainInLegacyMode && this.isNotSuperTenant(tenantDomain)) {
            HashMap<String, String[]> queryParams = new HashMap<String, String[]>();
            queryParams.put("tenantDomain", new String[]{tenantDomain});
            try {
                url = IdentityUtil.buildQueryUrl((String)url, queryParams);
            }
            catch (UnsupportedEncodingException e) {
                throw new IdentityProviderManagementException("Error while building URL for context: " + defaultContext + " for tenantDomain: " + tenantDomain, e);
            }
        }
        return this.resolveAbsoluteURL(defaultContext, url);
    }

    private boolean isNotSuperTenant(String tenantDomain) {
        return !StringUtils.equals((String)tenantDomain, (String)"carbon.super");
    }

    private FederatedAuthenticatorConfig buildSAMLProperties(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        String samlSSOUrl = this.buildSAMLUrl(IdentityUtil.getProperty((String)"SSOService.IdentityProviderURL"), tenantDomain, "samlsso", true);
        String samlLogoutUrl = this.buildSAMLUrl(IdentityUtil.getProperty((String)"SSOService.IdentityProviderURL"), tenantDomain, "samlsso", true);
        String samlECPUrl = this.buildSAMLUrl(IdentityUtil.getProperty((String)"SSOService.SAMLECPEndpoint"), tenantDomain, "samlecp", true);
        String samlArtifactUrl = this.buildSAMLUrl(IdentityUtil.getProperty((String)"SSOService.ArtifactResolutionEndpoint"), tenantDomain, "samlartresolve", false);
        FederatedAuthenticatorConfig samlFederatedAuthConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"samlsso");
        if (samlFederatedAuthConfig == null) {
            samlFederatedAuthConfig = new FederatedAuthenticatorConfig();
            samlFederatedAuthConfig.setName("samlsso");
        }
        ArrayList<Property> propertiesList = new ArrayList<Property>();
        Property samlSSOUrlProperty = this.resolveFedAuthnProperty(samlSSOUrl, samlFederatedAuthConfig, "SSOUrl");
        propertiesList.add(samlSSOUrlProperty);
        Property samlLogoutUrlProperty = this.resolveFedAuthnProperty(samlLogoutUrl, samlFederatedAuthConfig, "LogoutReqUrl");
        propertiesList.add(samlLogoutUrlProperty);
        Property samlECPUrlProperty = this.resolveFedAuthnProperty(samlECPUrl, samlFederatedAuthConfig, "ECPUrl");
        propertiesList.add(samlECPUrlProperty);
        Property samlArtifactUrlProperty = this.resolveFedAuthnProperty(samlArtifactUrl, samlFederatedAuthConfig, "ArtifactResolveUrl");
        propertiesList.add(samlArtifactUrlProperty);
        Property idPEntityIdProperty = IdentityApplicationManagementUtil.getProperty((Property[])samlFederatedAuthConfig.getProperties(), (String)OPENID_IDP_ENTITY_ID);
        if (idPEntityIdProperty == null) {
            idPEntityIdProperty = new Property();
            idPEntityIdProperty.setName(OPENID_IDP_ENTITY_ID);
            idPEntityIdProperty.setValue(IdPManagementUtil.getResidentIdPEntityId());
        }
        propertiesList.add(idPEntityIdProperty);
        if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            this.addSSOUrlAsDestinationUrl(samlFederatedAuthConfig, samlSSOUrl, propertiesList);
        }
        for (Property property : samlFederatedAuthConfig.getProperties()) {
            if (property == null || "SSOUrl".equals(property.getName()) || "LogoutReqUrl".equals(property.getName()) || "ECPUrl".equals(property.getName()) || OPENID_IDP_ENTITY_ID.equals(property.getName())) continue;
            propertiesList.add(property);
        }
        Property samlMetadataValidityPeriodProperty = IdentityApplicationManagementUtil.getProperty((Property[])samlFederatedAuthConfig.getProperties(), (String)"SAMLMetadataValidityPeriod");
        if (samlMetadataValidityPeriodProperty == null) {
            samlMetadataValidityPeriodProperty = new Property();
            samlMetadataValidityPeriodProperty.setName("SAMLMetadataValidityPeriod");
            samlMetadataValidityPeriodProperty.setValue("60");
        }
        propertiesList.add(samlMetadataValidityPeriodProperty);
        Property samlMetadataSigningEnabledProperty = IdentityApplicationManagementUtil.getProperty((Property[])samlFederatedAuthConfig.getProperties(), (String)"SAMLMetadataSigningEnabled");
        if (samlMetadataSigningEnabledProperty == null) {
            samlMetadataSigningEnabledProperty = new Property();
            samlMetadataSigningEnabledProperty.setName("SAMLMetadataSigningEnabled");
            samlMetadataSigningEnabledProperty.setValue("false");
        }
        propertiesList.add(samlMetadataSigningEnabledProperty);
        Property samlAuthnRequestSigningProperty = IdentityApplicationManagementUtil.getProperty((Property[])samlFederatedAuthConfig.getProperties(), (String)"samlAuthnRequestsSigningEnabled");
        if (samlAuthnRequestSigningProperty == null) {
            samlAuthnRequestSigningProperty = new Property();
            samlAuthnRequestSigningProperty.setName("samlAuthnRequestsSigningEnabled");
            samlAuthnRequestSigningProperty.setValue("false");
        }
        propertiesList.add(samlAuthnRequestSigningProperty);
        samlFederatedAuthConfig.setProperties(propertiesList.toArray(new Property[propertiesList.size()]));
        return samlFederatedAuthConfig;
    }

    private void addSSOUrlAsDestinationUrl(FederatedAuthenticatorConfig federatedAuthenticatorConfig, String ssoUrl, List<Property> propertiesList) {
        List destinationURLs = Arrays.stream(federatedAuthenticatorConfig.getProperties()).filter(property -> property.getName().startsWith("DestinationURI")).collect(Collectors.toList());
        boolean isSAMLSSOUrlNotPresentAsDestination = destinationURLs.stream().noneMatch(x -> StringUtils.equals((String)ssoUrl, (String)x.getValue()));
        if (isSAMLSSOUrlNotPresentAsDestination) {
            int propertyNameIndex = destinationURLs.size() + 1;
            Property destinationURLProperty = this.buildDestinationURLProperty(ssoUrl, propertyNameIndex);
            propertiesList.add(destinationURLProperty);
        }
    }

    private Property buildDestinationURLProperty(String destinationURL, int index) {
        Property destinationURLProperty = new Property();
        destinationURLProperty.setName("DestinationURI." + index);
        destinationURLProperty.setValue(destinationURL);
        return destinationURLProperty;
    }

    private Property resolveFedAuthnProperty(String epUrl, FederatedAuthenticatorConfig fedAuthnConfig, String propertyName) {
        Property property = IdentityApplicationManagementUtil.getProperty((Property[])fedAuthnConfig.getProperties(), (String)propertyName);
        if (property == null || IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
            property = new Property();
            property.setName(propertyName);
            property.setValue(epUrl);
        }
        return property;
    }

    @Override
    public void addResidentIdP(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        FederatedAuthenticatorConfig saml2SSOResidentAuthenticatorConfig;
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreAddResidentIdP(identityProvider, tenantDomain)) continue;
            return;
        }
        if (identityProvider.getFederatedAuthenticatorConfigs() == null) {
            identityProvider.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[0]);
        }
        if ((saml2SSOResidentAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (String)"samlsso")) == null) {
            saml2SSOResidentAuthenticatorConfig = new FederatedAuthenticatorConfig();
            saml2SSOResidentAuthenticatorConfig.setName("samlsso");
        }
        if (saml2SSOResidentAuthenticatorConfig.getProperties() == null) {
            saml2SSOResidentAuthenticatorConfig.setProperties(new Property[0]);
        }
        boolean idPEntityIdAvailable = false;
        for (Property property : saml2SSOResidentAuthenticatorConfig.getProperties()) {
            if (!OPENID_IDP_ENTITY_ID.equals(property.getName())) continue;
            idPEntityIdAvailable = true;
        }
        if (!idPEntityIdAvailable) {
            Property property = new Property();
            property.setName(OPENID_IDP_ENTITY_ID);
            property.setValue(IdPManagementUtil.getResidentIdPEntityId());
            if (saml2SSOResidentAuthenticatorConfig.getProperties().length > 0) {
                List<Property> properties = Arrays.asList(saml2SSOResidentAuthenticatorConfig.getProperties());
                properties.add(property);
                saml2SSOResidentAuthenticatorConfig.setProperties((Property[])properties.toArray());
            } else {
                saml2SSOResidentAuthenticatorConfig.setProperties(new Property[]{property});
            }
        }
        Property samlMetadataValidityPeriodProperty = new Property();
        String samlMetadataValidityPeriod = IdentityUtil.getProperty((String)"SSOService.SAMLMetadataValidityPeriod");
        if (StringUtils.isBlank((String)samlMetadataValidityPeriod)) {
            samlMetadataValidityPeriod = "60";
        } else if (!StringUtils.isNumeric((String)samlMetadataValidityPeriod) || Integer.parseInt(samlMetadataValidityPeriod) <= 0) {
            log.warn((Object)"SAMLMetadataValidityPeriod in identity.xml should be a numeric value hence defaulting to value: 60m");
            samlMetadataValidityPeriod = "60";
        }
        samlMetadataValidityPeriodProperty.setName("SAMLMetadataValidityPeriod");
        samlMetadataValidityPeriodProperty.setValue(samlMetadataValidityPeriod);
        Property samlMetadataSigningEnabledProperty = new Property();
        String samlMetadataSigningEnabled = IdentityUtil.getProperty((String)"SSOService.SAMLMetadataSigningEnabled");
        if (StringUtils.isBlank((String)samlMetadataSigningEnabled)) {
            log.warn((Object)"SAMLMetadataSigningEnabled in identity.xml should be a boolean value");
            samlMetadataSigningEnabled = "false";
        }
        samlMetadataSigningEnabledProperty.setName("SAMLMetadataSigningEnabled");
        samlMetadataSigningEnabledProperty.setValue(samlMetadataSigningEnabled);
        Property samlAuthnRequestSigningProperty = new Property();
        String samlAuthnRequestSigningEnabled = IdentityUtil.getProperty((String)"SSOService.SAML2AuthnRequestsSigningEnabled");
        if (StringUtils.isBlank((String)samlAuthnRequestSigningEnabled)) {
            log.warn((Object)"samlAuthnRequestSigningEnabled in identity.xml should be a boolean value");
            samlAuthnRequestSigningEnabled = "false";
        }
        samlAuthnRequestSigningProperty.setName("samlAuthnRequestsSigningEnabled");
        samlAuthnRequestSigningProperty.setValue(samlAuthnRequestSigningEnabled);
        ArrayList<Property> propertyList = new ArrayList<Property>(Arrays.asList(saml2SSOResidentAuthenticatorConfig.getProperties()));
        propertyList.add(samlMetadataValidityPeriodProperty);
        propertyList.add(samlMetadataSigningEnabledProperty);
        propertyList.add(samlAuthnRequestSigningProperty);
        Property[] properties = new Property[propertyList.size()];
        properties = propertyList.toArray(properties);
        saml2SSOResidentAuthenticatorConfig.setProperties(properties);
        Property oidcProperty = new Property();
        oidcProperty.setName(OPENID_IDP_ENTITY_ID);
        oidcProperty.setValue(this.getOIDCResidentIdPEntityId());
        FederatedAuthenticatorConfig oidcAuthenticationConfig = new FederatedAuthenticatorConfig();
        oidcAuthenticationConfig.setProperties(new Property[]{oidcProperty});
        oidcAuthenticationConfig.setName("openidconnect");
        Property passiveStsProperty = new Property();
        passiveStsProperty.setName(OPENID_IDP_ENTITY_ID);
        passiveStsProperty.setValue(IdPManagementUtil.getResidentIdPEntityId());
        FederatedAuthenticatorConfig passiveStsAuthenticationConfig = new FederatedAuthenticatorConfig();
        passiveStsAuthenticationConfig.setProperties(new Property[]{passiveStsProperty});
        passiveStsAuthenticationConfig.setName("passivests");
        FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs = new FederatedAuthenticatorConfig[]{saml2SSOResidentAuthenticatorConfig, passiveStsAuthenticationConfig, oidcAuthenticationConfig};
        identityProvider.setFederatedAuthenticatorConfigs(IdentityApplicationManagementUtil.concatArrays((FederatedAuthenticatorConfig[])identityProvider.getFederatedAuthenticatorConfigs(), (FederatedAuthenticatorConfig[])federatedAuthenticatorConfigs));
        IdentityProviderProperty[] idpProperties = new IdentityProviderProperty[2];
        IdentityProviderProperty rememberMeTimeoutProperty = new IdentityProviderProperty();
        String rememberMeTimeout = IdentityUtil.getProperty((String)"TimeConfig.RememberMeTimeout");
        if (StringUtils.isBlank((String)rememberMeTimeout) || !StringUtils.isNumeric((String)rememberMeTimeout) || Integer.parseInt(rememberMeTimeout) <= 0) {
            log.warn((Object)"RememberMeTimeout in identity.xml should be a numeric value");
            rememberMeTimeout = "20160";
        }
        rememberMeTimeoutProperty.setName("RememberMeTimeout");
        rememberMeTimeoutProperty.setValue(rememberMeTimeout);
        IdentityProviderProperty sessionIdletimeOutProperty = new IdentityProviderProperty();
        String idleTimeout = IdentityUtil.getProperty((String)"TimeConfig.SessionIdleTimeout");
        if (StringUtils.isBlank((String)idleTimeout) || !StringUtils.isNumeric((String)idleTimeout) || Integer.parseInt(idleTimeout) <= 0) {
            log.warn((Object)"SessionIdleTimeout in identity.xml should be a numeric value");
            idleTimeout = "15";
        }
        sessionIdletimeOutProperty.setName("SessionIdleTimeout");
        sessionIdletimeOutProperty.setValue(idleTimeout);
        idpProperties[0] = rememberMeTimeoutProperty;
        idpProperties[1] = sessionIdletimeOutProperty;
        identityProvider.setIdpProperties(idpProperties);
        dao.addIdP(identityProvider, IdentityTenantUtil.getTenantId((String)tenantDomain), tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostAddResidentIdP(identityProvider, tenantDomain)) continue;
            return;
        }
    }

    @Override
    public void updateResidentIdP(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider residentIdp = dao.getIdPByName(null, "LOCAL", IdentityTenantUtil.getTenantId((String)tenantDomain), tenantDomain);
        HashMap<String, String> configurationDetails = new HashMap<String, String>();
        for (IdentityProviderProperty identityProviderProperty : identityProvider.getIdpProperties()) {
            configurationDetails.put(identityProviderProperty.getName(), identityProviderProperty.getValue());
        }
        IdentityProviderProperty[] identityMgtProperties = residentIdp.getIdpProperties();
        ArrayList<IdentityProviderProperty> newProperties = new ArrayList<IdentityProviderProperty>();
        for (IdentityProviderProperty identityMgtProperty : identityMgtProperties) {
            IdentityProviderProperty prop = new IdentityProviderProperty();
            String key = identityMgtProperty.getName();
            prop.setName(key);
            if (configurationDetails.containsKey(key)) {
                prop.setValue((String)configurationDetails.get(key));
            } else {
                prop.setValue(identityMgtProperty.getValue());
            }
            newProperties.add(prop);
            configurationDetails.remove(key);
        }
        for (Map.Entry entry : configurationDetails.entrySet()) {
            IdentityProviderProperty prop = new IdentityProviderProperty();
            prop.setName((String)entry.getKey());
            prop.setValue((String)entry.getValue());
            newProperties.add(prop);
        }
        identityProvider.setIdpProperties(newProperties.toArray(new IdentityProviderProperty[newProperties.size()]));
        for (IdentityProviderProperty idpProp : identityProvider.getIdpProperties()) {
            if (StringUtils.equals((String)idpProp.getName(), (String)"SessionIdleTimeout")) {
                if (!StringUtils.isBlank((String)idpProp.getValue()) && StringUtils.isNumeric((String)idpProp.getValue()) && Integer.parseInt(idpProp.getValue().trim()) > 0) continue;
                throw new IdentityProviderManagementException("SessionIdleTimeout of ResidentIdP should be a numeric value greater than 0 ");
            }
            if (StringUtils.equals((String)idpProp.getName(), (String)"RememberMeTimeout")) {
                if (!StringUtils.isBlank((String)idpProp.getValue()) && StringUtils.isNumeric((String)idpProp.getValue()) && Integer.parseInt(idpProp.getValue().trim()) > 0) continue;
                throw new IdentityProviderManagementException("RememberMeTimeout of ResidentIdP should be a numeric value greater than 0 ");
            }
            if (StringUtils.equals((String)idpProp.getName(), (String)"SAMLMetadataValidityPeriod")) {
                if (!StringUtils.isBlank((String)idpProp.getValue()) && StringUtils.isNumeric((String)idpProp.getValue()) && Integer.parseInt(idpProp.getValue().trim()) > 0) continue;
                throw new IdentityProviderManagementException("SAMLMetadataValidityPeriod of ResidentIdP should be a numeric value greater than 0 ");
            }
            if (!StringUtils.equals((String)idpProp.getName(), (String)"SAMLMetadataSigningEnabled")) continue;
            if (StringUtils.isBlank((String)idpProp.getValue())) {
                throw new IdentityProviderManagementException("SAMLMetadataSigningEnabled of ResidentIdP should be a boolean value ");
            }
            if (!StringUtils.equals((String)idpProp.getName(), (String)"samlAuthnRequestsSigningEnabled") || !StringUtils.isBlank((String)idpProp.getValue())) continue;
            throw new IdentityProviderManagementException("samlAuthnRequestsSigningEnabled of ResidentIdP should be a boolean value ");
        }
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreUpdateResidentIdP(identityProvider, tenantDomain)) continue;
            return;
        }
        if (identityProvider.getFederatedAuthenticatorConfigs() == null) {
            identityProvider.setFederatedAuthenticatorConfigs(new FederatedAuthenticatorConfig[0]);
        }
        IdentityProvider identityProvider2 = IdentityProviderManager.getInstance().getIdPByName("LOCAL", tenantDomain, true);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        this.validateUpdateOfIdPEntityId(identityProvider2.getFederatedAuthenticatorConfigs(), identityProvider.getFederatedAuthenticatorConfigs(), tenantId, tenantDomain);
        dao.updateIdP(identityProvider, identityProvider2, tenantId, tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostUpdateResidentIdP(identityProvider, tenantDomain)) continue;
            return;
        }
    }

    @Override
    public List<IdentityProvider> getIdPs(String tenantDomain) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        return dao.getIdPs(null, tenantId, tenantDomain);
    }

    @Override
    public IdpSearchResult getIdPs(Integer limit, Integer offset, String filter, String sortOrder, String sortBy, String tenantDomain) throws IdentityProviderManagementException {
        return this.getIdPs(limit, offset, filter, sortOrder, sortBy, tenantDomain, new ArrayList<String>());
    }

    @Override
    public IdpSearchResult getIdPs(Integer limit, Integer offset, String filter, String sortOrder, String sortBy, String tenantDomain, List<String> requiredAttributes) throws IdentityProviderManagementException {
        IdpSearchResult result = new IdpSearchResult();
        List<ExpressionNode> expressionNodes = this.getExpressionNodes(filter);
        this.setParameters(limit, offset, sortOrder, sortBy, filter, result);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        result.setTotalIDPCount(dao.getTotalIdPCount(tenantId, expressionNodes));
        result.setIdpList(dao.getPaginatedIdPsSearch(tenantId, expressionNodes, result.getLimit(), result.getOffSet(), result.getSortOrder(), result.getSortBy(), requiredAttributes));
        return result;
    }

    @Override
    public int getTotalIdPCount(String filter, String tenantDomain) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        List<ExpressionNode> expressionNodes = this.getExpressionNodes(filter);
        return dao.getTotalIdPCount(tenantId, expressionNodes);
    }

    private List<ExpressionNode> getExpressionNodes(String filter) throws IdentityProviderManagementClientException {
        ArrayList<ExpressionNode> expressionNodes = new ArrayList<ExpressionNode>();
        try {
            if (StringUtils.isNotBlank((String)filter)) {
                FilterTreeBuilder filterTreeBuilder = new FilterTreeBuilder(filter);
                Node rootNode = filterTreeBuilder.buildTree();
                this.setExpressionNodeList(rootNode, expressionNodes);
            }
        }
        catch (IOException | IdentityException e) {
            String message = "Error occurred while validate filter, filter: " + filter;
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP, message, e);
        }
        return expressionNodes;
    }

    private void setExpressionNodeList(Node node, List<ExpressionNode> expression) throws IdentityProviderManagementClientException {
        if (node instanceof ExpressionNode) {
            if (StringUtils.isNotBlank((String)((ExpressionNode)node).getAttributeValue()) && ((ExpressionNode)node).getAttributeValue().contains("isEnabled")) {
                if ("true".contains(((ExpressionNode)node).getValue())) {
                    ((ExpressionNode)node).setValue("1");
                } else if ("false".contains(((ExpressionNode)node).getValue())) {
                    ((ExpressionNode)node).setValue("0");
                } else {
                    String message = "Invalid value: " + ((ExpressionNode)node).getValue() + "is passed for 'isEnabled' attribute in the filter. It should be 'true' or 'false'";
                    throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP, message);
                }
            }
            expression.add((ExpressionNode)node);
        } else if (node instanceof OperationNode) {
            this.setExpressionNodeList(node.getLeftNode(), expression);
            this.setExpressionNodeList(node.getRightNode(), expression);
        }
    }

    private void setParameters(Integer limit, Integer offset, String filter, String sortOrder, String sortBy, IdpSearchResult result) throws IdentityProviderManagementClientException {
        result.setLimit(this.validateLimit(limit));
        result.setOffSet(this.validateOffset(offset));
        result.setSortBy(this.validateSortBy(sortBy));
        result.setSortOrder(this.validateSortOrder(sortOrder));
        result.setFilter(filter);
    }

    private String validateSortBy(String sortBy) {
        if (StringUtils.isBlank((String)sortBy)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"sortBy attribute is empty. Therefore we set the default sortBy attribute. sortByID");
            }
            return "ID";
        }
        switch (sortBy) {
            case "name": {
                sortBy = "NAME";
                break;
            }
            case "homeRealmIdentifier": {
                sortBy = "HOME_REALM_ID";
                break;
            }
            default: {
                sortBy = "ID";
                if (!log.isDebugEnabled()) break;
                log.debug((Object)"sortBy attribute is incorrect. Therefore we set the default sortBy attribute. sortBy: ID");
            }
        }
        return sortBy;
    }

    private String validateSortOrder(String sortOrder) {
        if (StringUtils.isBlank((String)sortOrder)) {
            sortOrder = "ASC";
            if (log.isDebugEnabled()) {
                log.debug((Object)("sortOrder is empty. Therefore we set the default sortOrder value as ASC. SortOrder: " + sortOrder));
            }
        } else if (sortOrder.equals("DESC")) {
            sortOrder = "DESC";
        } else if (sortOrder.equals("ASC")) {
            sortOrder = "ASC";
        } else {
            sortOrder = "ASC";
            if (log.isDebugEnabled()) {
                log.debug((Object)("sortOrder is incorrect. Therefore we set the default sortOrder value as ASC. SortOrder: " + sortOrder));
            }
        }
        return sortOrder;
    }

    private int validateLimit(Integer limit) throws IdentityProviderManagementClientException {
        if (limit == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Given limit is null. Therefore we get the default limit from identity.xml.");
            }
            limit = IdentityUtil.getDefaultItemsPerPage();
        }
        if (limit < 0) {
            String message = "Given limit: " + limit + " is a negative value.";
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP, message);
        }
        int maximumItemsPerPage = IdentityUtil.getMaximumItemPerPage();
        if (limit > maximumItemsPerPage) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Given limit exceed the maximum limit. Therefore we get the default limit from identity.xml. limit: " + maximumItemsPerPage));
            }
            limit = maximumItemsPerPage;
        }
        return limit;
    }

    private int validateOffset(Integer offset) throws IdentityProviderManagementClientException {
        if (offset == null) {
            offset = 0;
        }
        if (offset < 0) {
            String message = "Invalid offset applied. Offset should not negative. offSet: " + offset;
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP, message);
        }
        return offset;
    }

    @Override
    public List<IdentityProvider> getIdPsSearch(String tenantDomain, String filter) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        return dao.getIdPsSearch(null, tenantId, tenantDomain, filter);
    }

    @Override
    public List<IdentityProvider> getEnabledIdPs(String tenantDomain) throws IdentityProviderManagementException {
        ArrayList<IdentityProvider> enabledIdentityProviders = new ArrayList<IdentityProvider>();
        List<IdentityProvider> identityProviers = this.getIdPs(tenantDomain);
        for (IdentityProvider idp : identityProviers) {
            if (!idp.isEnable()) continue;
            enabledIdentityProviders.add(idp);
        }
        return enabledIdentityProviders;
    }

    @Override
    public IdentityProvider getIdPByName(String idPName, String tenantDomain, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)idPName)) {
            String msg = "Invalid argument: Identity Provider Name value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByName(null, idPName, tenantId, tenantDomain);
        if (!ignoreFileBasedIdps) {
            if (identityProvider == null) {
                identityProvider = new FileBasedIdPMgtDAO().getIdPByName(idPName, tenantDomain);
            }
            if (identityProvider == null) {
                identityProvider = IdPManagementServiceComponent.getFileBasedIdPs().get("default");
            }
        }
        return identityProvider;
    }

    @Override
    public IdentityProvider getIdPById(String id, String tenantDomain, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        if (StringUtils.isEmpty((String)id)) {
            String msg = "Invalid argument: Identity Provider ID value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        IdentityProvider identityProvider = null;
        try {
            Integer intId = Integer.parseInt(id);
            identityProvider = dao.getIdPById(null, intId, tenantId, tenantDomain);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (!ignoreFileBasedIdps) {
            if (identityProvider == null) {
                identityProvider = new FileBasedIdPMgtDAO().getIdPByName(id, tenantDomain);
            }
            if (identityProvider == null) {
                identityProvider = IdPManagementServiceComponent.getFileBasedIdPs().get("default");
            }
        }
        return identityProvider;
    }

    @Override
    public IdentityProvider getIdPByResourceId(String resourceId, String tenantDomain, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        this.validateGetIdPInputValues(resourceId);
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        return dao.getIdPByResourceId(resourceId, tenantId, tenantDomain);
    }

    @Override
    public IdentityProvider getEnabledIdPByName(String idPName, String tenantDomain, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        IdentityProvider idp = this.getIdPByName(idPName, tenantDomain, ignoreFileBasedIdps);
        if (idp != null && idp.isEnable()) {
            return idp;
        }
        return null;
    }

    @Override
    public IdentityProvider getIdPByName(String idPName, String tenantDomain) throws IdentityProviderManagementException {
        return this.getIdPByName(idPName, tenantDomain, false);
    }

    @Override
    public IdentityProvider getIdPById(String id, String tenantDomain) throws IdentityProviderManagementException {
        return this.getIdPById(id, tenantDomain, false);
    }

    @Override
    public IdentityProvider getIdPByAuthenticatorPropertyValue(String property, String value, String tenantDomain, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)value)) {
            String msg = "Invalid argument: Authenticator property or property value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByAuthenticatorPropertyValue(null, property, value, tenantId, tenantDomain);
        if (identityProvider == null && !ignoreFileBasedIdps) {
            identityProvider = new FileBasedIdPMgtDAO().getIdPByAuthenticatorPropertyValue(property, value, tenantDomain);
        }
        return identityProvider;
    }

    public IdentityProvider getIdPByAuthenticatorPropertyValue(String property, String value, String tenantDomain, String authenticator, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)authenticator)) {
            String msg = "Invalid argument: Authenticator property, property value or authenticator name is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByAuthenticatorPropertyValue(null, property, value, authenticator, tenantId, tenantDomain);
        if (identityProvider == null && !ignoreFileBasedIdps) {
            identityProvider = new FileBasedIdPMgtDAO().getIdPByAuthenticatorPropertyValue(property, value, tenantDomain, authenticator);
        }
        return identityProvider;
    }

    @Override
    public IdentityProvider getEnabledIdPByName(String idPName, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider idp = this.getIdPByName(idPName, tenantDomain);
        if (idp != null && idp.isEnable()) {
            return idp;
        }
        return null;
    }

    @Override
    public IdentityProvider getIdPByRealmId(String realmId, String tenantDomain) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)realmId)) {
            String msg = "Invalid argument: Identity Provider Home Realm Identifier value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByRealmId(realmId, tenantId, tenantDomain);
        if (identityProvider == null) {
            identityProvider = new FileBasedIdPMgtDAO().getIdPByRealmId(realmId, tenantDomain);
        }
        return identityProvider;
    }

    @Override
    public IdentityProvider getEnabledIdPByRealmId(String realmId, String tenantDomain) throws IdentityProviderManagementException {
        IdentityProvider idp = this.getIdPByRealmId(realmId, tenantDomain);
        if (idp != null && idp.isEnable()) {
            return idp;
        }
        return null;
    }

    @Override
    public Set<ClaimMapping> getMappedLocalClaims(String idPName, String tenantDomain, List<String> idPClaimURIs) throws IdentityProviderManagementException {
        ClaimMapping[] claimMappings;
        ClaimConfig claimConfiguration;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)idPName)) {
            String msg = "Invalid argument: Identity Provider Name value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByName(null, idPName, tenantId, tenantDomain);
        if (identityProvider == null) {
            identityProvider = new FileBasedIdPMgtDAO().getIdPByName(idPName, tenantDomain);
        }
        if (identityProvider == null) {
            identityProvider = IdPManagementServiceComponent.getFileBasedIdPs().get("default");
        }
        if ((claimConfiguration = identityProvider.getClaimConfig()) != null && (claimMappings = claimConfiguration.getClaimMappings()) != null && claimMappings.length > 0 && idPClaimURIs != null) {
            HashSet<ClaimMapping> returnSet = new HashSet<ClaimMapping>();
            block0: for (String idpClaim : idPClaimURIs) {
                for (ClaimMapping claimMapping : claimMappings) {
                    if (!claimMapping.getRemoteClaim().getClaimUri().equals(idpClaim)) continue;
                    returnSet.add(claimMapping);
                    continue block0;
                }
            }
            return returnSet;
        }
        return new HashSet<ClaimMapping>();
    }

    @Override
    public Map<String, String> getMappedLocalClaimsMap(String idPName, String tenantDomain, List<String> idPClaimURIs) throws IdentityProviderManagementException {
        Set<ClaimMapping> claimMappings = this.getMappedLocalClaims(idPName, tenantDomain, idPClaimURIs);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (ClaimMapping claimMapping : claimMappings) {
            returnMap.put(claimMapping.getRemoteClaim().getClaimUri(), claimMapping.getLocalClaim().getClaimUri());
        }
        return returnMap;
    }

    @Override
    public Set<ClaimMapping> getMappedIdPClaims(String idPName, String tenantDomain, List<String> localClaimURIs) throws IdentityProviderManagementException {
        ClaimMapping[] claimMappings;
        ClaimConfig claimConfiguration;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)idPName)) {
            String msg = "Invalid argument: Identity Provider Name value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByName(null, idPName, tenantId, tenantDomain);
        if (identityProvider == null) {
            identityProvider = new FileBasedIdPMgtDAO().getIdPByName(idPName, tenantDomain);
        }
        if (identityProvider == null) {
            identityProvider = IdPManagementServiceComponent.getFileBasedIdPs().get("default");
        }
        if ((claimConfiguration = identityProvider.getClaimConfig()) != null && (claimMappings = claimConfiguration.getClaimMappings()) != null && claimMappings.length > 0 && localClaimURIs != null) {
            HashSet<ClaimMapping> returnSet = new HashSet<ClaimMapping>();
            block0: for (String localClaimURI : localClaimURIs) {
                for (ClaimMapping claimMapping : claimMappings) {
                    if (!claimMapping.getLocalClaim().getClaimUri().equals(localClaimURI)) continue;
                    returnSet.add(claimMapping);
                    continue block0;
                }
            }
            return returnSet;
        }
        return new HashSet<ClaimMapping>();
    }

    @Override
    public Map<String, String> getMappedIdPClaimsMap(String idPName, String tenantDomain, List<String> localClaimURIs) throws IdentityProviderManagementException {
        Set<ClaimMapping> claimMappings = this.getMappedIdPClaims(idPName, tenantDomain, localClaimURIs);
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (ClaimMapping claimMapping : claimMappings) {
            returnMap.put(claimMapping.getLocalClaim().getClaimUri(), claimMapping.getRemoteClaim().getClaimUri());
        }
        return returnMap;
    }

    @Override
    public Set<RoleMapping> getMappedLocalRoles(String idPName, String tenantDomain, String[] idPRoles) throws IdentityProviderManagementException {
        RoleMapping[] roleMappings;
        PermissionsAndRoleConfig roleConfiguration;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)idPName)) {
            String msg = "Invalid argument: Identity Provider Name value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByName(null, idPName, tenantId, tenantDomain);
        if (identityProvider == null) {
            identityProvider = new FileBasedIdPMgtDAO().getIdPByName(idPName, tenantDomain);
        }
        if (identityProvider == null) {
            identityProvider = IdPManagementServiceComponent.getFileBasedIdPs().get("default");
        }
        if ((roleConfiguration = identityProvider.getPermissionAndRoleConfig()) != null && (roleMappings = roleConfiguration.getRoleMappings()) != null && roleMappings.length > 0 && idPRoles != null) {
            HashSet<RoleMapping> returnSet = new HashSet<RoleMapping>();
            block0: for (String idPRole : idPRoles) {
                for (RoleMapping roleMapping : roleMappings) {
                    if (!roleMapping.getRemoteRole().equals(idPRole)) continue;
                    returnSet.add(roleMapping);
                    continue block0;
                }
            }
            return returnSet;
        }
        return new HashSet<RoleMapping>();
    }

    @Override
    public Map<String, LocalRole> getMappedLocalRolesMap(String idPName, String tenantDomain, String[] idPRoles) throws IdentityProviderManagementException {
        Set<RoleMapping> roleMappings = this.getMappedLocalRoles(idPName, tenantDomain, idPRoles);
        HashMap<String, LocalRole> returnMap = new HashMap<String, LocalRole>();
        for (RoleMapping roleMapping : roleMappings) {
            returnMap.put(roleMapping.getRemoteRole(), roleMapping.getLocalRole());
        }
        return returnMap;
    }

    @Override
    public Set<RoleMapping> getMappedIdPRoles(String idPName, String tenantDomain, LocalRole[] localRoles) throws IdentityProviderManagementException {
        RoleMapping[] roleMappings;
        PermissionsAndRoleConfig roleConfiguration;
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)idPName)) {
            String msg = "Invalid argument: Identity Provider Name value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        IdentityProvider identityProvider = dao.getIdPByName(null, idPName, tenantId, tenantDomain);
        if (identityProvider == null) {
            identityProvider = new FileBasedIdPMgtDAO().getIdPByName(idPName, tenantDomain);
        }
        if (identityProvider == null) {
            identityProvider = IdPManagementServiceComponent.getFileBasedIdPs().get("default");
        }
        if ((roleConfiguration = identityProvider.getPermissionAndRoleConfig()) != null && (roleMappings = roleConfiguration.getRoleMappings()) != null && roleMappings.length > 0 && localRoles != null) {
            HashSet<RoleMapping> returnSet = new HashSet<RoleMapping>();
            block0: for (LocalRole localRole : localRoles) {
                for (RoleMapping roleMapping : roleMappings) {
                    if (!roleMapping.getLocalRole().equals((Object)localRole)) continue;
                    returnSet.add(roleMapping);
                    continue block0;
                }
            }
            return returnSet;
        }
        return new HashSet<RoleMapping>();
    }

    @Override
    public Map<LocalRole, String> getMappedIdPRolesMap(String idPName, String tenantDomain, LocalRole[] localRoles) throws IdentityProviderManagementException {
        Set<RoleMapping> roleMappings = this.getMappedIdPRoles(idPName, tenantDomain, localRoles);
        HashMap<LocalRole, String> returnMap = new HashMap<LocalRole, String>();
        for (RoleMapping roleMapping : roleMappings) {
            returnMap.put(roleMapping.getLocalRole(), roleMapping.getRemoteRole());
        }
        return returnMap;
    }

    private void handleMetadata(int tenantId, IdentityProvider identityProvider) throws IdentityProviderManagementException {
        FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs;
        if (IdpMgtServiceComponentHolder.getInstance().getMetadataConverters().isEmpty()) {
            throw new IdentityProviderManagementException("Metadata Converter is not set");
        }
        for (FederatedAuthenticatorConfig federatedAuthenticatorConfig : federatedAuthenticatorConfigs = identityProvider.getFederatedAuthenticatorConfigs()) {
            Object[] properties = federatedAuthenticatorConfig.getProperties();
            if (!ArrayUtils.isNotEmpty((Object[])properties)) continue;
            block7: for (Object property : properties) {
                if (property == null || !StringUtils.isNotBlank((String)property.getName()) || !property.getName().contains("meta_data")) continue;
                for (MetadataConverter metadataConverter : IdpMgtServiceComponentHolder.getInstance().getMetadataConverters()) {
                    if (!metadataConverter.canHandle((Property)property)) continue;
                    try {
                        if (this.isMetadataFileExist(identityProvider.getIdentityProviderName(), property.getValue())) {
                            try {
                                metadataConverter.saveMetadataString(tenantId, identityProvider.getIdentityProviderName(), federatedAuthenticatorConfig.getName(), property.getValue());
                            }
                            catch (IdentityProviderManagementException e) {
                                String data = "Couldn't save metadata in registry.SAML2SSOMetadataConverter is not set. ";
                                throw IdPManagementUtil.handleServerException(IdPManagementConstants.ErrorMessage.ERROR_CODE_ADD_IDP, data);
                            }
                        }
                        StringBuilder certificate = new StringBuilder();
                        try {
                            FederatedAuthenticatorConfig metaFederated = metadataConverter.getFederatedAuthenticatorConfig((Property[])properties, certificate);
                            String spName = "";
                            for (Object value : properties) {
                                if (value == null || !"SPEntityId".equals(value.getName())) continue;
                                spName = value.getValue();
                            }
                            if (spName.equals("")) {
                                throw new IdentityProviderManagementException("SP name can't be empty");
                            }
                            if (metaFederated != null && ArrayUtils.isNotEmpty((Object[])metaFederated.getProperties())) {
                                for (int y = 0; y < metaFederated.getProperties().length; ++y) {
                                    if (metaFederated.getProperties()[y] == null || !"SPEntityId".equals(metaFederated.getProperties()[y].getName())) continue;
                                    metaFederated.getProperties()[y].setValue(spName);
                                    break;
                                }
                            }
                            if (metaFederated == null || !ArrayUtils.isNotEmpty((Object[])metaFederated.getProperties())) {
                                throw new IdentityProviderManagementException("Error setting metadata using file");
                            }
                            federatedAuthenticatorConfig.setProperties(metaFederated.getProperties());
                        }
                        catch (IdentityProviderManagementException ex) {
                            throw new IdentityProviderManagementException("Error converting metadata", (Throwable)((Object)ex));
                        }
                        if (certificate.toString().length() <= 0) continue block7;
                        identityProvider.setCertificate(certificate.toString());
                        continue block7;
                    }
                    catch (XMLStreamException e) {
                        throw new IdentityProviderManagementException("Error while configuring metadata", e);
                    }
                }
            }
        }
    }

    @Override
    @Deprecated
    public void addIdP(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        this.addIdPWithResourceId(identityProvider, tenantDomain);
    }

    @Override
    public IdentityProvider addIdPWithResourceId(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        this.validateAddIdPInputValues(identityProvider.getIdentityProviderName(), tenantDomain);
        this.validateOutboundProvisioningRoles(identityProvider, tenantDomain);
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreAddIdP(identityProvider, tenantDomain)) continue;
            return null;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (this.isPermissionAndRoleConfigExist(identityProvider)) {
            this.verifyAndUpdateRoleConfiguration(tenantDomain, tenantId, identityProvider.getPermissionAndRoleConfig());
        }
        this.validateIdPEntityId(identityProvider.getFederatedAuthenticatorConfigs(), tenantId, tenantDomain);
        this.validateIdPIssuerName(identityProvider, tenantId, tenantDomain);
        this.handleMetadata(tenantId, identityProvider);
        String resourceId = dao.addIdP(identityProvider, tenantId, tenantDomain);
        identityProvider = dao.getIdPByResourceId(resourceId, tenantId, tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostAddIdP(identityProvider, tenantDomain)) continue;
            return null;
        }
        return identityProvider;
    }

    @Override
    @Deprecated
    public void deleteIdP(String idPName, String tenantDomain) throws IdentityProviderManagementException {
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreDeleteIdP(idPName, tenantDomain)) continue;
            return;
        }
        if (StringUtils.isEmpty((String)idPName)) {
            String data = "IdP name is empty.";
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_NAME_INVALID, data);
        }
        IdentityProvider identityProvider = this.getIdPByName(idPName, tenantDomain, true);
        if (identityProvider == null) {
            return;
        }
        this.deleteIDP(identityProvider.getResourceId(), idPName, tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostDeleteIdP(idPName, tenantDomain)) continue;
            return;
        }
    }

    @Override
    public void deleteIdPs(String tenantDomain) throws IdentityProviderManagementException {
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreDeleteIdPs(tenantDomain)) continue;
            return;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        List<IdentityProvider> identityProviders = this.getIdPs(tenantDomain);
        for (IdentityProvider identityProvider : identityProviders) {
            this.deleteMetadataStrings(identityProvider.getIdentityProviderName(), tenantId);
        }
        dao.deleteIdPs(tenantId);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostDeleteIdPs(tenantDomain)) continue;
            return;
        }
    }

    @Override
    public void deleteIdPByResourceId(String resourceId, String tenantDomain) throws IdentityProviderManagementException {
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreDeleteIdPByResourceId(resourceId, tenantDomain)) continue;
            return;
        }
        IdentityProvider identityProvider = this.getIdPByResourceId(resourceId, tenantDomain, true);
        if (identityProvider == null) {
            return;
        }
        this.deleteIDP(resourceId, identityProvider.getIdentityProviderName(), tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostDeleteIdPByResourceId(resourceId, identityProvider, tenantDomain)) continue;
            return;
        }
    }

    private void deleteMetadataStrings(String idpName, int tenantId) throws IdentityProviderManagementException {
        for (MetadataConverter metadataConverter : IdpMgtServiceComponentHolder.getInstance().getMetadataConverters()) {
            if (!metadataConverter.canDelete(tenantId, idpName)) continue;
            metadataConverter.deleteMetadataString(tenantId, idpName);
        }
    }

    private void deleteIDP(String resourceId, String idpName, String tenantDomain) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        this.deleteMetadataStrings(idpName, tenantId);
        dao.deleteIdPByResourceId(resourceId, tenantId, tenantDomain);
    }

    @Deprecated
    public void forceDeleteIdp(String idpName, String tenantDomain) throws IdentityProviderManagementException {
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreDeleteIdP(idpName, tenantDomain)) continue;
            return;
        }
        IdentityProvider identityProvider = this.getIdPByName(idpName, tenantDomain, true);
        if (identityProvider == null) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_NAME_DOES_NOT_EXIST, idpName);
        }
        this.forceDeleteIDP(identityProvider.getResourceId(), idpName, tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostDeleteIdP(idpName, tenantDomain)) continue;
            return;
        }
    }

    public void forceDeleteIdpByResourceId(String resourceId, String tenantDomain) throws IdentityProviderManagementException {
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreDeleteIdPByResourceId(resourceId, tenantDomain)) continue;
            return;
        }
        IdentityProvider identityProvider = this.getIdPByResourceId(resourceId, tenantDomain, true);
        if (identityProvider == null) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_DOES_NOT_EXIST, resourceId);
        }
        this.forceDeleteIDP(resourceId, identityProvider.getIdentityProviderName(), tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostDeleteIdPByResourceId(resourceId, identityProvider, tenantDomain)) continue;
            return;
        }
    }

    private void forceDeleteIDP(String resourceId, String idpName, String tenantDomain) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        for (MetadataConverter metadataConverter : IdpMgtServiceComponentHolder.getInstance().getMetadataConverters()) {
            if (!metadataConverter.canDelete(tenantId, idpName)) continue;
            metadataConverter.deleteMetadataString(tenantId, idpName);
        }
        dao.forceDeleteIdPByResourceId(resourceId, tenantId, tenantDomain);
    }

    @Override
    @Deprecated
    public void updateIdP(String oldIdPName, IdentityProvider newIdentityProvider, String tenantDomain) throws IdentityProviderManagementException {
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreUpdateIdP(oldIdPName, newIdentityProvider, tenantDomain)) continue;
            return;
        }
        IdentityProvider currentIdentityProvider = this.getIdPByName(oldIdPName, tenantDomain, true);
        if (currentIdentityProvider == null) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_NAME_DOES_NOT_EXIST, oldIdPName);
        }
        this.updateIDP(currentIdentityProvider, newIdentityProvider, IdentityTenantUtil.getTenantId((String)tenantDomain), tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostUpdateIdP(oldIdPName, newIdentityProvider, tenantDomain)) continue;
            return;
        }
    }

    @Override
    public IdentityProvider updateIdPByResourceId(String resourceId, IdentityProvider newIdentityProvider, String tenantDomain) throws IdentityProviderManagementException {
        Collection<IdentityProviderMgtListener> listeners = IdPManagementServiceComponent.getIdpMgtListeners();
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPreUpdateIdPByResourceId(resourceId, newIdentityProvider, tenantDomain)) continue;
            return null;
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        IdentityProvider currentIdentityProvider = this.getIdPByResourceId(resourceId, tenantDomain, true);
        this.validateUpdateIdPInputValues(currentIdentityProvider, resourceId, newIdentityProvider, tenantDomain);
        this.updateIDP(currentIdentityProvider, newIdentityProvider, tenantId, tenantDomain);
        for (IdentityProviderMgtListener listener : listeners) {
            if (!listener.isEnable() || listener.doPostUpdateIdPByResourceId(resourceId, currentIdentityProvider, newIdentityProvider, tenantDomain)) continue;
            return null;
        }
        return dao.getIdPByResourceId(resourceId, tenantId, tenantDomain);
    }

    private void updateIDP(IdentityProvider currentIdentityProvider, IdentityProvider newIdentityProvider, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        if (this.isPermissionAndRoleConfigExist(newIdentityProvider)) {
            this.verifyAndUpdateRoleConfiguration(tenantDomain, tenantId, newIdentityProvider.getPermissionAndRoleConfig());
        }
        this.validateUpdateOfIdPEntityId(currentIdentityProvider.getFederatedAuthenticatorConfigs(), newIdentityProvider.getFederatedAuthenticatorConfigs(), tenantId, tenantDomain);
        this.validateIdPIssuerName(currentIdentityProvider, newIdentityProvider, tenantId, tenantDomain);
        this.handleMetadata(tenantId, newIdentityProvider);
        dao.updateIdP(newIdentityProvider, currentIdentityProvider, tenantId, tenantDomain);
    }

    @Override
    public FederatedAuthenticatorConfig[] getAllFederatedAuthenticators() throws IdentityProviderManagementException {
        List appConfig = ApplicationAuthenticatorService.getInstance().getFederatedAuthenticators();
        if (CollectionUtils.isNotEmpty((Collection)appConfig)) {
            return appConfig.toArray(new FederatedAuthenticatorConfig[appConfig.size()]);
        }
        return new FederatedAuthenticatorConfig[0];
    }

    @Override
    public ProvisioningConnectorConfig[] getAllProvisioningConnectors() throws IdentityProviderManagementException {
        List connectorConfigs = ProvisioningConnectorService.getInstance().getProvisioningConnectorConfigs();
        if (connectorConfigs != null && connectorConfigs.size() > 0) {
            return connectorConfigs.toArray(new ProvisioningConnectorConfig[0]);
        }
        return null;
    }

    private boolean validateIdPEntityId(FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        if (federatedAuthenticatorConfigs != null) {
            for (FederatedAuthenticatorConfig authConfig : federatedAuthenticatorConfigs) {
                Property[] properties;
                if (!"SAMLSSOAuthenticator".equals(authConfig.getName()) && !"samlsso".equals(authConfig.getName()) || (properties = authConfig.getProperties()) == null) continue;
                for (Property property : properties) {
                    if (!OPENID_IDP_ENTITY_ID.equals(property.getName())) continue;
                    if (dao.isIdPAvailableForAuthenticatorProperty(authConfig.getName(), OPENID_IDP_ENTITY_ID, property.getValue(), tenantId)) {
                        String msg = "An Identity Provider Entity ID has already been registered with the name '" + property.getValue() + "' for tenant '" + tenantDomain + "'";
                        throw new IdentityProviderManagementException(msg);
                    }
                    return true;
                }
            }
        }
        return true;
    }

    private boolean validateUpdateOfIdPEntityId(FederatedAuthenticatorConfig[] currentFederatedAuthConfigs, FederatedAuthenticatorConfig[] newFederatedAuthConfigs, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Property[] properties;
        String currentIdentityProviderEntityId = null;
        if (currentFederatedAuthConfigs != null) {
            block0: for (FederatedAuthenticatorConfig fedAuthnConfig : currentFederatedAuthConfigs) {
                if (!"SAMLSSOAuthenticator".equals(fedAuthnConfig.getName()) && !"samlsso".equals(fedAuthnConfig.getName())) continue;
                properties = fedAuthnConfig.getProperties();
                if (properties == null) break;
                for (Property property : properties) {
                    if (!OPENID_IDP_ENTITY_ID.equals(property.getName())) continue;
                    currentIdentityProviderEntityId = property.getValue();
                    break block0;
                }
                break;
            }
        }
        if (newFederatedAuthConfigs != null) {
            for (FederatedAuthenticatorConfig fedAuthnConfig : newFederatedAuthConfigs) {
                if (!"SAMLSSOAuthenticator".equals(fedAuthnConfig.getName()) && !"samlsso".equals(fedAuthnConfig.getName())) continue;
                properties = fedAuthnConfig.getProperties();
                if (properties == null) break;
                for (Property property : properties) {
                    if (!OPENID_IDP_ENTITY_ID.equals(property.getName())) continue;
                    if (currentIdentityProviderEntityId != null && currentIdentityProviderEntityId.equals(property.getValue())) {
                        return true;
                    }
                    if (dao.isIdPAvailableForAuthenticatorProperty(fedAuthnConfig.getName(), OPENID_IDP_ENTITY_ID, property.getValue(), tenantId)) {
                        String msg = "An Identity Provider Entity ID has already been registered with the name '" + property.getValue() + "' for tenant '" + tenantDomain + "'";
                        throw new IdentityProviderManagementException(msg);
                    }
                    return true;
                }
                break;
            }
        }
        return true;
    }

    private String getOIDCResidentIdPEntityId() {
        String OIDCEntityId = IdentityUtil.getProperty((String)"OAuth.OpenIDConnect.IDTokenIssuerID");
        if (StringUtils.isBlank((String)OIDCEntityId)) {
            OIDCEntityId = "localhost";
        }
        return OIDCEntityId;
    }

    public String getResidentIDPMetadata(String tenantDomain) throws IdentityProviderManagementException {
        if (IdpMgtServiceComponentHolder.getInstance().getMetadataConverters().isEmpty()) {
            throw new IdentityProviderManagementException("Error receiving Metadata object");
        }
        IdentityProvider residentIdentityProvider = this.getResidentIdP(tenantDomain);
        FederatedAuthenticatorConfig[] federatedAuthenticatorConfigs = residentIdentityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig samlFederatedAuthenticatorConfig = null;
        for (int i = 0; i < federatedAuthenticatorConfigs.length; ++i) {
            if (!federatedAuthenticatorConfigs[i].getName().equals("samlsso")) continue;
            samlFederatedAuthenticatorConfig = federatedAuthenticatorConfigs[i];
            break;
        }
        if (samlFederatedAuthenticatorConfig != null) {
            try {
                for (int t = 0; t < IdpMgtServiceComponentHolder.getInstance().getMetadataConverters().size(); ++t) {
                    MetadataConverter converter = IdpMgtServiceComponentHolder.getInstance().getMetadataConverters().get(t);
                    if (!converter.canHandle(samlFederatedAuthenticatorConfig)) continue;
                    return converter.getMetadataString(samlFederatedAuthenticatorConfig);
                }
            }
            catch (IdentityProviderSAMLException e) {
                throw new IdentityProviderManagementException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    public ConnectedAppsResult getConnectedApplications(String resourceId, Integer limit, Integer offset, String tenantDomain) throws IdentityProviderManagementException {
        this.validateResourceId(resourceId, tenantDomain);
        limit = this.validateLimit(limit);
        offset = this.validateOffset(offset);
        return dao.getConnectedApplications(resourceId, limit, offset);
    }

    private void validateResourceId(String resourceId, String tenantDomain) throws IdentityProviderManagementException {
        if (StringUtils.isEmpty((String)resourceId)) {
            String data = "Invalid argument: Identity Provider resource ID value is empty";
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP_CONNECTED_APPS, data);
        }
        if (this.getIdPByResourceId(resourceId, tenantDomain, true) == null) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_DOES_NOT_EXIST, resourceId);
        }
    }

    private String resolveAbsoluteURL(String defaultUrlContext, String urlFromConfig) throws IdentityProviderManagementServerException {
        if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && StringUtils.isNotBlank((String)urlFromConfig)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved URL:" + urlFromConfig + " from file configuration for default url context: " + defaultUrlContext));
            }
            return urlFromConfig;
        }
        try {
            return ServiceURLBuilder.create().addPath(new String[]{defaultUrlContext}).build().getAbsolutePublicURL();
        }
        catch (URLBuilderException e) {
            throw (IdentityProviderManagementServerException)IdentityProviderManagementException.error(IdentityProviderManagementServerException.class, (String)("Error while building URL: " + defaultUrlContext), (Throwable)e);
        }
    }

    private String addTenantPathParamInLegacyMode(String resolvedUrl, String tenantDomain) {
        try {
            if (!IdentityTenantUtil.isTenantQualifiedUrlsEnabled() && StringUtils.isNotBlank((String)tenantDomain) && !"carbon.super".equals(tenantDomain)) {
                resolvedUrl = this.getTenantUrl(resolvedUrl, tenantDomain);
            }
        }
        catch (URISyntaxException e) {
            log.error((Object)String.format("%s endpoint is malformed.", resolvedUrl), (Throwable)e);
        }
        return resolvedUrl;
    }

    private String getTenantUrl(String url, String tenantDomain) throws URISyntaxException {
        URI uri = new URI(url);
        URI uriModified = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), "/t/" + tenantDomain + uri.getPath(), uri.getQuery(), uri.getFragment());
        return uriModified.toString();
    }

    private void verifyAndUpdateRoleConfiguration(String tenantDomain, int tenantId, PermissionsAndRoleConfig roleConfiguration) throws IdentityProviderManagementException {
        ArrayList<RoleMapping> validRoleMappings = new ArrayList<RoleMapping>();
        ArrayList<String> validIdPRoles = new ArrayList<String>();
        for (RoleMapping mapping : roleConfiguration.getRoleMappings()) {
            try {
                if (mapping.getRemoteRole() == null || mapping.getLocalRole() == null || StringUtils.isBlank((String)mapping.getLocalRole().getLocalRoleName())) continue;
                UserStoreManager usm = IdPManagementServiceComponent.getRealmService().getTenantUserRealm(tenantId).getUserStoreManager();
                String role = mapping.getLocalRole().getLocalRoleName();
                if (StringUtils.isNotBlank((String)mapping.getLocalRole().getUserStoreId())) {
                    role = IdentityUtil.addDomainToName((String)role, (String)mapping.getLocalRole().getUserStoreId());
                }
                if (usm.isExistingRole(role)) {
                    validRoleMappings.add(mapping);
                    validIdPRoles.add(mapping.getRemoteRole());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Invalid local role name: " + role + " for the federated role: " + mapping.getRemoteRole()));
            }
            catch (UserStoreException e) {
                throw new IdentityProviderManagementException("Error occurred while retrieving UserStoreManager for tenant " + tenantDomain, e);
            }
        }
        roleConfiguration.setRoleMappings(validRoleMappings.toArray(new RoleMapping[0]));
        roleConfiguration.setIdpRoles(validIdPRoles.toArray(new String[0]));
    }

    private void validateGetIdPInputValues(String resourceId) throws IdentityProviderManagementException {
        if (StringUtils.isEmpty((String)resourceId)) {
            String data = "Invalid argument: Identity Provider resource ID value is empty";
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_GET_REQUEST_INVALID, data);
        }
    }

    private void validateAddIdPInputValues(String idpName, String tenantDomain) throws IdentityProviderManagementException {
        if (IdentityProviderManager.getInstance().getIdPByName(idpName, tenantDomain, true) != null) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_ALREADY_EXISTS, idpName);
        }
        if (IdPManagementServiceComponent.getFileBasedIdPs().containsKey(idpName) && !idpName.startsWith("SHARED_")) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_ALREADY_EXISTS, idpName);
        }
    }

    private void validateUpdateIdPInputValues(IdentityProvider currentIdentityProvider, String resourceId, IdentityProvider newIdentityProvider, String tenantDomain) throws IdentityProviderManagementException {
        if (currentIdentityProvider == null) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_DOES_NOT_EXIST, resourceId);
        }
        boolean isNewIdPNameExists = false;
        IdentityProvider retrievedIdentityProvider = this.getIdPByName(newIdentityProvider.getIdentityProviderName(), tenantDomain, true);
        if (retrievedIdentityProvider != null) {
            boolean bl = isNewIdPNameExists = !StringUtils.equals((String)retrievedIdentityProvider.getResourceId(), (String)currentIdentityProvider.getResourceId());
        }
        if (isNewIdPNameExists || IdPManagementServiceComponent.getFileBasedIdPs().containsKey(newIdentityProvider.getIdentityProviderName())) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_IDP_ALREADY_EXISTS, newIdentityProvider.getIdentityProviderName());
        }
        this.validateOutboundProvisioningConnectorProperties(newIdentityProvider);
    }

    private void validateOutboundProvisioningConnectorProperties(IdentityProvider newIdentityProvider) throws IdentityProviderManagementException {
        Object[] provisioningConnectorConfigs = newIdentityProvider.getProvisioningConnectorConfigs();
        if (!ArrayUtils.isEmpty((Object[])provisioningConnectorConfigs)) {
            Object connectorConfig;
            Object[] properties;
            Object[] objectArray = provisioningConnectorConfigs;
            int n = objectArray.length;
            for (int i = 0; i < n && !ArrayUtils.isEmpty((Object[])(properties = (connectorConfig = objectArray[i]).getProvisioningProperties())) && properties.length >= 2; ++i) {
                HashSet<Object> connectorProperties = new HashSet<Object>();
                for (Object property : properties) {
                    if (connectorProperties.add(property)) continue;
                    throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.DUPLICATE_OUTBOUND_CONNECTOR_PROPERTIES, newIdentityProvider.getIdentityProviderName());
                }
            }
        }
    }

    private boolean isPermissionAndRoleConfigExist(IdentityProvider identityProvider) {
        return identityProvider.getPermissionAndRoleConfig() != null && identityProvider.getPermissionAndRoleConfig().getRoleMappings() != null;
    }

    private boolean isMetadataFileExist(String idpName, String metadata) {
        return StringUtils.isNotEmpty((String)idpName) && StringUtils.isNotEmpty((String)metadata);
    }

    @Override
    public IdentityProvider getIdPByMetadataProperty(String property, String value, String tenantDomain, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (StringUtils.isEmpty((String)property) || StringUtils.isEmpty((String)value)) {
            String msg = "Invalid argument: IDP metadata property or property value is empty";
            throw new IdentityProviderManagementException(msg);
        }
        String idPName = this.getIDPNameByMetadataProperty(null, property, value, tenantId, tenantDomain, ignoreFileBasedIdps);
        if (idPName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("IDP Name not found for metadata property name: " + property + " value: " + value + ". Returning null without continuing."));
            }
            return null;
        }
        return this.getIdPByName(idPName, tenantDomain, ignoreFileBasedIdps);
    }

    private boolean validateIdPIssuerName(IdentityProvider identityProvider, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        Object[] identityProviderProperties = identityProvider.getIdpProperties();
        if (!ArrayUtils.isEmpty((Object[])identityProviderProperties)) {
            for (Object prop : identityProviderProperties) {
                String idpWithIssuer;
                if (prop == null || !"idpIssuerName".equals(prop.getName()) || !StringUtils.isNotBlank((String)prop.getValue()) || !StringUtils.isNotEmpty((String)(idpWithIssuer = this.getIDPNameByMetadataProperty(null, "idpIssuerName", prop.getValue(), tenantId, tenantDomain, false)))) continue;
                String msg = "The provided IDP Issuer Name '" + prop.getValue() + "' has already been registered with the IDP '" + idpWithIssuer + "'.";
                throw new IdentityProviderManagementClientException(msg);
            }
        }
        return true;
    }

    private boolean validateIdPIssuerName(IdentityProvider currentIdP, IdentityProvider newIdP, int tenantId, String tenantDomain) throws IdentityProviderManagementException {
        String idpWithIssuer;
        String newIdPIssuerName = null;
        Object[] identityProviderProperties = newIdP.getIdpProperties();
        if (!ArrayUtils.isEmpty((Object[])identityProviderProperties)) {
            for (Object prop : identityProviderProperties) {
                if (prop == null || !"idpIssuerName".equals(prop.getName()) || !StringUtils.isNotBlank((String)prop.getValue())) continue;
                newIdPIssuerName = prop.getValue();
            }
        }
        String currentIdPIssuerName = null;
        identityProviderProperties = currentIdP.getIdpProperties();
        if (!ArrayUtils.isEmpty((Object[])identityProviderProperties)) {
            for (Object prop : identityProviderProperties) {
                if (prop == null || !"idpIssuerName".equals(prop.getName()) || !StringUtils.isNotBlank((String)prop.getValue())) continue;
                currentIdPIssuerName = prop.getValue();
            }
        }
        if (StringUtils.isNotBlank(newIdPIssuerName) && !StringUtils.equals(newIdPIssuerName, currentIdPIssuerName) && StringUtils.isNotEmpty((String)(idpWithIssuer = this.getIDPNameByMetadataProperty(null, "idpIssuerName", newIdPIssuerName, tenantId, tenantDomain, false)))) {
            String msg = "The provided IDP Issuer Name '" + newIdPIssuerName + "' has already been registered with the IDP '" + idpWithIssuer + "'.";
            throw new IdentityProviderManagementClientException(msg);
        }
        return true;
    }

    private String getIDPNameByMetadataProperty(Connection dbConnection, String property, String value, int tenantId, String tenantDomain, boolean ignoreFileBasedIdps) throws IdentityProviderManagementException {
        String idPName = dao.getIdPNameByMetadataProperty(null, property, value, tenantId, tenantDomain);
        if (idPName == null && !ignoreFileBasedIdps) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attempting to retrieve IDP Name from filebased IDPs for IDP metadata property name: " + property + " value: " + value));
            }
            idPName = new FileBasedIdPMgtDAO().getIdPNameByMetadataProperty(property, value);
        }
        return idPName;
    }

    private void validateOutboundProvisioningRoles(IdentityProvider identityProvider, String tenantDomain) throws IdentityProviderManagementException {
        String provisioningRole = identityProvider.getProvisioningRole();
        if (StringUtils.isBlank((String)provisioningRole)) {
            return;
        }
        String[] outboundProvisioningRoles = StringUtils.split((String)provisioningRole, (String)",");
        try {
            RoleManagementService roleManagementService = IdpMgtServiceComponentHolder.getInstance().getRoleManagementService();
            for (String roleName : outboundProvisioningRoles) {
                try {
                    if (roleManagementService.isExistingRoleName(roleName, tenantDomain)) continue;
                    throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_NOT_EXISTING_OUTBOUND_PROVISIONING_ROLE, null);
                }
                catch (NotImplementedException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"isExistingRoleName is not implemented in the RoleManagementService. Therefore, proceeding without validating outbound provisioning role existence.");
                }
            }
        }
        catch (IdentityRoleManagementException e) {
            throw IdPManagementUtil.handleServerException(IdPManagementConstants.ErrorMessage.ERROR_CODE_VALIDATING_OUTBOUND_PROVISIONING_ROLES, null, e);
        }
    }
}

