/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.idp.mgt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.ProvisioningConnectorConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;
import org.wso2.carbon.idp.mgt.model.IdpSearchResult;
import org.wso2.carbon.idp.mgt.util.IdPManagementConstants;
import org.wso2.carbon.idp.mgt.util.IdPManagementUtil;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.UserStoreException;

public class IdentityProviderManagementService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(IdentityProviderManager.class);
    private static String LOCAL_DEFAULT_CLAIM_DIALECT = "http://wso2.org/claims";

    public IdentityProvider getResidentIdP() throws IdentityProviderManagementException {
        String tenantDomain = "";
        try {
            tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityProvider residentIdP = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
            return residentIdP;
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while getting ResidentIdP in tenantDomain :" + tenantDomain), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public void updateResidentIdP(IdentityProvider identityProvider) throws IdentityProviderManagementException {
        String tenantDomain = "";
        try {
            tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityProviderManager.getInstance().updateResidentIdP(identityProvider, tenantDomain);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while updating ResidentIdP in tenantDomain : " + tenantDomain), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public IdentityProvider[] getAllIdPs() throws IdentityProviderManagementException {
        String tenantDomain = "";
        try {
            tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            List<IdentityProvider> identityProviders = IdentityProviderManager.getInstance().getIdPs(tenantDomain);
            for (int i = 0; i < identityProviders.size(); ++i) {
                String providerName = identityProviders.get(i).getIdentityProviderName();
                if (providerName == null || !providerName.startsWith("SHARED_")) continue;
                identityProviders.remove(i);
                --i;
            }
            return identityProviders.toArray(new IdentityProvider[0]);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while getting IdPs in tenantDomain : " + tenantDomain), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public int getAllIdpCount() throws IdentityProviderManagementException {
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        return IdentityProviderManager.getInstance().getTotalIdPCount("", tenantDomain);
    }

    public IdentityProvider[] getAllPaginatedIdpInfo(int pageNumber) throws IdentityProviderManagementException {
        return this.getPaginatedIdpInfo("", pageNumber);
    }

    public IdentityProvider[] getPaginatedIdpInfo(String filter, int pageNumber) throws IdentityProviderManagementException {
        this.validateRequestedPageNumber(pageNumber);
        Integer limit = IdentityUtil.getDefaultItemsPerPage();
        Integer offset = this.getIdpPageOffset(pageNumber, limit);
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        IdpSearchResult idpSearchResult = IdentityProviderManager.getInstance().getIdPs(limit, offset, filter, "ASC", "ID", tenantDomain, new ArrayList<String>());
        return idpSearchResult.getIdPs().toArray(new IdentityProvider[0]);
    }

    public int getFilteredIdpCount(String filter) throws IdentityProviderManagementException {
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        return IdentityProviderManager.getInstance().getTotalIdPCount(filter, tenantDomain);
    }

    private int getIdpPageOffset(int pageNumber, int limit) {
        int offset = 0;
        if (pageNumber > 1) {
            offset = (pageNumber - 1) * limit;
        }
        return offset;
    }

    private void validateRequestedPageNumber(int pageNumber) throws IdentityProviderManagementException {
        if (pageNumber < 1) {
            throw IdPManagementUtil.handleClientException(IdPManagementConstants.ErrorMessage.ERROR_CODE_RETRIEVE_IDP, "Invalid page number requested. The page number should be a value greater than 0");
        }
    }

    public IdentityProvider[] getAllIdPsSearch(String filter) throws IdentityProviderManagementException {
        String tenantDomain = "";
        try {
            tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            List<IdentityProvider> identityProviders = IdentityProviderManager.getInstance().getIdPsSearch(tenantDomain, filter);
            for (int i = 0; i < identityProviders.size(); ++i) {
                String providerName = identityProviders.get(i).getIdentityProviderName();
                if (providerName == null || !providerName.startsWith("SHARED_")) continue;
                identityProviders.remove(i);
                --i;
            }
            return identityProviders.toArray(new IdentityProvider[0]);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while getting IdPs in tenantDomain : " + tenantDomain), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public IdentityProvider[] getEnabledAllIdPs() throws IdentityProviderManagementException {
        String tenantDomain = "";
        try {
            tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            List<IdentityProvider> identityProviders = IdentityProviderManager.getInstance().getEnabledIdPs(tenantDomain);
            return identityProviders.toArray(new IdentityProvider[0]);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while getting enabled registered Identity providers in tenantDomain : " + tenantDomain), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public IdentityProvider getIdPByName(String idPName) throws IdentityProviderManagementException {
        try {
            if (StringUtils.isBlank((String)idPName)) {
                throw new IllegalArgumentException("Provided IdP name is empty");
            }
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityProvider identityProvider = IdentityProviderManager.getInstance().getIdPByName(idPName, tenantDomain, true);
            IdPManagementUtil.removeOriginalPasswords(identityProvider);
            return identityProvider;
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while getting Idp with name " + idPName), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public void addIdP(IdentityProvider identityProvider) throws IdentityProviderManagementException {
        if (identityProvider != null && identityProvider.getIdentityProviderName() != null && identityProvider.getIdentityProviderName().startsWith("SHARED_")) {
            throw new IdentityProviderManagementException("Identity provider name cannot have SHARED_ as prefix.");
        }
        String tenantDomain = "";
        try {
            tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityProviderManager.getInstance().addIdP(identityProvider, tenantDomain);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while adding Identity provider in tenantDomain : " + tenantDomain), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public void deleteIdP(String idPName) throws IdentityProviderManagementException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityProviderManager.getInstance().deleteIdP(idPName, tenantDomain);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while deleting IdP with name " + idPName), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public void forceDeleteIdP(String idPName) throws IdentityProviderManagementException {
        String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            IdentityProviderManager.getInstance().forceDeleteIdp(idPName, tenantDomain);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)String.format("Error while force deleting IdP:%s in tenantDomain:%s", idPName, tenantDomain), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public String[] getAllLocalClaimUris() throws IdentityProviderManagementException {
        try {
            String claimDialect = LOCAL_DEFAULT_CLAIM_DIALECT;
            ClaimMapping[] claimMappings = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getClaimManager().getAllClaimMappings(claimDialect);
            ArrayList<String> claimUris = new ArrayList<String>();
            for (ClaimMapping claimMap : claimMappings) {
                claimUris.add(claimMap.getClaim().getClaimUri());
            }
            Object[] allLocalClaimUris = claimUris.toArray(new String[0]);
            if (ArrayUtils.isNotEmpty((Object[])allLocalClaimUris)) {
                Arrays.sort(allLocalClaimUris);
            }
            return allLocalClaimUris;
        }
        catch (UserStoreException e) {
            String message = "Error while reading system claims";
            log.error((Object)message, (Throwable)e);
            throw new IdentityProviderManagementException(message, e);
        }
    }

    public void updateIdP(String oldIdPName, IdentityProvider identityProvider) throws IdentityProviderManagementException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdPManagementUtil.removeRandomPasswords(identityProvider, true);
            IdentityProviderManager.getInstance().updateIdP(oldIdPName, identityProvider, tenantDomain);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)("Error while updating IdP with name " + oldIdPName), (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public FederatedAuthenticatorConfig[] getAllFederatedAuthenticators() throws IdentityProviderManagementException {
        try {
            return IdentityProviderManager.getInstance().getAllFederatedAuthenticators();
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)"Error while getting Federated Authenticators", (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public ProvisioningConnectorConfig[] getAllProvisioningConnectors() throws IdentityProviderManagementException {
        try {
            return IdentityProviderManager.getInstance().getAllProvisioningConnectors();
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)"Error while getting provisioning connectors", (Throwable)((Object)idpException));
            throw idpException;
        }
    }

    public String getResidentIDPMetadata() throws IdentityProviderManagementException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            return IdentityProviderManager.getInstance().getResidentIDPMetadata(tenantDomain);
        }
        catch (IdentityProviderManagementException idpException) {
            log.error((Object)"Error while retrieving IDP metadata", (Throwable)((Object)idpException));
            throw idpException;
        }
    }
}

