/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.crypto.api;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.wso2.carbon.crypto.api.CertificateInfo;
import org.wso2.carbon.crypto.api.CryptoContext;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.HybridEncryptionInput;
import org.wso2.carbon.crypto.api.HybridEncryptionOutput;
import org.wso2.carbon.crypto.api.PrivateKeyInfo;

public interface ExternalCryptoProvider {
    public byte[] sign(byte[] var1, String var2, String var3, CryptoContext var4, PrivateKeyInfo var5) throws CryptoException;

    public byte[] decrypt(byte[] var1, String var2, String var3, CryptoContext var4, PrivateKeyInfo var5) throws CryptoException;

    public byte[] encrypt(byte[] var1, String var2, String var3, CryptoContext var4, CertificateInfo var5) throws CryptoException;

    public boolean verifySignature(byte[] var1, byte[] var2, String var3, String var4, CryptoContext var5, CertificateInfo var6) throws CryptoException;

    public Certificate getCertificate(CryptoContext var1, CertificateInfo var2) throws CryptoException;

    public PrivateKey getPrivateKey(CryptoContext var1, PrivateKeyInfo var2) throws CryptoException;

    default public HybridEncryptionOutput hybridEncrypt(HybridEncryptionInput hybridEncryptionInput, String symmetricAlgorithm, String asymmetricAlgorithm, String javaSecurityProvider, CryptoContext cryptoContext, CertificateInfo certificateInfo) throws CryptoException {
        String errorMessage = "Hybrid encryption is not supported by this implementation.";
        throw new CryptoException(errorMessage);
    }

    default public byte[] hybridDecrypt(HybridEncryptionOutput hybridEncryptionOutput, String symmetricAlgorithm, String asymmetricAlgorithm, String javaSecurityProvider, CryptoContext cryptoContext, PrivateKeyInfo privateKeyInfo) throws CryptoException {
        String errorMessage = "Hybrid decryption is not supported by this implementation.";
        throw new CryptoException(errorMessage);
    }
}

