/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.AttributeMappingDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.ClaimDialectDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.ClaimPropertyDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.ExternalClaimDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.LocalClaimDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.internal.IdentityClaimManagementServiceDataHolder;
import org.wso2.carbon.identity.claim.metadata.mgt.model.AttributeMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.user.core.claim.ClaimMapping;
import org.wso2.carbon.user.core.service.RealmService;

public class ClaimMetadataUtils {
    private ClaimMetadataUtils() {
    }

    public static ClaimDialectDTO convertClaimDialectToClaimDialectDTO(ClaimDialect claimDialect) {
        ClaimDialectDTO claimDialectDTO = new ClaimDialectDTO();
        claimDialectDTO.setClaimDialectURI(claimDialect.getClaimDialectURI());
        return claimDialectDTO;
    }

    public static ClaimDialectDTO[] convertClaimDialectsToClaimDialectDTOs(ClaimDialect[] claimDialects) {
        ClaimDialectDTO[] claimDialectDTOs = new ClaimDialectDTO[claimDialects.length];
        for (int i = 0; i < claimDialects.length; ++i) {
            claimDialectDTOs[i] = ClaimMetadataUtils.convertClaimDialectToClaimDialectDTO(claimDialects[i]);
        }
        return claimDialectDTOs;
    }

    public static ClaimDialect convertClaimDialectDTOToClaimDialect(ClaimDialectDTO claimDialectDTO) {
        ClaimDialect claimDialect = new ClaimDialect(claimDialectDTO.getClaimDialectURI());
        return claimDialect;
    }

    public static LocalClaimDTO convertLocalClaimToLocalClaimDTO(LocalClaim localClaim) {
        LocalClaimDTO localClaimDTO = new LocalClaimDTO();
        localClaimDTO.setLocalClaimURI(localClaim.getClaimURI());
        List<AttributeMapping> attributeMappings = localClaim.getMappedAttributes();
        AttributeMappingDTO[] attributeMappingDTOs = new AttributeMappingDTO[attributeMappings.size()];
        int i = 0;
        for (AttributeMapping attributeMapping : attributeMappings) {
            AttributeMappingDTO attributeMappingDTO = new AttributeMappingDTO();
            attributeMappingDTO.setUserStoreDomain(attributeMapping.getUserStoreDomain());
            attributeMappingDTO.setAttributeName(attributeMapping.getAttributeName());
            attributeMappingDTOs[i] = attributeMappingDTO;
            ++i;
        }
        localClaimDTO.setAttributeMappings(attributeMappingDTOs);
        Map<String, String> claimProperties = localClaim.getClaimProperties();
        ClaimPropertyDTO[] claimPropertyDTOs = new ClaimPropertyDTO[claimProperties.size()];
        int j = 0;
        for (Map.Entry<String, String> claimPropertyEntry : claimProperties.entrySet()) {
            ClaimPropertyDTO claimProperty = new ClaimPropertyDTO();
            claimProperty.setPropertyName(claimPropertyEntry.getKey());
            claimProperty.setPropertyValue(claimPropertyEntry.getValue());
            claimPropertyDTOs[j] = claimProperty;
            ++j;
        }
        localClaimDTO.setClaimProperties(claimPropertyDTOs);
        return localClaimDTO;
    }

    public static LocalClaimDTO[] convertLocalClaimsToLocalClaimDTOs(LocalClaim[] localClaims) {
        LocalClaimDTO[] localClaimDTOs = new LocalClaimDTO[localClaims.length];
        for (int i = 0; i < localClaims.length; ++i) {
            localClaimDTOs[i] = ClaimMetadataUtils.convertLocalClaimToLocalClaimDTO(localClaims[i]);
        }
        return localClaimDTOs;
    }

    public static LocalClaim convertLocalClaimDTOToLocalClaim(LocalClaimDTO localClaimDTO) {
        LocalClaim localClaim = new LocalClaim(localClaimDTO.getLocalClaimURI());
        if (localClaimDTO.getAttributeMappings() != null) {
            ArrayList<AttributeMapping> attributeMappings = new ArrayList<AttributeMapping>();
            for (AttributeMappingDTO attributeMappingDTO : localClaimDTO.getAttributeMappings()) {
                attributeMappings.add(new AttributeMapping(attributeMappingDTO.getUserStoreDomain(), attributeMappingDTO.getAttributeName()));
            }
            localClaim.setMappedAttributes(attributeMappings);
        }
        if (localClaimDTO.getClaimProperties() != null) {
            HashMap<String, String> claimProperties = new HashMap<String, String>();
            for (ClaimPropertyDTO claimPropertyDTO : localClaimDTO.getClaimProperties()) {
                claimProperties.put(claimPropertyDTO.getPropertyName(), claimPropertyDTO.getPropertyValue());
            }
            localClaim.setClaimProperties(claimProperties);
        }
        return localClaim;
    }

    public static ExternalClaimDTO convertExternalClaimToExternalClaimDTO(ExternalClaim externalClaim) {
        ExternalClaimDTO externalClaimDTO = new ExternalClaimDTO();
        externalClaimDTO.setExternalClaimDialectURI(externalClaim.getClaimDialectURI());
        externalClaimDTO.setExternalClaimURI(externalClaim.getClaimURI());
        externalClaimDTO.setMappedLocalClaimURI(externalClaim.getMappedLocalClaim());
        Map<String, String> claimProperties = externalClaim.getClaimProperties();
        ClaimPropertyDTO[] claimPropertyDTOs = new ClaimPropertyDTO[claimProperties.size()];
        int j = 0;
        for (Map.Entry<String, String> claimPropertyEntry : claimProperties.entrySet()) {
            ClaimPropertyDTO claimProperty = new ClaimPropertyDTO();
            claimProperty.setPropertyName(claimPropertyEntry.getKey());
            claimProperty.setPropertyValue(claimPropertyEntry.getValue());
            claimPropertyDTOs[j] = claimProperty;
            ++j;
        }
        externalClaimDTO.setClaimProperties(claimPropertyDTOs);
        return externalClaimDTO;
    }

    public static ExternalClaimDTO[] convertExternalClaimsToExternalClaimDTOs(ExternalClaim[] externalClaims) {
        ExternalClaimDTO[] externalClaimDTOs = new ExternalClaimDTO[externalClaims.length];
        for (int i = 0; i < externalClaims.length; ++i) {
            externalClaimDTOs[i] = ClaimMetadataUtils.convertExternalClaimToExternalClaimDTO(externalClaims[i]);
        }
        return externalClaimDTOs;
    }

    public static ExternalClaim convertExternalClaimDTOToExternalClaim(ExternalClaimDTO externalClaimDTO) {
        ExternalClaim externalClaim = new ExternalClaim(externalClaimDTO.getExternalClaimDialectURI(), externalClaimDTO.getExternalClaimURI(), externalClaimDTO.getMappedLocalClaimURI());
        if (externalClaimDTO.getClaimProperties() != null) {
            HashMap<String, String> claimProperties = new HashMap<String, String>();
            for (ClaimPropertyDTO claimPropertyDTO : externalClaimDTO.getClaimProperties()) {
                claimProperties.put(claimPropertyDTO.getPropertyName(), claimPropertyDTO.getPropertyValue());
            }
            externalClaim.setClaimProperties(claimProperties);
        }
        return externalClaim;
    }

    public static ClaimMapping convertLocalClaimToClaimMapping(LocalClaim localClaim, int tenantId) throws UserStoreException {
        ClaimMapping claimMapping = new ClaimMapping();
        Claim claim = new Claim();
        claim.setClaimUri(localClaim.getClaimURI());
        claim.setDialectURI(localClaim.getClaimDialectURI());
        Map<String, String> claimProperties = localClaim.getClaimProperties();
        if (claimProperties.containsKey("DisplayName")) {
            claim.setDisplayTag(claimProperties.get("DisplayName"));
        }
        if (claimProperties.containsKey("Description")) {
            claim.setDescription(claimProperties.get("Description"));
        }
        if (claimProperties.containsKey("RegEx")) {
            claim.setRegEx(claimProperties.get("RegEx"));
        }
        if (claimProperties.containsKey("DisplayOrder")) {
            claim.setDisplayOrder(Integer.parseInt(claimProperties.get("DisplayOrder")));
        }
        if (claimProperties.containsKey("SupportedByDefault")) {
            if ("false".equalsIgnoreCase(claimProperties.get("SupportedByDefault"))) {
                claim.setSupportedByDefault(Boolean.FALSE.booleanValue());
            } else {
                claim.setSupportedByDefault(Boolean.TRUE.booleanValue());
            }
        }
        if (claimProperties.containsKey("Required")) {
            if ("false".equalsIgnoreCase(claimProperties.get("Required"))) {
                claim.setRequired(Boolean.FALSE.booleanValue());
            } else {
                claim.setRequired(Boolean.TRUE.booleanValue());
            }
        }
        if (claimProperties.containsKey("ReadOnly")) {
            if ("false".equalsIgnoreCase(claimProperties.get("ReadOnly"))) {
                claim.setReadOnly(Boolean.FALSE.booleanValue());
            } else {
                claim.setReadOnly(Boolean.TRUE.booleanValue());
            }
        }
        claimMapping.setClaim((org.wso2.carbon.user.api.Claim)claim);
        List<AttributeMapping> mappedAttributes = localClaim.getMappedAttributes();
        for (AttributeMapping attributeMapping : mappedAttributes) {
            claimMapping.setMappedAttribute(attributeMapping.getUserStoreDomain(), attributeMapping.getAttributeName());
        }
        if (claimProperties.containsKey("DefaultAttribute")) {
            claimMapping.setMappedAttribute(claimProperties.get("DefaultAttribute"));
        } else {
            RealmService realmService = IdentityClaimManagementServiceDataHolder.getInstance().getRealmService();
            if (realmService != null && realmService.getTenantUserRealm(tenantId) != null) {
                UserRealm realm = realmService.getTenantUserRealm(tenantId);
                String primaryDomainName = realm.getRealmConfiguration().getUserStoreProperty("DomainName");
                claimMapping.setMappedAttribute(localClaim.getMappedAttribute(primaryDomainName));
            } else {
                claimMapping.setMappedAttribute(localClaim.getMappedAttribute("PRIMARY"));
            }
        }
        return claimMapping;
    }

    public static ClaimMapping convertExternalClaimToClaimMapping(ExternalClaim externalClaim, List<LocalClaim> localClaims, int tenantId) throws UserStoreException {
        ClaimMapping claimMapping = new ClaimMapping();
        if (localClaims != null) {
            for (LocalClaim localClaim : localClaims) {
                if (!externalClaim.getMappedLocalClaim().equalsIgnoreCase(localClaim.getClaimURI())) continue;
                claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, tenantId);
                break;
            }
        }
        if (claimMapping == null) {
            claimMapping = new ClaimMapping();
        }
        if (claimMapping.getClaim() == null) {
            Claim claim = new Claim();
            claimMapping.setClaim((org.wso2.carbon.user.api.Claim)claim);
        }
        claimMapping.getClaim().setDialectURI(externalClaim.getClaimDialectURI());
        claimMapping.getClaim().setClaimUri(externalClaim.getClaimURI());
        return claimMapping;
    }
}

