/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.identity.claim.metadata.mgt.model.AttributeMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.model.Claim;

public class LocalClaim
extends Claim {
    private List<AttributeMapping> mappedAttributes;

    public LocalClaim(String claimURI) {
        super("http://wso2.org/claims", claimURI);
        this.mappedAttributes = new ArrayList<AttributeMapping>();
    }

    public LocalClaim(String claimURI, List<AttributeMapping> mappedAttributes, Map<String, String> claimProperties) {
        super("http://wso2.org/claims", claimURI, claimProperties);
        if (mappedAttributes == null) {
            mappedAttributes = new ArrayList<AttributeMapping>();
        }
        this.mappedAttributes = mappedAttributes;
    }

    public List<AttributeMapping> getMappedAttributes() {
        return this.mappedAttributes;
    }

    public String getMappedAttribute(String userStoreDomainName) {
        for (AttributeMapping mappedAttribute : this.getMappedAttributes()) {
            if (!mappedAttribute.getUserStoreDomain().equals(userStoreDomainName.toUpperCase())) continue;
            return mappedAttribute.getAttributeName();
        }
        return null;
    }

    public void setMappedAttributes(List<AttributeMapping> mappedAttributes) {
        if (mappedAttributes == null) {
            mappedAttributes = new ArrayList<AttributeMapping>();
        }
        this.mappedAttributes = mappedAttributes;
    }

    public void setMappedAttribute(AttributeMapping mappedAttribute) {
        this.mappedAttributes.add(mappedAttribute);
    }
}

