/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementServiceImpl;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataStoreFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.internal.IdentityClaimManagementServiceDataHolder;
import org.wso2.carbon.identity.claim.metadata.mgt.listener.ClaimConfigListener;
import org.wso2.carbon.identity.claim.metadata.mgt.listener.ClaimMetadataTenantMgtListener;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.user.store.configuration.listener.UserStoreConfigListener;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.stratos.common.listeners.TenantMgtListener;
import org.wso2.carbon.user.core.claim.ClaimManagerFactory;
import org.wso2.carbon.user.core.listener.ClaimManagerListener;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="identity.claim.metadata.component", immediate=true)
public class IdentityClaimManagementServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityClaimManagementServiceComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bundleCtx = ctxt.getBundleContext();
            IdentityClaimManagementServiceDataHolder.getInstance().setBundleContext(bundleCtx);
            ClaimMetadataStoreFactory claimMetadataStoreFactory = new ClaimMetadataStoreFactory();
            bundleCtx.registerService(ClaimManagerFactory.class.getName(), (Object)claimMetadataStoreFactory, null);
            ClaimMetadataManagementServiceImpl claimManagementService = new ClaimMetadataManagementServiceImpl();
            bundleCtx.registerService(ClaimMetadataManagementService.class.getName(), (Object)claimManagementService, null);
            IdentityClaimManagementServiceDataHolder.getInstance().setClaimManagementService(claimManagementService);
            bundleCtx.registerService(TenantMgtListener.class.getName(), (Object)new ClaimMetadataTenantMgtListener(), null);
            this.registerClaimConfigListener(bundleCtx);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Identity Claim Management Core bundle is activated");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error occurred while activating Identity Claim Management Service Component", e);
        }
    }

    private void registerClaimConfigListener(BundleContext bundleCtx) {
        ClaimConfigListener claimConfigListener = new ClaimConfigListener();
        ServiceRegistration mappedClaimConfigListenerSR = bundleCtx.registerService(UserStoreConfigListener.class.getName(), (Object)claimConfigListener, null);
        if (mappedClaimConfigListenerSR != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ClaimConfigListener Service registered.");
            }
        } else {
            log.error((Object)"Error registering ClaimConfigListener Service.");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Claim Management bundle is deactivated");
        }
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        IdentityClaimManagementServiceDataHolder.getInstance().setRealmService(realmService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService set in Identity Claim Management bundle");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        IdentityClaimManagementServiceDataHolder.getInstance().setRealmService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService unset in Identity Claim Management bundle");
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        IdentityClaimManagementServiceDataHolder.getInstance().setRegistryService(registryService);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Identity Claim Management bundle");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        IdentityClaimManagementServiceDataHolder.getInstance().setRegistryService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Identity Claim Management bundle");
        }
    }

    @Reference(name="claim.manager.listener.service", service=ClaimManagerListener.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetClaimManagerListener")
    public synchronized void setClaimManagerListener(ClaimManagerListener claimManagerListener) {
        IdentityClaimManagementServiceDataHolder.getInstance().setClaimManagerListener(claimManagerListener);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ClaimManagerListener set in Identity Claim Management bundle");
        }
    }

    public synchronized void unsetClaimManagerListener(ClaimManagerListener claimManagerListener) {
        IdentityClaimManagementServiceDataHolder.getInstance().unsetClaimManagerListener(claimManagerListener);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ClaimManagerListener unset in Identity Claim Management bundle");
        }
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

