/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.AttributeMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.model.Claim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.util.ClaimConstants;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.user.api.UserStoreException;

public class LocalClaimDAO
extends ClaimDAO {
    private static final Log log = LogFactory.getLog(LocalClaimDAO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LocalClaim> getLocalClaims(int tenantId) throws ClaimMetadataException {
        ArrayList<LocalClaim> localClaims = new ArrayList<LocalClaim>();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        try {
            Map<Integer, Claim> localClaimMap = this.getClaims(connection, "http://wso2.org/claims", tenantId);
            Map<Integer, List<AttributeMapping>> claimAttributeMappingsOfDialect = this.getClaimAttributeMappingsOfDialect(connection, "http://wso2.org/claims", tenantId);
            Map<Integer, Map<String, String>> claimPropertiesOfDialect = this.getClaimPropertiesOfDialect(connection, "http://wso2.org/claims", tenantId);
            for (Map.Entry<Integer, Claim> claimEntry : localClaimMap.entrySet()) {
                int claimId = claimEntry.getKey();
                Claim claim = claimEntry.getValue();
                List<AttributeMapping> attributeMappingsOfClaim = claimAttributeMappingsOfDialect.get(claimId);
                Map<String, String> propertiesOfClaim = claimPropertiesOfDialect.get(claimId);
                localClaims.add(new LocalClaim(claim.getClaimURI(), attributeMappingsOfClaim, propertiesOfClaim));
            }
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
        return localClaims;
    }

    private Map<Integer, List<AttributeMapping>> getClaimAttributeMappingsOfDialect(Connection connection, String claimDialectURI, int tenantId) throws ClaimMetadataException {
        HashMap<Integer, List<AttributeMapping>> attributeMappings = new HashMap<Integer, List<AttributeMapping>>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT IDN_CLAIM_MAPPED_ATTRIBUTE.USER_STORE_DOMAIN_NAME, IDN_CLAIM_MAPPED_ATTRIBUTE.ATTRIBUTE_NAME, IDN_CLAIM_MAPPED_ATTRIBUTE.LOCAL_CLAIM_ID FROM IDN_CLAIM_MAPPED_ATTRIBUTE INNER JOIN IDN_CLAIM ON IDN_CLAIM_MAPPED_ATTRIBUTE.LOCAL_CLAIM_ID = IDN_CLAIM.ID INNER JOIN IDN_CLAIM_DIALECT ON IDN_CLAIM.DIALECT_ID = IDN_CLAIM_DIALECT.ID WHERE IDN_CLAIM_DIALECT.DIALECT_URI=? AND IDN_CLAIM_DIALECT.TENANT_ID=? AND IDN_CLAIM.TENANT_ID=? AND IDN_CLAIM_MAPPED_ATTRIBUTE.TENANT_ID=? ORDER BY IDN_CLAIM_MAPPED_ATTRIBUTE.LOCAL_CLAIM_ID");
            preparedStatement.setString(1, claimDialectURI);
            preparedStatement.setInt(2, tenantId);
            preparedStatement.setInt(3, tenantId);
            preparedStatement.setInt(4, tenantId);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String userStoreDomainName = resultSet.getString("USER_STORE_DOMAIN_NAME");
                String attributeName = resultSet.getString("ATTRIBUTE_NAME");
                int localClaimId = resultSet.getInt("LOCAL_CLAIM_ID");
                AttributeMapping attributeMapping = new AttributeMapping(userStoreDomainName, attributeName);
                ArrayList<AttributeMapping> existingAttributeMapping = (ArrayList<AttributeMapping>)attributeMappings.get(localClaimId);
                if (existingAttributeMapping == null) {
                    existingAttributeMapping = new ArrayList<AttributeMapping>();
                }
                existingAttributeMapping.add(attributeMapping);
                attributeMappings.put(localClaimId, existingAttributeMapping);
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error occurred while retrieving attribute mappings.", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(resultSet);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)preparedStatement);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)resultSet);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)preparedStatement);
        return attributeMappings;
    }

    private Map<Integer, Map<String, String>> getClaimPropertiesOfDialect(Connection connection, String claimDialectURI, int tenantId) throws ClaimMetadataException {
        HashMap<Integer, Map<String, String>> claimPropertyMap = new HashMap<Integer, Map<String, String>>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT IDN_CLAIM_PROPERTY.PROPERTY_NAME, IDN_CLAIM_PROPERTY.PROPERTY_VALUE, IDN_CLAIM_PROPERTY.LOCAL_CLAIM_ID FROM IDN_CLAIM_PROPERTY INNER JOIN IDN_CLAIM ON IDN_CLAIM_PROPERTY.LOCAL_CLAIM_ID = IDN_CLAIM.ID INNER JOIN IDN_CLAIM_DIALECT ON IDN_CLAIM.DIALECT_ID = IDN_CLAIM_DIALECT.ID AND IDN_CLAIM_DIALECT.DIALECT_URI=? AND IDN_CLAIM_DIALECT.TENANT_ID=? AND IDN_CLAIM.TENANT_ID=? ORDER BY IDN_CLAIM_PROPERTY.LOCAL_CLAIM_ID");
            preparedStatement.setString(1, claimDialectURI);
            preparedStatement.setInt(2, tenantId);
            preparedStatement.setInt(3, tenantId);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String propertyName = resultSet.getString("PROPERTY_NAME");
                String propertyValue = resultSet.getString("PROPERTY_VALUE");
                int localClaimId = resultSet.getInt("LOCAL_CLAIM_ID");
                HashMap<String, String> existingAttributeMap = (HashMap<String, String>)claimPropertyMap.get(localClaimId);
                if (existingAttributeMap == null) {
                    existingAttributeMap = new HashMap<String, String>();
                }
                existingAttributeMap.put(propertyName, propertyValue);
                claimPropertyMap.put(localClaimId, existingAttributeMap);
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error occurred while retrieving attribute mappings.", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(resultSet);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)preparedStatement);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)resultSet);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)preparedStatement);
        return claimPropertyMap;
    }

    public void addLocalClaim(LocalClaim localClaim, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        Object prepStmt = null;
        String localClaimURI = localClaim.getClaimURI();
        try {
            connection.setAutoCommit(false);
            int localClaimId = this.addClaim(connection, "http://wso2.org/claims", localClaimURI, tenantId);
            if (localClaimId == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JDBC Driver did not return the claimId, executing Select operation");
                }
                localClaimId = this.getClaimId(connection, "http://wso2.org/claims", localClaimURI, tenantId);
            }
            this.addClaimAttributeMappings(connection, localClaimId, localClaim.getMappedAttributes(), tenantId);
            this.addClaimProperties(connection, localClaimId, localClaim.getClaimProperties(), tenantId);
            connection.commit();
        }
        catch (SQLException e) {
            LocalClaimDAO.rollbackTransaction(connection);
            throw new ClaimMetadataException("Error while adding local claim " + localClaimURI, e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void updateLocalClaim(LocalClaim localClaim, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        Object prepStmt = null;
        String localClaimURI = localClaim.getClaimURI();
        try {
            connection.setAutoCommit(false);
            int localClaimId = this.getClaimId(connection, "http://wso2.org/claims", localClaimURI, tenantId);
            this.deleteClaimAttributeMappings(connection, localClaimId, tenantId);
            this.addClaimAttributeMappings(connection, localClaimId, localClaim.getMappedAttributes(), tenantId);
            this.deleteClaimProperties(connection, localClaimId, tenantId);
            this.addClaimProperties(connection, localClaimId, localClaim.getClaimProperties(), tenantId);
            connection.commit();
        }
        catch (SQLException e) {
            LocalClaimDAO.rollbackTransaction(connection);
            throw new ClaimMetadataException("Error while updating local claim " + localClaimURI, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, null);
        }
    }

    public void removeLocalClaim(String localClaimURI, int tenantId) throws ClaimMetadataException {
        this.removeClaim("http://wso2.org/claims", localClaimURI, tenantId);
    }

    public void deleteClaimMappingAttributes(int tenantId, String userstoreDomain) throws UserStoreException {
        if (StringUtils.isEmpty((String)userstoreDomain)) {
            String message = ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_TENANT_DOMAIN.getMessage();
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new UserStoreException(message);
        }
        userstoreDomain = userstoreDomain.toUpperCase();
        try (Connection dbConnection = IdentityDatabaseUtil.getDBConnection((boolean)true);
             PreparedStatement preparedStatement = dbConnection.prepareStatement("DELETE FROM IDN_CLAIM_MAPPED_ATTRIBUTE WHERE USER_STORE_DOMAIN_NAME=? AND TENANT_ID=?");){
            preparedStatement.setString(1, userstoreDomain);
            preparedStatement.setInt(2, tenantId);
            preparedStatement.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)dbConnection);
        }
        catch (SQLException e) {
            String message = String.format(ClaimConstants.ErrorMessage.ERROR_CODE_DELETE_IDN_CLAIM_MAPPED_ATTRIBUTE.getMessage(), userstoreDomain, tenantId);
            throw new UserStoreException(message, (Throwable)e);
        }
    }

    private void addClaimAttributeMappings(Connection connection, int localClaimId, List<AttributeMapping> attributeMappings, int tenantId) throws ClaimMetadataException {
        PreparedStatement prepStmt = null;
        if (localClaimId > 0 && attributeMappings != null) {
            try {
                String query = "INSERT INTO IDN_CLAIM_MAPPED_ATTRIBUTE (LOCAL_CLAIM_ID, USER_STORE_DOMAIN_NAME, ATTRIBUTE_NAME, TENANT_ID) VALUES (?, ?, ?, ?)";
                prepStmt = connection.prepareStatement(query);
                for (AttributeMapping attributeMapping : attributeMappings) {
                    if (StringUtils.isBlank((String)attributeMapping.getUserStoreDomain())) {
                        throw new ClaimMetadataException("User store domain of mapped Attribute cannot be empty for the local claim id : " + localClaimId);
                    }
                    if (StringUtils.isBlank((String)attributeMapping.getAttributeName())) {
                        throw new ClaimMetadataException("Mapped attribute of the local claim id : " + localClaimId + " cannot be empty");
                    }
                    prepStmt.setInt(1, localClaimId);
                    prepStmt.setString(2, attributeMapping.getUserStoreDomain());
                    prepStmt.setString(3, attributeMapping.getAttributeName());
                    prepStmt.setInt(4, tenantId);
                    prepStmt.addBatch();
                }
                prepStmt.executeBatch();
            }
            catch (SQLException e) {
                try {
                    throw new ClaimMetadataException("Error while adding attribute mappings", e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    throw throwable;
                }
            }
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    private void deleteClaimAttributeMappings(Connection connection, int localClaimId, int tenantId) throws ClaimMetadataException {
        PreparedStatement prepStmt = null;
        try {
            String query = "DELETE FROM IDN_CLAIM_MAPPED_ATTRIBUTE WHERE LOCAL_CLAIM_ID=? AND TENANT_ID=?";
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, localClaimId);
            prepStmt.setInt(2, tenantId);
            prepStmt.execute();
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while deleting attribute mappings", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
    }

    private static void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }
}

