/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class ExternalClaimDAO
extends ClaimDAO {
    private static final Log log = LogFactory.getLog(ExternalClaimDAO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ExternalClaim> getExternalClaims(String externalDialectURI, int tenantId) throws ClaimMetadataException {
        ArrayList<ExternalClaim> externalClaims = new ArrayList();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        try {
            externalClaims = this.getExternalClaimsFromDB(connection, externalDialectURI, tenantId);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
        return externalClaims;
    }

    public void addExternalClaim(ExternalClaim externalClaim, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        Object prepStmt = null;
        String externalClaimURI = externalClaim.getClaimURI();
        String externalClaimDialectURI = externalClaim.getClaimDialectURI();
        String mappedLocalClaimURI = externalClaim.getMappedLocalClaim();
        try {
            connection.setAutoCommit(false);
            int localClaimId = this.getClaimId(connection, "http://wso2.org/claims", mappedLocalClaimURI, tenantId);
            int externalClaimId = this.addClaim(connection, externalClaimDialectURI, externalClaimURI, tenantId);
            if (externalClaimId == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"JDBC Driver did not return the claimId, executing Select operation");
                }
                externalClaimId = this.getClaimId(connection, externalClaimDialectURI, externalClaimURI, tenantId);
            }
            this.addClaimMapping(connection, externalClaimId, localClaimId, tenantId);
            this.addClaimProperties(connection, externalClaimId, externalClaim.getClaimProperties(), tenantId);
            connection.commit();
        }
        catch (SQLException e) {
            this.rollbackTransaction(connection);
            throw new ClaimMetadataException("Error while adding external claim " + externalClaimURI + " to dialect " + externalClaimDialectURI, e);
        }
        finally {
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void updateExternalClaim(ExternalClaim externalClaim, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        String externalClaimURI = externalClaim.getClaimURI();
        String externalClaimDialectURI = externalClaim.getClaimDialectURI();
        String mappedLocalClaimURI = externalClaim.getMappedLocalClaim();
        try {
            connection.setAutoCommit(false);
            int externalClaimId = this.getClaimId(connection, externalClaimDialectURI, externalClaimURI, tenantId);
            int localClaimId = this.getClaimId(connection, "http://wso2.org/claims", mappedLocalClaimURI, tenantId);
            this.updateClaimMapping(connection, externalClaimId, localClaimId, tenantId);
            this.deleteClaimProperties(connection, externalClaimId, tenantId);
            this.addClaimProperties(connection, externalClaimId, externalClaim.getClaimProperties(), tenantId);
            connection.commit();
        }
        catch (SQLException e) {
            this.rollbackTransaction(connection);
            throw new ClaimMetadataException("Error while updating external claim " + externalClaimURI + " in dialect " + externalClaimDialectURI, e);
        }
        finally {
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, null, null);
        }
    }

    public void removeExternalClaim(String externalClaimDialectURI, String externalClaimURI, int tenantId) throws ClaimMetadataException {
        this.removeClaim(externalClaimDialectURI, externalClaimURI, tenantId);
    }

    public boolean isMappedLocalClaim(String mappedLocalClaimURI, int tenantId) throws ClaimMetadataException {
        boolean isMappedLocalClaim = false;
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "SELECT MAPPED_LOCAL_CLAIM_ID FROM IDN_CLAIM_MAPPING WHERE MAPPED_LOCAL_CLAIM_ID=(SELECT ID FROM IDN_CLAIM WHERE DIALECT_ID=(SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?) AND CLAIM_URI=? AND TENANT_ID=?) AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, "http://wso2.org/claims");
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, mappedLocalClaimURI);
            prepStmt.setInt(4, tenantId);
            prepStmt.setInt(5, tenantId);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                isMappedLocalClaim = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while checking mapped local claim " + mappedLocalClaimURI, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return isMappedLocalClaim;
    }

    private void addClaimMapping(Connection connection, int externalClaimId, int localClaimId, int tenantId) throws ClaimMetadataException {
        PreparedStatement prepStmt = null;
        String query = "INSERT INTO IDN_CLAIM_MAPPING (MAPPED_LOCAL_CLAIM_ID, EXT_CLAIM_ID, TENANT_ID) VALUES (?, ?, ?)";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, localClaimId);
            prepStmt.setInt(2, externalClaimId);
            prepStmt.setInt(3, tenantId);
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new ClaimMetadataException("Error while adding claim mapping", e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    private void updateClaimMapping(Connection connection, int externalClaimId, int localClaimId, int tenantId) throws ClaimMetadataException {
        PreparedStatement prepStmt = null;
        String query = "UPDATE IDN_CLAIM_MAPPING SET MAPPED_LOCAL_CLAIM_ID=? WHERE EXT_CLAIM_ID=? AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, localClaimId);
            prepStmt.setInt(2, externalClaimId);
            prepStmt.setInt(3, tenantId);
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            throw new ClaimMetadataException("Error while updating claim mapping", e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        }
    }

    private String getClaimMapping(Connection connection, int externalClaimId, int tenantId) throws ClaimMetadataException {
        String mappedLocalClaimURI = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "SELECT CLAIM_URI FROM IDN_CLAIM WHERE ID=(SELECT MAPPED_LOCAL_CLAIM_ID FROM IDN_CLAIM_MAPPING WHERE EXT_CLAIM_ID=? AND TENANT_ID=?) AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, externalClaimId);
            prepStmt.setInt(2, tenantId);
            prepStmt.setInt(3, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                mappedLocalClaimURI = rs.getString("CLAIM_URI");
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while retrieving claim mapping", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        if (StringUtils.isBlank((String)mappedLocalClaimURI)) {
            throw new ClaimMetadataException("Invalid external claim URI. Claim mapping cannot be empty.");
        }
        return mappedLocalClaimURI;
    }

    private List<ExternalClaim> getExternalClaimsFromDB(Connection connection, String claimDialectURI, int tenantId) throws ClaimMetadataException {
        HashMap<Integer, ExternalClaim> claimMap = new HashMap<Integer, ExternalClaim>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "SELECT CLAIMS.ID, PROPERTY.PROPERTY_NAME, PROPERTY.PROPERTY_VALUE, CLAIMS.CLAIM_URI, RESOLVED.CLAIM_URI MAPPED_URI FROM IDN_CLAIM CLAIMS LEFT JOIN IDN_CLAIM_PROPERTY PROPERTY ON PROPERTY.LOCAL_CLAIM_ID=CLAIMS.ID AND CLAIMS.TENANT_ID=PROPERTY.TENANT_ID INNER JOIN IDN_CLAIM_MAPPING MAPPING ON MAPPING.EXT_CLAIM_ID=CLAIMS.ID  AND CLAIMS.TENANT_ID=MAPPING.TENANT_ID INNER JOIN IDN_CLAIM RESOLVED          ON RESOLVED.ID=MAPPING.MAPPED_LOCAL_CLAIM_ID AND RESOLVED.TENANT_ID=MAPPING.TENANT_ID WHERE CLAIMS.DIALECT_ID=(SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?) AND CLAIMS.TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setInt(3, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String claimPropertyName = rs.getString("PROPERTY_NAME");
                String claimPropertyValue = rs.getString("PROPERTY_VALUE");
                int localId = rs.getInt("ID");
                if (claimMap.get(localId) == null) {
                    String mappedURI = rs.getString("MAPPED_URI");
                    String claimURI = rs.getString("CLAIM_URI");
                    HashMap<String, String> propmap = new HashMap<String, String>();
                    propmap.put(claimPropertyName, claimPropertyValue);
                    ExternalClaim temp = new ExternalClaim(claimDialectURI, claimURI, mappedURI, propmap);
                    claimMap.put(localId, temp);
                    continue;
                }
                ((ExternalClaim)claimMap.get(localId)).getClaimProperties().put(claimPropertyName, claimPropertyValue);
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while listing claims for dialect " + claimDialectURI, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return new ArrayList<ExternalClaim>(claimMap.values());
    }

    private void rollbackTransaction(Connection dbConnection) {
        try {
            if (dbConnection != null) {
                dbConnection.rollback();
            }
        }
        catch (SQLException e1) {
            log.error((Object)"An error occurred while rolling back transactions. ", (Throwable)e1);
        }
    }
}

