/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class ClaimDialectDAO {
    private static final Log log = LogFactory.getLog(ClaimDialectDAO.class);

    public List<ClaimDialect> getClaimDialects(int tenantId) throws ClaimMetadataException {
        ArrayList<ClaimDialect> claimDialects = new ArrayList<ClaimDialect>();
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "SELECT DIALECT_URI FROM IDN_CLAIM_DIALECT WHERE TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String claimDialectURI = rs.getString("DIALECT_URI");
                ClaimDialect claimDialect = new ClaimDialect(claimDialectURI);
                claimDialects.add(claimDialect);
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while listing claim dialects", e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, rs, (PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)rs, (PreparedStatement)prepStmt);
        return claimDialects;
    }

    public void addClaimDialect(ClaimDialect claimDialect, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String query = "INSERT INTO IDN_CLAIM_DIALECT (DIALECT_URI, TENANT_ID) VALUES (?, ?)";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialect.getClaimDialectURI());
            prepStmt.setInt(2, tenantId);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new ClaimMetadataException("Error while adding claim dialect " + claimDialect.getClaimDialectURI(), e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void renameClaimDialect(ClaimDialect oldClaimDialect, ClaimDialect newClaimDialect, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String query = "UPDATE IDN_CLAIM_DIALECT SET DIALECT_URI=? WHERE DIALECT_URI=? AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, newClaimDialect.getClaimDialectURI());
            prepStmt.setString(2, oldClaimDialect.getClaimDialectURI());
            prepStmt.setInt(3, tenantId);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new ClaimMetadataException("Error while renaming claim dialect " + oldClaimDialect.getClaimDialectURI(), e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void removeClaimDialect(ClaimDialect claimDialect, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String query = "DELETE FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialect.getClaimDialectURI());
            prepStmt.setInt(2, tenantId);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new ClaimMetadataException("Error while deleting claim dialect " + claimDialect.getClaimDialectURI(), e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public void removeAllClaimDialects(int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection((boolean)false);
        PreparedStatement prepStmt = null;
        String query = "DELETE FROM IDN_CLAIM_DIALECT WHERE TENANT_ID = ?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setInt(1, tenantId);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new ClaimMetadataException("Error while deleting claim dialects of tenant: " + tenantId, e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }
}

