/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataClientException;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.Claim;
import org.wso2.carbon.identity.claim.metadata.mgt.util.ClaimConstants;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.utils.DBUtils;

public class ClaimDAO {
    private static final Log log = LogFactory.getLog(ClaimDAO.class);

    public Map<Integer, Claim> getClaims(Connection connection, String claimDialectURI, int tenantId) throws ClaimMetadataException {
        HashMap<Integer, Claim> claimMap = new HashMap<Integer, Claim>();
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        String query = "SELECT ID, CLAIM_URI FROM IDN_CLAIM WHERE DIALECT_ID=(SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?) AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setInt(3, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                String claimURI = rs.getString("CLAIM_URI");
                int claimId = rs.getInt("ID");
                claimMap.put(claimId, new Claim(claimDialectURI, claimURI));
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while listing claims for dialect " + claimDialectURI, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return claimMap;
    }

    public int addClaim(Connection connection, String claimDialectURI, String claimURI, int tenantId) throws ClaimMetadataException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int claimId = 0;
        String query = "INSERT INTO IDN_CLAIM (DIALECT_ID, CLAIM_URI, TENANT_ID) VALUES ((SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?), ?, ?)";
        try {
            String dbProductName = connection.getMetaData().getDatabaseProductName();
            prepStmt = connection.prepareStatement(query, new String[]{DBUtils.getConvertedAutoGeneratedColumnName((String)dbProductName, (String)"ID")});
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, claimURI);
            prepStmt.setInt(4, tenantId);
            prepStmt.executeUpdate();
            rs = prepStmt.getGeneratedKeys();
            if (rs.next()) {
                claimId = rs.getInt(1);
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while adding claim " + claimURI + " to dialect " + claimDialectURI, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement(prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return claimId;
    }

    public void removeClaim(String claimDialectURI, String localClaimURI, int tenantId) throws ClaimMetadataException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        String query = "DELETE FROM IDN_CLAIM WHERE DIALECT_ID=(SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?) AND CLAIM_URI=? AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, localClaimURI);
            prepStmt.setInt(4, tenantId);
            prepStmt.executeUpdate();
            IdentityDatabaseUtil.commitTransaction((Connection)connection);
        }
        catch (SQLException e) {
            IdentityDatabaseUtil.rollbackTransaction((Connection)connection);
            throw new ClaimMetadataException("Error while deleting claim " + localClaimURI + " from dialect" + claimDialectURI, e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    public int getClaimId(Connection connection, String claimDialectURI, String claimURI, int tenantId) throws ClaimMetadataException {
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        int claimId = 0;
        String query = "SELECT ID FROM IDN_CLAIM WHERE DIALECT_ID=(SELECT ID FROM IDN_CLAIM_DIALECT WHERE DIALECT_URI=? AND TENANT_ID=?) AND CLAIM_URI=? AND TENANT_ID=?";
        try {
            prepStmt = connection.prepareStatement(query);
            prepStmt.setString(1, claimDialectURI);
            prepStmt.setInt(2, tenantId);
            prepStmt.setString(3, claimURI);
            prepStmt.setInt(4, tenantId);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                claimId = rs.getInt("ID");
            }
        }
        catch (SQLException e) {
            try {
                throw new ClaimMetadataException("Error while retrieving ID for claim " + claimURI + " in dialect " + claimDialectURI, e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeResultSet(rs);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)rs);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        if (claimId == 0) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_MAPPED_TO_INVALID_LOCAL_CLAIM_URI.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_MAPPED_TO_INVALID_LOCAL_CLAIM_URI.getMessage(), claimURI, claimDialectURI));
        }
        return claimId;
    }

    public Map<String, String> getClaimProperties(Connection connection, int claimId, int tenantId) throws ClaimMetadataException {
        HashMap<String, String> claimProperties = new HashMap<String, String>();
        String query = "SELECT PROPERTY_NAME, PROPERTY_VALUE FROM IDN_CLAIM_PROPERTY WHERE LOCAL_CLAIM_ID=? AND TENANT_ID=?";
        try (PreparedStatement prepStmt = connection.prepareStatement(query);){
            prepStmt.setInt(1, claimId);
            prepStmt.setInt(2, tenantId);
            try (ResultSet rs = prepStmt.executeQuery();){
                while (rs.next()) {
                    String claimPropertyName = rs.getString("PROPERTY_NAME");
                    String claimPropertyValue = rs.getString("PROPERTY_VALUE");
                    claimProperties.put(claimPropertyName, claimPropertyValue);
                }
            }
        }
        catch (SQLException e) {
            throw new ClaimMetadataException("Error while retrieving claim properties", e);
        }
        return claimProperties;
    }

    public void addClaimProperties(Connection connection, int claimId, Map<String, String> claimProperties, int tenantId) throws ClaimMetadataException {
        if (claimId > 0 && claimProperties != null) {
            String query = "INSERT INTO IDN_CLAIM_PROPERTY (LOCAL_CLAIM_ID, PROPERTY_NAME, PROPERTY_VALUE, TENANT_ID) VALUES (?, ?, ?, ?)";
            try (PreparedStatement prepStmt = connection.prepareStatement(query);){
                for (Map.Entry<String, String> property : claimProperties.entrySet()) {
                    prepStmt.setInt(1, claimId);
                    prepStmt.setString(2, property.getKey());
                    prepStmt.setString(3, property.getValue());
                    prepStmt.setInt(4, tenantId);
                    prepStmt.addBatch();
                }
                prepStmt.executeBatch();
            }
            catch (SQLException e) {
                throw new ClaimMetadataException("Error while adding claim properties", e);
            }
        }
    }

    protected void deleteClaimProperties(Connection connection, int claimId, int tenantId) throws ClaimMetadataException {
        String query = "DELETE FROM IDN_CLAIM_PROPERTY WHERE LOCAL_CLAIM_ID=? AND TENANT_ID=?";
        try (PreparedStatement prepStmt = connection.prepareStatement(query);){
            prepStmt.setInt(1, claimId);
            prepStmt.setInt(2, tenantId);
            prepStmt.execute();
        }
        catch (SQLException e) {
            throw new ClaimMetadataException("Error while deleting claim properties", e);
        }
    }
}

