/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.dao;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.cache.LocalClaimCache;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.LocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.util.ClaimConstants;
import org.wso2.carbon.user.api.UserStoreException;

public class CacheBackedLocalClaimDAO {
    private static final Log log = LogFactory.getLog(CacheBackedLocalClaimDAO.class);
    LocalClaimDAO localClaimDAO;
    LocalClaimCache localClaimInvalidationCache = LocalClaimCache.getInstance();

    public CacheBackedLocalClaimDAO(LocalClaimDAO localClaimDAO) {
        this.localClaimDAO = localClaimDAO;
    }

    public List<LocalClaim> getLocalClaims(int tenantId) throws ClaimMetadataException {
        List<LocalClaim> localClaimList = (List<LocalClaim>)this.localClaimInvalidationCache.getValueFromCache(tenantId);
        if (localClaimList == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache miss for local claim list for tenant: " + tenantId));
            }
            localClaimList = this.localClaimDAO.getLocalClaims(tenantId);
            this.localClaimInvalidationCache.addToCache(tenantId, new ArrayList<LocalClaim>(localClaimList));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cache hit for local claim list for tenant: " + tenantId));
        }
        return localClaimList;
    }

    public void addLocalClaim(LocalClaim localClaim, int tenantId) throws ClaimMetadataException {
        this.localClaimDAO.addLocalClaim(localClaim, tenantId);
        this.localClaimInvalidationCache.clearCacheEntry(tenantId);
    }

    public void updateLocalClaim(LocalClaim localClaim, int tenantId) throws ClaimMetadataException {
        this.localClaimDAO.updateLocalClaim(localClaim, tenantId);
        this.localClaimInvalidationCache.clearCacheEntry(tenantId);
    }

    public void removeLocalClaim(String localClaimURI, int tenantId) throws ClaimMetadataException {
        this.localClaimDAO.removeLocalClaim(localClaimURI, tenantId);
        this.localClaimInvalidationCache.clearCacheEntry(tenantId);
    }

    public void removeClaimMappingAttributes(int tenantId, String userstoreDomain) throws UserStoreException {
        if (StringUtils.isEmpty((String)userstoreDomain)) {
            String message = ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_TENANT_DOMAIN.getMessage();
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new UserStoreException(message);
        }
        this.localClaimDAO.deleteClaimMappingAttributes(tenantId, userstoreDomain);
        this.localClaimInvalidationCache.clearCacheEntry(tenantId);
    }
}

