/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.dao;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.cache.ExternalClaimCache;
import org.wso2.carbon.identity.claim.metadata.mgt.cache.ExternalClaimCacheKey;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ExternalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;

public class CacheBackedExternalClaimDAO {
    private static final Log log = LogFactory.getLog(CacheBackedExternalClaimDAO.class);
    ExternalClaimDAO externalClaimDAO;
    ExternalClaimCache externalClaimCache = ExternalClaimCache.getInstance();

    public CacheBackedExternalClaimDAO(ExternalClaimDAO externalClaimDAO) {
        this.externalClaimDAO = externalClaimDAO;
    }

    public List<ExternalClaim> getExternalClaims(String externalDialectURI, int tenantId) throws ClaimMetadataException {
        ExternalClaimCacheKey cacheKey = new ExternalClaimCacheKey(externalDialectURI, tenantId);
        List<ExternalClaim> externalClaimList = (List<ExternalClaim>)this.externalClaimCache.getValueFromCache(cacheKey);
        if (externalClaimList == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache miss for external claim list for dialect: " + externalDialectURI + " in tenant: " + tenantId));
            }
            externalClaimList = this.externalClaimDAO.getExternalClaims(externalDialectURI, tenantId);
            this.externalClaimCache.addToCache(cacheKey, new ArrayList<ExternalClaim>(externalClaimList));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cache hit for external claim list for dialect: " + externalDialectURI + " in tenant: " + tenantId));
        }
        return externalClaimList;
    }

    public void addExternalClaim(ExternalClaim externalClaim, int tenantId) throws ClaimMetadataException {
        this.externalClaimDAO.addExternalClaim(externalClaim, tenantId);
        String externalClaimDialectURI = externalClaim.getClaimDialectURI();
        ExternalClaimCacheKey cacheKey = new ExternalClaimCacheKey(externalClaimDialectURI, tenantId);
        this.externalClaimCache.clearCacheEntry(cacheKey);
    }

    public void updateExternalClaim(ExternalClaim externalClaim, int tenantId) throws ClaimMetadataException {
        this.externalClaimDAO.updateExternalClaim(externalClaim, tenantId);
        String externalClaimDialectURI = externalClaim.getClaimDialectURI();
        ExternalClaimCacheKey cacheKey = new ExternalClaimCacheKey(externalClaimDialectURI, tenantId);
        this.externalClaimCache.clearCacheEntry(cacheKey);
    }

    public void removeExternalClaim(String externalClaimDialectURI, String externalClaimURI, int tenantId) throws ClaimMetadataException {
        this.externalClaimDAO.removeExternalClaim(externalClaimDialectURI, externalClaimURI, tenantId);
        ExternalClaimCacheKey cacheKey = new ExternalClaimCacheKey(externalClaimDialectURI, tenantId);
        this.externalClaimCache.clearCacheEntry(cacheKey);
    }

    public boolean isMappedLocalClaim(String mappedLocalClaimURI, int tenantId) throws ClaimMetadataException {
        return this.externalClaimDAO.isMappedLocalClaim(mappedLocalClaimURI, tenantId);
    }

    public void removeExternalClaimCache(String externalClaimDialectURI, int tenantId) {
        ExternalClaimCacheKey cacheKey = new ExternalClaimCacheKey(externalClaimDialectURI, tenantId);
        this.externalClaimCache.clearCacheEntry(cacheKey);
    }
}

