/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.dao;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.cache.ClaimDialectCache;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDialectDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;

public class CacheBackedClaimDialectDAO
extends ClaimDialectDAO {
    private static final Log log = LogFactory.getLog(CacheBackedClaimDialectDAO.class);
    private ClaimDialectCache claimDialectCache = ClaimDialectCache.getInstance();

    @Override
    public List<ClaimDialect> getClaimDialects(int tenantId) throws ClaimMetadataException {
        List<ClaimDialect> claimDialectList = this.claimDialectCache.getClaimDialects(tenantId);
        if (claimDialectList != null && !claimDialectList.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache hit for claim dialect list for tenant: " + tenantId + ". Claim dialect list size: " + claimDialectList.size()));
            }
            return claimDialectList;
        }
        claimDialectList = super.getClaimDialects(tenantId);
        this.claimDialectCache.putClaimDialects(tenantId, claimDialectList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache miss for claim dialect list for tenant: " + tenantId + ". Updated cache with claim dialect list retrieved from database. Claim dialect list size: " + claimDialectList.size()));
        }
        return claimDialectList;
    }

    @Override
    public void renameClaimDialect(ClaimDialect oldClaimDialect, ClaimDialect newClaimDialect, int tenantId) throws ClaimMetadataException {
        super.renameClaimDialect(oldClaimDialect, newClaimDialect, tenantId);
        this.claimDialectCache.clearClaimDialects(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Claim dialect: " + oldClaimDialect.getClaimDialectURI() + " is renamed to new claim dialect: " + newClaimDialect.getClaimDialectURI() + " for tenant: " + tenantId + ". Invalidated ClaimDialectCache."));
        }
    }

    @Override
    public void removeClaimDialect(ClaimDialect claimDialect, int tenantId) throws ClaimMetadataException {
        super.removeClaimDialect(claimDialect, tenantId);
        this.claimDialectCache.clearClaimDialects(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Claim dialect: " + claimDialect.getClaimDialectURI() + " is removed for tenant: " + tenantId + ". Invalidated ClaimDialectCache."));
        }
    }

    @Override
    public void addClaimDialect(ClaimDialect claimDialect, int tenantId) throws ClaimMetadataException {
        super.addClaimDialect(claimDialect, tenantId);
        this.claimDialectCache.clearClaimDialects(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Claim dialect: " + claimDialect.getClaimDialectURI() + " is added for tenant: " + tenantId + ". Invalidated ClaimDialectCache."));
        }
    }
}

