/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt.cache;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.cache.Cache;
import javax.cache.CacheBuilder;
import javax.cache.CacheConfiguration;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.wso2.carbon.caching.impl.CacheImpl;
import org.wso2.carbon.identity.core.model.IdentityCacheConfig;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class BaseCache<K extends Serializable, V extends Serializable> {
    private static final String CACHE_MANAGER_NAME = "IdentityClaimMetadataMgtCacheManager";
    private CacheBuilder<K, V> cacheBuilder;
    private String cacheName;

    public BaseCache(String cacheName) {
        this.cacheName = cacheName;
        IdentityCacheConfig identityCacheConfig = IdentityUtil.getIdentityCacheConfig((String)CACHE_MANAGER_NAME, (String)cacheName);
        if (identityCacheConfig != null && !identityCacheConfig.isDistributed()) {
            this.cacheName = "$__local__$." + cacheName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<K, V> getBaseCache() {
        Cache cache;
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(CACHE_MANAGER_NAME);
        if (this.getCacheTimeout() > 0 && this.cacheBuilder == null) {
            String string = this.cacheName.intern();
            synchronized (string) {
                if (this.cacheBuilder == null) {
                    cacheManager.removeCache(this.cacheName);
                    this.cacheBuilder = cacheManager.createCacheBuilder(this.cacheName).setExpiry(CacheConfiguration.ExpiryType.ACCESSED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)this.getCacheTimeout())).setExpiry(CacheConfiguration.ExpiryType.MODIFIED, new CacheConfiguration.Duration(TimeUnit.SECONDS, (long)this.getCacheTimeout())).setStoreByValue(false);
                    cache = this.cacheBuilder.build();
                    this.setCapacity((CacheImpl)cache);
                } else {
                    cache = cacheManager.getCache(this.cacheName);
                    this.setCapacity((CacheImpl)cache);
                }
            }
        } else {
            cache = cacheManager.getCache(this.cacheName);
            this.setCapacity((CacheImpl)cache);
        }
        return cache;
    }

    public void addToCache(K key, V entry) {
        if (!this.isEnabled()) {
            return;
        }
        Cache<K, V> cache = this.getBaseCache();
        if (cache != null) {
            cache.put(key, entry);
        }
    }

    public V getValueFromCache(K key) {
        if (!this.isEnabled()) {
            return null;
        }
        if (key == null) {
            return null;
        }
        Cache<K, V> cache = this.getBaseCache();
        if (cache != null && cache.get(key) != null) {
            return (V)((Serializable)cache.get(key));
        }
        return null;
    }

    public void clearCacheEntry(K key) {
        if (!this.isEnabled()) {
            return;
        }
        Cache<K, V> cache = this.getBaseCache();
        if (cache != null) {
            cache.remove(key);
        }
    }

    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        Cache<K, V> cache = this.getBaseCache();
        if (cache != null) {
            cache.removeAll();
        }
    }

    public boolean isEnabled() {
        IdentityCacheConfig identityCacheConfig = IdentityUtil.getIdentityCacheConfig((String)CACHE_MANAGER_NAME, (String)this.cacheName);
        if (identityCacheConfig != null) {
            return identityCacheConfig.isEnabled();
        }
        return true;
    }

    public int getCacheTimeout() {
        IdentityCacheConfig identityCacheConfig = IdentityUtil.getIdentityCacheConfig((String)CACHE_MANAGER_NAME, (String)this.cacheName);
        if (identityCacheConfig != null && identityCacheConfig.getTimeout() > 0) {
            return identityCacheConfig.getTimeout();
        }
        return -1;
    }

    public int getCapacity() {
        IdentityCacheConfig identityCacheConfig = IdentityUtil.getIdentityCacheConfig((String)CACHE_MANAGER_NAME, (String)this.cacheName);
        if (identityCacheConfig != null && identityCacheConfig.getCapacity() > 0) {
            return identityCacheConfig.getCapacity();
        }
        return -1;
    }

    public void setCapacity(CacheImpl cache) {
        if (this.getCapacity() > 0) {
            cache.setCapacity((long)this.getCapacity());
        }
    }
}

