/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataStore;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedClaimDialectDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedExternalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedLocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDialectDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ExternalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.LocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.internal.IdentityClaimManagementServiceDataHolder;
import org.wso2.carbon.identity.claim.metadata.mgt.model.AttributeMapping;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.util.ClaimMetadataUtils;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimKey;
import org.wso2.carbon.user.core.claim.inmemory.ClaimConfig;
import org.wso2.carbon.user.core.listener.ClaimManagerListener;

public class DefaultClaimMetadataStore
implements ClaimMetadataStore {
    private static final Log log = LogFactory.getLog(DefaultClaimMetadataStore.class);
    private ClaimDialectDAO claimDialectDAO = new CacheBackedClaimDialectDAO();
    private CacheBackedLocalClaimDAO localClaimDAO = new CacheBackedLocalClaimDAO(new LocalClaimDAO());
    private CacheBackedExternalClaimDAO externalClaimDAO = new CacheBackedExternalClaimDAO(new ExternalClaimDAO());
    private int tenantId;

    public static DefaultClaimMetadataStore getInstance(int tenantId) {
        ClaimConfig claimConfig = new ClaimConfig();
        return new DefaultClaimMetadataStore(claimConfig, tenantId);
    }

    public DefaultClaimMetadataStore(ClaimConfig claimConfig, int tenantId) {
        try {
            if (this.claimDialectDAO.getClaimDialects(tenantId).size() == 0) {
                this.init(claimConfig, tenantId);
            }
        }
        catch (ClaimMetadataException e) {
            log.error((Object)"Error while retrieving claim dialects", (Throwable)((Object)e));
        }
        this.tenantId = tenantId;
    }

    private void init(ClaimConfig claimConfig, int tenantId) {
        try {
            this.claimDialectDAO.addClaimDialect(new ClaimDialect("http://wso2.org/claims"), tenantId);
        }
        catch (ClaimMetadataException e) {
            log.error((Object)"Error while adding claim dialect http://wso2.org/claims", (Throwable)((Object)e));
        }
        if (claimConfig.getClaimMap() != null) {
            String claimDialectURI;
            ClaimKey claimKey;
            String primaryDomainName = IdentityUtil.getPrimaryDomainName();
            HashSet<String> claimDialectList = new HashSet<String>();
            for (Map.Entry entry : claimConfig.getClaimMap().entrySet()) {
                claimKey = (ClaimKey)entry.getKey();
                org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = (org.wso2.carbon.user.core.claim.ClaimMapping)entry.getValue();
                claimDialectURI = claimMapping.getClaim().getDialectURI();
                String claimURI = claimKey.getClaimUri();
                if ("http://wso2.org/claims".equalsIgnoreCase(claimDialectURI)) {
                    ArrayList<AttributeMapping> mappedAttributes = new ArrayList<AttributeMapping>();
                    if (StringUtils.isNotBlank((String)claimMapping.getMappedAttribute())) {
                        mappedAttributes.add(new AttributeMapping(primaryDomainName, claimMapping.getMappedAttribute()));
                    }
                    if (claimMapping.getMappedAttributes() != null) {
                        for (Map.Entry claimMappingEntry : claimMapping.getMappedAttributes().entrySet()) {
                            mappedAttributes.add(new AttributeMapping((String)claimMappingEntry.getKey(), (String)claimMappingEntry.getValue()));
                        }
                    }
                    LocalClaim localClaim = new LocalClaim(claimURI, mappedAttributes, this.fillClaimProperties(claimConfig, claimKey));
                    try {
                        LocalClaimDAO localClaimDAO = new LocalClaimDAO();
                        localClaimDAO.addLocalClaim(localClaim, tenantId);
                    }
                    catch (ClaimMetadataException e) {
                        log.error((Object)("Error while adding local claim " + claimURI), (Throwable)((Object)e));
                    }
                    continue;
                }
                claimDialectList.add(claimDialectURI);
            }
            for (String claimDialectURI2 : claimDialectList) {
                ClaimDialect claimDialect = new ClaimDialect(claimDialectURI2);
                try {
                    this.claimDialectDAO.addClaimDialect(claimDialect, tenantId);
                }
                catch (ClaimMetadataException e) {
                    log.error((Object)("Error while adding claim dialect " + claimDialectURI2), (Throwable)((Object)e));
                }
            }
            for (Map.Entry entry : claimConfig.getClaimMap().entrySet()) {
                claimKey = (ClaimKey)entry.getKey();
                String claimURI = claimKey.getClaimUri();
                claimDialectURI = ((org.wso2.carbon.user.core.claim.ClaimMapping)entry.getValue()).getClaim().getDialectURI();
                if ("http://wso2.org/claims".equalsIgnoreCase(claimDialectURI)) continue;
                String mappedLocalClaimURI = (String)((Map)claimConfig.getPropertyHolderMap().get(claimKey)).get("MappedLocalClaim");
                ExternalClaim externalClaim = new ExternalClaim(claimDialectURI, claimURI, mappedLocalClaimURI, this.fillClaimProperties(claimConfig, claimKey));
                try {
                    ExternalClaimDAO externalClaimDAO = new ExternalClaimDAO();
                    externalClaimDAO.addExternalClaim(externalClaim, tenantId);
                }
                catch (ClaimMetadataException e) {
                    log.error((Object)("Error while adding external claim " + claimURI + " to dialect " + claimDialectURI), (Throwable)((Object)e));
                }
            }
        }
    }

    private Map<String, String> fillClaimProperties(ClaimConfig claimConfig, ClaimKey claimKey) {
        Map claimProperties = (Map)claimConfig.getPropertyHolderMap().get(claimKey);
        claimProperties.remove("Dialect");
        claimProperties.remove("ClaimURI");
        claimProperties.remove("AttributeID");
        if (!claimProperties.containsKey("DisplayName")) {
            claimProperties.put("DisplayName", "0");
        }
        if (claimProperties.containsKey("SupportedByDefault") && StringUtils.isBlank((String)((String)claimProperties.get("SupportedByDefault")))) {
            claimProperties.put("SupportedByDefault", "true");
        }
        if (claimProperties.containsKey("ReadOnly") && StringUtils.isBlank((String)((String)claimProperties.get("ReadOnly")))) {
            claimProperties.put("ReadOnly", "true");
        }
        if (claimProperties.containsKey("Required") && StringUtils.isBlank((String)((String)claimProperties.get("Required")))) {
            claimProperties.put("Required", "true");
        }
        return claimProperties;
    }

    public String[] getAllClaimUris() throws UserStoreException {
        String[] localClaims;
        for (ClaimManagerListener listener : IdentityClaimManagementServiceDataHolder.getClaimManagerListeners()) {
            if (listener.getAllClaimUris()) continue;
            return null;
        }
        try {
            List<LocalClaim> localClaimList = this.localClaimDAO.getLocalClaims(this.tenantId);
            localClaims = new String[localClaimList.size()];
            int i = 0;
            for (LocalClaim localClaim : localClaimList) {
                localClaims[i] = localClaim.getClaimURI();
                ++i;
            }
        }
        catch (ClaimMetadataException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
        return localClaims;
    }

    public String getAttributeName(String domainName, String claimURI) throws UserStoreException {
        if (StringUtils.isBlank((String)domainName)) {
            throw new IllegalArgumentException("User store domain name parameter cannot be empty");
        }
        if (StringUtils.isBlank((String)claimURI)) {
            throw new IllegalArgumentException("Local claim URI parameter cannot be empty");
        }
        for (ClaimManagerListener claimManagerListener : IdentityClaimManagementServiceDataHolder.getClaimManagerListeners()) {
            if (claimManagerListener.getAttributeName(domainName, claimURI)) continue;
            return null;
        }
        try {
            List<LocalClaim> localClaimList = this.localClaimDAO.getLocalClaims(this.tenantId);
            for (LocalClaim localClaim : localClaimList) {
                if (!localClaim.getClaimURI().equalsIgnoreCase(claimURI)) continue;
                return this.getMappedAttribute(domainName, localClaim, this.tenantId);
            }
            List<ClaimDialect> list = this.claimDialectDAO.getClaimDialects(this.tenantId);
            for (ClaimDialect claimDialect : list) {
                if ("http://wso2.org/claims".equalsIgnoreCase(claimDialect.getClaimDialectURI())) continue;
                List<ExternalClaim> externalClaims = this.externalClaimDAO.getExternalClaims(claimDialect.getClaimDialectURI(), this.tenantId);
                for (ExternalClaim externalClaim : externalClaims) {
                    if (!externalClaim.getClaimURI().equalsIgnoreCase(claimURI)) continue;
                    for (LocalClaim localClaim : localClaimList) {
                        if (!localClaim.getClaimURI().equalsIgnoreCase(externalClaim.getMappedLocalClaim())) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Picking mapped attribute for external claim : " + externalClaim.getClaimURI() + " using mapped local claim : " + localClaim.getClaimURI()));
                        }
                        return this.getMappedAttribute(domainName, localClaim, this.tenantId);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning NULL for getAttributeName() for domain : " + domainName + ", claim URI : " + claimURI));
            }
            return null;
        }
        catch (ClaimMetadataException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    private String getMappedAttribute(String domainName, LocalClaim localClaim, int tenantId) throws UserStoreException {
        String mappedAttribute = localClaim.getMappedAttribute(domainName);
        if (StringUtils.isNotBlank((String)mappedAttribute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Assigned mapped attribute : " + mappedAttribute + " from user store domain : " + domainName + " for claim : " + localClaim.getClaimURI() + " in tenant : " + tenantId));
            }
            return mappedAttribute;
        }
        mappedAttribute = localClaim.getClaimProperty("DefaultAttribute");
        if (StringUtils.isNotBlank((String)mappedAttribute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Assigned mapped attribute : " + mappedAttribute + " from " + "DefaultAttribute" + " property for claim : " + localClaim.getClaimURI() + " in tenant : " + tenantId));
            }
            return mappedAttribute;
        }
        UserRealm realm = IdentityClaimManagementServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId);
        String primaryDomainName = realm.getRealmConfiguration().getUserStoreProperty("DomainName");
        mappedAttribute = localClaim.getMappedAttribute(primaryDomainName);
        if (StringUtils.isNotBlank((String)mappedAttribute)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Assigned mapped attribute : " + mappedAttribute + " from primary user store domain : " + primaryDomainName + " for claim : " + localClaim.getClaimURI() + " in tenant : " + tenantId));
            }
            return mappedAttribute;
        }
        throw new IllegalStateException("Cannot find suitable mapped attribute for local claim " + localClaim.getClaimURI());
    }

    @Deprecated
    public String getAttributeName(String claimURI) throws UserStoreException {
        UserRealm realm = IdentityClaimManagementServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(this.tenantId);
        String primaryDomainName = realm.getRealmConfiguration().getUserStoreProperty("DomainName");
        return this.getAttributeName(primaryDomainName, claimURI);
    }

    @Deprecated
    public Claim getClaim(String claimURI) throws UserStoreException {
        try {
            List<LocalClaim> localClaims = this.localClaimDAO.getLocalClaims(this.tenantId);
            for (LocalClaim localClaim : localClaims) {
                if (!localClaim.getClaimURI().equalsIgnoreCase(claimURI)) continue;
                org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, this.tenantId);
                return claimMapping.getClaim();
            }
            List<ClaimDialect> claimDialects = this.claimDialectDAO.getClaimDialects(this.tenantId);
            for (ClaimDialect claimDialect : claimDialects) {
                if ("http://wso2.org/claims".equalsIgnoreCase(claimDialect.getClaimDialectURI())) continue;
                List<ExternalClaim> externalClaims = this.externalClaimDAO.getExternalClaims(claimDialect.getClaimDialectURI(), this.tenantId);
                for (ExternalClaim externalClaim : externalClaims) {
                    Iterator<LocalClaim> iterator;
                    if (!externalClaim.getClaimURI().equalsIgnoreCase(claimURI) || !(iterator = localClaims.iterator()).hasNext()) continue;
                    LocalClaim localClaim = iterator.next();
                    org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, this.tenantId);
                    return claimMapping.getClaim();
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning NULL for getClaim() for claim URI : " + claimURI));
            }
            return null;
        }
        catch (ClaimMetadataException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Deprecated
    public ClaimMapping getClaimMapping(String claimURI) throws UserStoreException {
        try {
            List<LocalClaim> localClaims = this.localClaimDAO.getLocalClaims(this.tenantId);
            for (LocalClaim localClaim : localClaims) {
                if (!localClaim.getClaimURI().equalsIgnoreCase(claimURI)) continue;
                org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, this.tenantId);
                return claimMapping;
            }
            List<ClaimDialect> claimDialects = this.claimDialectDAO.getClaimDialects(this.tenantId);
            for (ClaimDialect claimDialect : claimDialects) {
                if ("http://wso2.org/claims".equalsIgnoreCase(claimDialect.getClaimDialectURI())) continue;
                List<ExternalClaim> externalClaims = this.externalClaimDAO.getExternalClaims(claimDialect.getClaimDialectURI(), this.tenantId);
                for (ExternalClaim externalClaim : externalClaims) {
                    if (!externalClaim.getClaimURI().equalsIgnoreCase(claimURI)) continue;
                    for (LocalClaim localClaim : localClaims) {
                        if (!localClaim.getClaimURI().equalsIgnoreCase(externalClaim.getMappedLocalClaim())) continue;
                        org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, this.tenantId);
                        return claimMapping;
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Returning NULL for getClaimMapping() for claim URI : " + claimURI));
            }
            return null;
        }
        catch (ClaimMetadataException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Deprecated
    public ClaimMapping[] getAllClaimMappings(String dialectUri) throws UserStoreException {
        if ("http://wso2.org/claims".equalsIgnoreCase(dialectUri)) {
            try {
                List<LocalClaim> localClaims = this.localClaimDAO.getLocalClaims(this.tenantId);
                ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping> claimMappings = new ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping>();
                for (LocalClaim localClaim : localClaims) {
                    org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, this.tenantId);
                    claimMappings.add(claimMapping);
                }
                return claimMappings.toArray(new ClaimMapping[0]);
            }
            catch (ClaimMetadataException e) {
                throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        try {
            List<ExternalClaim> externalClaims = this.externalClaimDAO.getExternalClaims(dialectUri, this.tenantId);
            List<LocalClaim> localClaims = this.localClaimDAO.getLocalClaims(this.tenantId);
            ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping> claimMappings = new ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping>();
            for (ExternalClaim externalClaim : externalClaims) {
                org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertExternalClaimToClaimMapping(externalClaim, localClaims, this.tenantId);
                claimMappings.add(claimMapping);
            }
            return claimMappings.toArray(new ClaimMapping[0]);
        }
        catch (ClaimMetadataException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Deprecated
    public ClaimMapping[] getAllClaimMappings() throws UserStoreException {
        return this.getAllClaimMappings("http://wso2.org/claims");
    }

    @Deprecated
    public void addNewClaimMapping(ClaimMapping claimMapping) throws UserStoreException {
        throw new UnsupportedOperationException("ClaimMetadataStore does not supports management operations");
    }

    @Deprecated
    public void deleteClaimMapping(ClaimMapping claimMapping) throws UserStoreException {
        throw new UnsupportedOperationException("ClaimMetadataStore does not supports management operations");
    }

    @Deprecated
    public void updateClaimMapping(ClaimMapping claimMapping) throws UserStoreException {
        throw new UnsupportedOperationException("ClaimMetadataStore does not supports management operations");
    }

    @Deprecated
    public ClaimMapping[] getAllSupportClaimMappingsByDefault() throws UserStoreException {
        try {
            List<LocalClaim> localClaims = this.localClaimDAO.getLocalClaims(this.tenantId);
            ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping> claimMappings = new ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping>();
            for (LocalClaim localClaim : localClaims) {
                org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, this.tenantId);
                if (!claimMapping.getClaim().isSupportedByDefault()) continue;
                claimMappings.add(claimMapping);
            }
            return claimMappings.toArray(new ClaimMapping[0]);
        }
        catch (ClaimMetadataException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    @Deprecated
    public ClaimMapping[] getAllRequiredClaimMappings() throws UserStoreException {
        try {
            List<LocalClaim> localClaims = this.localClaimDAO.getLocalClaims(this.tenantId);
            ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping> claimMappings = new ArrayList<org.wso2.carbon.user.core.claim.ClaimMapping>();
            for (LocalClaim localClaim : localClaims) {
                org.wso2.carbon.user.core.claim.ClaimMapping claimMapping = ClaimMetadataUtils.convertLocalClaimToClaimMapping(localClaim, this.tenantId);
                if (!claimMapping.getClaim().isRequired()) continue;
                claimMappings.add(claimMapping);
            }
            return claimMappings.toArray(new ClaimMapping[0]);
        }
        catch (ClaimMetadataException e) {
            throw new UserStoreException(e.getMessage(), (Throwable)((Object)e));
        }
    }
}

