/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.DefaultClaimMetadataStore;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.claim.ClaimManager;
import org.wso2.carbon.user.core.claim.ClaimManagerFactory;
import org.wso2.carbon.user.core.claim.DefaultClaimManager;
import org.wso2.carbon.user.core.claim.inmemory.ClaimConfig;
import org.wso2.carbon.user.core.claim.inmemory.FileBasedClaimBuilder;

public class ClaimMetadataStoreFactory
implements ClaimManagerFactory {
    private static final Log log = LogFactory.getLog(DefaultClaimManager.class);
    private static ClaimConfig claimConfig;

    public synchronized ClaimManager createClaimManager(int tenantId) {
        DefaultClaimMetadataStore identityClaimManager = new DefaultClaimMetadataStore(claimConfig, tenantId);
        return identityClaimManager;
    }

    static {
        try {
            claimConfig = FileBasedClaimBuilder.buildClaimMappingsFromConfigFile();
        }
        catch (IOException e) {
            log.error((Object)"Could not find claim configuration file", (Throwable)e);
        }
        catch (XMLStreamException e) {
            log.error((Object)"Error while parsing claim configuration file", (Throwable)e);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error while initializing claim manager");
        }
    }
}

