/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementService;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedClaimDialectDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedExternalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.CacheBackedLocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ClaimDialectDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.ExternalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.dao.LocalClaimDAO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataClientException;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataServerException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.util.ClaimConstants;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.user.api.UserStoreException;

public class ClaimMetadataManagementServiceImpl
implements ClaimMetadataManagementService {
    private static final Log log = LogFactory.getLog(ClaimMetadataManagementServiceImpl.class);
    private ClaimDialectDAO claimDialectDAO = new CacheBackedClaimDialectDAO();
    private CacheBackedLocalClaimDAO localClaimDAO = new CacheBackedLocalClaimDAO(new LocalClaimDAO());
    private CacheBackedExternalClaimDAO externalClaimDAO = new CacheBackedExternalClaimDAO(new ExternalClaimDAO());

    @Override
    public List<ClaimDialect> getClaimDialects(String tenantDomain) throws ClaimMetadataException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        List<ClaimDialect> claimDialects = this.claimDialectDAO.getClaimDialects(tenantId);
        return claimDialects;
    }

    @Override
    public void addClaimDialect(ClaimDialect claimDialect, String tenantDomain) throws ClaimMetadataException {
        if (claimDialect == null || StringUtils.isBlank((String)claimDialect.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_CLAIM_DIALECT);
        }
        if (StringUtils.isBlank((String)tenantDomain)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_TENANT_DOMAIN);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (tenantId == -1) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_INVALID_TENANT_DOMAIN.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_INVALID_TENANT_DOMAIN.getMessage(), tenantDomain));
        }
        List<ClaimDialect> claimDialects = this.claimDialectDAO.getClaimDialects(tenantId);
        Set claimDialectUris = claimDialects.stream().map(ClaimDialect::getClaimDialectURI).collect(Collectors.toSet());
        if (claimDialectUris.contains(claimDialect.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EXISTING_CLAIM_DIALECT.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_EXISTING_CLAIM_DIALECT.getMessage(), claimDialect.getClaimDialectURI()));
        }
        this.claimDialectDAO.addClaimDialect(claimDialect, tenantId);
    }

    @Override
    public void renameClaimDialect(ClaimDialect oldClaimDialect, ClaimDialect newClaimDialect, String tenantDomain) throws ClaimMetadataException {
        if (oldClaimDialect == null || StringUtils.isBlank((String)oldClaimDialect.getClaimDialectURI()) || newClaimDialect == null || StringUtils.isBlank((String)newClaimDialect.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_CLAIM_DIALECT);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        this.claimDialectDAO.renameClaimDialect(oldClaimDialect, newClaimDialect, tenantId);
        this.externalClaimDAO.removeExternalClaimCache(oldClaimDialect.getClaimDialectURI(), tenantId);
    }

    @Override
    public void removeClaimDialect(ClaimDialect claimDialect, String tenantDomain) throws ClaimMetadataException {
        if (claimDialect == null || StringUtils.isBlank((String)claimDialect.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_CLAIM_DIALECT.getCode(), "Claim dialect URI cannot be empty");
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        this.claimDialectDAO.removeClaimDialect(claimDialect, tenantId);
        this.externalClaimDAO.removeExternalClaimCache(claimDialect.getClaimDialectURI(), tenantId);
    }

    @Override
    public List<LocalClaim> getLocalClaims(String tenantDomain) throws ClaimMetadataException {
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        List<LocalClaim> localClaims = this.localClaimDAO.getLocalClaims(tenantId);
        return localClaims;
    }

    @Override
    public void addLocalClaim(LocalClaim localClaim, String tenantDomain) throws ClaimMetadataException {
        if (localClaim == null || StringUtils.isBlank((String)localClaim.getClaimURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_LOCAL_CLAIM_URI);
        }
        if (localClaim.getMappedAttributes().isEmpty()) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_MAPPED_ATTRIBUTES_IN_LOCAL_CLAIM.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_MAPPED_ATTRIBUTES_IN_LOCAL_CLAIM.getMessage(), localClaim.getClaimDialectURI(), localClaim.getClaimURI()));
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (this.isExistingLocalClaimURI(localClaim.getClaimURI(), tenantId)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EXISTING_LOCAL_CLAIM_URI.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_EXISTING_LOCAL_CLAIM_URI.getMessage(), localClaim.getClaimURI()));
        }
        this.localClaimDAO.addLocalClaim(localClaim, tenantId);
    }

    @Override
    public void updateLocalClaim(LocalClaim localClaim, String tenantDomain) throws ClaimMetadataException {
        if (localClaim == null || StringUtils.isBlank((String)localClaim.getClaimURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_LOCAL_CLAIM_URI);
        }
        if (localClaim.getMappedAttributes().isEmpty()) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_MAPPED_ATTRIBUTES_IN_LOCAL_CLAIM.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_MAPPED_ATTRIBUTES_IN_LOCAL_CLAIM.getMessage(), localClaim.getClaimDialectURI(), localClaim.getClaimURI()));
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        this.localClaimDAO.updateLocalClaim(localClaim, tenantId);
    }

    @Override
    public void removeLocalClaim(String localClaimURI, String tenantDomain) throws ClaimMetadataException {
        if (StringUtils.isBlank((String)localClaimURI)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_LOCAL_CLAIM_URI);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        boolean isMappedLocalClaim = this.externalClaimDAO.isMappedLocalClaim(localClaimURI, tenantId);
        if (isMappedLocalClaim) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_LOCAL_CLAIM_HAS_MAPPED_EXTERNAL_CLAIM.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_LOCAL_CLAIM_HAS_MAPPED_EXTERNAL_CLAIM.getMessage(), localClaimURI));
        }
        this.localClaimDAO.removeLocalClaim(localClaimURI, tenantId);
    }

    @Override
    public List<ExternalClaim> getExternalClaims(String externalClaimDialectURI, String tenantDomain) throws ClaimMetadataException {
        if (StringUtils.isBlank((String)externalClaimDialectURI)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTERNAL_CLAIM_URI);
        }
        if ("http://wso2.org/claims".equalsIgnoreCase(externalClaimDialectURI)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_INVALID_EXTERNAL_CLAIM_DIALECT);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        List<ExternalClaim> externalClaims = this.externalClaimDAO.getExternalClaims(externalClaimDialectURI, tenantId);
        return externalClaims;
    }

    @Override
    public void addExternalClaim(ExternalClaim externalClaim, String tenantDomain) throws ClaimMetadataException {
        if (externalClaim == null || StringUtils.isBlank((String)externalClaim.getClaimURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTERNAL_CLAIM_URI);
        }
        if (StringUtils.isBlank((String)externalClaim.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTERNAL_DIALECT_URI);
        }
        if (StringUtils.isBlank((String)externalClaim.getMappedLocalClaim())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_MAPPED_TO_EMPTY_LOCAL_CLAIM_URI);
        }
        if ("http://wso2.org/claims".equalsIgnoreCase(externalClaim.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_INVALID_EXTERNAL_CLAIM_DIALECT);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        if (this.isExistingExternalClaimURI(externalClaim.getClaimDialectURI(), externalClaim.getClaimURI(), tenantId)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EXISTING_EXTERNAL_CLAIM_URI.getCode(), String.format(ClaimConstants.ErrorMessage.ERROR_CODE_EXISTING_EXTERNAL_CLAIM_URI.getMessage(), externalClaim.getClaimURI(), externalClaim.getClaimDialectURI()));
        }
        this.externalClaimDAO.addExternalClaim(externalClaim, tenantId);
    }

    @Override
    public void updateExternalClaim(ExternalClaim externalClaim, String tenantDomain) throws ClaimMetadataException {
        if (externalClaim == null || StringUtils.isBlank((String)externalClaim.getClaimURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTERNAL_CLAIM_URI);
        }
        if (StringUtils.isBlank((String)externalClaim.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTERNAL_DIALECT_URI);
        }
        if (StringUtils.isBlank((String)externalClaim.getMappedLocalClaim())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_MAPPED_TO_EMPTY_LOCAL_CLAIM_URI);
        }
        if ("http://wso2.org/claims".equalsIgnoreCase(externalClaim.getClaimDialectURI())) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_INVALID_EXTERNAL_CLAIM_DIALECT);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        this.externalClaimDAO.updateExternalClaim(externalClaim, tenantId);
    }

    @Override
    public void removeExternalClaim(String externalClaimDialectURI, String externalClaimURI, String tenantDomain) throws ClaimMetadataException {
        if (StringUtils.isBlank((String)externalClaimDialectURI)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTERNAL_DIALECT_URI.getCode(), "External claim dialect URI cannot be empty");
        }
        if (StringUtils.isBlank((String)externalClaimURI)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_EXTERNAL_CLAIM_URI);
        }
        if ("http://wso2.org/claims".equalsIgnoreCase(externalClaimDialectURI)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_INVALID_EXTERNAL_CLAIM_DIALECT);
        }
        int tenantId = IdentityTenantUtil.getTenantId((String)tenantDomain);
        this.externalClaimDAO.removeExternalClaim(externalClaimDialectURI, externalClaimURI, tenantId);
    }

    @Override
    public void removeClaimMappingAttributes(int tenantId, String userstoreDomain) throws ClaimMetadataException {
        if (StringUtils.isEmpty((String)userstoreDomain)) {
            throw new ClaimMetadataClientException(ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_TENANT_DOMAIN.getCode(), ClaimConstants.ErrorMessage.ERROR_CODE_EMPTY_TENANT_DOMAIN.getMessage());
        }
        try {
            this.localClaimDAO.removeClaimMappingAttributes(tenantId, userstoreDomain);
        }
        catch (UserStoreException e) {
            String errorMessage = String.format(ClaimConstants.ErrorMessage.ERROR_CODE_SERVER_ERROR_DELETING_CLAIM_MAPPINGS.getMessage(), tenantId, userstoreDomain);
            throw new ClaimMetadataServerException(ClaimConstants.ErrorMessage.ERROR_CODE_SERVER_ERROR_DELETING_CLAIM_MAPPINGS.getCode(), errorMessage, e);
        }
    }

    @Override
    public void removeAllClaims(int tenantId) throws ClaimMetadataException {
        this.claimDialectDAO.removeAllClaimDialects(tenantId);
    }

    @Override
    public String getMaskingRegexForLocalClaim(String localClaimURI, String tenantDomain) throws ClaimMetadataException {
        List<LocalClaim> localClaims = this.getLocalClaims(tenantDomain);
        for (LocalClaim localClaim : localClaims) {
            if (!localClaim.getClaimURI().equals(localClaimURI)) continue;
            return StringEscapeUtils.unescapeXml((String)localClaim.getClaimProperty("MaskingRegEx"));
        }
        return null;
    }

    private boolean isExistingExternalClaimURI(String externalClaimDialectURI, String externalClaimURI, int tenantId) throws ClaimMetadataException {
        return this.externalClaimDAO.getExternalClaims(externalClaimDialectURI, tenantId).stream().filter(claim -> claim.getClaimURI().equals(externalClaimURI)).findFirst().isPresent();
    }

    private boolean isExistingLocalClaimURI(String localClaimURI, int tenantId) throws ClaimMetadataException {
        return this.localClaimDAO.getLocalClaims(tenantId).stream().filter(claim -> claim.getClaimURI().equals(localClaimURI)).findFirst().isPresent();
    }
}

