/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.ClaimDialectDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.ExternalClaimDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.dto.LocalClaimDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataClientException;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.internal.IdentityClaimManagementServiceDataHolder;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ClaimDialect;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.util.ClaimMetadataUtils;

public class ClaimMetadataManagementAdminService {
    private static final Log log = LogFactory.getLog(ClaimMetadataManagementAdminService.class);

    public ClaimDialectDTO[] getClaimDialects() throws ClaimMetadataException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            List<ClaimDialect> claimDialectList = IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().getClaimDialects(tenantDomain);
            ClaimDialect[] claimDialects = claimDialectList.toArray(new ClaimDialect[0]);
            ClaimDialectDTO[] claimDialectDTOS = ClaimMetadataUtils.convertClaimDialectsToClaimDialectDTOs(claimDialects);
            Arrays.sort(claimDialectDTOS, new Comparator<ClaimDialectDTO>(){

                @Override
                public int compare(ClaimDialectDTO o1, ClaimDialectDTO o2) {
                    return o1.getClaimDialectURI().toLowerCase().compareTo(o2.getClaimDialectURI().toLowerCase());
                }
            });
            return claimDialectDTOS;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void addClaimDialect(ClaimDialectDTO claimDialect) throws ClaimMetadataException {
        try {
            ClaimDialect dialect = ClaimMetadataUtils.convertClaimDialectDTOToClaimDialect(claimDialect);
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().addClaimDialect(dialect, tenantDomain);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void renameClaimDialect(ClaimDialectDTO oldClaimDialect, ClaimDialectDTO newClaimDialect) throws ClaimMetadataException {
        try {
            ClaimDialect oldDialect = ClaimMetadataUtils.convertClaimDialectDTOToClaimDialect(oldClaimDialect);
            ClaimDialect newDialect = ClaimMetadataUtils.convertClaimDialectDTOToClaimDialect(newClaimDialect);
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().renameClaimDialect(oldDialect, newDialect, tenantDomain);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void removeClaimDialect(ClaimDialectDTO claimDialect) throws ClaimMetadataException {
        try {
            ClaimDialect dialect = ClaimMetadataUtils.convertClaimDialectDTOToClaimDialect(claimDialect);
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().removeClaimDialect(dialect, tenantDomain);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public LocalClaimDTO[] getLocalClaims() throws ClaimMetadataException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            List<LocalClaim> localClaimList = IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().getLocalClaims(tenantDomain);
            LocalClaim[] localClaims = localClaimList.toArray(new LocalClaim[0]);
            LocalClaimDTO[] localClaimDTOS = ClaimMetadataUtils.convertLocalClaimsToLocalClaimDTOs(localClaims);
            Arrays.sort(localClaimDTOS, new Comparator<LocalClaimDTO>(){

                @Override
                public int compare(LocalClaimDTO o1, LocalClaimDTO o2) {
                    return o1.getLocalClaimURI().toLowerCase().compareTo(o2.getLocalClaimURI().toLowerCase());
                }
            });
            return localClaimDTOS;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void addLocalClaim(LocalClaimDTO localClaim) throws ClaimMetadataException {
        try {
            LocalClaim claim = ClaimMetadataUtils.convertLocalClaimDTOToLocalClaim(localClaim);
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().addLocalClaim(claim, tenantDomain);
        }
        catch (ClaimMetadataClientException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)((Object)e));
            }
            throw new ClaimMetadataException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void updateLocalClaim(LocalClaimDTO localClaim) throws ClaimMetadataException {
        try {
            LocalClaim claim = ClaimMetadataUtils.convertLocalClaimDTOToLocalClaim(localClaim);
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().updateLocalClaim(claim, tenantDomain);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void removeLocalClaim(String localClaimURI) throws ClaimMetadataException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().removeLocalClaim(localClaimURI, tenantDomain);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public ExternalClaimDTO[] getExternalClaims(String externalClaimDialectURI) throws ClaimMetadataException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            List<ExternalClaim> externalClaimList = IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().getExternalClaims(externalClaimDialectURI, tenantDomain);
            ExternalClaim[] externalClaims = externalClaimList.toArray(new ExternalClaim[0]);
            ExternalClaimDTO[] externalClaimDTOS = ClaimMetadataUtils.convertExternalClaimsToExternalClaimDTOs(externalClaims);
            Arrays.sort(externalClaimDTOS, new Comparator<ExternalClaimDTO>(){

                @Override
                public int compare(ExternalClaimDTO o1, ExternalClaimDTO o2) {
                    return o1.getExternalClaimURI().toLowerCase().compareTo(o2.getExternalClaimURI().toLowerCase());
                }
            });
            return externalClaimDTOS;
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void addExternalClaim(ExternalClaimDTO externalClaim) throws ClaimMetadataException {
        try {
            ExternalClaim claim = ClaimMetadataUtils.convertExternalClaimDTOToExternalClaim(externalClaim);
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().addExternalClaim(claim, tenantDomain);
        }
        catch (ClaimMetadataClientException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)((Object)e));
            }
            throw new ClaimMetadataException(e.getMessage(), (Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void updateExternalClaim(ExternalClaimDTO externalClaim) throws ClaimMetadataException {
        try {
            ExternalClaim claim = ClaimMetadataUtils.convertExternalClaimDTOToExternalClaim(externalClaim);
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().updateExternalClaim(claim, tenantDomain);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }

    public void removeExternalClaim(String externalClaimDialectURI, String externalClaimURI) throws ClaimMetadataException {
        try {
            String tenantDomain = CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            IdentityClaimManagementServiceDataHolder.getInstance().getClaimManagementService().removeExternalClaim(externalClaimDialectURI, externalClaimURI, tenantDomain);
        }
        catch (Throwable e) {
            log.error((Object)e.getMessage(), e);
            throw new ClaimMetadataException(e.getMessage(), e);
        }
    }
}

