/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.claim.metadata.mgt;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.claim.metadata.mgt.ClaimMetadataManagementServiceImpl;
import org.wso2.carbon.identity.claim.metadata.mgt.exception.ClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.model.ExternalClaim;
import org.wso2.carbon.identity.claim.metadata.mgt.model.LocalClaim;

public class ClaimMetadataHandler {
    private static final Log log = LogFactory.getLog(ClaimMetadataHandler.class);
    private static final ClaimMetadataHandler INSTANCE = new ClaimMetadataHandler();

    public static ClaimMetadataHandler getInstance() {
        return INSTANCE;
    }

    public Set<ExternalClaim> getMappingsFromOtherDialectToCarbon(String otherDialectURI, Set<String> otherClaimURIs, String tenantDomain) throws ClaimMetadataException {
        HashSet<ExternalClaim> returnSet = new HashSet();
        if (otherDialectURI == null) {
            String message = "Invalid argument: 'otherDialectURI' is 'NULL'";
            log.error((Object)message);
            throw new ClaimMetadataException(message);
        }
        try {
            ClaimMetadataManagementServiceImpl claimMetadataService = new ClaimMetadataManagementServiceImpl();
            if (otherDialectURI.equals("http://wso2.org/claims")) {
                List<LocalClaim> localClaims = claimMetadataService.getLocalClaims(tenantDomain);
                if (otherClaimURIs == null || otherClaimURIs.isEmpty()) {
                    for (LocalClaim localClaim : localClaims) {
                        ExternalClaim claimMapping = new ExternalClaim(localClaim.getClaimDialectURI(), localClaim.getClaimURI(), localClaim.getClaimURI());
                        returnSet.add(claimMapping);
                    }
                    return returnSet;
                }
                for (LocalClaim localClaim : localClaims) {
                    if (!otherClaimURIs.contains(localClaim.getClaimURI())) continue;
                    ExternalClaim claimMapping = new ExternalClaim(otherDialectURI, localClaim.getClaimURI(), localClaim.getClaimURI());
                    returnSet.add(claimMapping);
                }
                return returnSet;
            }
            List<ExternalClaim> externalClaims = claimMetadataService.getExternalClaims(otherDialectURI, tenantDomain);
            if (otherClaimURIs == null || otherClaimURIs.isEmpty()) {
                returnSet = new HashSet<ExternalClaim>(externalClaims);
            } else {
                for (ExternalClaim externalClaim : externalClaims) {
                    if (!otherClaimURIs.contains(externalClaim.getClaimURI())) continue;
                    returnSet.add(externalClaim);
                }
            }
            return returnSet;
        }
        catch (ClaimMetadataException e) {
            throw new ClaimMetadataException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public Map<String, String> getMappingsMapFromOtherDialectToCarbon(String otherDialectURI, Set<String> otherClaimURIs, String tenantDomain, boolean useCarbonDialectAsKey) throws ClaimMetadataException {
        HashMap<String, String> returnMap = new HashMap<String, String>();
        Set<ExternalClaim> mappings = this.getMappingsFromOtherDialectToCarbon(otherDialectURI, otherClaimURIs, tenantDomain);
        for (ExternalClaim externalClaim : mappings) {
            if (useCarbonDialectAsKey) {
                returnMap.put(externalClaim.getMappedLocalClaim(), externalClaim.getClaimURI());
                continue;
            }
            returnMap.put(externalClaim.getClaimURI(), externalClaim.getMappedLocalClaim());
        }
        return returnMap;
    }
}

