/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.util;

import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementClientException;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementSQLException;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementServerException;

public class TemplateMgtUtils {
    public static TemplateManagementServerException handleServerException(TemplateMgtConstants.ErrorMessages error, String data, Throwable e) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new TemplateManagementServerException(message, error.getCode(), e);
    }

    public static TemplateManagementServerException handleServerException(TemplateMgtConstants.ErrorMessages error, Throwable e, String ... data) {
        String message = TemplateMgtUtils.populateMessageWithData(error, data);
        if (e == null) {
            return new TemplateManagementServerException(message, error.getCode());
        }
        return new TemplateManagementServerException(message, error.getCode(), e);
    }

    public static TemplateManagementClientException handleClientException(TemplateMgtConstants.ErrorMessages error, String data) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new TemplateManagementClientException(message, error.getCode());
    }

    public static TemplateManagementClientException handleClientException(TemplateMgtConstants.ErrorMessages error, Throwable e, String ... data) {
        String message = TemplateMgtUtils.populateMessageWithData(error, data);
        return new TemplateManagementClientException(message, error.getCode(), e);
    }

    public static TemplateManagementSQLException handleSQLException(TemplateMgtConstants.ErrorMessages error, String data, Throwable e) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new TemplateManagementSQLException(message, error.getCode(), e);
    }

    public static int getTenantIdFromCarbonContext() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    public static String getTenantDomainFromCarbonContext() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    private static String populateMessageWithData(TemplateMgtConstants.ErrorMessages error, String ... data) {
        String message = data.length != 0 ? String.format(error.getMessage(), data) : error.getMessage();
        return message;
    }
}

