/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.identity.configuration.mgt.core.ConfigurationManager;
import org.wso2.carbon.identity.template.mgt.handler.ReadOnlyTemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.TemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.impl.ConfigStoreBasedTemplateHandler;
import org.wso2.carbon.identity.template.mgt.model.Template;

public class TemplateManagerDataHolder {
    private static TemplateManagerDataHolder instance = new TemplateManagerDataHolder();
    private ConfigurationManager configurationManager;
    private TemplateHandler readWriteTemplateHandler = new ConfigStoreBasedTemplateHandler();
    private List<ReadOnlyTemplateHandler> readOnlyTemplateHandlers = new ArrayList<ReadOnlyTemplateHandler>();
    private Map<String, Template> fileBasedTemplates = new HashMap<String, Template>();

    public static TemplateManagerDataHolder getInstance() {
        return instance;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void setConfigurationManager(ConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public TemplateHandler getReadWriteTemplateHandler() {
        return this.readWriteTemplateHandler;
    }

    public void setReadWriteTemplateHandler(TemplateHandler readWriteTemplateHandler) {
        this.readWriteTemplateHandler = readWriteTemplateHandler;
    }

    public List<ReadOnlyTemplateHandler> getReadOnlyTemplateHandlers() {
        return Collections.unmodifiableList(this.readOnlyTemplateHandlers);
    }

    public void addReadOnlyTemplateHandler(ReadOnlyTemplateHandler templateHandler) {
        this.readOnlyTemplateHandlers.add(templateHandler);
    }

    public void removeReadOnlyTemplateHandler(ReadOnlyTemplateHandler templateHandler) {
        this.readOnlyTemplateHandlers.remove(templateHandler);
    }

    public Map<String, Template> getFileBasedTemplates() {
        return Collections.unmodifiableMap(this.fileBasedTemplates);
    }

    public void addFileBasedTemplate(String templateId, Template template) {
        this.fileBasedTemplates.put(templateId, template);
    }
}

