/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.configuration.mgt.core.ConfigurationManager;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.template.mgt.TemplateManager;
import org.wso2.carbon.identity.template.mgt.TemplateManagerImpl;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.handler.ReadOnlyTemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.impl.ConfigStoreBasedTemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.impl.FileBasedTemplateHandler;
import org.wso2.carbon.identity.template.mgt.internal.TemplateManagerDataHolder;
import org.wso2.carbon.identity.template.mgt.model.Template;

@Component(name="carbon.identity.template.mgt.component", immediate=true)
public class TemplateManagerComponent {
    private static Log log = LogFactory.getLog(TemplateManagerComponent.class);

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            BundleContext bundleContext = componentContext.getBundleContext();
            bundleContext.registerService(TemplateManager.class, (Object)new TemplateManagerImpl(), null);
            FileBasedTemplateHandler fileBasedTemplateHandler = new FileBasedTemplateHandler();
            TemplateManagerDataHolder.getInstance().addReadOnlyTemplateHandler(fileBasedTemplateHandler);
            ConfigStoreBasedTemplateHandler configStoreBasedTemplateHandler = new ConfigStoreBasedTemplateHandler();
            TemplateManagerDataHolder.getInstance().setReadWriteTemplateHandler(configStoreBasedTemplateHandler);
            this.loadDefaultTemplates();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Template Manager bundle is activated.");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating TemplateManagerComponent.", e);
        }
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="carbon.configuration.mgt.component", service=ConfigurationManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationManager")
    protected void setConfigurationManager(ConfigurationManager configurationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Manager service is set in the Template Manager component.");
        }
        TemplateManagerDataHolder.getInstance().setConfigurationManager(configurationManager);
    }

    protected void unsetConfigurationManager(ConfigurationManager configurationManager) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Configuration Manager service is unset in the Template Manager component.");
        }
        TemplateManagerDataHolder.getInstance().setConfigurationManager(null);
    }

    @Reference(name="identity.template.handler", service=ReadOnlyTemplateHandler.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetReadOnlyTemplateHandler")
    protected void setReadOnlyTemplateHandler(ReadOnlyTemplateHandler readOnlyTemplateHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template handler " + readOnlyTemplateHandler.getClass().getName() + " is added."));
        }
        TemplateManagerDataHolder.getInstance().addReadOnlyTemplateHandler(readOnlyTemplateHandler);
    }

    protected void unsetReadOnlyTemplateHandler(ReadOnlyTemplateHandler readOnlyTemplateHandler) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template handler " + readOnlyTemplateHandler.getClass().getName() + " is removed."));
        }
        TemplateManagerDataHolder.getInstance().removeReadOnlyTemplateHandler(readOnlyTemplateHandler);
    }

    private void loadDefaultTemplates() throws FileNotFoundException {
        List<Path> paths = Arrays.asList(TemplateMgtConstants.SP_TEMPLATES_DIR_PATH, TemplateMgtConstants.IDP_TEMPLATES_DIR_PATH);
        for (Path path : paths) {
            if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)"No file-based idp/application templates");
                continue;
            }
            try {
                Files.walk(path, new FileVisitOption[0]).filter(filePath -> Files.isRegularFile(filePath, new LinkOption[0]) && filePath.toString().endsWith(".json")).forEach(filePath -> {
                    try {
                        String templateJsonString = FileUtils.readFileToString((File)filePath.toFile());
                        JSONObject templateObj = new JSONObject(templateJsonString);
                        Template template = new Template();
                        template.setTemplateId(templateObj.getString("id"));
                        template.setTemplateName(templateObj.getString("name"));
                        template.setDescription(templateObj.getString("description"));
                        template.setImageUrl(templateObj.getString("image"));
                        if (StringUtils.equals((String)TemplateMgtConstants.SP_TEMPLATES_DIR_PATH.toString(), (String)path.toString())) {
                            template.setTemplateType(TemplateMgtConstants.TemplateType.APPLICATION_TEMPLATE);
                            template.setPropertiesMap(this.extractApplicationSpecificProperties(templateObj));
                            template.setTemplateScript(templateObj.getJSONObject("application").toString());
                        } else if (StringUtils.equals((String)TemplateMgtConstants.IDP_TEMPLATES_DIR_PATH.toString(), (String)path.toString())) {
                            template.setTemplateType(TemplateMgtConstants.TemplateType.IDP_TEMPLATE);
                            template.setPropertiesMap(this.extractIDPSpecificProperties(templateObj));
                            template.setTemplateScript(templateObj.getJSONObject("idp").toString());
                        }
                        TemplateManagerDataHolder.getInstance().addFileBasedTemplate(templateObj.getString("id"), template);
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while reading  templates.", (Throwable)e);
                    }
                });
            }
            catch (IOException e) {
                log.error((Object)"Error while reading templates.", (Throwable)e);
            }
        }
    }

    private Map<String, String> extractApplicationSpecificProperties(JSONObject templateObj) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)templateObj.getString("authenticationProtocol"))) {
            properties.put("protocol", templateObj.getString("authenticationProtocol"));
        }
        if (templateObj.getJSONArray("types") != null) {
            JSONArray typesJSONArray = templateObj.getJSONArray("types");
            ArrayList<String> types = new ArrayList<String>();
            if (typesJSONArray != null) {
                for (int i = 0; i < typesJSONArray.length(); ++i) {
                    types.add(typesJSONArray.getString(i));
                }
            }
            properties.put("types", String.join((CharSequence)",", types));
        }
        if (StringUtils.isNotEmpty((String)templateObj.getString("category"))) {
            properties.put("category", templateObj.getString("category"));
        }
        if (StringUtils.isNotEmpty((String)String.valueOf(templateObj.getInt("displayOrder")))) {
            properties.put("display-order", Integer.toString(templateObj.getInt("displayOrder")));
        }
        if (StringUtils.isNotEmpty((String)templateObj.getString("templateGroup"))) {
            properties.put("template-group", templateObj.getString("templateGroup"));
        }
        return properties;
    }

    private Map<String, String> extractIDPSpecificProperties(JSONObject templateObj) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)templateObj.getString("category"))) {
            properties.put("category", templateObj.getString("category"));
        }
        if (StringUtils.isNotEmpty((String)String.valueOf(templateObj.getInt("displayOrder")))) {
            properties.put("displayOrder", Integer.toString(templateObj.getInt("displayOrder")));
        }
        if (templateObj.getJSONArray("services") != null) {
            JSONArray servicesJSONArray = templateObj.getJSONArray("services");
            ArrayList<String> services = new ArrayList<String>();
            if (servicesJSONArray != null) {
                for (int i = 0; i < servicesJSONArray.length(); ++i) {
                    services.add(servicesJSONArray.getString(i));
                }
            }
            properties.put("services", String.join((CharSequence)",", services));
        }
        return properties;
    }
}

