/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.handler.impl;

import java.util.ArrayList;
import java.util.List;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementException;
import org.wso2.carbon.identity.template.mgt.model.Template;
import org.wso2.carbon.security.sts.service.util.STSServiceValidationUtil;

public class WSTrustConnectorValidator {
    private static final String WS_TRUST_TEMPLATE_ID = "061a3de4-8c08-4878-84a6-24245f11bf0e";
    private static final String STS_TEMPLATE_NOT_FOUND_MESSAGE = "Request template with id: %s could not be found since the WS-Trust connector has not been configured.";

    public static void validateWSTrustTemplateAvailability(String templateId) throws TemplateManagementException {
        if (templateId.equals(WS_TRUST_TEMPLATE_ID) && !STSServiceValidationUtil.isWSTrustAvailable()) {
            throw new TemplateManagementException(String.format(STS_TEMPLATE_NOT_FOUND_MESSAGE, templateId), TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_NOT_FOUND.getCode());
        }
    }

    public static List<Template> removeWSTrustTemplate(List<Template> templateList) {
        ArrayList<Template> removableTemplates = new ArrayList<Template>();
        for (Template templateListItem : templateList) {
            if (!templateListItem.getTemplateId().equals(WS_TRUST_TEMPLATE_ID) || STSServiceValidationUtil.isWSTrustAvailable()) continue;
            removableTemplates.add(templateListItem);
        }
        templateList.removeAll(removableTemplates);
        return templateList;
    }
}

