/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.handler.impl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementClientException;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementException;
import org.wso2.carbon.identity.template.mgt.handler.ReadOnlyTemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.impl.WSTrustConnectorValidator;
import org.wso2.carbon.identity.template.mgt.internal.TemplateManagerDataHolder;
import org.wso2.carbon.identity.template.mgt.model.Template;
import org.wso2.carbon.identity.template.mgt.util.TemplateMgtUtils;

public class FileBasedTemplateHandler
implements ReadOnlyTemplateHandler {
    private static final Log log = LogFactory.getLog(FileBasedTemplateHandler.class);
    private static final Integer DEFAULT_SEARCH_OFFSET = 0;

    @Override
    public Template getTemplateById(String templateId) throws TemplateManagementException {
        WSTrustConnectorValidator.validateWSTrustTemplateAvailability(templateId);
        return TemplateManagerDataHolder.getInstance().getFileBasedTemplates().get(templateId);
    }

    @Override
    public List<Template> listTemplates(String templateType, Integer limit, Integer offset, Condition searchCondition) throws TemplateManagementException {
        this.validatePaginationParameters(limit, offset);
        if (limit == null || limit == 0) {
            limit = IdentityUtil.getDefaultItemsPerPage();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defined in the request, default to: " + limit));
            }
        }
        if (offset == null) {
            offset = DEFAULT_SEARCH_OFFSET;
        }
        return WSTrustConnectorValidator.removeWSTrustTemplate(TemplateManagerDataHolder.getInstance().getFileBasedTemplates().entrySet().stream().filter(entry -> StringUtils.equals((String)((Template)entry.getValue()).getTemplateType().toString(), (String)templateType)).skip(offset.intValue()).limit(limit.intValue()).map(Map.Entry::getValue).collect(Collectors.toList()));
    }

    private void validatePaginationParameters(Integer limit, Integer offset) throws TemplateManagementClientException {
        if (limit != null && limit < 0) {
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_INVALID_ARGUMENTS_FOR_LIMIT, null);
        }
        if (offset != null && offset < 0) {
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_INVALID_ARGUMENTS_FOR_OFFSET, null);
        }
    }
}

