/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.handler.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.cache.ConfigStoreBasedTemplateCache;
import org.wso2.carbon.identity.template.mgt.cache.ConfigStoreBasedTemplateCacheEntry;
import org.wso2.carbon.identity.template.mgt.cache.ConfigStoreBasedTemplateCacheKey;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementClientException;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementException;
import org.wso2.carbon.identity.template.mgt.handler.ReadOnlyTemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.TemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.impl.ConfigStoreBasedTemplateHandler;
import org.wso2.carbon.identity.template.mgt.internal.TemplateManagerDataHolder;
import org.wso2.carbon.identity.template.mgt.model.Template;

public class CacheBackedConfigStoreBasedTemplateHandler
implements TemplateHandler {
    private static final Log log = LogFactory.getLog(CacheBackedConfigStoreBasedTemplateHandler.class);
    private ConfigStoreBasedTemplateHandler configStoreBasedTemplateHandler = null;
    private ConfigStoreBasedTemplateCache configStoreBasedTemplateCache = null;

    public CacheBackedConfigStoreBasedTemplateHandler(ConfigStoreBasedTemplateHandler configStoreBasedTemplateHandler) {
        this.configStoreBasedTemplateHandler = configStoreBasedTemplateHandler;
        this.configStoreBasedTemplateCache = ConfigStoreBasedTemplateCache.getInstance();
    }

    @Override
    public String addTemplate(Template template) throws TemplateManagementException {
        return this.configStoreBasedTemplateHandler.addTemplate(template);
    }

    @Override
    public Template getTemplateById(String templateId) throws TemplateManagementException {
        Template template;
        ConfigStoreBasedTemplateCacheKey cacheKey = new ConfigStoreBasedTemplateCacheKey(templateId);
        ConfigStoreBasedTemplateCacheEntry entry = (ConfigStoreBasedTemplateCacheEntry)((Object)this.configStoreBasedTemplateCache.getValueFromCache((Serializable)((Object)cacheKey)));
        if (entry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache entry found for Template with id " + templateId));
            }
            Template template2 = entry.getTemplate();
            return template2;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache entry not found for Template with id " + templateId + ". Fetching entry from DB"));
        }
        if ((template = this.configStoreBasedTemplateHandler.getTemplateById(templateId)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Entry fetched from Config store for Template " + templateId + ". Updating cache"));
            }
            this.configStoreBasedTemplateCache.addToCache((Serializable)((Object)cacheKey), (Serializable)((Object)new ConfigStoreBasedTemplateCacheEntry(template)));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Entry for Template with id " + templateId + " not found in cache or config store"));
        }
        return template;
    }

    @Override
    public void updateTemplateById(String templateId, Template template) throws TemplateManagementException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing entry for Template with id " + templateId + " from cache"));
        }
        this.clearTemplateCache(templateId);
        this.configStoreBasedTemplateHandler.updateTemplateById(templateId, template);
    }

    @Override
    public void deleteTemplateById(String templateId) throws TemplateManagementException {
        boolean isReadWriteTemplate;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing entry for Template with id " + templateId + " from cache"));
        }
        if (!(isReadWriteTemplate = this.isReadWriteTemplate(templateId))) {
            String error = String.format(TemplateMgtConstants.ErrorMessages.ERROR_CODE_DELETE_READONLY_TEMPLATE.getMessage(), templateId);
            if (log.isDebugEnabled()) {
                log.debug((Object)error);
            }
            throw new TemplateManagementClientException(error, TemplateMgtConstants.ErrorMessages.ERROR_CODE_DELETE_READONLY_TEMPLATE.getCode());
        }
        this.clearTemplateCache(templateId);
        this.configStoreBasedTemplateHandler.deleteTemplateById(templateId);
    }

    @Override
    public List<Template> listTemplates(String templateType, Integer limit, Integer offset, Condition searchCondition) throws TemplateManagementException {
        return this.configStoreBasedTemplateHandler.listTemplates(templateType, limit, offset, searchCondition);
    }

    private void clearTemplateCache(String templateId) throws TemplateManagementException {
        Template template = this.getTemplateById(templateId);
        if (template != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing entry for Template with id " + templateId + " from cache."));
            }
            ConfigStoreBasedTemplateCacheKey cacheKey = new ConfigStoreBasedTemplateCacheKey(templateId);
            this.configStoreBasedTemplateCache.clearCacheEntry((Serializable)((Object)cacheKey));
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Entry for Template with id " + templateId + " not found in cache or DB"));
        }
    }

    private boolean isReadWriteTemplate(String templateId) {
        List<ReadOnlyTemplateHandler> readOnlyTemplateHandlers = TemplateManagerDataHolder.getInstance().getReadOnlyTemplateHandlers();
        for (ReadOnlyTemplateHandler readOnlyTemplateHandler : readOnlyTemplateHandlers) {
            Template template = null;
            try {
                template = readOnlyTemplateHandler.getTemplateById(templateId);
            }
            catch (TemplateManagementException exception) {
                continue;
            }
            if (template == null) continue;
            return false;
        }
        return true;
    }
}

