/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.function;

import java.util.ArrayList;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resource;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceFile;
import org.wso2.carbon.identity.configuration.mgt.core.util.ConfigurationUtils;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.function.TemplatePropertiesToAttributes;
import org.wso2.carbon.identity.template.mgt.model.Template;
import org.wso2.carbon.identity.template.mgt.util.TemplateMgtUtils;

public class TemplateToResource
implements Function<Template, Resource> {
    @Override
    public Resource apply(Template template) {
        ArrayList<ResourceFile> resourceFileList = new ArrayList<ResourceFile>();
        resourceFileList.add(this.getResourceFile(template));
        Resource resource = new Resource();
        resource.setResourceName(template.getTemplateName());
        resource.setResourceType(this.getResourceTypeFromTemplateType(template.getTemplateType()));
        resource.setAttributes(new TemplatePropertiesToAttributes().apply(template));
        resource.setResourceId(template.getTemplateId());
        resource.setTenantDomain(TemplateMgtUtils.getTenantDomainFromCarbonContext());
        resource.setFiles(resourceFileList);
        return resource;
    }

    private String getResourceTypeFromTemplateType(TemplateMgtConstants.TemplateType templateType) {
        if (templateType != null) {
            return templateType.toString();
        }
        return null;
    }

    private ResourceFile getResourceFile(Template template) {
        ResourceFile resourceFile = new ResourceFile();
        resourceFile.setId(ConfigurationUtils.generateUniqueID());
        resourceFile.setName(template.getTemplateType().toString() + "_template_object");
        resourceFile.setInputStream(IOUtils.toInputStream((String)template.getTemplateScript()));
        return resourceFile;
    }
}

