/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.function;

import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.identity.configuration.mgt.core.model.Attribute;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resource;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.model.Template;

public class ResourceToTemplate
implements Function<Resource, Template> {
    @Override
    public Template apply(Resource resource) {
        Template template = this.convertAttributesToProperties(resource.getAttributes());
        template.setTemplateName(resource.getResourceName());
        template.setTemplateId(resource.getResourceId());
        template.setTenantId(IdentityTenantUtil.getTenantId((String)resource.getTenantDomain()));
        template.setTemplateType(this.getTemplateTypeFromResourceType(resource.getResourceType()));
        return template;
    }

    private Template convertAttributesToProperties(List<Attribute> attributeList) {
        Template template = new Template();
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        attributeList.forEach(attribute -> {
            if ("description".equals(attribute.getKey())) {
                template.setDescription(attribute.getValue());
            } else if ("imageUrl".equals(attribute.getKey())) {
                template.setImageUrl(attribute.getValue());
            } else {
                propertiesMap.put(attribute.getKey(), attribute.getValue());
            }
        });
        template.setPropertiesMap(propertiesMap);
        return template;
    }

    private TemplateMgtConstants.TemplateType getTemplateTypeFromResourceType(String resourceType) {
        if (!StringUtils.isBlank((String)resourceType)) {
            return TemplateMgtConstants.TemplateType.valueOf(resourceType);
        }
        return null;
    }
}

