/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt.dao.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.dao.TemplateManagerDAO;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementException;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementSQLException;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementServerException;
import org.wso2.carbon.identity.template.mgt.model.Template;
import org.wso2.carbon.identity.template.mgt.model.TemplateInfo;
import org.wso2.carbon.identity.template.mgt.util.JdbcUtils;
import org.wso2.carbon.identity.template.mgt.util.TemplateMgtUtils;

public class TemplateManagerDAOImpl
implements TemplateManagerDAO {
    @Override
    public Template addTemplate(Template template) throws TemplateManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("INSERT INTO IDN_TEMPLATE_MGT (TENANT_ID, NAME, DESCRIPTION, TEMPLATE_SCRIPT) VALUES (?,?,?,?)", preparedStatement -> {
                preparedStatement.setInt(1, template.getTenantId());
                preparedStatement.setString(2, template.getTemplateName());
                preparedStatement.setString(3, template.getDescription());
                InputStream inputStream = IOUtils.toInputStream((String)template.getTemplateScript());
                try {
                    preparedStatement.setBinaryStream(4, inputStream, inputStream.available());
                }
                catch (IOException e) {
                    throw TemplateMgtUtils.handleSQLException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_INSERT_TEMPLATE, template.getTemplateName(), e);
                }
            });
        }
        catch (DataAccessException e) {
            throw TemplateMgtUtils.handleServerException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_INSERT_TEMPLATE, template.getTemplateName(), e);
        }
        Template templateResult = new Template(template.getTenantId(), template.getTemplateName(), template.getDescription(), template.getTemplateScript());
        return templateResult;
    }

    @Override
    public Template getTemplateByName(String templateName, Integer tenantId) throws TemplateManagementException {
        Template template;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            template = (Template)jdbcTemplate.fetchSingleRecord("SELECT NAME,DESCRIPTION,TEMPLATE_SCRIPT FROM IDN_TEMPLATE_MGT WHERE NAME=? AND TENANT_ID=?", (resultSet, rowNumber) -> {
                Template templateResult;
                try {
                    templateResult = new Template(resultSet.getString(1), resultSet.getString(2), IOUtils.toString((InputStream)resultSet.getBinaryStream(3)));
                }
                catch (IOException e) {
                    throw new TemplateManagementSQLException(String.format(TemplateMgtConstants.ErrorMessages.ERROR_CODE_SELECT_TEMPLATE_BY_NAME.getMessage(), tenantId, templateName), TemplateMgtConstants.ErrorMessages.ERROR_CODE_SELECT_TEMPLATE_BY_NAME.getCode(), e);
                }
                return templateResult;
            }, preparedStatement -> {
                preparedStatement.setString(1, templateName);
                preparedStatement.setInt(2, tenantId);
            });
        }
        catch (DataAccessException e) {
            throw new TemplateManagementServerException(String.format(TemplateMgtConstants.ErrorMessages.ERROR_CODE_SELECT_TEMPLATE_BY_NAME.getMessage(), tenantId, templateName), TemplateMgtConstants.ErrorMessages.ERROR_CODE_SELECT_TEMPLATE_BY_NAME.getCode(), e);
        }
        return template;
    }

    @Override
    public List<TemplateInfo> getAllTemplates(Integer tenantId, Integer limit, Integer offset) throws TemplateManagementException {
        List templates;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            int initialOffset;
            String query;
            if (JdbcUtils.isH2MySqlOrPostgresDB()) {
                query = "SELECT NAME,DESCRIPTION FROM IDN_TEMPLATE_MGT WHERE TENANT_ID=? ORDER BY TEMPLATE_ID ASC LIMIT ? OFFSET ?";
            } else if (JdbcUtils.isDB2DB()) {
                query = "SELECT NAME, DESCRIPTION FROM (SELECT ROW_NUMBER() OVER (ORDER BY TEMPLATE_ID) AS rn, t.* FROM IDN_TEMPLATE_MGT AS t) WHERE TENANT_ID=? AND rn BETWEEN ? AND ?";
                initialOffset = offset;
                offset = offset + limit;
                limit = initialOffset + 1;
            } else if (JdbcUtils.isMSSqlDB()) {
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
                query = "SELECT NAME, DESCRIPTION FROM (SELECT TENANT_ID, NAME, DESCRIPTION, ROW_NUMBER() OVER (ORDER BY TEMPLATE_ID) AS RowNum FROM IDN_TEMPLATE_MGT) AS T WHERE T.TENANT_ID = ? AND T.RowNum BETWEEN ? AND ?";
            } else {
                query = "SELECT NAME,DESCRIPTION FROM (SELECT TENANT_ID, NAME, DESCRIPTION, rownum AS rnum FROM (SELECT TENANT_ID, NAME, DESCRIPTION FROM IDN_TEMPLATE_MGT ORDER BY TENANT_ID) WHERE TENANT_ID =? AND rownum <= ?) WHERE rnum > ?";
                limit = offset + limit;
            }
            int finalLimit = limit;
            int finalOffset = offset;
            templates = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new TemplateInfo(resultSet.getString(1), resultSet.getString(2)), preparedStatement -> {
                preparedStatement.setInt(1, tenantId);
                preparedStatement.setInt(2, finalLimit);
                preparedStatement.setInt(3, finalOffset);
            });
        }
        catch (DataAccessException e) {
            throw new TemplateManagementServerException(String.format(TemplateMgtConstants.ErrorMessages.ERROR_CODE_PAGINATED_LIST_TEMPLATES.getMessage(), tenantId, limit, offset), TemplateMgtConstants.ErrorMessages.ERROR_CODE_PAGINATED_LIST_TEMPLATES.getCode(), e);
        }
        return templates;
    }

    @Override
    public Template updateTemplate(String templateName, Template newTemplate) throws TemplateManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("UPDATE IDN_TEMPLATE_MGT SET NAME= ?, DESCRIPTION= ?, TEMPLATE_SCRIPT= ? WHERE TENANT_ID= ? AND NAME = ?", preparedStatement -> {
                preparedStatement.setString(1, newTemplate.getTemplateName());
                preparedStatement.setString(2, newTemplate.getDescription());
                try {
                    InputStream inputStream = IOUtils.toInputStream((String)newTemplate.getTemplateScript());
                    preparedStatement.setBinaryStream(3, inputStream, inputStream.available());
                }
                catch (IOException e) {
                    throw TemplateMgtUtils.handleSQLException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_UPDATE_TEMPLATE, newTemplate.getTemplateName(), e);
                }
                preparedStatement.setInt(4, newTemplate.getTenantId());
                preparedStatement.setString(5, templateName);
            });
        }
        catch (DataAccessException e) {
            throw TemplateMgtUtils.handleServerException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_UPDATE_TEMPLATE, newTemplate.getTemplateName(), e);
        }
        return new Template(newTemplate.getTenantId(), newTemplate.getTemplateName(), newTemplate.getDescription(), newTemplate.getTemplateScript());
    }

    @Override
    public TemplateInfo deleteTemplate(String templateName, Integer tenantId) throws TemplateManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM IDN_TEMPLATE_MGT WHERE NAME=? AND TENANT_ID =?", preparedStatement -> {
                preparedStatement.setString(1, templateName);
                preparedStatement.setInt(2, tenantId);
            });
        }
        catch (DataAccessException e) {
            throw new TemplateManagementServerException(String.format(TemplateMgtConstants.ErrorMessages.ERROR_CODE_DELETE_TEMPLATE.getMessage(), tenantId.toString(), templateName), TemplateMgtConstants.ErrorMessages.ERROR_CODE_DELETE_TEMPLATE.getCode(), e);
        }
        return new TemplateInfo(tenantId, templateName);
    }
}

