/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.template.mgt;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.identity.template.mgt.TemplateManager;
import org.wso2.carbon.identity.template.mgt.TemplateMgtConstants;
import org.wso2.carbon.identity.template.mgt.dao.impl.TemplateManagerDAOImpl;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementClientException;
import org.wso2.carbon.identity.template.mgt.exception.TemplateManagementException;
import org.wso2.carbon.identity.template.mgt.handler.ReadOnlyTemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.impl.CacheBackedConfigStoreBasedTemplateHandler;
import org.wso2.carbon.identity.template.mgt.handler.impl.ConfigStoreBasedTemplateHandler;
import org.wso2.carbon.identity.template.mgt.internal.TemplateManagerDataHolder;
import org.wso2.carbon.identity.template.mgt.model.Template;
import org.wso2.carbon.identity.template.mgt.model.TemplateInfo;
import org.wso2.carbon.identity.template.mgt.util.TemplateMgtUtils;

public class TemplateManagerImpl
implements TemplateManager {
    private static final Log log = LogFactory.getLog(TemplateManagerImpl.class);
    private static final Integer DEFAULT_SEARCH_LIMIT = 100;
    private static CacheBackedConfigStoreBasedTemplateHandler configStoreBasedTemplateHandler = new CacheBackedConfigStoreBasedTemplateHandler((ConfigStoreBasedTemplateHandler)TemplateManagerDataHolder.getInstance().getReadWriteTemplateHandler());

    @Override
    public String addTemplate(Template template) throws TemplateManagementException {
        this.validateInputParameters(template);
        return configStoreBasedTemplateHandler.addTemplate(template);
    }

    @Override
    public Template getTemplateByName(String templateName) throws TemplateManagementException {
        if (!this.isTemplateExists(templateName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No template found for the name: " + templateName));
            }
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_NAME_INVALID, templateName);
        }
        return this.fetchSingleTemplate(templateName);
    }

    @Override
    public Template updateTemplate(String templateName, Template template) throws TemplateManagementException {
        this.validateInputParameters(template);
        TemplateManagerDAOImpl templateManagerDAO = new TemplateManagerDAOImpl();
        if (!this.isTemplateExists(templateName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No template found for the name: " + templateName));
            }
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_NAME_INVALID, templateName);
        }
        if (!StringUtils.equals((String)templateName, (String)template.getTemplateName()) && this.isTemplateExists(template.getTemplateName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A template already exists with the name: " + template.getTemplateName()));
            }
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_ALREADY_EXIST, template.getTemplateName());
        }
        return templateManagerDAO.updateTemplate(templateName, template);
    }

    @Override
    public TemplateInfo deleteTemplate(String templateName) throws TemplateManagementException {
        if (StringUtils.isBlank((String)templateName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Template Name is not found in the request or invalid Template Name.");
            }
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_NAME_REQUIRED, null);
        }
        if (this.getTemplateByName(templateName) == null) {
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_NAME_INVALID, templateName);
        }
        TemplateManagerDAOImpl templateManagerDAO = new TemplateManagerDAOImpl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Template deleted successfully. Name: " + templateName));
        }
        return templateManagerDAO.deleteTemplate(templateName, TemplateMgtUtils.getTenantIdFromCarbonContext());
    }

    @Override
    public List<TemplateInfo> listTemplates(Integer limit, Integer offset) throws TemplateManagementException {
        this.validatePaginationParameters(limit, offset);
        if (limit == 0) {
            limit = DEFAULT_SEARCH_LIMIT;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defined in the request, default to: " + limit));
            }
        }
        TemplateManagerDAOImpl templateManagerDAO = new TemplateManagerDAOImpl();
        return templateManagerDAO.getAllTemplates(TemplateMgtUtils.getTenantIdFromCarbonContext(), limit, offset);
    }

    public Template fetchSingleTemplate(String templateName) throws TemplateManagementException {
        TemplateManagerDAOImpl templateManagerDAO = new TemplateManagerDAOImpl();
        return templateManagerDAO.getTemplateByName(templateName.trim(), TemplateMgtUtils.getTenantIdFromCarbonContext());
    }

    private boolean isTemplateExists(String templateName) throws TemplateManagementException {
        return this.fetchSingleTemplate(templateName) != null;
    }

    private void validateInputParameters(Template template) throws TemplateManagementException {
        if (StringUtils.isBlank((String)template.getTemplateName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Template name cannot be empty.");
            }
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_NAME_REQUIRED, null);
        }
        if (StringUtils.isBlank((String)template.getTemplateScript())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Template script cannot be empty.");
            }
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_SCRIPT_REQUIRED, null);
        }
    }

    private void validatePaginationParameters(Integer limit, Integer offset) throws TemplateManagementClientException {
        if (limit < 0 || offset < 0) {
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_INVALID_ARGUMENTS_FOR_LIMIT_OFFSET, null);
        }
    }

    @Override
    public Template getTemplateById(String templateId) throws TemplateManagementException {
        List<ReadOnlyTemplateHandler> readOnlyTemplateHandlers = TemplateManagerDataHolder.getInstance().getReadOnlyTemplateHandlers();
        for (ReadOnlyTemplateHandler readOnlyTemplateHandler : readOnlyTemplateHandlers) {
            Template template = readOnlyTemplateHandler.getTemplateById(templateId);
            if (template == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("A template exists with the id: " + templateId));
            }
            return template;
        }
        return configStoreBasedTemplateHandler.getTemplateById(templateId);
    }

    @Override
    public List<Template> listTemplates(String templateType, Integer limit, Integer offset) throws TemplateManagementException {
        return this.listTemplates(templateType, limit, offset, null);
    }

    @Override
    public List<Template> listTemplates(String templateType, Integer limit, Integer offset, Condition searchCondition) throws TemplateManagementException {
        if (!this.isValidTemplateType(templateType)) {
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_INVALID_TEMPLATE_TYPE, templateType);
        }
        if (limit != null || offset != null) {
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_PAGINATION_NOT_SUPPORTED, null);
        }
        ArrayList<Template> templates = new ArrayList<Template>();
        List<ReadOnlyTemplateHandler> readOnlyTemplateHandlers = TemplateManagerDataHolder.getInstance().getReadOnlyTemplateHandlers();
        for (ReadOnlyTemplateHandler readOnlyTemplateHandler : readOnlyTemplateHandlers) {
            templates.addAll(readOnlyTemplateHandler.listTemplates(templateType, limit, offset, searchCondition));
        }
        templates.addAll(configStoreBasedTemplateHandler.listTemplates(templateType, limit, offset, searchCondition));
        return templates;
    }

    @Override
    public void deleteTemplateById(String templateId) throws TemplateManagementException {
        configStoreBasedTemplateHandler.deleteTemplateById(templateId);
    }

    private boolean isValidTemplateType(String templateType) {
        return EnumUtils.isValidEnum(TemplateMgtConstants.TemplateType.class, (String)templateType);
    }

    @Override
    public void updateTemplateById(String templateId, Template template) throws TemplateManagementException {
        if (StringUtils.isBlank((String)templateId)) {
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_INVALID_TEMPLATE_ID, templateId);
        }
        template.setTemplateId(templateId);
        this.validateInputParameters(template);
        configStoreBasedTemplateHandler.updateTemplateById(templateId, template);
    }

    @Override
    public Template addTemplateUsingTemplateMgtDAO(Template template) throws TemplateManagementException {
        this.validateInputParameters(template);
        if (this.isTemplateExists(template.getTemplateName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A template already exists with the name: " + template.getTemplateName()));
            }
            throw TemplateMgtUtils.handleClientException(TemplateMgtConstants.ErrorMessages.ERROR_CODE_TEMPLATE_ALREADY_EXIST, template.getTemplateName());
        }
        TemplateManagerDAOImpl templateManagerDAO = new TemplateManagerDAOImpl();
        return templateManagerDAO.addTemplate(template);
    }
}

