/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt.internal;

import java.net.URL;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.sts.common.SecurityScenario;
import org.wso2.carbon.identity.sts.common.SecurityScenarioDatabase;
import org.wso2.carbon.identity.sts.common.config.SecurityConfigAdmin;
import org.wso2.carbon.identity.sts.common.identity.provider.IdentityProviderUtil;
import org.wso2.carbon.identity.sts.common.util.XmlConfiguration;
import org.wso2.carbon.identity.sts.mgt.STSConfigurationContextObserver;
import org.wso2.carbon.identity.sts.mgt.STSObserver;
import org.wso2.carbon.identity.sts.mgt.admin.STSConfigAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityConstants;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.sts.mgt.component", immediate=true)
public class IdentitySTSMgtServiceComponent {
    private static final Log log = LogFactory.getLog(IdentitySTSMgtServiceComponent.class);
    private static RegistryService registryService;
    private static ConfigurationContext configContext;
    private static BundleContext bundleContext;
    private static RealmService realmService;

    public static ConfigurationContext getConfigurationContext() {
        return configContext;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService set in Identity STS Mgt bundle");
        }
        try {
            IdentitySTSMgtServiceComponent.registryService = registryService;
        }
        catch (Throwable e) {
            log.error((Object)"Failed to load security scenarios", e);
        }
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        IdentitySTSMgtServiceComponent.realmService = realmService;
    }

    public static BundleContext getBundleContext() {
        return bundleContext;
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity STS Mgt bundle is activated");
        }
        bundleContext = ctxt.getBundleContext();
        try {
            this.initialize();
        }
        catch (Throwable e) {
            log.error((Object)"Failed to load security scenarios", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.info((Object)"Identity STS Mgt bundle is deactivated");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"RegistryService set in Identity STS Mgt bundle");
        }
        IdentitySTSMgtServiceComponent.registryService = null;
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService set in Identity STS Mgt bundle");
        }
        configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ConfigurationContextService unset in Identity STS Mgt bundle");
        }
        configContext = null;
    }

    @Reference(name="identity.provider.sts.service", service=IdentityProviderUtil.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityProviderAdminUtil")
    protected void setIdentityProviderAdminUtil(IdentityProviderUtil providerUtil) {
        if (log.isDebugEnabled()) {
            log.info((Object)"IdentityProviderUtil set in Identity STS Mgt bundle");
        }
    }

    protected void unsetIdentityProviderAdminUtil(IdentityProviderUtil providerUtil) {
        if (log.isDebugEnabled()) {
            log.info((Object)"IdentityProviderUtil unset in Identity STS Mgt bundle");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        IdentitySTSMgtServiceComponent.realmService = null;
    }

    @Reference(name="security.config.service", service=SecurityConfigAdmin.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetSecurityConfigAdminService")
    protected void setSecurityConfigAdminService(SecurityConfigAdmin securityConfig) {
        if (log.isDebugEnabled()) {
            log.info((Object)"SecurityConfigAdmin set in Identity STS Mgt bundle");
        }
    }

    protected void unsetSecurityConfigAdminService(SecurityConfigAdmin securityConfig) {
        if (log.isDebugEnabled()) {
            log.info((Object)"SecurityConfigAdmin unset in Identity STS Mgt bundle");
        }
    }

    private void initialize() throws Exception {
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new STSConfigurationContextObserver(), null);
        log.debug((Object)"Registered STSConfigurationContextObserver to configure STS service for tenants.");
        this.loadSecurityScenarios();
        STSConfigAdmin.configureService(configContext.getAxisConfiguration(), (Registry)registryService.getConfigSystemRegistry());
        STSConfigAdmin.configureGenericSTS();
        configContext.getAxisConfiguration().addObservers((AxisObserver)new STSObserver());
    }

    private void loadSecurityScenarios() throws Exception {
        UserRegistry registry = registryService.getConfigSystemRegistry();
        try {
            URL resource = bundleContext.getBundle().getResource("scenario-config.xml");
            if (resource == null) {
                return;
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(resource.openStream(), "http://www.wso2.org/products/carbon/security");
            OMElement[] elements = xmlConfiguration.getElements("//ns:Scenario");
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            for (OMElement scenarioEle : elements) {
                SecurityScenario scenario = new SecurityScenario();
                String scenarioId = scenarioEle.getAttribute(SecurityConstants.ID_QN).getAttributeValue();
                scenario.setScenarioId(scenarioId);
                scenario.setSummary(scenarioEle.getFirstChildWithName(SecurityConstants.SUMMARY_QN).getText());
                scenario.setDescription(scenarioEle.getFirstChildWithName(SecurityConstants.DESCRIPTION_QN).getText());
                scenario.setCategory(scenarioEle.getFirstChildWithName(SecurityConstants.CATEGORY_QN).getText());
                scenario.setWsuId(scenarioEle.getFirstChildWithName(SecurityConstants.WSUID_QN).getText());
                scenario.setType(scenarioEle.getFirstChildWithName(SecurityConstants.TYPE_QN).getText());
                OMElement genPolicyElem = scenarioEle.getFirstChildWithName(SecurityConstants.IS_GEN_POLICY_QN);
                if (genPolicyElem != null && "false".equals(genPolicyElem.getText())) {
                    scenario.setGeneralPolicy(false);
                }
                String resourceUri = "/repository/components/org.wso2.carbon.security.mgt/policy/" + scenarioId;
                Iterator modules = scenarioEle.getFirstChildWithName(SecurityConstants.MODULES_QN).getChildElements();
                while (modules.hasNext()) {
                    String module = ((OMElement)modules.next()).getText();
                    scenario.addModule(module);
                }
                SecurityScenarioDatabase.put((String)scenarioId, (SecurityScenario)scenario);
                if (scenarioId.equals("DisableSecurity") || scenarioId.equals("policyFromRegistry")) continue;
                ResourceImpl scenarioResource = new ResourceImpl();
                URL urlResource = bundleContext.getBundle().getResource(scenarioId + "-policy.xml");
                if (urlResource == null) {
                    return;
                }
                scenarioResource.setContentStream(urlResource.openStream());
                if (registry.resourceExists(resourceUri)) continue;
                registry.put(resourceUri, (Resource)scenarioResource);
            }
            if (!transactionStarted) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw e;
        }
    }
}

