/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt.base;

import java.util.Properties;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.rampart.policy.model.CryptoConfig;
import org.apache.rampart.policy.model.RampartConfig;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.sts.mgt.base.InMemoryPasswordCallbackHandler;

public class IdentityBaseUtil {
    private static final Log log = LogFactory.getLog(IdentityBaseUtil.class);
    public static String policyString = "<wsp:Policy wsu:Id=\"SigOnly\"                    xmlns:wsu=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\"                    xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\">            <wsp:ExactlyOne>                <wsp:All>                    <sp:AsymmetricBinding xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">                        <wsp:Policy>                            <sp:InitiatorToken>                                <wsp:Policy>                                    <sp:X509Token                                            sp:IncludeToken=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/AlwaysToRecipient\">                                        <wsp:Policy>                                            <sp:RequireThumbprintReference/>                                            <sp:WssX509V3Token10/>                                        </wsp:Policy>                                    </sp:X509Token>                                </wsp:Policy>                            </sp:InitiatorToken>                            <sp:RecipientToken>                                <wsp:Policy>                                    <sp:X509Token                                            sp:IncludeToken=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy/IncludeToken/Never\">                                        <wsp:Policy>                                            <sp:RequireThumbprintReference/>                                            <sp:WssX509V3Token10/>                                        </wsp:Policy>                                    </sp:X509Token>                                </wsp:Policy>                            </sp:RecipientToken>                            <sp:AlgorithmSuite>                                <wsp:Policy>                                    <sp:Basic256/>                                </wsp:Policy>                            </sp:AlgorithmSuite>                            <sp:Layout>                                <wsp:Policy>                                    <sp:Strict/>                                </wsp:Policy>                            </sp:Layout>                            <sp:IncludeTimestamp/>                            <sp:OnlySignEntireHeadersAndBody/>                        </wsp:Policy>                    </sp:AsymmetricBinding>                    <sp:Wss10 xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">                        <wsp:Policy>                            <sp:MustSupportRefKeyIdentifier/>                            <sp:MustSupportRefIssuerSerial/>                        </wsp:Policy>                    </sp:Wss10>                    <sp:SignedParts xmlns:sp=\"http://schemas.xmlsoap.org/ws/2005/07/securitypolicy\">                        <sp:Body/>                    </sp:SignedParts>                </wsp:All>            </wsp:ExactlyOne>        </wsp:Policy>";

    public static Policy getDefaultRampartConfig() {
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        String keyStore = serverConfig.getFirstProperty("Security.KeyStore.Location");
        String keyStoreType = serverConfig.getFirstProperty("Security.KeyStore.Type");
        String keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.Password");
        String privateKeyAlias = serverConfig.getFirstProperty("Security.KeyStore.KeyAlias");
        String privateKeyPassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
        RampartConfig rampartConfig = new RampartConfig();
        rampartConfig.setUser(privateKeyAlias);
        rampartConfig.setPwCbClass("org.wso2.carbon.identity.sts.mgt.base.InMemoryPasswordCallbackHandler");
        InMemoryPasswordCallbackHandler.addUser(privateKeyAlias, privateKeyPassword);
        CryptoConfig sigCrypto = new CryptoConfig();
        Properties props = new Properties();
        sigCrypto.setProvider("org.apache.ws.security.components.crypto.Merlin");
        props.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", keyStoreType);
        props.setProperty("org.apache.ws.security.crypto.merlin.file", keyStore);
        props.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", keyStorePassword);
        props.setProperty("org.apache.ws.security.crypto.merlin.load.cacerts", "false");
        sigCrypto.setProp(props);
        rampartConfig.setSigCryptoConfig(sigCrypto);
        Policy policy = new Policy();
        policy.addAssertion((Assertion)rampartConfig);
        return policy;
    }

    public static Policy getSignOnlyPolicy() throws IdentityException {
        Policy policy;
        try {
            OMElement policyOM = AXIOMUtil.stringToOM((String)policyString);
            PolicyEngine policyEngine = new PolicyEngine();
            policy = PolicyEngine.getPolicy((OMElement)policyOM);
        }
        catch (Exception e) {
            String msg = "error building policy from " + policyString;
            log.error((Object)msg);
            throw IdentityException.error((String)msg, (Throwable)e);
        }
        return policy;
    }
}

