/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt.admin;

import javax.security.auth.callback.CallbackHandler;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.sts.common.config.SecurityConfigAdmin;
import org.wso2.carbon.identity.sts.common.config.SecurityServiceAdmin;
import org.wso2.carbon.identity.sts.common.identity.provider.AttributeCallbackHandler;
import org.wso2.carbon.identity.sts.common.identity.provider.IdentityProviderUtil;
import org.wso2.carbon.identity.sts.mgt.IPPasswordCallbackHandler;
import org.wso2.carbon.identity.sts.mgt.internal.IdentitySTSMgtServiceComponent;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.utils.ServerException;

public class STSConfigAdmin {
    private static final Log log = LogFactory.getLog(STSConfigAdmin.class);

    private STSConfigAdmin() {
    }

    public static void configureService(String serviceName) throws IdentityProviderException {
        try {
            AxisConfiguration axisConfig = IdentitySTSMgtServiceComponent.getConfigurationContext().getAxisConfiguration();
            SecurityConfigAdmin admin = new SecurityConfigAdmin(axisConfig, (Registry)IdentitySTSMgtServiceComponent.getRegistryService().getConfigSystemRegistry(), (CallbackHandler)new IPPasswordCallbackHandler());
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String ksName = serverConfig.getFirstProperty("Security.KeyStore.Location");
            ksName = ksName.substring(ksName.lastIndexOf("/") + 1);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Applying identity security policy for service " + serviceName));
            }
            if (IdentityProviderUtil.isIntial()) {
                if ("sts-ut".equals(serviceName)) {
                    admin.applySecurity("sts-ut", "scenario19", null, null, null, null);
                } else if ("sts-openid-ut".equals(serviceName)) {
                    admin.applySecurity("sts-openid-ut", "scenario19", null, null, null, null);
                } else if ("sts-ic".equals(serviceName)) {
                    admin.applySecurity("sts-ic", "scenario18", null, new String[]{ksName}, ksName, null);
                } else if ("sts-openid-ic".equals(serviceName)) {
                    admin.applySecurity("sts-openid-ic", "scenario18", null, new String[]{ksName}, ksName, null);
                } else if ("sts-ut-symm".equals(serviceName)) {
                    admin.applySecurity("sts-ut-symm", "scenario18", null, new String[]{ksName}, ksName, null);
                } else if ("sts-ic-symm".equals(serviceName)) {
                    admin.applySecurity("sts-ic-symm", "scenario18", null, new String[]{ksName}, ksName, null);
                }
            }
            if ("sts-ut".equals(serviceName)) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-ut");
            } else if ("sts-ut-symm".equals(serviceName)) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-ut-symm");
            } else if ("sts-openid-ut".equals(serviceName)) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-openid-ut");
            } else if ("sts-ic".equals(serviceName)) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-ic");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"errorInChangingSecurityConfiguration", (Throwable)e);
            throw new IdentityProviderException("errorInChangingSecurityConfiguration", (Throwable)e);
        }
    }

    public static void configureGenericSTS() throws IdentityProviderException {
        AxisConfiguration config = IdentitySTSMgtServiceComponent.getConfigurationContext().getAxisConfiguration();
        STSConfigAdmin.configureGenericSTS(config);
    }

    public static void configureGenericSTS(AxisConfiguration config) throws IdentityProviderException {
        block8: {
            try {
                ServerConfiguration serverConfig;
                String ttl;
                AxisService stsService = config.getService("wso2carbon-sts");
                if (stsService == null) {
                    return;
                }
                Parameter origParam = stsService.getParameter(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG.getLocalPart());
                if (origParam == null) break block8;
                OMElement samlConfigElem = origParam.getParameterElement().getFirstChildWithName(SAMLTokenIssuerConfig.SAML_ISSUER_CONFIG);
                SAMLTokenIssuerConfig samlConfig = new SAMLTokenIssuerConfig(samlConfigElem);
                samlConfig.setCallbackHandlerName(AttributeCallbackHandler.class.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Configured the SAML callback handler: " + AttributeCallbackHandler.class.getName() + " in the service " + stsService.getName() + " for tenant " + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain() + "[" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId() + "]"));
                }
                if (StringUtils.isNotBlank((String)(ttl = (serverConfig = ServerConfiguration.getInstance()).getFirstProperty("STSTimeToLive")))) {
                    try {
                        samlConfig.setTtl(Long.parseLong(ttl));
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("STSTimeToLive read from carbon.xml " + ttl));
                        }
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)"Error while reading STSTimeToLive from carbon.xml", (Throwable)e);
                    }
                }
                STSConfigAdmin.setSTSParameter(samlConfig, config);
            }
            catch (Exception e) {
                log.error((Object)"Error while setting password callback to the STS", (Throwable)e);
                throw new IdentityProviderException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void configureService(AxisConfiguration config, Registry registry) throws IdentityProviderException {
        AxisConfiguration axisConfig = IdentitySTSMgtServiceComponent.getConfigurationContext().getAxisConfiguration();
        try {
            ServerConfiguration serverConfig = ServerConfiguration.getInstance();
            String ksName = serverConfig.getFirstProperty("Security.KeyStore.Location");
            ksName = ksName.substring(ksName.lastIndexOf("/") + 1);
            SecurityConfigAdmin admin = new SecurityConfigAdmin(config, registry, (CallbackHandler)new IPPasswordCallbackHandler());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Applying identity security policy for Identity STS services");
            }
            if (IdentityProviderUtil.isIntial()) {
                if (axisConfig.getService("sts-ut") != null) {
                    admin.applySecurity("sts-ut", "scenario19", null, null, null, null);
                }
                if (axisConfig.getService("sts-openid-ut") != null) {
                    admin.applySecurity("sts-openid-ut", "scenario19", null, null, null, null);
                }
                if (axisConfig.getService("sts-ic") != null) {
                    admin.applySecurity("sts-ic", "scenario18", null, new String[]{ksName}, ksName, null);
                }
                if (axisConfig.getService("sts-openid-ic") != null) {
                    admin.applySecurity("sts-openid-ic", "scenario18", null, new String[]{ksName}, ksName, null);
                }
                if (axisConfig.getService("sts-ut-symm") != null) {
                    admin.applySecurity("sts-ut-symm", "scenario18", null, new String[]{ksName}, ksName, null);
                }
                if (axisConfig.getService("sts-ic-symm") != null) {
                    admin.applySecurity("sts-ic-symm", "scenario18", null, new String[]{ksName}, ksName, null);
                }
            }
            if (axisConfig.getService("sts-ut") != null) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-ut");
            }
            if (axisConfig.getService("sts-ut-symm") != null) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-ut-symm");
            }
            if (axisConfig.getService("sts-openid-ut") != null) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-openid-ut");
            }
            if (axisConfig.getService("sts-ic") != null) {
                STSConfigAdmin.overrideCallbackHandler(axisConfig, "sts-ic");
            }
        }
        catch (Exception e) {
            log.error((Object)"errorInChangingSecurityConfiguration", (Throwable)e);
            throw new IdentityProviderException("errorInChangingSecurityConfiguration", (Throwable)e);
        }
    }

    public static void overrideCallbackHandler(AxisConfiguration axisConfig, String service) throws AxisFault {
        AxisService sts = axisConfig.getService(service);
        Parameter cbHandlerParam = sts.getParameter("passwordCallbackRef");
        if (cbHandlerParam != null) {
            sts.removeParameter(cbHandlerParam);
            if (log.isDebugEnabled()) {
                log.debug((Object)"removedParameter");
            }
        }
        Parameter param = STSConfigAdmin.getPasswordCallBackRefParameter();
        sts.addParameter(param);
        if (log.isDebugEnabled()) {
            log.debug((Object)"addedParameter");
        }
    }

    public static void overrideCallbackHandler(AxisService service) throws AxisFault {
        Parameter cbHandlerParam = service.getParameter("passwordCallbackRef");
        CallbackHandler handler = null;
        if (cbHandlerParam != null) {
            handler = (CallbackHandler)cbHandlerParam;
            service.removeParameter(cbHandlerParam);
            if (log.isDebugEnabled()) {
                log.debug((Object)"removedParameter");
            }
        }
        CallbackHandler cb = null;
        cb = handler != null ? handler : new IPPasswordCallbackHandler();
        Parameter param = new Parameter();
        param.setName("passwordCallbackRef");
        param.setValue((Object)cb);
        service.addParameter(param);
        if (log.isDebugEnabled()) {
            log.debug((Object)"addedParameter");
        }
    }

    public static Parameter getPasswordCallBackRefParameter() throws AxisFault {
        Parameter param = new Parameter();
        param.setName("passwordCallbackRef");
        try {
            param.setValue((Object)new IPPasswordCallbackHandler());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        return param;
    }

    private static void setSTSParameter(SAMLTokenIssuerConfig samlConfig, AxisConfiguration config) throws AxisFault, ServerException {
        try {
            new SecurityServiceAdmin(config).setServiceParameterElement("wso2carbon-sts", samlConfig.getParameter());
        }
        catch (ServerException e) {
            throw new AxisFault("Error configuring STS parameters.", (Throwable)e);
        }
    }
}

