/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sts.mgt;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.AxisObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.sts.mgt.TenantSTSObserver;
import org.wso2.carbon.identity.sts.mgt.admin.STSConfigAdmin;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class STSConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static final Log log = LogFactory.getLog(STSConfigurationContextObserver.class);

    public void createdConfigurationContext(ConfigurationContext configurationContext) {
        int tenantID = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Configuring the STS service for tenant: " + tenantDomain + "[" + tenantID + "]"));
            }
            STSConfigAdmin.configureGenericSTS(configurationContext.getAxisConfiguration());
            configurationContext.getAxisConfiguration().addObservers((AxisObserver)new TenantSTSObserver());
        }
        catch (IdentityProviderException e) {
            String msg = "Failed to configure STS service for tenant: " + tenantDomain + "[" + tenantID + "]";
            log.error((Object)msg, (Throwable)e);
        }
    }
}

